/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.domain.entity.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.yunxi.dg.base.center.item.dao.das.IItemRCombinationDas;
import com.yunxi.dg.base.center.item.dao.vo.CombinationCountVo;
import com.yunxi.dg.base.center.item.domain.entity.IItemRCombinationDomain;
import com.yunxi.dg.base.center.item.eo.ItemRCombinationEo;
import com.yunxi.dg.base.framework.core.db.das.ICommonDas;
import com.yunxi.dg.base.framework.core.domain.BaseDomainImpl;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ItemRCombinationDomainImpl
extends BaseDomainImpl<ItemRCombinationEo>
implements IItemRCombinationDomain {
    @Resource
    private IItemRCombinationDas das;

    public ICommonDas<ItemRCombinationEo> commonDas() {
        return this.das;
    }

    @Override
    public void removeCombinationIds(List<Long> ids) {
        this.das.removeCombinationIds(ids);
    }

    @Override
    public void removeItemIds(List<Long> itemIds) {
        this.das.removeItemIds(itemIds);
    }

    @Override
    public Map<Long, Integer> groupByCombinationIdCount(List<Long> ids) {
        HashMap<Long, Integer> resultMap = new HashMap<Long, Integer>();
        List combinationCountVos = this.das.groupByCombinationIdCount(ids);
        if (CollectionUtil.isNotEmpty((Collection)combinationCountVos)) {
            for (CombinationCountVo combinationCountVo : combinationCountVos) {
                if (Objects.isNull(combinationCountVo.getCombinationId())) continue;
                Integer count = Objects.nonNull(combinationCountVo.getCount()) ? combinationCountVo.getCount() : 0;
                resultMap.put(combinationCountVo.getCombinationId(), count);
            }
        }
        return resultMap;
    }
}

