/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.domain.entity.impl;

import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.item.dao.das.ItemBundleRelationDgDas;
import com.yunxi.dg.base.center.item.domain.entity.IItemBundleRelationDgDomain;
import com.yunxi.dg.base.center.item.eo.ItemBundleRelationDgEo;
import com.yunxi.dg.base.framework.core.db.das.ICommonDas;
import com.yunxi.dg.base.framework.core.domain.BaseDomainImpl;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class ItemBundleRelationDgDomainImpl
extends BaseDomainImpl<ItemBundleRelationDgEo>
implements IItemBundleRelationDgDomain {
    @Resource
    private ItemBundleRelationDgDas das;

    public ICommonDas<ItemBundleRelationDgEo> commonDas() {
        return this.das;
    }

    @Override
    public List<ItemBundleRelationDgEo> getListBySkuId(List<Long> skuIdList) {
        if (CollectionUtils.isEmpty(skuIdList)) {
            return Lists.newArrayList();
        }
        ItemBundleRelationDgEo itemBundleRelationEo = new ItemBundleRelationDgEo();
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        sqlFilterList.add(SqlFilter.in((String)"sku_id", (Object)StringUtils.join(skuIdList, (String)",")));
        itemBundleRelationEo.setSqlFilters(sqlFilterList);
        itemBundleRelationEo.setOrderBy("id");
        return this.das.selectList((BaseEo)itemBundleRelationEo, Integer.valueOf(1), Integer.valueOf(1000));
    }

    @Override
    public List<ItemBundleRelationDgEo> getListByItemId(Long itemId) {
        if (ObjectUtils.isNotEmpty((Object)itemId)) {
            return Lists.newArrayList();
        }
        ItemBundleRelationDgEo itemBundleRelationEo = new ItemBundleRelationDgEo();
        itemBundleRelationEo.setItemId(itemId);
        return this.das.selectList((BaseEo)itemBundleRelationEo, Integer.valueOf(1), Integer.valueOf(1000));
    }

    @Override
    public List<ItemBundleRelationDgEo> getBundleItemBySubItem(Long subItemId, Long subSkuId) {
        if (subItemId == null && subSkuId == null) {
            return Lists.newArrayList();
        }
        ItemBundleRelationDgEo param = new ItemBundleRelationDgEo();
        if (subItemId != null) {
            param.setSubItemId(subItemId);
        }
        if (subSkuId != null) {
            param.setSubSkuId(subSkuId);
        }
        return this.das.selectList((BaseEo)param, Integer.valueOf(1), Integer.valueOf(1000));
    }

    @Override
    public List<ItemBundleRelationDgEo> selectByItemIdsList(List<Long> itemIds) {
        if (CollectionUtils.isEmpty(itemIds)) {
            return Lists.newArrayList();
        }
        return ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().in((Object)"item_id", itemIds)).orderByAsc((Object)"id")).list();
    }

    @Override
    public void removeBySkuId(Long skuId) {
        this.das.removeBySkuId(skuId);
    }

    @Override
    public List<ItemBundleRelationDgEo> selectBySkuIdsList(List<Long> skuIds) {
        if (CollectionUtils.isEmpty(skuIds)) {
            return Lists.newArrayList();
        }
        return ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().in((Object)"sku_id", skuIds)).orderByAsc((Object)"id")).list();
    }

    @Override
    public void removeBySkuIds(List<Long> skuIds) {
        this.das.removeBySkuIds(skuIds);
    }

    @Override
    public List<ItemBundleRelationDgEo> queryBySkuIdAndVersion(Long skuId, String version) {
        return ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().eq((Object)"sku_id", (Object)skuId)).eq((Object)"version", (Object)version)).list();
    }
}

