/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.domain.entity.impl;

import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.item.dao.das.ShelfDgDas;
import com.yunxi.dg.base.center.item.dao.vo.ShelfDgQueryReqVo;
import com.yunxi.dg.base.center.item.dao.vo.ShelfItemDgVo;
import com.yunxi.dg.base.center.item.dao.vo.ShelfItemSkuDgVo;
import com.yunxi.dg.base.center.item.dao.vo.ShelfListDgRespVo;
import com.yunxi.dg.base.center.item.domain.entity.IShelfDgDomain;
import com.yunxi.dg.base.center.item.eo.ShelfDgEo;
import com.yunxi.dg.base.framework.core.db.das.ICommonDas;
import com.yunxi.dg.base.framework.core.domain.BaseDomainImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class ShelfDgDomainImpl
extends BaseDomainImpl<ShelfDgEo>
implements IShelfDgDomain {
    @Resource
    private ShelfDgDas das;

    public ICommonDas<ShelfDgEo> commonDas() {
        return this.das;
    }

    @Override
    public PageInfo<ShelfItemDgVo> selectSelfItemByPage(ShelfItemDgVo shelfItemVo, Integer pageNum, Integer pageSize) {
        return this.das.selectSelfItemByPage(shelfItemVo, pageNum, pageSize);
    }

    @Override
    public List<ShelfItemSkuDgVo> selectSelfItemSkuList(Long shopId, Long itemId, Integer busType) {
        return this.das.selectSelfItemSkuList(shopId, itemId, busType);
    }

    @Override
    public List<ShelfDgEo> selectByParam(List<Long> shopIds, List<Long> itemIds, List<Long> skuIds, Integer busType) {
        if (CollectionUtils.isEmpty(shopIds) && CollectionUtils.isEmpty(itemIds) && CollectionUtils.isEmpty(skuIds)) {
            return Lists.newArrayList();
        }
        ShelfDgEo param = ShelfDgEo.newInstance();
        ArrayList sqlFilterList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(shopIds)) {
            sqlFilterList.add(SqlFilter.in((String)"shop_id", shopIds));
        }
        if (CollectionUtils.isNotEmpty(itemIds)) {
            sqlFilterList.add(SqlFilter.in((String)"item_id", itemIds));
        }
        if (CollectionUtils.isNotEmpty(skuIds)) {
            sqlFilterList.add(SqlFilter.in((String)"sku_id", skuIds));
        }
        if (busType != null) {
            param.setBusType(busType);
        }
        if (CollectionUtils.isNotEmpty((Collection)sqlFilterList)) {
            param.setSqlFilters((List)sqlFilterList);
        }
        return this.das.selectList((BaseEo)param);
    }

    @Override
    public Long selectSelfItemCount(ShelfItemDgVo shelfItemVo) {
        return this.das.selectSelfItemCount(shelfItemVo);
    }

    @Override
    public Long newSelectSelfItemCount(ShelfItemDgVo shelfItemVo) {
        return this.das.newSelectSelfItemCount(shelfItemVo);
    }

    @Override
    public List<ShelfDgEo> selectByParam(Long shopId, Long channelId, Long itemId, Long skuId, Integer status) {
        if (shopId == null && itemId == null && skuId == null) {
            return Lists.newArrayList();
        }
        ShelfDgEo param = ShelfDgEo.newInstance();
        if (shopId != null) {
            param.setShopId(shopId);
        }
        if (itemId != null) {
            param.setItemId(itemId);
        }
        if (skuId != null) {
            param.setSkuId(skuId);
        }
        if (status != null) {
            param.setStatus(status);
        }
        if (channelId != null) {
            param.setChannelId(channelId);
        }
        return this.das.selectList((BaseEo)param);
    }

    @Override
    public List<ShelfDgEo> selectByItemIds(List<Long> itemIds, Integer status) {
        if (CollectionUtils.isEmpty(itemIds)) {
            return Lists.newArrayList();
        }
        ShelfDgEo param = ShelfDgEo.newInstance();
        ArrayList sqlFilterList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(itemIds)) {
            sqlFilterList.add(SqlFilter.in((String)"item_id", itemIds));
        }
        if (status != null) {
            param.setStatus(status);
        }
        if (CollectionUtils.isNotEmpty((Collection)sqlFilterList)) {
            param.setSqlFilters((List)sqlFilterList);
        }
        return this.das.selectList((BaseEo)param);
    }

    @Override
    public List<Long> selectByBundleItemIds(List<Long> itemIds) {
        return this.das.selectByBundleItemIds(itemIds);
    }

    @Override
    public PageInfo<ShelfListDgRespVo> queryShelfPage(ShelfDgQueryReqVo reqVo, Integer pageNum, Integer pageSize) {
        return this.das.queryShelfPage(reqVo, pageNum, pageSize);
    }

    @Override
    public void updateShelfStatusByIds(List<Long> ids, int status) {
        this.das.updateShelfStatusByIds(ids, status);
    }

    @Override
    public List<ShelfDgEo> selectByItemIdsAndShop(Set<Long> itemIds, Long shopId, Integer status) {
        return ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().in((Object)"item_id", itemIds)).eq((Object)"shop_id", (Object)shopId)).eq((Object)"status", (Object)status)).list();
    }

    @Override
    public List<ShelfDgEo> selectBySkuIdsAndShopIds(Set<Long> skuIds, Set<Long> shopIds) {
        return ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().in((Object)"sku_id", skuIds)).in((Object)"shop_id", shopIds)).list();
    }
}

