/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.boot.mqc;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.yunxi.dg.base.center.item.constants.StorageChangeLogStatusDgEnum;
import com.yunxi.dg.base.center.item.dao.vo.TradeOrderMessageDgVo;
import com.yunxi.dg.base.center.item.domain.entity.IItemStorageDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IStorageChangeLogDgDomain;
import com.yunxi.dg.base.center.item.eo.ItemStorageDgEo;
import com.yunxi.dg.base.center.item.eo.StorageChangeLogDgEo;
import com.yunxi.dg.base.center.item.service.util.ItemStorageDgUtils;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@MQDesc(tag="VIRTUAL_TRADE_ORDER_STORAGE_CHANGE_DG")
public class TradeOrderStatusDgProcess
implements IMessageProcessor {
    private Logger logger = LoggerFactory.getLogger(TradeOrderStatusDgProcess.class);
    @Resource
    private IStorageChangeLogDgDomain storageChangeLogDgDomain;
    @Resource
    private IItemStorageDgDomain itemStorageDgDomain;
    @Resource
    private ItemStorageDgUtils itemStorageDgUtils;
    private String wait = "wait_delivery";
    private String cancel = "cancel_delivery";

    @Transactional(rollbackFor={Exception.class})
    public MessageResponse process(Object message) {
        this.logger.info("\u83b7\u53d6\u5230\u4ea4\u6613\u4e2d\u5fc3mq\u6d88\u606f:{}", (Object)JSON.toJSONString((Object)message));
        MessageVo messageVo = (MessageVo)message;
        try {
            TradeOrderMessageDgVo tradeOrderMessageDgVo = (TradeOrderMessageDgVo)JSON.parseObject((String)String.valueOf(messageVo.getData()), TradeOrderMessageDgVo.class);
            if (tradeOrderMessageDgVo == null) {
                this.logger.info("\u65e0\u6cd5\u89e3\u6790\u51fa\u4ea4\u6613\u4e2d\u5fc3\u7684mq\u6d88\u606f\u5185\u5bb9");
                return MessageResponse.SUCCESS;
            }
            StorageChangeLogDgEo storageChangeLogDgEo = new StorageChangeLogDgEo();
            storageChangeLogDgEo.setOrderNo(tradeOrderMessageDgVo.getOrderNo());
            storageChangeLogDgEo.setInstanceId(tradeOrderMessageDgVo.getInstanceId());
            storageChangeLogDgEo.setTenantId(tradeOrderMessageDgVo.getTenantId());
            List storageChangeLogDgEoList = this.storageChangeLogDgDomain.selectList((BaseEo)storageChangeLogDgEo);
            if (CollectionUtils.isEmpty((Collection)storageChangeLogDgEoList)) {
                this.logger.info("\u4e0d\u5b58\u5728\u4ea4\u6613\u8ba2\u5355\u53f7:{},\u5b9e\u4f8b:{},\u79df\u6237:{}\u7684\u5546\u54c1\u5e93\u5b58\u53d8\u66f4\u8bb0\u5f55\u6570\u636e", new Object[]{tradeOrderMessageDgVo.getOrderNo(), tradeOrderMessageDgVo.getInstanceId(), tradeOrderMessageDgVo.getTenantId()});
                return MessageResponse.SUCCESS;
            }
            for (StorageChangeLogDgEo changeLogEo : storageChangeLogDgEoList) {
                if (!changeLogEo.getStatus().equals(StorageChangeLogStatusDgEnum.PREEMPTION.getStatus())) {
                    return MessageResponse.SUCCESS;
                }
                ItemStorageDgEo itemStorageDgEo = new ItemStorageDgEo();
                itemStorageDgEo.setShelfId(changeLogEo.getShelfId());
                itemStorageDgEo.setInstanceId(changeLogEo.getInstanceId());
                itemStorageDgEo.setTenantId(changeLogEo.getTenantId());
                itemStorageDgEo = (ItemStorageDgEo)this.itemStorageDgDomain.selectOne((BaseEo)itemStorageDgEo);
                if (itemStorageDgEo == null) {
                    this.logger.info("\u67e5\u8be2\u4e0d\u5230\u5546\u54c1\u5e93\u5b58\u6570\u636e");
                    continue;
                }
                ItemStorageDgEo storageUpdateEo = new ItemStorageDgEo();
                storageUpdateEo.setId(itemStorageDgEo.getId());
                StorageChangeLogDgEo changeUpdateEo = new StorageChangeLogDgEo();
                changeUpdateEo.setId(changeLogEo.getId());
                if (this.wait.equals(tradeOrderMessageDgVo.getOrderStatus())) {
                    storageUpdateEo.setBalance(Long.valueOf(itemStorageDgEo.getBalance() - changeLogEo.getAppending()));
                    storageUpdateEo.setAppending(Long.valueOf(itemStorageDgEo.getAppending() - changeLogEo.getAppending()));
                    changeUpdateEo.setStatus(StorageChangeLogStatusDgEnum.CONFIRM.getStatus());
                } else {
                    if (!this.cancel.equals(tradeOrderMessageDgVo.getOrderStatus())) continue;
                    storageUpdateEo.setAppending(Long.valueOf(itemStorageDgEo.getAppending() - changeLogEo.getAppending()));
                    changeUpdateEo.setStatus(StorageChangeLogStatusDgEnum.CANCEL.getStatus());
                    this.logger.info("\u8ba2\u5355\u53d6\u6d88\u5546\u54c1\u5e93\u5b58\u56de\u6eda\u5f00\u59cb");
                    boolean result = this.itemStorageDgUtils.addItemStorage(changeLogEo.getShopId(), changeLogEo.getSkuId(), changeLogEo.getAppending());
                    this.logger.info("\u8ba2\u5355\u53d6\u6d88\u5546\u54c1\u5e93\u5b58\u56de\u6eda\u7ed3\u675f\uff0c\u56de\u6eda\u7ed3\u679c\uff1a{}", (Object)result);
                }
                this.itemStorageDgDomain.updateSelective((BaseEo)storageUpdateEo);
                this.storageChangeLogDgDomain.updateSelective((BaseEo)changeUpdateEo);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return MessageResponse.ERROR;
        }
        return MessageResponse.SUCCESS;
    }
}

