/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.mqc;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.yunxi.dg.base.center.item.service.entity.IItemPushOaAssistService;
import com.yunxi.dg.base.commons.rpc.third.audit.PushThirdAuditBo;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@MQDesc(tag="OA_AUDIT_RESULT_MAPPING", msgType="publish")
public class ItemOaAuditCustomer
implements IMessageProcessor<String> {
    private static final Logger log = LoggerFactory.getLogger(ItemOaAuditCustomer.class);
    @Resource
    private IItemPushOaAssistService itemPushOaAssistService;
    @Resource
    private ILockService lockService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageResponse process(String message) {
        log.info("[oa\u5ba1\u6838\u56de\u8c03\u7ed3\u679c]:{}", (Object)message);
        Mutex lock = null;
        PushThirdAuditBo pushThirdAuditBo = (PushThirdAuditBo)JSONObject.parseObject((String)message, PushThirdAuditBo.class);
        String orderType = pushThirdAuditBo.getOrderType();
        Long orderId = pushThirdAuditBo.getBusinessOrderId();
        try {
            String status = pushThirdAuditBo.getStatus();
            if (ObjectUtil.isNull((Object)orderId) || ObjectUtil.isNull((Object)status)) {
                log.info("[oa\u5ba1\u6838\u56de\u8c03\u7ed3\u679c]\u6d88\u8d39\u5931\u8d25\uff0c\u53c2\u6570\u4e0d\u5b8c\u6574");
                MessageResponse messageResponse = MessageResponse.SUCCESS;
                return messageResponse;
            }
            if (ObjectUtil.equal((Object)"bom_form_audit", (Object)orderType)) {
                lock = this.lockService.lock("it_item_version_dg:", orderId + "_" + orderType, 0, 10, TimeUnit.SECONDS);
                this.itemPushOaAssistService.bomOaAuditCallBack(pushThirdAuditBo, status);
                log.info("[bom\u6e05\u5355oa\u5ba1\u6838\u56de\u8c03\u7ed3\u679c]\u6d88\u8d39\u6210\u529f\uff0c\u6d88\u606f\u4f53\uff1a{}", (Object)message);
            } else {
                log.info("\u5355\u636e\u7c7b\u578b\u4e0d\u662fbom\u6e05\u5355\u7533\u8bf7\uff1a{}", (Object)orderType);
            }
        }
        catch (Exception e) {
            log.info("bom\u6e05\u5355oa\u5ba1\u6838\u56de\u8c03\u5931\u8d25,\u62a5\u9519\u4fe1\u606f\uff1a{}", (Throwable)e);
            MessageResponse messageResponse = MessageResponse.ERROR;
            return messageResponse;
        }
        finally {
            if (Objects.nonNull(lock)) {
                this.lockService.unlock(lock);
            }
        }
        return MessageResponse.SUCCESS;
    }
}

