/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.rest;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.yunxi.dg.base.center.item.api.directory.IDirectoryDgTreeQueryApi;
import com.yunxi.dg.base.center.item.dto.request.DirTreeDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.DirectoryDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.RootDirectoryDgReqDto;
import com.yunxi.dg.base.center.item.dto.response.DirIndexDgTreeDto;
import com.yunxi.dg.base.center.item.dto.response.DirectoryItemTreeDto;
import com.yunxi.dg.base.center.item.eo.DirIndexDgEo;
import com.yunxi.dg.base.center.item.exception.ItemBusinessRuntimeException;
import com.yunxi.dg.base.center.item.exception.ItemExceptionCode;
import com.yunxi.dg.base.center.item.service.entity.IDirectoryDgService;
import com.yunxi.dg.base.center.item.service.entity.IDirectoryItemDgService;
import com.yunxi.dg.base.center.item.service.entity.IDirectoryItemTreeService;
import com.yunxi.dg.base.center.item.service.util.QueryParamDgUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/dg/dir"})
public class DirectoryDgTreeQueryRest
implements IDirectoryDgTreeQueryApi {
    @Resource
    private IDirectoryItemTreeService directoryItemTreeService;
    @Resource
    private IDirectoryItemDgService directoryItemDgService;
    @Resource
    private IDirectoryDgService directoryDgService;

    public RestResponse<List<DirectoryItemTreeDto>> queryDgDirTree(DirTreeDgReqDto dirTreeDgReqDto) {
        return new RestResponse((Object)this.directoryItemTreeService.queryDgDirTree(dirTreeDgReqDto));
    }

    public RestResponse<List<DirectoryItemTreeDto>> queryDgDirectoryTreeById(Long id, String dirUsage, Long shopId) {
        return new RestResponse((Object)this.directoryItemTreeService.queryDgDirectoryTreeById(id, dirUsage, shopId));
    }

    public RestResponse<List<DirectoryItemTreeDto>> queryDgDirTreeByName(String name, String dirUsage) {
        if (!StringUtils.isNotBlank((CharSequence)name) && !StringUtils.isNotBlank((CharSequence)dirUsage)) {
            throw new BizException(ItemExceptionCode.EMPTY_PARAM_ERROR.getCode(), ItemExceptionCode.EMPTY_PARAM_ERROR.getMsg());
        }
        DirIndexDgEo example = new DirIndexDgEo();
        example.setDirUsage(dirUsage);
        example.setInstanceId(null);
        example.setTenantId(null);
        List directoryEos = this.directoryItemDgService.queryDirectory(example);
        ArrayList<Long> idsList = new ArrayList<Long>();
        for (DirIndexDgEo directoryEo : directoryEos) {
            idsList.add(directoryEo.getRootId());
        }
        List treeDtos = this.directoryItemTreeService.queryDgDirTreeByName(name, idsList);
        return new RestResponse((Object)treeDtos);
    }

    public RestResponse<List<DirectoryItemTreeDto>> queryDgDirectoryTreeByFilter(RootDirectoryDgReqDto reqDto) {
        if (Objects.nonNull(reqDto)) {
            DirIndexDgEo example = DirIndexDgEo.newInstance((Map)reqDto.getExtFields());
            DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)example);
            QueryParamDgUtils.columnLike((BaseEo)example, (String)"name", (String)example.getName());
            List directoryEos = this.directoryDgService.queryDirectory(example);
            ArrayList<Long> idsList = new ArrayList<Long>();
            for (DirIndexDgEo directoryEo : directoryEos) {
                idsList.add(directoryEo.getRootId());
            }
            List treeDtos = this.directoryItemTreeService.queryDirByRootIds(idsList, null);
            return new RestResponse((Object)treeDtos);
        }
        throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR.getCode(), ItemExceptionCode.EMPTY_PARAM_ERROR.getMsg());
    }

    public RestResponse<DirectoryItemTreeDto> queryDgDirectoryTree(Long id, DirectoryDgReqDto directoryDgReqDto) {
        if (Objects.nonNull(directoryDgReqDto)) {
            ArrayList<Long> idsList = new ArrayList<Long>();
            idsList.add(id);
            List treeDtos = this.directoryItemTreeService.queryDirByRootIds(idsList, directoryDgReqDto.getStatus());
            if (CollectionUtils.isEmpty((Collection)treeDtos)) {
                throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_DIR.getCode(), ItemExceptionCode.NON_EXIST_DIR.getMsg());
            }
            return new RestResponse(treeDtos.get(0));
        }
        throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR.getCode(), ItemExceptionCode.EMPTY_PARAM_ERROR.getMsg());
    }

    public RestResponse<List<DirIndexDgTreeDto>> queryDgDirTreeDetail(RootDirectoryDgReqDto reqDto) {
        if (reqDto == null || reqDto.getInstanceId() == null || reqDto.getTenantId() == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PARAM);
        }
        return new RestResponse((Object)this.directoryItemTreeService.queryDgDirTreeDetail(reqDto));
    }
}

