/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.pulldata.service.component.fetch.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yunxi.dg.base.center.pulldata.dao.mapper.ThreeInventoryPostDetailMapper;
import com.yunxi.dg.base.center.pulldata.dto.entity.ThreeInventoryPostDetailDto;
import com.yunxi.dg.base.center.pulldata.service.component.fetch.DataFetchBo;
import com.yunxi.dg.base.center.pulldata.service.component.fetch.DataFetchStrategy;
import com.yunxi.dg.base.center.pulldata.service.component.refresher.DataInserter;
import com.yunxi.dg.base.center.pulldata.service.component.runner.BizRunnerAfterGetLockRunner;
import com.yunxi.dg.base.center.pulldata.service.component.selector.DataFetchStrategySelector;
import com.yunxi.dg.base.center.pulldata.service.entity.IThreeInventoryPostDetailService;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractDataFetchStrategy
implements DataFetchStrategy,
InitializingBean {
    @Resource
    private ThreeInventoryPostDetailMapper mapper;
    @Resource
    private DataInserter dataInserter;
    @Resource
    private DataFetchStrategySelector dataFetchStrategySelector;
    @Resource
    IThreeInventoryPostDetailService service;
    @Resource
    private BizRunnerAfterGetLockRunner runner;

    public void afterPropertiesSet() throws Exception {
        this.dataFetchStrategySelector.register(this.type(), this);
    }

    @Override
    public void fetchAndSaveData(DataFetchBo dataFetchBo) {
        this.runner.run(String.format("fetchAndSaveData_%s", dataFetchBo.getSource()), () -> {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"reconciliation_time", (Object)dataFetchBo.getReconciliationDate());
            queryWrapper.eq((Object)"source", (Object)dataFetchBo.getSource());
            return this.mapper.count(queryWrapper) > 0;
        }, s -> this.doFetchAndSaveData(dataFetchBo));
    }

    public abstract void doFetchAndSaveData(DataFetchBo var1);

    public void doSave(List<ThreeInventoryPostDetailDto> dtoList) {
        this.dataInserter.doBatchInsert(this.service, dtoList);
    }

    public void doDelete(ThreeInventoryPostDetailDto dto) {
        this.service.delete(dto);
    }
}

