/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.dao.das.customer.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.eo.BaseEo;
import com.yunxi.dg.base.center.report.dao.das.customer.IDgCustomerDas;
import com.yunxi.dg.base.center.report.dao.mapper.customer.DgCustomerMapper;
import com.yunxi.dg.base.center.report.dto.customer.request.CsTransactionCustomerQueryDto;
import com.yunxi.dg.base.center.report.dto.customer.request.CsTransactionCustomerQueryExtDto;
import com.yunxi.dg.base.center.report.dto.customer.request.CustomerTransactionStatusCountQueryDto;
import com.yunxi.dg.base.center.report.dto.customer.response.CsCustomerCountRespDto;
import com.yunxi.dg.base.center.report.dto.customer.response.CsTransactionCustomerInfoRespDto;
import com.yunxi.dg.base.center.report.dto.customer.response.CuCustomerRespDto;
import com.yunxi.dg.base.center.report.dto.customer.response.CustomerFinancialOrgPlatformRespDto;
import com.yunxi.dg.base.center.report.dto.customer.response.FinancialOrgByPlatformVo;
import com.yunxi.dg.base.center.report.dto.customer.response.OperationTeamRespDto;
import com.yunxi.dg.base.center.report.dto.customer.response.RPlatCusRespDto;
import com.yunxi.dg.base.center.report.eo.customer.DgCustomerEo;
import com.yunxi.dg.base.framework.core.db.das.AbstractDas;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Repository;

@Repository
public class DgCustomerDasImpl
extends AbstractDas<DgCustomerEo, String>
implements IDgCustomerDas {
    @Resource
    private DgCustomerMapper dgCustomerMapper;

    @Override
    public List<CsTransactionCustomerInfoRespDto> listTransactionCustomer(CsTransactionCustomerQueryDto reqDto, List<Integer> businessType) {
        return this.dgCustomerMapper.listTransactionCustomer(reqDto, businessType);
    }

    @Override
    public List<CsTransactionCustomerInfoRespDto> listCustomer(CsTransactionCustomerQueryExtDto reqDto, List<Integer> businessType) {
        return this.dgCustomerMapper.listCustomer(reqDto, businessType);
    }

    @Override
    public Map<Integer, Integer> queryGroupByStatusCount(CustomerTransactionStatusCountQueryDto reqDto, List<Integer> businessType) {
        List<CsCustomerCountRespDto> csCustomerCountRespDtos = this.dgCustomerMapper.queryGroupByStatusCount(reqDto, businessType);
        return ((List)Optional.ofNullable(csCustomerCountRespDtos).orElse(new ArrayList())).stream().collect(Collectors.toMap(CsCustomerCountRespDto::getStatus, CsCustomerCountRespDto::getCountNum));
    }

    @Override
    public List<DgCustomerEo> queryByCodes(Set<String> customerCodes) {
        if (customerCodes == null || customerCodes.isEmpty()) {
            return Collections.emptyList();
        }
        return this.dgCustomerMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(DgCustomerEo.class).in(DgCustomerEo::getCode, customerCodes)).eq(BaseEo::getDr, (Object)0));
    }

    @Override
    public List<CuCustomerRespDto> queryCuCustomerIds(List<String> customerCodesList) {
        return this.dgCustomerMapper.queryCuCustomerIds(customerCodesList);
    }

    @Override
    public List<OperationTeamRespDto> queryOperationTeamEos(List<Long> operatorTeamIds) {
        return this.dgCustomerMapper.queryOperationTeamEos(operatorTeamIds);
    }

    @Override
    public List<RPlatCusRespDto> queryRPlatCusByList(List<Long> customerIds) {
        return this.dgCustomerMapper.queryRPlatCusByList(customerIds);
    }

    @Override
    public List<CustomerFinancialOrgPlatformRespDto> queryFinancialOrgPlatformByCustomerId(List<Long> customerIds, Integer orgType) {
        return this.dgCustomerMapper.queryFinancialOrgPlatformByCustomerId(customerIds, orgType);
    }

    @Override
    public List<FinancialOrgByPlatformVo> getFinancialOrgByPlatformIds(List<Long> ids) {
        return this.dgCustomerMapper.getFinancialOrgByPlatformIds(ids);
    }
}

