/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.domain.customer.impl;

import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.report.dao.das.customer.IDgCustomerDas;
import com.yunxi.dg.base.center.report.domain.customer.IDgCustomerDomain;
import com.yunxi.dg.base.center.report.dto.customer.request.CsTransactionCustomerQueryDto;
import com.yunxi.dg.base.center.report.dto.customer.request.CsTransactionCustomerQueryExtDto;
import com.yunxi.dg.base.center.report.dto.customer.request.CustomerTransactionStatusCountQueryDto;
import com.yunxi.dg.base.center.report.dto.customer.response.CsTransactionCustomerInfoRespDto;
import com.yunxi.dg.base.center.report.dto.customer.response.CuCustomerRespDto;
import com.yunxi.dg.base.center.report.dto.customer.response.CustomerFinancialOrgPlatformRespDto;
import com.yunxi.dg.base.center.report.dto.customer.response.FinancialOrgByPlatformVo;
import com.yunxi.dg.base.center.report.dto.customer.response.FinancialOrgRespDto;
import com.yunxi.dg.base.center.report.dto.customer.response.OperationTeamRespDto;
import com.yunxi.dg.base.center.report.dto.customer.response.RPlatCusRespDto;
import com.yunxi.dg.base.center.report.eo.customer.DgCustomerEo;
import com.yunxi.dg.base.framework.core.db.das.ICommonDas;
import com.yunxi.dg.base.framework.core.domain.BaseDomainImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DgCustomerDomainImpl
extends BaseDomainImpl<DgCustomerEo>
implements IDgCustomerDomain {
    @Resource
    private IDgCustomerDas iDgCustomerDas;

    public ICommonDas<DgCustomerEo> commonDas() {
        return this.iDgCustomerDas;
    }

    @Override
    public PageInfo<CsTransactionCustomerInfoRespDto> queryTransactionCustomerPage(CsTransactionCustomerQueryDto reqDto, List<Integer> businessType) {
        PageHelper.startPage((int)reqDto.getPageNum(), (int)reqDto.getPageSize());
        List transactionCustomerList = this.iDgCustomerDas.listTransactionCustomer(reqDto, businessType);
        PageHelper.clearPage();
        return new PageInfo(transactionCustomerList);
    }

    @Override
    public List<DgCustomerEo> listCustomerByCompanyIds(Set<Long> companyIds) {
        DgCustomerEo dgCustomerEo = new DgCustomerEo();
        dgCustomerEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.in((String)"company_id", companyIds)}));
        return this.iDgCustomerDas.selectList((BaseEo)dgCustomerEo);
    }

    @Override
    public List<CsTransactionCustomerInfoRespDto> queryTransactionCustomerList(CsTransactionCustomerQueryDto reqDto, List<Integer> businessType) {
        return this.iDgCustomerDas.listTransactionCustomer(reqDto, businessType);
    }

    @Override
    public PageInfo<CsTransactionCustomerInfoRespDto> queryCustomerPage(CsTransactionCustomerQueryExtDto reqDto, List<Integer> businessType) {
        PageHelper.startPage((int)reqDto.getPageNum(), (int)reqDto.getPageSize());
        List list = this.iDgCustomerDas.listCustomer(reqDto, businessType);
        PageHelper.clearPage();
        return new PageInfo(list);
    }

    @Override
    public List<CsTransactionCustomerInfoRespDto> queryCustomerList(CsTransactionCustomerQueryExtDto reqDto, List<Integer> businessType) {
        return this.iDgCustomerDas.listCustomer(reqDto, businessType);
    }

    @Override
    public Map<Integer, Integer> queryGroupByStatusCount(CustomerTransactionStatusCountQueryDto reqDto, List<Integer> businessType) {
        return this.iDgCustomerDas.queryGroupByStatusCount(reqDto, businessType);
    }

    @Override
    public List<DgCustomerEo> queryByCodes(Set<String> customerCodes) {
        return this.iDgCustomerDas.queryByCodes(customerCodes);
    }

    @Override
    public List<CuCustomerRespDto> queryCuCustomerIds(List<String> customerCodeList) {
        return this.iDgCustomerDas.queryCuCustomerIds(customerCodeList);
    }

    @Override
    public List<RPlatCusRespDto> queryRPlatCusByList(List<Long> customerIds) {
        return this.iDgCustomerDas.queryRPlatCusByList(customerIds);
    }

    @Override
    public List<CustomerFinancialOrgPlatformRespDto> queryFinancialOrgPlatformByCustomerId(List<Long> customerIds, Integer orgType) {
        return this.iDgCustomerDas.queryFinancialOrgPlatformByCustomerId(customerIds, orgType);
    }

    @Override
    public List<OperationTeamRespDto> queryOperationTeamEos(List<Long> operatorTeamIds) {
        return this.iDgCustomerDas.queryOperationTeamEos(operatorTeamIds);
    }

    @Override
    public Map<Long, List<FinancialOrgRespDto>> getFinancialOrgByPlatformIds(List<Long> ids) {
        HashMap<Long, List<FinancialOrgRespDto>> map = new HashMap<Long, List<FinancialOrgRespDto>>();
        if (CollectionUtils.isEmpty(ids)) {
            return map;
        }
        List vos = this.iDgCustomerDas.getFinancialOrgByPlatformIds(ids);
        if (CollectionUtils.isEmpty((Collection)vos)) {
            return map;
        }
        Map<Long, List<FinancialOrgByPlatformVo>> listMap = vos.stream().collect(Collectors.groupingBy(FinancialOrgByPlatformVo::getPlatformId));
        listMap.forEach((k, v) -> {
            ArrayList dtos = Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)dtos, (Collection)v, FinancialOrgRespDto.class);
            map.put((Long)k, dtos);
        });
        return map;
    }
}

