/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.util;

import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.huieryun.opensearch.enums.LogicalSymbol;
import com.dtyunxi.huieryun.opensearch.enums.SortOrder;
import com.dtyunxi.huieryun.opensearch.vo.FilterFieldVo;
import com.dtyunxi.huieryun.opensearch.vo.OSSearchVo;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.util.ParamConverter;
import com.google.common.base.Functions;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.report.anno.es.BaseEsOption;
import com.yunxi.dg.base.center.report.anno.es.EsCondition;
import com.yunxi.dg.base.center.report.anno.es.EsEqualOption;
import com.yunxi.dg.base.center.report.anno.es.EsExistsOption;
import com.yunxi.dg.base.center.report.anno.es.EsInOption;
import com.yunxi.dg.base.center.report.anno.es.EsNonInOption;
import com.yunxi.dg.base.center.report.anno.es.EsRangeNumOption;
import com.yunxi.dg.base.center.report.anno.es.EsRangeOption;
import com.yunxi.dg.base.center.report.anno.es.EsWildcardOption;
import com.yunxi.dg.base.center.report.constants.EsOptionType;
import com.yunxi.dg.base.center.report.constants.IsFlagEnum;
import com.yunxi.dg.base.center.report.dto.es.resp.EsSearchBuildResp;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class EsSearchUtils {
    private static final Logger logger = LoggerFactory.getLogger(EsSearchUtils.class);
    private OSSearchVo queryVo = new OSSearchVo();

    public static EsSearchUtils newInstance() {
        return new EsSearchUtils();
    }

    private static List<Annotation> contains(Annotation[] fields) {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        Arrays.asList(fields).forEach(field -> {
            if (field instanceof EsEqualOption || field instanceof EsWildcardOption || field instanceof EsRangeOption || field instanceof EsRangeNumOption || field instanceof EsCondition || field instanceof EsInOption || field instanceof EsExistsOption || field instanceof EsNonInOption) {
                annotations.add((Annotation)field);
            }
        });
        return annotations;
    }

    private static EsSearchBuildResp buildContext(Field[] fieldList) {
        List<Field> fields = Arrays.asList(fieldList);
        EsSearchBuildResp searchBuildResp = new EsSearchBuildResp();
        Map fieldAnnoMaps = fields.stream().filter(e -> !CollectionUtils.isEmpty(EsSearchUtils.contains(e.getAnnotations()))).collect(Collectors.toMap(Functions.identity(), e -> EsSearchUtils.contains(e.getAnnotations())));
        searchBuildResp.setFieldAnnoMaps(fieldAnnoMaps);
        Map<String, List<Field>> rangeKeyMap = fields.stream().filter(e -> Objects.nonNull(e.getAnnotation(EsRangeOption.class))).collect(Collectors.groupingBy(e -> e.getAnnotation(EsRangeOption.class).key()));
        searchBuildResp.setRangeKeyMap(rangeKeyMap);
        Map<String, List<Field>> rangeNumKeyMap = fields.stream().filter(e -> Objects.nonNull(e.getAnnotation(EsRangeNumOption.class))).collect(Collectors.groupingBy(e -> e.getAnnotation(EsRangeNumOption.class).key()));
        searchBuildResp.setRangeNumKeyMap(rangeNumKeyMap);
        return searchBuildResp;
    }

    public OSSearchVo getNewSearchVo(Object obj) throws Exception {
        ArrayList inSuccess = Lists.newArrayList();
        Field[] fields = obj.getClass().getDeclaredFields();
        EsSearchBuildResp searchBuildResp = EsSearchUtils.buildContext(fields);
        for (Field field : fields) {
            List annotations = (List)searchBuildResp.getFieldAnnoMaps().get(field);
            if (CollectionUtils.isEmpty((Collection)annotations)) continue;
            for (Annotation annotation : annotations) {
                String key;
                String o2;
                String o1;
                List keyFieldList;
                EsRangeOption rangeOption;
                String key2;
                String key3;
                Object fieldVal = this.getFieldVal(obj, field);
                if (Objects.isNull(fieldVal)) continue;
                String val = fieldVal instanceof List ? null : fieldVal.toString();
                Class<? extends Annotation> esOption = annotation.annotationType();
                BaseEsOption baseEsOption = esOption.getAnnotation(BaseEsOption.class);
                EsOptionType optionType = baseEsOption.optionType();
                if (optionType == EsOptionType.EQUAL) {
                    EsEqualOption equalOption = (EsEqualOption)annotation;
                    key3 = this.getKey(field, equalOption.key());
                    logger.info("\u7cbe\u51c6\u5339\u914dkey:{},val:{}", (Object)key3, (Object)val);
                    this.queryVo.addEqualFilter(key3, val);
                    continue;
                }
                if (optionType == EsOptionType.WILDCARD) {
                    EsWildcardOption wildcardOption = (EsWildcardOption)annotation;
                    if (wildcardOption.keys().length > 0) {
                        logger.info("\u6a21\u7cca\u5339\u914dkey:{},val:{}", (Object)wildcardOption.keys(), (Object)val);
                        this.queryVo.addWildcardFilter(wildcardOption.keys(), "*" + val + "*", LogicalSymbol.OR);
                        continue;
                    }
                    key3 = this.getKey(field, wildcardOption.key());
                    logger.info("\u6a21\u7cca\u5339\u914dkey:{},val:{}", (Object)key3, (Object)val);
                    this.queryVo.addWildcardFilter(key3, "*" + val + "*");
                    continue;
                }
                if (optionType == EsOptionType.IN) {
                    EsInOption inOption = (EsInOption)annotation;
                    String[] keys = inOption.keys();
                    if (keys.length == 0) {
                        key2 = this.getKey(field, inOption.key());
                        keys = new String[]{key2};
                    }
                    FilterFieldVo filter = this.queryVo.createCompoundFilter(LogicalSymbol.AND);
                    List inList = (List)fieldVal;
                    if (CollectionUtils.isEmpty((Collection)inList)) continue;
                    for (String o : inList) {
                        if (inOption.optionType() == EsOptionType.WILDCARD) {
                            this.addWildcardFilter(filter, keys, this.wildcard(o));
                            continue;
                        }
                        this.addEqualsFilter(filter, keys, o);
                    }
                    this.queryVo.addFilters(new FilterFieldVo[]{filter});
                    continue;
                }
                if (optionType == EsOptionType.NOT_IN) {
                    EsNonInOption nonInOption = (EsNonInOption)annotation;
                    String[] fieldNames = nonInOption.keys();
                    if (fieldNames.length == 0) {
                        key2 = this.getKey(field, nonInOption.key());
                        fieldNames = new String[]{key2};
                    }
                    List nonInList = (List)fieldVal;
                    for (int i = 0; i < fieldNames.length; ++i) {
                        this.queryVo.addNonInFilter(fieldNames[i], nonInList.toArray(new String[0]));
                    }
                    continue;
                }
                if (optionType == EsOptionType.EXISTS) {
                    EsExistsOption existsOption = (EsExistsOption)annotation;
                    key3 = this.getKey(field, existsOption.key());
                    if (IsFlagEnum.YES.getCode().equals(val)) {
                        this.queryVo.addExistsFilter(key3);
                        continue;
                    }
                    FilterFieldVo nonExistsFilter = FilterFieldVo.exists((String)key3);
                    nonExistsFilter.setNon(Boolean.valueOf(true));
                    this.queryVo.addFilters(new FilterFieldVo[]{nonExistsFilter});
                    continue;
                }
                if (optionType == EsOptionType.RANGE) {
                    rangeOption = (EsRangeOption)annotation;
                    if (rangeOption.priority() != 2 || (keyFieldList = (List)searchBuildResp.getRangeKeyMap().get(rangeOption.key())).size() != 2) continue;
                    keyFieldList.stream().sorted(Comparator.comparing(handle -> handle.getAnnotation(EsRangeOption.class).priority()));
                    o1 = this.getDateTimeStr(this.getFieldVal(obj, (Field)keyFieldList.get(0)));
                    o2 = this.getDateTimeStr(this.getFieldVal(obj, (Field)keyFieldList.get(1)));
                    if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)o1) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)o2)) continue;
                    key = this.getKey(field, rangeOption.key());
                    logger.info("\u8303\u56f4\u641c\u7d22:{},[{},{}]", new Object[]{key, this.beginTimeLong(o1), this.endTimeLong(o2)});
                    this.queryVo.addRangeFilter(key, this.beginTimeLong(o1), this.endTimeLong(o2));
                    continue;
                }
                if (optionType == EsOptionType.RANGE_NUM) {
                    rangeOption = (EsRangeNumOption)annotation;
                    if (inSuccess.contains(rangeOption.key())) continue;
                    keyFieldList = (List)searchBuildResp.getRangeNumKeyMap().get(rangeOption.key());
                    keyFieldList.stream().sorted(Comparator.comparing(handle -> handle.getAnnotation(EsRangeNumOption.class).priority()));
                    o1 = ParamConverter.convertToString((Object)this.getFieldVal(obj, (Field)keyFieldList.get(0)));
                    if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)o1)) {
                        o1 = BigDecimal.ZERO.toString();
                    }
                    if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)(o2 = ParamConverter.convertToString((Object)this.getFieldVal(obj, (Field)keyFieldList.get(1)))))) {
                        o2 = String.valueOf(Integer.MAX_VALUE);
                    }
                    if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)o1) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)o2)) continue;
                    key = this.getKey(field, rangeOption.key());
                    logger.info("\u8303\u56f4\u641c\u7d22:{},[{},{}]", new Object[]{key, o1, o2});
                    this.queryVo.addRangeFilter(key, o1, o2);
                    inSuccess.add(rangeOption.key());
                    continue;
                }
                if (optionType != EsOptionType.COMMON) continue;
                EsCondition condition = (EsCondition)annotation;
                if (condition.optionType() == EsOptionType.PAGE_NUM) {
                    logger.info("\u9875\u6570:{}", (Object)val);
                    this.queryVo.setPage(Integer.parseInt(val));
                    continue;
                }
                if (condition.optionType() == EsOptionType.PAGE_SIZE) {
                    logger.info("\u6bcf\u9875\u663e\u793a:{}", (Object)val);
                    this.queryVo.setPageSize(Integer.parseInt(val));
                    continue;
                }
                if (condition.optionType() == EsOptionType.ORDER_BY) {
                    logger.info("\u6392\u5e8f:{}", (Object)val);
                    this.queryVo.addSort(val, SortOrder.DESC);
                    continue;
                }
                if (condition.optionType() != EsOptionType.DR) continue;
                logger.info("dr:{}", (Object)val);
                this.queryVo.addEqualFilter("dr", val);
            }
        }
        return this.queryVo;
    }

    private String getDateTimeStr(Object fieldVal1) {
        if (fieldVal1 instanceof Date) {
            return DateUtil.format((Date)((Date)fieldVal1), (String)"yyyy-MM-dd");
        }
        return ParamConverter.convertToString((Object)fieldVal1);
    }

    private String getKey(Field field, String key) {
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)key)) {
            return key;
        }
        return field.getName();
    }

    private Object getFieldVal(Object obj, Field field) throws Exception {
        Class<?> c = obj.getClass();
        String fieldName = field.getName();
        String getMethod = "get" + fieldName.substring(0, 1).toUpperCase(Locale.ROOT) + fieldName.substring(1);
        Method method = c.getMethod(getMethod, new Class[0]);
        Object val = method.invoke(obj, new Object[0]);
        return val;
    }

    protected String wildcard(String wildcard) {
        if (StringUtils.isBlank((String)wildcard)) {
            return "";
        }
        return String.format("*%s*", wildcard).replaceAll(" ", "");
    }

    protected Date beginTime(String time) {
        return DateUtil.parse((String)(time + " 00:00:00"), (String)DatePattern.DATETIME_PATTERN.getPattern());
    }

    protected Date endTime(String time) {
        return DateUtil.parse((String)(time + " 23:59:59"), (String)DatePattern.DATETIME_PATTERN.getPattern());
    }

    protected Date beginTime() {
        return this.beginTime("1970-01-01");
    }

    protected Date endTime() {
        return this.endTime("2050-12-30");
    }

    protected String beginTimeLong(String time) {
        return String.valueOf(this.beginTime(time).getTime());
    }

    protected String endTimeLong(String time) {
        return String.valueOf(this.endTime(time).getTime());
    }

    public final void addWildcardFilter(FilterFieldVo compoundFilter, String[] fieldNames, String likeValue) {
        for (int i = 0; i < fieldNames.length; ++i) {
            compoundFilter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.wildcard((String)fieldNames[i], (String)likeValue, (LogicalSymbol)LogicalSymbol.OR)});
        }
    }

    public final void addEqualsFilter(FilterFieldVo compoundFilter, String[] fieldNames, String likeValue) {
        for (int i = 0; i < fieldNames.length; ++i) {
            compoundFilter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.equal((String)fieldNames[i], (String)likeValue, (LogicalSymbol)LogicalSymbol.OR)});
        }
    }
}

