/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.scheduler.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.scheduler.api.IAppBizApi;
import com.dtyunxi.yundt.cube.center.scheduler.api.ITaskApi;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.AppBizQueryReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.AppBizUpdateReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskAndBizCreateReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskQueryReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskUpdateReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.response.AppBizQueryRespDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.response.TaskQueryRespDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.query.IAppBizQueryApi;
import com.dtyunxi.yundt.cube.center.scheduler.api.query.ITaskQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.report.scheduler.config.InstanceInfo;
import com.yunxi.dg.base.center.report.scheduler.config.SchedulerTaskProperties;
import com.yunxi.dg.base.center.report.scheduler.service.ISchedulerService;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SchedulerServiceImpl
implements ISchedulerService {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ITaskApi taskApi;
    @Autowired
    private ITaskQueryApi taskQueryApi;
    @Autowired
    private IAppBizApi appBizApi;
    @Autowired
    private IAppBizQueryApi appBizQueryApi;
    @Autowired
    private SchedulerTaskProperties schedulerTaskProperties;
    @Value(value="${scheduler.client.app_code}")
    private String appCode;

    @Override
    public void initScheduler() throws Exception {
        try {
            this.logger.info("1\u3001========\u300b\uff1a\u5f00\u59cb\u6267\u884c\u8c03\u5ea6\u4efb\u52a1\u521d\u59cb\u5316");
            List<InstanceInfo> instanceList = this.schedulerTaskProperties.getInstanceList();
            if (CollectionUtils.isEmpty(instanceList)) {
                this.logger.error("2\u3001========\u300b\uff1a\u6ca1\u6709\u8fdb\u884c\u8c03\u5ea6\u4efb\u52a1\u914d\u7f6e");
                return;
            }
            this.logger.info("3\u3001\u8c03\u5ea6\u4efb\u52a1\u914d\u7f6e:{}", (Object)JSON.toJSONString(instanceList));
            List<TaskAndBizCreateReqDto> taskAndBizList = this.schedulerTaskProperties.getTaskList();
            if (CollectionUtils.isEmpty(taskAndBizList)) {
                this.logger.error("4\u3001========\u300b\uff1a\u6ca1\u6709\u8fdb\u884c\u8c03\u5ea6\u4efb\u52a1\u5b9e\u4f8b\u914d\u7f6e");
                return;
            }
            this.logger.info("5\u3001\u8c03\u5ea6\u4efb\u52a1\u5b9e\u4f8b\u914d\u7f6e:{}", (Object)JSON.toJSONString(taskAndBizList));
            ArrayList successList = Lists.newArrayList();
            ArrayList failList = Lists.newArrayList();
            instanceList.forEach(instanceInfo -> taskAndBizList.forEach(taskAndBizCreateReqDto -> {
                AppBizQueryReqDto appBizQueryReqDto = new AppBizQueryReqDto();
                appBizQueryReqDto.setAppCode(this.appCode);
                appBizQueryReqDto.setBizCode(taskAndBizCreateReqDto.getBizCode());
                String filter = ObjectHelper.bean2Json((Object)appBizQueryReqDto);
                PageInfo pageInfo = (PageInfo)this.appBizQueryApi.queryByPage(filter, Integer.valueOf(1), Integer.valueOf(1)).getData();
                if (pageInfo == null || CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
                    try {
                        this.createTaskAndBiz((TaskAndBizCreateReqDto)taskAndBizCreateReqDto, (InstanceInfo)instanceInfo);
                        successList.add(taskAndBizCreateReqDto.getBizName());
                    }
                    catch (Exception e) {
                        failList.add(taskAndBizCreateReqDto.getBizName());
                        this.logger.error("\u3010\u3011\u521b\u5efa\u5931\u8d25", (Object)taskAndBizCreateReqDto.getBizName(), (Object)e);
                    }
                } else {
                    try {
                        AppBizQueryRespDto origAppBiz = (AppBizQueryRespDto)pageInfo.getList().get(0);
                        this.modifyTaskAndBiz((TaskAndBizCreateReqDto)taskAndBizCreateReqDto, origAppBiz, (InstanceInfo)instanceInfo);
                        successList.add(taskAndBizCreateReqDto.getBizName());
                    }
                    catch (Exception e) {
                        failList.add(taskAndBizCreateReqDto.getBizName());
                        this.logger.error("\u3010\u3011\u4fee\u6539\u5931\u8d25", (Object)taskAndBizCreateReqDto.getBizName(), (Object)e);
                    }
                }
            }));
            successList.forEach(taskName -> this.logger.info("=========>\u30106\u3001[{}]\u4efb\u52a1\u8fdb\u884c\u4e2d\u3002\u3002\u3002\u3011", taskName));
            failList.forEach(taskName -> this.logger.info("=========>\u30107\u3001[{}]\u4efb\u52a1\u521d\u59cb\u5316\u5931\u8d25\u3011", taskName));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception();
        }
    }

    private Long createTaskAndBiz(TaskAndBizCreateReqDto task, InstanceInfo instanceInfo) {
        Long taskId = null;
        task.setAppCode(this.appCode);
        task.setTaskName(task.getBizName());
        task.setShardType("SINGLE");
        String params = ObjectHelper.bean2Json((Object)instanceInfo);
        task.setParams(params);
        task.setInstanceId(instanceInfo.getInstanceId());
        task.setTenantId(instanceInfo.getTenantId());
        RestResponse restResponse = this.taskApi.addWithBiz(task);
        taskId = (Long)RestResponseHelper.extractData((RestResponse)restResponse);
        RequestDto enableParam = new RequestDto();
        enableParam.setInstanceId(instanceInfo.getInstanceId());
        enableParam.setTenantId(instanceInfo.getTenantId());
        String filter = ObjectHelper.bean2Json((Object)enableParam);
        RestResponse enableResponse = this.taskApi.enableById(taskId, filter);
        RestResponseHelper.checkOrThrow((RestResponse)enableResponse);
        return taskId;
    }

    private void modifyTaskAndBiz(TaskAndBizCreateReqDto task, AppBizQueryRespDto origAppBiz, InstanceInfo instanceInfo) {
        TaskQueryReqDto taskQueryReqDto = new TaskQueryReqDto();
        taskQueryReqDto.setTaskName(origAppBiz.getBizName());
        taskQueryReqDto.setAppBizId(origAppBiz.getId());
        String taskFilter = ObjectHelper.bean2Json((Object)taskQueryReqDto);
        PageInfo taskPageInfo = (PageInfo)this.taskQueryApi.queryByPage(taskFilter, Integer.valueOf(1), Integer.valueOf(1)).getData();
        if (null == taskPageInfo || CollectionUtils.isEmpty((Collection)taskPageInfo.getList())) {
            throw new BizException("\u4efb\u52a1\u4e0d\u5b58\u5728", origAppBiz.getBizName());
        }
        TaskQueryRespDto origTask = (TaskQueryRespDto)taskPageInfo.getList().get(0);
        if (!origTask.getScheduleExpression().equals(task.getScheduleExpression()) || !origTask.getTaskName().equals(task.getBizName())) {
            AppBizUpdateReqDto appBiz = new AppBizUpdateReqDto();
            appBiz.setBizName(task.getBizName());
            appBiz.setInstanceId(instanceInfo.getInstanceId());
            appBiz.setTenantId(instanceInfo.getTenantId());
            this.appBizApi.modifyById(origAppBiz.getId(), appBiz);
            RestResponse disableResponse = this.taskApi.disableById(origTask.getId(), "{}");
            RestResponseHelper.checkOrThrow((RestResponse)disableResponse);
            TaskUpdateReqDto taskUpate = new TaskUpdateReqDto();
            taskUpate.setScheduleExpression(task.getScheduleExpression());
            taskUpate.setTaskName(task.getBizName());
            taskUpate.setInstanceId(instanceInfo.getInstanceId());
            taskUpate.setTenantId(instanceInfo.getTenantId());
            String params = ObjectHelper.bean2Json((Object)instanceInfo);
            taskUpate.setParams(params);
            this.taskApi.modifyById(origTask.getId(), taskUpate);
            RestResponse enbaleResponse = this.taskApi.enableById(origTask.getId(), "{}");
            RestResponseHelper.checkOrThrow((RestResponse)enbaleResponse);
        }
    }
}

