/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.scheduler.utils;

import com.yunxi.dg.base.center.report.scheduler.utils.CacheMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger logger = LoggerFactory.getLogger(Utils.class);
    private static CacheMap cacheMap = new CacheMap(3600L, 1000);

    public static boolean isDevelopEnv() {
        String nacosCnfNs = System.getProperty("spring.cloud.nacos.config.namespace");
        if ("fc67814d-d7a8-4210-a0ea-e7b239e82bc6,eff9c877-559f-4f7d-a5fe-0885c7d25316".contains(nacosCnfNs)) {
            logger.info("\u6ce8\u610f\uff1a\u672c\u5730\u5f00\u53d1\u8c03\u8bd5\uff0c\u4e0d\u6267\u884c\u8be5\u65b9\u6cd5\uff1a" + Utils.getCallInfo(3));
            return true;
        }
        return false;
    }

    private static String getCallInfo(int depth) {
        StackTraceElement[] stacks = Thread.currentThread().getStackTrace();
        String[] result = new String[]{stacks[depth].getClassName(), stacks[depth].getMethodName(), stacks[depth].getLineNumber() + "", stacks[depth].getFileName()};
        return result[0] + "." + result[1];
    }

    public static Object getCacheValue(String category, Object key) {
        return cacheMap.get(category + ":" + key);
    }

    public static Object setCacheValue(String category, Object key, Object value) {
        return cacheMap.put(category + ":" + key, value);
    }

    public static <R> R or(R ... objs) {
        for (R item : objs) {
            if (item == null) continue;
            return item;
        }
        return null;
    }

    public static boolean equals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }
}

