/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.scheduler.task;

import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.AbstractSingleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import com.yunxi.dg.base.center.report.dto.entity.ReportSyncReqDto;
import com.yunxi.dg.base.center.report.service.entity.IFinishProductWarehouseInventoryReportService;
import java.time.LocalDateTime;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="finishProductWarehouseInventoryReport")
@Scope(value="prototype")
public class FinishProductWarehouseInventoryReportJob
extends AbstractSingleScheduleEvent {
    private static final Logger log = LoggerFactory.getLogger(FinishProductWarehouseInventoryReportJob.class);
    @Resource
    private IFinishProductWarehouseInventoryReportService service;

    public void before(TaskMsg taskMsg) {
        MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
        log.info("==========\u5f00\u59cb\u6267\u884c\u6210\u54c1\u4ed3\u5206\u5185\u5916\u4ed3\u76d8\u70b9\u62a5\u8868-WMS==========");
    }

    public boolean execute(TaskMsg taskMsg) {
        try {
            long time = System.currentTimeMillis();
            LocalDateTime lastOrderUpdateTime = this.service.getLastOrderUpdateTime();
            ReportSyncReqDto dto = new ReportSyncReqDto(lastOrderUpdateTime, null, Integer.valueOf(1));
            this.service.syncWithParams(dto);
            log.info("[\u6210\u54c1\u4ed3\u5206\u5185\u5916\u4ed3\u76d8\u70b9\u62a5\u8868-WMS\u8017\u65f6]:{} ms", (Object)(System.currentTimeMillis() - time));
        }
        catch (Exception e) {
            log.error("[\u6210\u54c1\u4ed3\u5206\u5185\u5916\u4ed3\u76d8\u70b9\u62a5\u8868-WMS]\uff0c\u6267\u884c\u9519\u8bef\uff1a{}\uff0c\u9519\u8bef\u6808\u4fe1\u606f\uff1a", (Object)e.getMessage(), (Object)e);
            return false;
        }
        return true;
    }

    public void after(TaskMsg taskMsg) {
        log.info("==========\u6267\u884c\u6210\u54c1\u4ed3\u5206\u5185\u5916\u4ed3\u76d8\u70b9\u62a5\u8868-WMS\u5b8c\u6210==========");
    }
}

