/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.scheduler.task;

import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.AbstractSingleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.report.domain.entity.IDictDomain;
import com.yunxi.dg.base.center.report.domain.trade.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.report.dto.entity.DgOrderDetailReportPageReqDto;
import com.yunxi.dg.base.center.report.dto.entity.DictDto;
import com.yunxi.dg.base.center.report.service.entity.ISkuSaleStatisticsReportService;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="skuSaleStatisticsTask")
@Scope(value="prototype")
public class SkuSaleStatisticsTask
extends AbstractSingleScheduleEvent {
    private static final Logger log = LoggerFactory.getLogger(SkuSaleStatisticsTask.class);
    @Resource
    private IDgPerformOrderInfoDomain dgPerformOrderInfoDomain;
    @Resource
    private IDictDomain dictDomain;
    @Resource
    private ISkuSaleStatisticsReportService skuSaleStatisticsReportService;

    public void before(TaskMsg taskMsg) {
        log.info("sku\u9500\u91cf\u7edf\u8ba1\u4efb\u52a1\u5f00\u59cb");
    }

    public boolean execute(TaskMsg taskMsg) {
        log.info("sku\u9500\u91cf\u7edf\u8ba1\u5f00\u59cb");
        try {
            List dictDtoList = this.dictDomain.queryDictByCodeAndGroupCode("yunxi-dg-base-center-report", "skuSaleStatisticsDateNumer");
            if (CollectionUtil.isEmpty((Collection)dictDtoList)) {
                log.info("sku\u9500\u91cf\u7edf\u8ba1\u65e5\u671f\u65f6\u95f4\u672a\u8bbe\u7f6e");
                return Boolean.TRUE;
            }
            DgOrderDetailReportPageReqDto dto = new DgOrderDetailReportPageReqDto();
            dto.setOrderTypeList((List)Lists.newArrayList((Object[])new String[]{"standard_order", "change_delivery_order", "stock_reform_order", "overseas_order"}));
            String dictValue = ((DictDto)dictDtoList.get(0)).getDictValue();
            LocalDate deliveryStartTime = LocalDate.now().minusDays(Long.valueOf(dictValue));
            dto.setDeliveryStartTime(deliveryStartTime + " 00:00:00");
            dto.setDeliveryEndTime(LocalDate.now() + " 23:59:59");
            List orderDetailReportDtoList = this.dgPerformOrderInfoDomain.totalSkuSaleStatistics(dto);
            if (CollectionUtil.isEmpty((Collection)orderDetailReportDtoList)) {
                log.info("sku\u9500\u91cf\u7edf\u8ba1\u6570\u636e\u4e3a\u7a7a");
                return Boolean.TRUE;
            }
            this.skuSaleStatisticsReportService.batchAddSkuSaleStatisticsReport(orderDetailReportDtoList);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("sku\u9500\u91cf\u7edf\u8ba1\u4efb\u52a1\u5f02\u5e38:{}", (Object)e.getMessage());
        }
        return Boolean.TRUE;
    }

    public void after(TaskMsg taskMsg) {
        log.info("sku\u9500\u91cf\u7edf\u8ba1\u4efb\u52a1\u7ed3\u675f");
    }
}

