/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.domain.entity.impl;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.trade.api.constants.PayStatusEnum;
import com.yunxi.dg.base.center.trade.dao.das.IPayRecordDas;
import com.yunxi.dg.base.center.trade.domain.entity.IPayRecordDomain;
import com.yunxi.dg.base.center.trade.eo.PayRecordEo;
import com.yunxi.dg.base.framework.core.db.das.ICommonDas;
import com.yunxi.dg.base.framework.core.domain.BaseDomainImpl;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class PayRecordDomainImpl
extends BaseDomainImpl<PayRecordEo>
implements IPayRecordDomain {
    @Resource
    private IPayRecordDas das;

    public ICommonDas<PayRecordEo> commonDas() {
        return this.das;
    }

    @Override
    public PayRecordEo selectByTradeNo(String tradeNo) {
        return this.das.selectByTradeNo(tradeNo);
    }

    @Override
    public PayRecordEo selectByPayNo(String payNo) {
        return this.das.selectByPayNo(payNo);
    }

    @Override
    public PayRecordEo selectByOrderNo(String orderNo) {
        return this.das.selectByOrderNo(orderNo);
    }

    @Override
    public PayRecordEo lockById(Long id) {
        return this.das.lockById(id);
    }

    @Override
    public int insertPayRecord(PayRecordEo payRecordEo) {
        return this.das.insertPayRecord(payRecordEo);
    }

    @Override
    public BigDecimal getOrderPayAmount(String orderNo) {
        PayRecordEo payRecordEo = new PayRecordEo();
        payRecordEo.setOrderNo(orderNo);
        List payRecordEos = this.selectList((BaseEo)payRecordEo);
        if (CollectionUtils.isNotEmpty((Collection)payRecordEos)) {
            BigDecimal reduce = payRecordEos.stream().filter(bean -> PayStatusEnum.SUCCESS.getName().equals(bean.getPayStatus())).map(PayRecordEo::getPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            return reduce;
        }
        return BigDecimal.ZERO;
    }

    @Override
    public List<PayRecordEo> selectListByOrderNo(String orderNo) {
        PayRecordEo payRecordEo = new PayRecordEo();
        payRecordEo.setOrderNo(orderNo);
        payRecordEo.setDr(0);
        payRecordEo.setOrderByDesc("create_time");
        return this.das.selectList((BaseEo)payRecordEo);
    }

    @Override
    public List<PayRecordEo> selectListByOrderNoAndStatus(String orderNo, String status) {
        PayRecordEo payRecordEo = new PayRecordEo();
        payRecordEo.setOrderNo(orderNo);
        payRecordEo.setPayStatus(PayStatusEnum.SUCCESS.getName());
        return this.das.selectList((BaseEo)payRecordEo);
    }
}

