/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.domain.order.oms;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderItemStatusEnum;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.trade.constants.amount.DgOmsOrderAmountTypeEnum;
import com.yunxi.dg.base.center.trade.dao.das.IDgPerformOrderItemLineDas;
import com.yunxi.dg.base.center.trade.dao.das.IDgPerformOrderLineAmountDas;
import com.yunxi.dg.base.center.trade.dao.das.IDgPerformOrderLineDas;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineAmountDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IOrderLineReleationItemLineDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderLineBizQueryDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineAmountDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderItemReqDto;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemLineEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderLineAmountEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderLineEo;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DgOmsOrderLineBizQueryDomainImpl
implements IDgOmsOrderLineBizQueryDomain {
    private static final Logger log = LoggerFactory.getLogger(DgOmsOrderLineBizQueryDomainImpl.class);
    @Resource
    private IDgPerformOrderLineDomain orderLineDomain;
    @Resource
    private IDgPerformOrderItemLineDomain orderItemLineDomain;
    @Resource
    private IOrderLineReleationItemLineDomain orderLineReleationItemLineDomain;
    @Resource
    private IDgPerformOrderLineAmountDomain performOrderLineAmountDomain;
    @Resource
    private IDgPerformOrderItemLineDas performOrderItemLineDas;
    @Resource
    private IDgPerformOrderLineDas performOrderLineDas;
    @Resource
    private IDgPerformOrderLineAmountDas performOrderLineAmountDas;

    @Override
    public List<DgPerformOrderLineDto> queryOrderLineByOrderId(Long orderId) {
        LambdaQueryWrapper queryOrderItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryOrderItemWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgPerformOrderLineEo::getOrderId, (Object)orderId);
        List performOrderLineEos = this.performOrderLineDas.getMapper().selectList((Wrapper)queryOrderItemWrapper);
        if (CollectionUtils.isEmpty((Collection)performOrderLineEos)) {
            return new ArrayList<DgPerformOrderLineDto>();
        }
        ArrayList<DgPerformOrderLineDto> performOrderLineRespDtos = new ArrayList<DgPerformOrderLineDto>();
        CubeBeanUtils.copyCollection(performOrderLineRespDtos, (Collection)performOrderLineEos, DgPerformOrderLineDto.class);
        return performOrderLineRespDtos;
    }

    @Override
    public List<DgPerformOrderLineDto> queryOrderLineByOrderIdFilterCancel(Long orderId) {
        LambdaQueryWrapper queryOrderItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryOrderItemWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgPerformOrderLineEo::getOrderId, (Object)orderId);
        queryOrderItemWrapper.ne(DgPerformOrderLineEo::getStatus, (Object)"CANCEL");
        List performOrderLineEos = this.performOrderLineDas.getMapper().selectList((Wrapper)queryOrderItemWrapper);
        if (CollectionUtils.isEmpty((Collection)performOrderLineEos)) {
            return new ArrayList<DgPerformOrderLineDto>();
        }
        ArrayList<DgPerformOrderLineDto> performOrderLineRespDtos = new ArrayList<DgPerformOrderLineDto>();
        CubeBeanUtils.copyCollection(performOrderLineRespDtos, (Collection)performOrderLineEos, DgPerformOrderLineDto.class);
        return performOrderLineRespDtos;
    }

    @Override
    public List<DgPerformOrderLineDto> queryOrderLineByOrderIds(List<Long> orderIds) {
        LambdaQueryWrapper queryOrderItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryOrderItemWrapper.eq(BaseEo::getDr, (Object)0)).in(DgPerformOrderLineEo::getOrderId, orderIds);
        List performOrderLineEos = this.performOrderLineDas.getMapper().selectList((Wrapper)queryOrderItemWrapper);
        if (CollectionUtils.isEmpty((Collection)performOrderLineEos)) {
            return new ArrayList<DgPerformOrderLineDto>();
        }
        ArrayList<DgPerformOrderLineDto> performOrderLineRespDtos = new ArrayList<DgPerformOrderLineDto>();
        CubeBeanUtils.copyCollection(performOrderLineRespDtos, (Collection)performOrderLineEos, DgPerformOrderLineDto.class);
        return performOrderLineRespDtos;
    }

    @Override
    public PageInfo<DgPerformOrderLineDto> queryPageById(Long orderId, Integer pageNum, Integer pageSize) {
        DgPerformOrderLineEo orderLineEo = new DgPerformOrderLineEo();
        orderLineEo.setOrderId(orderId);
        orderLineEo.setOrderBy("sku_code");
        PageInfo<DgPerformOrderLineDto> dtoPageInfo = this.selectPage(orderLineEo, pageNum, pageSize);
        return dtoPageInfo;
    }

    private PageInfo<DgPerformOrderLineDto> selectPage(DgPerformOrderLineEo orderLineEo, Integer pageNum, Integer pageSize) {
        PageInfo eoPageInfo = this.orderLineDomain.selectPage((BaseEo)orderLineEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        if (CollectionUtils.isEmpty((Collection)eoPageInfo.getList())) {
            return dtoPageInfo;
        }
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        CubeBeanUtils.copyCollection(dtoList, (Collection)eoPageInfo.getList(), DgPerformOrderLineDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<DgPerformOrderLineDto> queryOrderLineInfoByOrderId(Long orderId) {
        LambdaQueryWrapper queryOrderItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryOrderItemWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgPerformOrderLineEo::getOrderId, (Object)orderId);
        List performOrderLineEos = this.performOrderLineDas.getMapper().selectList((Wrapper)queryOrderItemWrapper);
        if (CollectionUtils.isEmpty((Collection)performOrderLineEos)) {
            return new ArrayList<DgPerformOrderLineDto>();
        }
        ArrayList<DgPerformOrderLineDto> performOrderLineRespDtos = new ArrayList<DgPerformOrderLineDto>();
        CubeBeanUtils.copyCollection(performOrderLineRespDtos, (Collection)performOrderLineEos, DgPerformOrderLineDto.class);
        this.selectReleationList(performOrderLineRespDtos);
        performOrderLineRespDtos.forEach(line -> {
            Long orderLineId = line.getId();
            List<DgPerformOrderItemLineEo> dgPerformOrderItemLineEos = this.orderItemLineDomain.queryAllItemLineByOrderLineId(orderLineId);
            BigDecimal returnAmount = dgPerformOrderItemLineEos.stream().filter(itemLine -> Objects.equals(itemLine.getShFlag(), 1)).map(DgPerformOrderItemLineEo::getPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            DgPerformOrderLineAmountEo dgPerformOrderLineAmountEo = this.performOrderLineAmountDomain.queryByLineId(line.getId(), DgOmsOrderAmountTypeEnum.LINE_ACTUAL_PRICE.getCode());
            line.setRefundableAmount(dgPerformOrderLineAmountEo.getAmount().subtract(returnAmount.abs()));
            String snCodeStr = dgPerformOrderItemLineEos.stream().filter(itemLine -> Objects.equals(itemLine.getShFlag(), 0)).map(DgPerformOrderItemLineEo::getSnCode).filter(StringUtils::isNotBlank).collect(Collectors.joining(";", "", ""));
            line.setSnCode(snCodeStr);
        });
        return performOrderLineRespDtos;
    }

    @Override
    public List<DgPerformOrderLineDto> queryOrderLineInfoByOrderIdAndCancelStatus(Long orderId, String status) {
        LambdaQueryWrapper queryOrderItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryOrderItemWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgPerformOrderLineEo::getOrderId, (Object)orderId)).eq(DgPerformOrderLineEo::getStatus, (Object)status);
        List performOrderLineEos = this.performOrderLineDas.getMapper().selectList((Wrapper)queryOrderItemWrapper);
        if (CollectionUtils.isEmpty((Collection)performOrderLineEos)) {
            return new ArrayList<DgPerformOrderLineDto>();
        }
        ArrayList<DgPerformOrderLineDto> performOrderLineRespDtos = new ArrayList<DgPerformOrderLineDto>();
        CubeBeanUtils.copyCollection(performOrderLineRespDtos, (Collection)performOrderLineEos, DgPerformOrderLineDto.class);
        this.selectReleationList(performOrderLineRespDtos);
        return performOrderLineRespDtos;
    }

    @Override
    public List<DgPerformOrderLineDto> queryNotCancelOrderLineInfoByOrderId(Long orderId) {
        LambdaQueryWrapper queryOrderItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryOrderItemWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgPerformOrderLineEo::getOrderId, (Object)orderId);
        List performOrderLineEos = this.performOrderLineDas.getMapper().selectList((Wrapper)queryOrderItemWrapper);
        if (CollectionUtils.isEmpty((Collection)performOrderLineEos)) {
            return new ArrayList<DgPerformOrderLineDto>();
        }
        List orderLineEos = performOrderLineEos.stream().filter(e -> e.getStatus() == null || SaleOrderItemStatusEnum.NORMAL.getCode().equals(e.getStatus())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(orderLineEos)) {
            return new ArrayList<DgPerformOrderLineDto>();
        }
        ArrayList<DgPerformOrderLineDto> performOrderLineRespDtos = new ArrayList<DgPerformOrderLineDto>();
        CubeBeanUtils.copyCollection(performOrderLineRespDtos, orderLineEos, DgPerformOrderLineDto.class);
        this.selectReleationList(performOrderLineRespDtos);
        return performOrderLineRespDtos;
    }

    @Override
    public List<DgPerformOrderLineDto> queryOrderLineInfoByOrderIds(List<Long> orderIds) {
        LambdaQueryWrapper queryOrderItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryOrderItemWrapper.eq(BaseEo::getDr, (Object)0)).in(DgPerformOrderLineEo::getOrderId, orderIds);
        List performOrderLineEos = this.performOrderLineDas.getMapper().selectList((Wrapper)queryOrderItemWrapper);
        if (CollectionUtils.isEmpty((Collection)performOrderLineEos)) {
            return new ArrayList<DgPerformOrderLineDto>();
        }
        ArrayList<DgPerformOrderLineDto> performOrderLineRespDtos = new ArrayList<DgPerformOrderLineDto>();
        CubeBeanUtils.copyCollection(performOrderLineRespDtos, (Collection)performOrderLineEos, DgPerformOrderLineDto.class);
        this.selectReleationList(performOrderLineRespDtos);
        return performOrderLineRespDtos;
    }

    @Override
    public DgPerformOrderLineDto queryById(Long id) {
        LambdaQueryWrapper queryOrderItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryOrderItemWrapper.eq(BaseEo::getDr, (Object)0)).eq(BaseEo::getId, (Object)id);
        DgPerformOrderLineEo performOrderLineEo = (DgPerformOrderLineEo)this.performOrderLineDas.getMapper().selectOne((Wrapper)queryOrderItemWrapper);
        DgPerformOrderLineDto respDto = new DgPerformOrderLineDto();
        CubeBeanUtils.copyProperties((Object)respDto, (Object)performOrderLineEo, (String[])new String[0]);
        return respDto;
    }

    @Override
    public List<DgPerformOrderLineDto> queryByIds(List<Long> ids) {
        LambdaQueryWrapper queryOrderItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryOrderItemWrapper.eq(BaseEo::getDr, (Object)0)).in(BaseEo::getId, ids);
        List performOrderLineEos = this.performOrderLineDas.getMapper().selectList((Wrapper)queryOrderItemWrapper);
        ArrayList<DgPerformOrderLineDto> respDtos = new ArrayList<DgPerformOrderLineDto>();
        CubeBeanUtils.copyCollection(respDtos, (Collection)performOrderLineEos, DgPerformOrderLineDto.class);
        return respDtos;
    }

    @Override
    public DgPerformOrderLineDto queryInfoById(Long id) {
        LambdaQueryWrapper queryOrderItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryOrderItemWrapper.eq(BaseEo::getDr, (Object)0)).eq(BaseEo::getId, (Object)id);
        DgPerformOrderLineEo performOrderLineEo = (DgPerformOrderLineEo)this.performOrderLineDas.getMapper().selectOne((Wrapper)queryOrderItemWrapper);
        DgPerformOrderLineDto respDto = new DgPerformOrderLineDto();
        CubeBeanUtils.copyProperties((Object)respDto, (Object)performOrderLineEo, (String[])new String[0]);
        List<DgPerformOrderLineAmountDto> amountDtoList = this.performOrderLineAmountDomain.queryByOrderLineId(id);
        respDto.setAmountDtoList(amountDtoList);
        return respDto;
    }

    @Override
    public List<DgPerformOrderLineDto> queryInfoByIds(List<Long> ids) {
        LambdaQueryWrapper queryOrderItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryOrderItemWrapper.eq(BaseEo::getDr, (Object)0)).in(BaseEo::getId, ids);
        List performOrderLineEos = this.performOrderLineDas.getMapper().selectList((Wrapper)queryOrderItemWrapper);
        ArrayList<DgPerformOrderLineDto> respDtos = new ArrayList<DgPerformOrderLineDto>();
        CubeBeanUtils.copyCollection(respDtos, (Collection)performOrderLineEos, DgPerformOrderLineDto.class);
        this.selectReleationList(respDtos);
        return respDtos;
    }

    @Override
    public List<DgPerformOrderLineDto> queryOrderLineByOrderSkus(DgPerformOrderItemReqDto reqDto) {
        AssertUtils.notNull((Object)reqDto, (String)"reqDto \u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderLineEo orderLineEo = new DgPerformOrderLineEo();
        orderLineEo.setOrderId(reqDto.getOrderId());
        if (StringUtils.isNotBlank((CharSequence)reqDto.getSkuCode())) {
            orderLineEo.setSkuCode(reqDto.getSkuCode());
        }
        LambdaQueryWrapper queryItemEo = new LambdaQueryWrapper((Object)orderLineEo);
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getSkuCodeList())) {
            queryItemEo.in(DgPerformOrderLineEo::getSkuCode, (Collection)reqDto.getSkuCodeList());
        }
        queryItemEo.eq(BaseEo::getDr, (Object)0);
        return this.selectList((Wrapper<DgPerformOrderLineEo>)queryItemEo);
    }

    private List<DgPerformOrderLineDto> selectList(Wrapper<DgPerformOrderLineEo> queryWrapper) {
        List orderLineEos = this.performOrderLineDas.getMapper().selectList(queryWrapper);
        if (CollectionUtils.isEmpty((Collection)orderLineEos)) {
            return null;
        }
        ArrayList<DgPerformOrderLineDto> orderLineDtos = new ArrayList<DgPerformOrderLineDto>();
        CubeBeanUtils.copyCollection(orderLineDtos, (Collection)orderLineEos, DgPerformOrderLineDto.class);
        return orderLineDtos;
    }

    private void selectReleationList(List<DgPerformOrderLineDto> list) {
        LambdaQueryWrapper queryOrderAmountWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryOrderAmountWrapper.eq(BaseEo::getDr, (Object)0)).in(DgPerformOrderLineAmountEo::getOrderLineId, (Collection)list.stream().map(BaseDto::getId).collect(Collectors.toList()));
        List amountEos = this.performOrderLineAmountDas.getMapper().selectList((Wrapper)queryOrderAmountWrapper);
        Map<Long, List<DgPerformOrderLineAmountEo>> amountMap = amountEos.stream().collect(Collectors.groupingBy(DgPerformOrderLineAmountEo::getOrderLineId));
        list.forEach(line -> {
            ArrayList amountDtoList = new ArrayList();
            CubeBeanUtils.copyCollection(amountDtoList, (Collection)((Collection)amountMap.get(line.getId())), DgPerformOrderLineAmountDto.class);
            line.setAmountDtoList(amountDtoList);
        });
    }
}

