/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.domain.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.yunxi.dg.base.center.trade.constants.NoticeResultSyncStatusEnum;
import com.yunxi.dg.base.center.trade.dao.das.IDgPerformNoticeSyncRecordDas;
import com.yunxi.dg.base.center.trade.dao.das.IDgPerformNoticeSyncRecordShippingDas;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformNoticeSyncRecordDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformNoticeSyncRecordItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformNoticeSyncRecordShippingDomain;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgOutDeliveryDetailResultExtDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgOutDeliveryResultReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgWmsShippingInfoReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.enums.ShippingOrderTypeEnum;
import com.yunxi.dg.base.center.trade.enums.ShippingStatusEnum;
import com.yunxi.dg.base.center.trade.enums.SyncRecordShippingTypeEnum;
import com.yunxi.dg.base.center.trade.eo.DgPerformNoticeSyncRecordEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformNoticeSyncRecordItemEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformNoticeSyncRecordShippingEo;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.db.das.ICommonDas;
import com.yunxi.dg.base.framework.core.domain.BaseDomainImpl;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DgPerformNoticeSyncRecordDomainImpl
extends BaseDomainImpl<DgPerformNoticeSyncRecordEo>
implements IDgPerformNoticeSyncRecordDomain {
    private static final Logger LOGGER = LoggerFactory.getLogger(DgPerformNoticeSyncRecordDomainImpl.class);
    @Resource
    private IDgPerformNoticeSyncRecordDas das;
    @Resource
    private IDgPerformNoticeSyncRecordShippingDas shippingDas;
    @Resource
    private IDgPerformNoticeSyncRecordShippingDomain dgPerformNoticeSyncRecordShippingDomain;
    @Resource
    private IDgPerformNoticeSyncRecordItemDomain dgPerformNoticeSyncRecordItemDomain;

    public ICommonDas<DgPerformNoticeSyncRecordEo> commonDas() {
        return this.das;
    }

    @Override
    public List<DgPerformNoticeSyncRecordEo> queryEosByOrderId(Long orderId) {
        AssertUtils.isFalse(orderId == null, "\u67e5\u8be2\u53c2\u6570orderId\u4e0d\u80fd\u4e3a\u7a7a");
        return ((ExtQueryChainWrapper)this.das.filter().eq((Object)"business_id", (Object)orderId)).list();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByOrderId(Long orderId) {
        List recordEoList = ((ExtQueryChainWrapper)this.das.filter().eq((Object)"business_id", (Object)orderId)).list();
        if (CollectionUtil.isNotEmpty((Collection)recordEoList)) {
            recordEoList.forEach(recordEo -> {
                this.das.logicDeleteById(recordEo.getId());
                List recordShippingEoList = ((ExtQueryChainWrapper)this.shippingDas.filter().eq((Object)"record_id", (Object)recordEo.getId())).list();
                if (CollectionUtil.isNotEmpty((Collection)recordShippingEoList)) {
                    recordShippingEoList.forEach(shippingEo -> this.shippingDas.deleteById(shippingEo.getId()));
                }
            });
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saleOutSyncRecord(DgPerformOrderRespDto performOrder, DgOutDeliveryResultReqDto deliveryResultReqDto) {
        LOGGER.info("\u9500\u552e\u5355\u51fa\u5e93\u4fe1\u606f\u4fdd\u5b58\uff1a{}\uff0c{}", (Object)JSON.toJSONString((Object)performOrder), (Object)JSON.toJSONString((Object)deliveryResultReqDto));
        LOGGER.info("\u67e5\u8be2\u51fa\u5165\u5e93\u7ed3\u679c\u540c\u6b65\u8bb0\u5f55\uff1a{}\uff0c{}", (Object)performOrder.getId(), (Object)deliveryResultReqDto.getOutResultOrderNo());
        DgPerformNoticeSyncRecordEo syncRecordEo = new DgPerformNoticeSyncRecordEo();
        List syncRecordEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().eq((Object)"business_id", (Object)performOrder.getId())).eq((Object)"result_notice_order_no", (Object)deliveryResultReqDto.getOutResultOrderNo())).list();
        if (CollectionUtils.isEmpty((Collection)syncRecordEoList)) {
            syncRecordEo.setResultNoticeOrderNo(deliveryResultReqDto.getOutResultOrderNo());
            syncRecordEo.setBusinessId(performOrder.getId());
            syncRecordEo.setBusinessNo(performOrder.getSaleOrderNo());
            syncRecordEo.setBusinessType(Integer.valueOf(1));
            syncRecordEo.setNoticeResultJson(JSON.toJSONString((Object)deliveryResultReqDto));
            syncRecordEo.setShippingCompany(deliveryResultReqDto.getShipmentEnterpriseName());
            syncRecordEo.setTotalCartons(deliveryResultReqDto.getTotalCartons());
            syncRecordEo.setTotalQuantity(deliveryResultReqDto.getTotalQuantity());
            syncRecordEo.setNoticeResultSyncStatus(NoticeResultSyncStatusEnum.ACCEPT.getCode());
            this.das.insert((BaseEo)syncRecordEo);
        } else {
            syncRecordEo = (DgPerformNoticeSyncRecordEo)syncRecordEoList.get(0);
        }
        List predictShippingEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgPerformNoticeSyncRecordShippingDomain.filter().eq((Object)"order_id", (Object)performOrder.getId())).eq((Object)"shipping_type", (Object)SyncRecordShippingTypeEnum.PREDICT_SHIPPING.getCode())).list();
        Optional.ofNullable(predictShippingEoList).ifPresent(data -> {
            LOGGER.info("\u5220\u9664\u9884\u53d1\u8d27\u7269\u6d41\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)predictShippingEoList));
            data.forEach(eo -> this.dgPerformNoticeSyncRecordShippingDomain.logicDeleteById(eo.getId()));
        });
        Long syncRecordShippingId = null;
        if (CollectionUtils.isNotEmpty((Collection)deliveryResultReqDto.getShippingInfoList())) {
            for (DgWmsShippingInfoReqDto shippingInfo : deliveryResultReqDto.getShippingInfoList()) {
                LOGGER.info("\u5904\u7406\u51fa\u5e93\u7ed3\u679c\u5355\u7269\u6d41\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)shippingInfo));
                if (StringUtils.isBlank((CharSequence)shippingInfo.getShippingNo()) && StringUtils.isBlank((CharSequence)shippingInfo.getConsignNo())) {
                    LOGGER.info("\u65e0\u7269\u6d41\u5355\u53f7\u4fe1\u606f");
                    continue;
                }
                List recordShippingEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgPerformNoticeSyncRecordShippingDomain.filter().eq((Object)"order_id", (Object)performOrder.getId())).eq((Object)"consignment_no", (Object)shippingInfo.getShippingNo())).list();
                if (CollectionUtils.isEmpty((Collection)recordShippingEoList)) {
                    DgPerformNoticeSyncRecordShippingEo shippingEo = new DgPerformNoticeSyncRecordShippingEo();
                    shippingEo.setNoticeOrderNo(shippingInfo.getOutNoticeOrderNo());
                    shippingEo.setDeliveryTime(shippingInfo.getDeliveryTime());
                    shippingEo.setShippingType(shippingInfo.getShippingType());
                    shippingEo.setShippingCompany(shippingInfo.getShippingCompanyName());
                    shippingEo.setShippingCompanyCode(shippingInfo.getShippingCompanyCode());
                    shippingEo.setShippingCompanyPhone(deliveryResultReqDto.getPhoneNum());
                    shippingEo.setConsignmentNo(StringUtils.isBlank((CharSequence)shippingInfo.getConsignNo()) ? shippingInfo.getShippingNo() : shippingInfo.getConsignNo());
                    shippingEo.setStatus(ShippingStatusEnum.NORMAL.getCode());
                    shippingEo.setShippingType(SyncRecordShippingTypeEnum.ACTUAL_SHIPPING.getCode());
                    shippingEo.setOrderType(ShippingOrderTypeEnum.SALE.getCode());
                    shippingEo.setRecordId(syncRecordEo.getId());
                    shippingEo.setVolume(deliveryResultReqDto.getTotalVolume());
                    shippingEo.setWeight(deliveryResultReqDto.getTotalWeight());
                    shippingEo.setOrderId(performOrder.getId());
                    if (StringUtils.isNotBlank((CharSequence)deliveryResultReqDto.getPhoneNum())) {
                        JSONObject extension = new JSONObject();
                        extension.put("phoneNum", (Object)deliveryResultReqDto.getPhoneNum());
                        shippingEo.setExtension(extension.toJSONString());
                    }
                    LOGGER.info("\u4fdd\u5b58\u7269\u6d41\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)shippingEo));
                    this.dgPerformNoticeSyncRecordShippingDomain.insert((BaseEo)shippingEo);
                    syncRecordShippingId = shippingEo.getId();
                    continue;
                }
                LOGGER.info("\u8be5\u7269\u6d41\u4fe1\u606f\u5df2\u5b58\u5728\uff1a{}", (Object)shippingInfo.getShippingNo());
            }
        } else {
            LOGGER.error("\u65e0\u7269\u6d41\u4fe1\u606f");
        }
        if (CollectionUtils.isNotEmpty((Collection)deliveryResultReqDto.getDeliveryDetailList()) && ObjectUtils.isNotEmpty(syncRecordShippingId)) {
            for (DgOutDeliveryDetailResultExtDto detail : deliveryResultReqDto.getDeliveryDetailList()) {
                DgPerformNoticeSyncRecordItemEo recordItemEo = (DgPerformNoticeSyncRecordItemEo)BeanUtil.copyProperties((Object)detail, DgPerformNoticeSyncRecordItemEo.class, (String[])new String[0]);
                recordItemEo.setRecordId(syncRecordEo.getId());
                recordItemEo.setRecordShippingId(syncRecordShippingId);
                recordItemEo.setOrderId(syncRecordEo.getBusinessId());
                recordItemEo.setSkuCode(detail.getLongCode());
                recordItemEo.setQuantity(detail.getOutQuantity());
                recordItemEo.setOrderItemId(detail.getTradeOrderItemId());
                LOGGER.info("\u4fdd\u5b58\u5546\u54c1\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)recordItemEo));
                this.dgPerformNoticeSyncRecordItemDomain.insert((BaseEo)recordItemEo);
            }
        } else {
            LOGGER.error("\u65e0\u5546\u54c1\u4fe1\u606f");
        }
    }
}

