/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.domain.entity.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.eo.BaseEo;
import com.yunxi.dg.base.center.trade.constants.DgSaleAuditResultEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleAuditTypeEnum;
import com.yunxi.dg.base.center.trade.dao.das.IDgSaleOrderAuditDas;
import com.yunxi.dg.base.center.trade.domain.entity.IDgSaleOrderAuditDomain;
import com.yunxi.dg.base.center.trade.eo.DgSaleOrderAuditEo;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.db.das.ICommonDas;
import com.yunxi.dg.base.framework.core.domain.BaseDomainImpl;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class DgSaleOrderAuditDomainImpl
extends BaseDomainImpl<DgSaleOrderAuditEo>
implements IDgSaleOrderAuditDomain {
    @Resource
    private IDgSaleOrderAuditDas das;

    public ICommonDas<DgSaleOrderAuditEo> commonDas() {
        return this.das;
    }

    @Override
    public void saveSaleOrderAudit(Long orderId, DgSaleAuditTypeEnum saleAuditTypeEnum, DgSaleAuditResultEnum saleAuditEnum) {
        String requestUserCode = (String)ObjectUtil.defaultIfNull((Object)ServiceContext.getContext().getRequestUserCode(), (Object)"");
        if (StringUtils.isBlank((CharSequence)requestUserCode)) {
            requestUserCode = "system";
        }
        DgSaleOrderAuditEo saleOrderAuditEo = new DgSaleOrderAuditEo();
        saleOrderAuditEo.setOrderId(orderId);
        saleOrderAuditEo.setAuditor(requestUserCode);
        saleOrderAuditEo.setAuditTime(new Date());
        saleOrderAuditEo.setAuditResult(saleAuditEnum.getCode());
        saleOrderAuditEo.setAuditType(saleAuditTypeEnum.getType());
        this.das.insert((BaseEo)saleOrderAuditEo);
    }

    @Override
    public void saveSaleOrderAudit(Long orderId, String saleAuditType, DgSaleAuditResultEnum saleAuditEnum) {
        String requestUserCode = (String)ObjectUtil.defaultIfNull((Object)ServiceContext.getContext().getRequestUserCode(), (Object)"");
        if (StringUtils.isBlank((CharSequence)requestUserCode)) {
            requestUserCode = "system";
        }
        DgSaleOrderAuditEo saleOrderAuditEo = new DgSaleOrderAuditEo();
        saleOrderAuditEo.setOrderId(orderId);
        saleOrderAuditEo.setAuditor(requestUserCode);
        saleOrderAuditEo.setAuditTime(new Date());
        saleOrderAuditEo.setAuditResult(saleAuditEnum.getCode());
        saleOrderAuditEo.setAuditType(saleAuditType);
        this.das.insert((BaseEo)saleOrderAuditEo);
    }

    @Override
    public void saveSaleOrderAudit(Long orderId, DgSaleOrderAuditEo dgSaleOrderAuditEo) {
        AssertUtils.notNull(orderId, "\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull(dgSaleOrderAuditEo, "\u4fdd\u5b58\u5ba1\u6838\u8bb0\u5f55\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        dgSaleOrderAuditEo.setOrderId(orderId);
        this.das.insert((BaseEo)dgSaleOrderAuditEo);
    }

    @Override
    public DgSaleOrderAuditEo selectByOrderIdAndAuditType(Long orderId, DgSaleAuditTypeEnum saleAuditTypeEnum) {
        AssertUtils.notNull(orderId, "\u5165\u53c2\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(DgSaleOrderAuditEo::getOrderId, (Object)orderId);
        if (saleAuditTypeEnum != null) {
            wrapper.eq(DgSaleOrderAuditEo::getAuditType, (Object)saleAuditTypeEnum.getType());
        }
        wrapper.eq(BaseEo::getDr, (Object)0);
        wrapper.orderByDesc(BaseEo::getCreateTime);
        return (DgSaleOrderAuditEo)this.das.getMapper().selectOne((Wrapper)wrapper);
    }
}

