/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.domain.order.oms;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderAssignStatusEnum;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.customer.dto.response.DgCustomerRespDto;
import com.yunxi.dg.base.center.customer.proxy.query.IDgCustomerQueryApiProxy;
import com.yunxi.dg.base.center.trade.anno.DgRedisLock;
import com.yunxi.dg.base.center.trade.cache.CacheWrapper;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderLevelEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderSourceEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderStatusEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderTypeEnum;
import com.yunxi.dg.base.center.trade.constants.OrderItemDistributionStatusEnum;
import com.yunxi.dg.base.center.trade.dao.das.IDgPerformOrderInfoDas;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformNoticeSyncRecordDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformNoticeSyncRecordShippingDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderAddrDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderAmountDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderAttachmentDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderExtensionDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineAmountDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineAmountDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderPaymentDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderSnapshotDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderWarehouseInfoDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IResetRedisNoIndexCommon;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoQueryDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderLineBizQueryDomain;
import com.yunxi.dg.base.center.trade.domain.order.event.AbstractPerformOrderDomain;
import com.yunxi.dg.base.center.trade.domain.order.event.PerformOrderInfoUpdateEvent;
import com.yunxi.dg.base.center.trade.domain.order.oms.ContextDtoUtil;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderExtensionDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderInfoDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgOutDeliveryDetailResultExtDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgOutDeliveryResultReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderAddrReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgOrderStatusLogRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderInfoOutNoticeSyncRecordRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.enums.InstallationPushStatusEnum;
import com.yunxi.dg.base.center.trade.enums.ItemLineDeliveryStatusEnum;
import com.yunxi.dg.base.center.trade.enums.ShippingOrderTypeEnum;
import com.yunxi.dg.base.center.trade.enums.SyncRecordShippingTypeEnum;
import com.yunxi.dg.base.center.trade.eo.DgPerformNoticeSyncRecordEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformNoticeSyncRecordShippingEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderAddrEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderAmountEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderAttachmentEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderExtensionEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemLineAmountEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemLineEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderLineAmountEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderLineEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderPaymentEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderSnapshotEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderWarehouseInfoEo;
import com.yunxi.dg.base.center.trade.exception.DgPcpTradeExceptionCode;
import com.yunxi.dg.base.center.trade.utils.DgBeanUtils;
import com.yunxi.dg.base.center.trade.utils.NoGreateUtil;
import com.yunxi.dg.base.center.trade.vo.ModifyPlanDeliveryDateVo;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.framework.core.db.das.ICommonDas;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Component
public class DgOmsOrderInfoDomainImpl
extends AbstractPerformOrderDomain
implements IDgOmsOrderInfoDomain,
IResetRedisNoIndexCommon {
    private static final Logger log = LoggerFactory.getLogger(DgOmsOrderInfoDomainImpl.class);
    private static List<String> INDEMPOTENT_ORDERTYPE_CHECK = new ArrayList<String>();
    private static final String YFK_ACCOUNT_TYPE = "YFK";
    private static final String YFK_ACCOUNT_CATEGORY = "capital";
    private static final String DEFAULT_BATCH_NO = "default_batch_no";
    @Resource
    private IDgPerformOrderInfoDas das;
    @Resource
    private ApplicationEventPublisher publisher;
    @Resource
    private IDgCustomerQueryApiProxy dgCustomerQueryApiProxy;
    @Resource
    private IDgPerformOrderInfoDomain performOrderInfoDomain;
    @Resource
    private IDgPerformOrderWarehouseInfoDomain dgPerformOrderWarehouseInfoDomain;
    @Resource
    private IDgPerformOrderExtensionDomain performOrderExtensionDomain;
    @Resource
    private IDgPerformOrderPaymentDomain performOrderPaymentDomain;
    @Resource
    private IDgPerformOrderSnapshotDomain performOrderSnapshotDomain;
    @Resource
    private IDgPerformOrderAddrDomain performOrderAddrDomain;
    @Resource
    private IDgPerformOrderAttachmentDomain dgPerformOrderAttachmentDomain;
    @Resource
    private IDgPerformOrderAmountDomain performOrderAmountDomain;
    @Resource
    private IDgPerformOrderWarehouseInfoDomain performOrderWarehouseInfoDomain;
    @Resource
    private IDgOmsOrderInfoQueryDomain omsOrderInfoQueryDomain;
    @Resource
    private IDgOmsOrderLineBizQueryDomain omsOrderLineBizQueryDomain;
    @Resource
    private IDgPerformOrderItemLineDomain orderItemLineDomain;
    @Resource
    private IDgPerformOrderLineDomain orderLineDomain;
    @Resource
    private IDgAfterSaleOrderDomain dgAfterSaleOrderDomain;
    @Resource
    private IDgPerformOrderLineAmountDomain performOrderLineAmountDomain;
    @Resource
    private IDgPerformOrderItemLineAmountDomain performOrderItemLineAmountDomain;
    @Resource
    private IDgPerformOrderInfoDas dgPerformOrderInfoDas;
    @Resource
    private CacheWrapper cacheWrapper;
    @Resource
    private NoGreateUtil performOrderNoGreateUtil;
    @Resource
    private ContextDtoUtil contextDtoUtil;
    @Resource
    private IDgPerformNoticeSyncRecordDomain performNoticeSyncRecordDomain;
    @Resource
    private IDgPerformNoticeSyncRecordShippingDomain performNoticeSyncRecordShippingDomain;

    @Override
    public String getLatestNo() {
        return this.performOrderInfoDomain.getLatestNo();
    }

    @Override
    protected ICommonDas<DgPerformOrderInfoEo> baseDas() {
        return this.dgPerformOrderInfoDas;
    }

    @Override
    protected CacheWrapper cacheWrapper() {
        return this.cacheWrapper;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_UNCOMMITTED)
    @DgRedisLock(lockName="saleOrder", key="#addReqDto.platformOrderNo", condition="#addReqDto.platformOrderNo!=null")
    public DgPerformOrderRespDto addCisSaleOrder(DgBizPerformOrderReqDto addReqDto) {
        log.info("\u521b\u5efa\u8ba2\u5355addCisSaleOrder\uff1a{}", (Object)JSON.toJSONString((Object)addReqDto));
        AssertUtils.notNull((Object)addReqDto, (String)"addReqDto\u4e0d\u80fd\u4e3a\u7a7a");
        if (!INDEMPOTENT_ORDERTYPE_CHECK.contains(addReqDto.getOrderType())) {
            this.checkPlatformOrderRepeat((DgPerformOrderInfoDto)addReqDto);
        }
        if (DgSaleOrderSourceEnum.PROMOTION.getType().equals(addReqDto.getOrderSource())) {
            this.checkPromotionOrderRepeat((DgPerformOrderInfoDto)addReqDto);
        }
        DgPerformOrderRespDto performOrderRespDto = this.createSaleOrder(addReqDto);
        if (!INDEMPOTENT_ORDERTYPE_CHECK.contains(addReqDto.getOrderType())) {
            this.reCheckPlatformOrderRepeat((DgPerformOrderInfoDto)addReqDto, performOrderRespDto);
        }
        if (performOrderRespDto.getId() != null) {
            DgPerformOrderAddrReqDto orderAddrReqDto = addReqDto.getOrderAddrReqDto();
            DgPerformOrderAddrEo performOrderAddrEo = new DgPerformOrderAddrEo();
            CubeBeanUtils.copyProperties((Object)performOrderAddrEo, (Object)orderAddrReqDto, (String[])new String[0]);
            performOrderAddrEo.setOrderId(performOrderRespDto.getId());
            this.performOrderAddrDomain.insert((BaseEo)performOrderAddrEo);
            List attachmentDtos = addReqDto.getAttachmentFileList();
            if (CollectionUtils.isNotEmpty((Collection)attachmentDtos)) {
                List attachmentEos = attachmentDtos.stream().map(attachmentDto -> {
                    DgPerformOrderAttachmentEo dgPerformOrderAttachmentEo = (DgPerformOrderAttachmentEo)BeanUtil.copyProperties((Object)attachmentDto, DgPerformOrderAttachmentEo.class, (String[])new String[0]);
                    dgPerformOrderAttachmentEo.setId(null);
                    dgPerformOrderAttachmentEo.setOrderId(performOrderRespDto.getId());
                    return dgPerformOrderAttachmentEo;
                }).collect(Collectors.toList());
                this.dgPerformOrderAttachmentDomain.insertBatch(attachmentEos);
            }
        } else {
            log.error("[\u65b0\u589e\u9500\u552e\u8ba2\u5355]\u8ba2\u5355\u4fdd\u5b58\u5931\u8d25\uff0c\u8ba2\u5355\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)addReqDto));
            throw new BizException(DgPcpTradeExceptionCode.SAVE_ORDER_EXCEPTION.getCode(), DgPcpTradeExceptionCode.SAVE_ORDER_EXCEPTION.getMsg());
        }
        log.info("[\u65b0\u589e\u9500\u552e\u8ba2\u5355]\u8ba2\u5355\u4fdd\u5b58\u6210\u529f\uff0c\u8ba2\u5355\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)performOrderRespDto));
        return performOrderRespDto;
    }

    private void checkPlatformOrderRepeat(DgPerformOrderInfoDto addReqDto) {
        if (StringUtils.isNotBlank((CharSequence)addReqDto.getPlatformOrderNo())) {
            List effectSaleOrderEos;
            LambdaQueryWrapper queryPlatformWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)queryPlatformWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgPerformOrderInfoEo::getPlatformOrderNo, (Object)addReqDto.getPlatformOrderNo());
            List list = this.performOrderInfoDomain.getMapper().selectList((Wrapper)queryPlatformWrapper);
            List saleOrderEos = Optional.ofNullable(list).orElseGet(Collections::emptyList).stream().filter(saleOrderEo -> DgSaleOrderLevelEnum.ORIGINAL.getType().equals(saleOrderEo.getOrderLevel()) || DgSaleOrderLevelEnum.MAIN.getType().equals(saleOrderEo.getOrderLevel())).filter(saleOrderEo -> !DgSaleOrderStatusEnum.OBSOLETE.getCode().equals(saleOrderEo.getOrderStatus())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(saleOrderEos) && CollectionUtils.isNotEmpty(effectSaleOrderEos = saleOrderEos.stream().filter(s -> !INDEMPOTENT_ORDERTYPE_CHECK.contains(s.getOrderType())).collect(Collectors.toList()))) {
                log.error("[\u65b0\u589e\u9500\u552e\u8ba2\u5355]\u8be5\u5e73\u53f0\u8ba2\u5355\uff08{}\uff09\u5df2\u751f\u6210\u5bf9\u5e94\u7684\u9500\u552e\u8ba2\u5355\uff08{}\uff09\uff0c\u4e0d\u53ef\u591a\u6b21\u751f\u6210\u9500\u552e\u5355", (Object)addReqDto.getPlatformOrderNo(), (Object)((DgPerformOrderInfoEo)effectSaleOrderEos.get(0)).getSaleOrderNo());
                throw DgPcpTradeExceptionCode.MUTIL_SALE_ORDER_EXCEPTION.builderException();
            }
        }
    }

    private void checkPromotionOrderRepeat(DgPerformOrderInfoDto addReqDto) {
        if (StringUtils.isNotBlank((CharSequence)addReqDto.getPlatformOrderNo())) {
            LambdaQueryWrapper queryPlatformWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)queryPlatformWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgPerformOrderInfoEo::getPlatformOrderNo, (Object)addReqDto.getPlatformOrderNo());
            List list = this.performOrderInfoDomain.getMapper().selectList((Wrapper)queryPlatformWrapper);
            boolean match = Optional.ofNullable(list).orElseGet(Collections::emptyList).stream().anyMatch(e -> DgSaleOrderSourceEnum.PROMOTION.getType().equals(e.getOrderSource()));
            AssertUtils.isTrue((!match ? 1 : 0) != 0, (String)"\u5f53\u524d\u5e73\u53f0\u8ba2\u5355\u5df2\u5b58\u5728\u5bf9\u5e94\u7684\u5185\u90e8\u4fc3\u9500\u8ba2\u5355\u4e86");
        }
    }

    private DgPerformOrderRespDto createSaleOrder(DgBizPerformOrderReqDto addReqDto) {
        AssertUtils.notNull((Object)addReqDto, (String)"addReqDto\u4e0d\u80fd\u4e3a\u7a7a");
        this.trimPlatformOrderNo(addReqDto);
        DgPerformOrderInfoEo performOrderInfoEo = new DgPerformOrderInfoEo();
        CubeBeanUtils.copyProperties((Object)performOrderInfoEo, (Object)addReqDto, (String[])new String[]{"id"});
        ArrayList saleOrderType = Lists.newArrayList((Object[])new String[]{DgSaleOrderTypeEnum.E3_SALE_ORDER.getType(), DgSaleOrderTypeEnum.PLATFORM_SETTLEMENT_ORDER.getType()});
        if (saleOrderType.contains(addReqDto.getOrderType())) {
            performOrderInfoEo.setSaleOrderNo(this.performOrderNoGreateUtil.generatePlatformSettlementOrderNo());
        } else {
            performOrderInfoEo.setSaleOrderNo(Optional.ofNullable(addReqDto.getSaleOrderNo()).orElse(this.performOrderNoGreateUtil.generateOrderNo()));
        }
        performOrderInfoEo.setPlatformOrderNo(addReqDto.getPlatformOrderNo());
        if (Objects.isNull(performOrderInfoEo.getSaleCreateTime())) {
            performOrderInfoEo.setSaleCreateTime(new Date());
        }
        DgSaleOrderTypeEnum.enumOf((String)addReqDto.getOrderType());
        DgPerformOrderAmountEo amountEo = new DgPerformOrderAmountEo();
        if (addReqDto.getManualCreate().booleanValue()) {
            if (StringUtils.isBlank((CharSequence)addReqDto.getPlatformOrderNo())) {
                performOrderInfoEo.setPlatformOrderNo(this.performOrderNoGreateUtil.generateDefaultPlatformNo());
            }
            log.info("[\u65b0\u589e\u9500\u552e\u8ba2\u5355]\u624b\u52a8\u521b\u5efa\u9500\u552e\u8ba2\u5355\uff0c\u9700\u8981\u8ba1\u7b97\u5546\u54c1\u7684\u603b\u4ef7\u683c\u548c\u5e94\u4ed8\u91d1\u989d");
            this.calOrderTotalAmount(addReqDto, performOrderInfoEo);
        }
        performOrderInfoEo.setMerchantOriginReceivableAmount(performOrderInfoEo.getMerchantReceivableAmount());
        this.performOrderInfoDomain.insert((BaseEo)performOrderInfoEo);
        CubeBeanUtils.copyProperties((Object)amountEo, (Object)performOrderInfoEo, (String[])new String[]{"id"});
        amountEo.setOrderNo(performOrderInfoEo.getSaleOrderNo());
        amountEo.setOrderId(performOrderInfoEo.getId());
        this.performOrderAmountDomain.insert((BaseEo)amountEo);
        DgPerformOrderWarehouseInfoEo warehouseInfoEo = new DgPerformOrderWarehouseInfoEo();
        CubeBeanUtils.copyProperties((Object)warehouseInfoEo, (Object)addReqDto, (String[])new String[]{"id"});
        BeanUtil.copyProperties((Object)addReqDto.getPerformOrderWarehouseInfoDto(), (Object)warehouseInfoEo, (String[])new String[]{"id"});
        warehouseInfoEo.setOrderId(performOrderInfoEo.getId());
        if (addReqDto.getPerformOrderWarehouseInfoDto() != null && Objects.nonNull(addReqDto.getPerformOrderWarehouseInfoDto().getDeliveryLogicalWarehouseCode())) {
            warehouseInfoEo.setDeliveryLogicalWarehouseCode(addReqDto.getDeliveryLogicalWarehouseCode());
            warehouseInfoEo.setLogicalWarehouseCode(addReqDto.getDeliveryLogicalWarehouseCode());
            warehouseInfoEo.setDefaultLogicalWarehouseCode(addReqDto.getDeliveryLogicalWarehouseCode());
        }
        warehouseInfoEo.setPlanShipmentEnterpriseId(addReqDto.getShipmentEnterpriseId());
        warehouseInfoEo.setPlanShipmentEnterpriseCode(addReqDto.getShipmentEnterpriseCode());
        warehouseInfoEo.setPlanShipmentEnterpriseName(addReqDto.getShipmentEnterpriseName());
        ArrayList<DgPerformNoticeSyncRecordShippingEo> recordShippingEoList = new ArrayList<DgPerformNoticeSyncRecordShippingEo>();
        if (CollectionUtils.isNotEmpty((Collection)addReqDto.getItemList())) {
            if (StringUtils.isNotBlank((CharSequence)((DgPerformOrderItemReqDto)addReqDto.getItemList().get(0)).getInvoiceNo())) {
                addReqDto.getItemList().forEach(saleOrderItemReqDto -> {
                    DgPerformNoticeSyncRecordShippingEo recordShippingEo = new DgPerformNoticeSyncRecordShippingEo();
                    Date deliveryTime = Optional.ofNullable(saleOrderItemReqDto.getDeliveryTime()).orElse(addReqDto.getDeliveryTime());
                    recordShippingEo.setOrderId(performOrderInfoEo.getId());
                    recordShippingEo.setShippingType(SyncRecordShippingTypeEnum.ACTUAL_SHIPPING.getCode());
                    recordShippingEo.setConsignmentNo(saleOrderItemReqDto.getInvoiceNo());
                    recordShippingEo.setShippingCompanyCode(saleOrderItemReqDto.getLogisticsCompanyCode());
                    recordShippingEo.setShippingCompany(saleOrderItemReqDto.getLogisticsCompany());
                    recordShippingEo.setDeliveryTime(deliveryTime);
                    recordShippingEoList.add(recordShippingEo);
                });
            }
        } else if (CollectionUtils.isNotEmpty((Collection)addReqDto.getGiftList())) {
            if (addReqDto.getGiftList().get(0) != null && StringUtils.isNotBlank((CharSequence)((DgPerformOrderItemReqDto)addReqDto.getGiftList().get(0)).getInvoiceNo())) {
                addReqDto.getGiftList().forEach(saleOrderItemReqDto -> {
                    DgPerformNoticeSyncRecordShippingEo recordShippingEo = new DgPerformNoticeSyncRecordShippingEo();
                    Date deliveryTime = Optional.ofNullable(saleOrderItemReqDto.getDeliveryTime()).orElse(addReqDto.getDeliveryTime());
                    recordShippingEo.setOrderId(performOrderInfoEo.getId());
                    recordShippingEo.setShippingType(SyncRecordShippingTypeEnum.ACTUAL_SHIPPING.getCode());
                    recordShippingEo.setConsignmentNo(saleOrderItemReqDto.getInvoiceNo());
                    recordShippingEo.setShippingCompanyCode(saleOrderItemReqDto.getPerformOrderItemExtensionDto().getLogisticsCompanyCode());
                    recordShippingEo.setShippingCompany(saleOrderItemReqDto.getPerformOrderItemExtensionDto().getLogisticsCompany());
                    recordShippingEo.setDeliveryTime(deliveryTime);
                    recordShippingEoList.add(recordShippingEo);
                });
            }
        } else if (StringUtils.isNotBlank((CharSequence)addReqDto.getShippingNo())) {
            DgPerformNoticeSyncRecordShippingEo recordShippingEo = new DgPerformNoticeSyncRecordShippingEo();
            recordShippingEo.setOrderId(performOrderInfoEo.getId());
            recordShippingEo.setShippingType(SyncRecordShippingTypeEnum.ACTUAL_SHIPPING.getCode());
            recordShippingEo.setConsignmentNo(addReqDto.getPerformOrderExtensionDto().getInvoiceNo());
            recordShippingEo.setShippingCompanyCode(addReqDto.getPerformOrderExtensionDto().getLogisticsCompanyCode());
            recordShippingEo.setShippingCompany(addReqDto.getPerformOrderExtensionDto().getLogisticsCompany());
            recordShippingEo.setDeliveryTime(ObjectUtil.isNotEmpty((Object)addReqDto.getDeliveryTime()) ? addReqDto.getDeliveryTime() : addReqDto.getDeliveryCompleteDate());
            recordShippingEo.setOrderType(ShippingOrderTypeEnum.SALE.getCode());
            recordShippingEo.setStatus("NORMAL");
            recordShippingEoList.add(recordShippingEo);
        }
        if (StringUtils.isNotEmpty((CharSequence)addReqDto.getWhetherToFlow())) {
            warehouseInfoEo.setWhetherToFlow(addReqDto.getWhetherToFlow());
            warehouseInfoEo.setDeliveryAddressCheck("UNREACHABLE");
            warehouseInfoEo.setUnreachableCause(addReqDto.getUnreachableCause());
        }
        this.dgPerformOrderWarehouseInfoDomain.insert((BaseEo)warehouseInfoEo);
        if (CollectionUtils.isNotEmpty(recordShippingEoList)) {
            List recordShippingEoListIns = recordShippingEoList.stream().filter(f -> StringUtils.isNotBlank((CharSequence)f.getConsignmentNo())).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<DgPerformNoticeSyncRecordShippingEo>(Comparator.comparing(DgPerformNoticeSyncRecordShippingEo::getConsignmentNo))), ArrayList::new));
            log.info("\u4fdd\u5b58\u51fa\u5e93\u7269\u6d41\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)recordShippingEoListIns));
            this.performNoticeSyncRecordShippingDomain.insertBatch(recordShippingEoListIns);
        }
        DgPerformOrderExtensionEo extensionEo = new DgPerformOrderExtensionEo();
        CubeBeanUtils.copyProperties((Object)extensionEo, (Object)addReqDto.getPerformOrderExtensionDto(), (String[])new String[]{"id"});
        extensionEo.setOrderId(performOrderInfoEo.getId());
        extensionEo.setInstallationPushStatus(InstallationPushStatusEnum.NOT_PUSHED.getType());
        this.performOrderExtensionDomain.insert((BaseEo)extensionEo);
        DgPerformOrderPaymentEo paymentEo = new DgPerformOrderPaymentEo();
        CubeBeanUtils.copyProperties((Object)paymentEo, (Object)addReqDto.getPerformOrderPaymentDto(), (String[])new String[]{"id"});
        paymentEo.setOrderId(performOrderInfoEo.getId());
        paymentEo.setRemainingPayAmount(amountEo.getPayAmount());
        this.performOrderPaymentDomain.insert((BaseEo)paymentEo);
        DgPerformOrderSnapshotEo snapshotEo = new DgPerformOrderSnapshotEo();
        CubeBeanUtils.copyProperties((Object)snapshotEo, (Object)addReqDto.getPerformOrderSnapshotDto(), (String[])new String[]{"id"});
        snapshotEo.setOrderId(performOrderInfoEo.getId());
        if (StringUtils.isNotBlank((CharSequence)addReqDto.getPerformOrderSnapshotDto().getCustomerCode()) || StringUtils.isNotBlank((CharSequence)addReqDto.getPerformOrderSnapshotDto().getHsCustomerCode())) {
            String customerCode = StringUtils.isBlank((CharSequence)addReqDto.getPerformOrderSnapshotDto().getCustomerCode()) ? addReqDto.getPerformOrderSnapshotDto().getHsCustomerCode() : addReqDto.getPerformOrderSnapshotDto().getCustomerCode();
            DgCustomerRespDto customerRespDto = (DgCustomerRespDto)RestResponseHelper.extractData((RestResponse)this.dgCustomerQueryApiProxy.queryByCode(customerCode));
            log.info("\u65b0\u589e\u8ba2\u5355\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)customerRespDto));
            snapshotEo.setCustomerId(addReqDto.getPerformOrderSnapshotDto().getHsCustomerId() != null ? addReqDto.getPerformOrderSnapshotDto().getHsCustomerId() : customerRespDto.getId());
            snapshotEo.setCustomerCode(addReqDto.getPerformOrderSnapshotDto().getHsCustomerCode() != null ? addReqDto.getPerformOrderSnapshotDto().getHsCustomerCode() : customerRespDto.getCode());
            snapshotEo.setCustomerName(addReqDto.getPerformOrderSnapshotDto().getHsCustomerName() != null ? addReqDto.getPerformOrderSnapshotDto().getHsCustomerName() : customerRespDto.getName());
        }
        snapshotEo.setKneadeFlag(Integer.valueOf(0));
        this.performOrderSnapshotDomain.insert((BaseEo)snapshotEo);
        DgPerformOrderRespDto performOrderRespDto = new DgPerformOrderRespDto();
        CubeBeanUtils.copyProperties((Object)performOrderRespDto, (Object)performOrderInfoEo, (String[])new String[0]);
        performOrderRespDto.setPerformOrderPaymentDto(this.contextDtoUtil.pay2Dto(paymentEo));
        performOrderRespDto.setPerformOrderSnapshotDto(this.contextDtoUtil.snap2Dto(snapshotEo));
        performOrderRespDto.setPerformOrderExtensionDto(this.contextDtoUtil.ext2Dto(extensionEo));
        performOrderRespDto.setPerformOrderAmountDto(this.contextDtoUtil.amount2Dto(amountEo));
        performOrderRespDto.setPerformOrderWarehouseInfoDto(this.contextDtoUtil.warehouse2Dto(warehouseInfoEo));
        return performOrderRespDto;
    }

    private void trimPlatformOrderNo(DgBizPerformOrderReqDto addReqDto) {
        if (StringUtils.isNotEmpty((CharSequence)addReqDto.getPlatformOrderNo())) {
            addReqDto.setPlatformOrderNo(addReqDto.getPlatformOrderNo().trim());
        }
    }

    private void calOrderTotalAmount(DgBizPerformOrderReqDto addReqDto, DgPerformOrderInfoEo performOrderInfoEo) {
        List itemList = addReqDto.getItemList();
        ArrayList totalGoodsList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)itemList)) {
            totalGoodsList.addAll(itemList);
        }
        if (CollectionUtils.isNotEmpty((Collection)addReqDto.getGiftList())) {
            for (DgPerformOrderItemReqDto itemReqDto : addReqDto.getGiftList()) {
                itemReqDto.setDiscountAmount(itemReqDto.getSalePrice().multiply(itemReqDto.getItemNum()));
            }
            totalGoodsList.addAll(addReqDto.getGiftList());
        }
        BigDecimal goodsTotalNum = totalGoodsList.stream().map(DgPerformOrderItemDto::getCalcItemNum).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal goodsTotalAmount = Optional.ofNullable(totalGoodsList.stream().map(saleOrderItemReqDto -> {
            if (saleOrderItemReqDto.getSalePrice() != null) {
                return saleOrderItemReqDto.getSalePrice().multiply(saleOrderItemReqDto.getItemNum());
            }
            return BigDecimal.ZERO;
        }).reduce(BigDecimal.ZERO, BigDecimal::add)).orElse(BigDecimal.ZERO);
        BigDecimal discountAmount = Optional.ofNullable(totalGoodsList.stream().map(DgPerformOrderItemDto::getDiscountAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add)).orElse(BigDecimal.ZERO);
        BigDecimal freightCost = Optional.ofNullable(addReqDto.getFreightCost()).orElse(BigDecimal.ZERO);
        BigDecimal payAmount = totalGoodsList.stream().map(DgPerformOrderItemDto::getPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal realPayAmount = totalGoodsList.stream().map(DgPerformOrderItemDto::getRealPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal merchantReceivableAmount = payAmount.add(freightCost);
        log.info("\u8ba2\u5355\u6210\u4ea4\u91d1\u989d:{},\u8fd0\u8d39:{},\u5e94\u6536\u91d1\u989d:{},\u5b9e\u4ed8\u91d1\u989d:{}", new Object[]{payAmount, freightCost, merchantReceivableAmount, realPayAmount});
        log.info("[\u65b0\u589e\u9500\u552e\u8ba2\u5355]\u5546\u54c1\u603b\u6570\u91cf\uff1a{}\uff0c\u5546\u54c1\u603b\u91d1\u989d\uff1a{}\uff0c\u6210\u4ea4\u91d1\u989d\uff1a{}, \u4f18\u60e0\u603b\u91d1\u989d\uff1a{}, \u5546\u5bb6\u5e94\u6536\uff1a{}", new Object[]{goodsTotalNum, goodsTotalAmount, payAmount, discountAmount, merchantReceivableAmount});
        performOrderInfoEo.setGoodsTotalNum(goodsTotalNum);
        performOrderInfoEo.setGoodsTotalAmount(goodsTotalAmount);
        performOrderInfoEo.setPayAmount(payAmount);
        performOrderInfoEo.setRealPayAmount(realPayAmount);
        performOrderInfoEo.setDiscountAmount(discountAmount);
        performOrderInfoEo.setMerchantReceivableAmount(merchantReceivableAmount);
    }

    private void reCheckPlatformOrderRepeat(DgPerformOrderInfoDto addReqDto, DgPerformOrderRespDto performOrderRespDto) {
        if (StringUtils.isNotBlank((CharSequence)addReqDto.getPlatformOrderNo())) {
            LambdaQueryWrapper queryPlatformWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)queryPlatformWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgPerformOrderInfoEo::getPlatformOrderNo, (Object)addReqDto.getPlatformOrderNo());
            List list = this.performOrderInfoDomain.getMapper().selectList((Wrapper)queryPlatformWrapper);
            List saleOrderEos = Optional.ofNullable(list).orElseGet(Collections::emptyList).stream().filter(orderEo -> DgSaleOrderLevelEnum.ORIGINAL.getType().equals(orderEo.getOrderLevel()) || DgSaleOrderLevelEnum.MAIN.getType().equals(orderEo.getOrderLevel())).filter(orderEo -> !DgSaleOrderStatusEnum.OBSOLETE.getCode().equals(orderEo.getOrderStatus())).collect(Collectors.toList());
            List effectSaleOrderEos = saleOrderEos.stream().filter(s -> !INDEMPOTENT_ORDERTYPE_CHECK.contains(s.getOrderType())).collect(Collectors.toList());
            if (effectSaleOrderEos.size() > 1) {
                log.error("[\u65b0\u589e\u9500\u552e\u8ba2\u5355]\u8be5\u5e73\u53f0\u8ba2\u5355\uff08{}\uff09\u5df2\u751f\u6210\u5bf9\u5e94\u7684\u9500\u552e\u8ba2\u5355\uff08{}\uff09\uff0c\u4e0d\u53ef\u591a\u6b21\u751f\u6210\u9500\u552e\u5355", (Object)addReqDto.getPlatformOrderNo(), (Object)((DgPerformOrderInfoEo)effectSaleOrderEos.get(0)).getSaleOrderNo());
                throw DgPcpTradeExceptionCode.MUTIL_SALE_ORDER_EXCEPTION.builderException();
            }
            DgPerformOrderInfoEo insertedOrderEo = (DgPerformOrderInfoEo)effectSaleOrderEos.get(0);
            String hadSaleOrderNo = insertedOrderEo.getSaleOrderNo();
            if (!hadSaleOrderNo.equals(performOrderRespDto.getSaleOrderNo())) {
                log.error("[\u65b0\u589e\u9500\u552e\u8ba2\u5355]\u5f53\u524d\u6570\u636e\u5e93\u65b0\u589e\u7684\u9500\u552e\u8ba2\u5355\u975e\u672c\u7ebf\u7a0b\u521b\u5efa\u751f\u6210\uff0c\u5f53\u524d\u7ebf\u7a0b\u751f\u6210\u7684\u8ba2\u5355\u53f7\u4e3a\uff1a{}\uff0c\u6570\u636e\u5e93\u5df2\u5b58\u5728\u7684\u8ba2\u5355\u53f7\u4e3a\uff1a{}", (Object)performOrderRespDto.getSaleOrderNo(), (Object)hadSaleOrderNo);
                throw DgPcpTradeExceptionCode.MUTIL_SALE_ORDER_EXCEPTION.builderException();
            }
        }
    }

    @Override
    public DgPerformOrderInfoEo createChildOrder(DgPerformOrderReqDto childOrderEo) {
        DgPerformOrderInfoEo eo = this.insert(childOrderEo);
        log.info("[\u62c6\u5355]\u5b50\u8ba2\u5355({})\u7684\u57fa\u672c\u4fe1\u606f\u4e3a\uff1a{}", (Object)eo.getSaleOrderNo(), (Object)JSON.toJSONString((Object)childOrderEo));
        return eo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public DgPerformOrderInfoEo insert(DgPerformOrderReqDto performOrderReqDto) {
        AssertUtils.notNull((Object)performOrderReqDto, (String)"performOrderReqDto \u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderInfoEo performOrderInfoEo = new DgPerformOrderInfoEo();
        CubeBeanUtils.copyProperties((Object)performOrderInfoEo, (Object)performOrderReqDto, (String[])new String[0]);
        this.performOrderInfoDomain.insert((BaseEo)performOrderInfoEo);
        DgPerformOrderExtensionEo performOrderExtensionEo = new DgPerformOrderExtensionEo();
        CubeBeanUtils.copyProperties((Object)performOrderExtensionEo, (Object)performOrderReqDto.getPerformOrderExtensionDto(), (String[])new String[]{"id"});
        performOrderExtensionEo.setOrderId(performOrderInfoEo.getId());
        this.performOrderExtensionDomain.insert((BaseEo)performOrderExtensionEo);
        DgPerformOrderSnapshotEo performOrderSnapshotEo = new DgPerformOrderSnapshotEo();
        CubeBeanUtils.copyProperties((Object)performOrderSnapshotEo, (Object)performOrderReqDto.getPerformOrderSnapshotDto(), (String[])new String[]{"id"});
        performOrderSnapshotEo.setOrderId(performOrderInfoEo.getId());
        this.performOrderSnapshotDomain.insert((BaseEo)performOrderSnapshotEo);
        if (null != performOrderReqDto.getPerformOrderPaymentDto()) {
            DgPerformOrderPaymentEo performOrderPaymentEo = new DgPerformOrderPaymentEo();
            CubeBeanUtils.copyProperties((Object)performOrderPaymentEo, (Object)performOrderReqDto.getPerformOrderPaymentDto(), (String[])new String[]{"id"});
            performOrderPaymentEo.setOrderId(performOrderInfoEo.getId());
            this.performOrderPaymentDomain.insert((BaseEo)performOrderPaymentEo);
        }
        if (null != performOrderReqDto.getPerformOrderAmountDto()) {
            DgPerformOrderAmountEo performOrderAmountEo = new DgPerformOrderAmountEo();
            CubeBeanUtils.copyProperties((Object)performOrderAmountEo, (Object)performOrderReqDto.getPerformOrderAmountDto(), (String[])new String[]{"id"});
            performOrderAmountEo.setOrderId(performOrderInfoEo.getId());
            this.performOrderAmountDomain.insert((BaseEo)performOrderAmountEo);
        }
        if (null != performOrderReqDto.getPerformOrderWarehouseInfoDto()) {
            DgPerformOrderWarehouseInfoEo performOrderWarehouseInfoEo = new DgPerformOrderWarehouseInfoEo();
            CubeBeanUtils.copyProperties((Object)performOrderWarehouseInfoEo, (Object)performOrderReqDto.getPerformOrderWarehouseInfoDto(), (String[])new String[]{"id"});
            performOrderWarehouseInfoEo.setOrderId(performOrderInfoEo.getId());
            this.performOrderWarehouseInfoDomain.insert((BaseEo)performOrderWarehouseInfoEo);
        }
        return performOrderInfoEo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(DgPerformOrderReqDto performOrderReqDto) {
        AssertUtils.notNull((Object)performOrderReqDto, (String)"performOrderReqDto \u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderInfoEo performOrderInfoEo = new DgPerformOrderInfoEo();
        Optional.of(performOrderReqDto).ifPresent(eo -> {
            CubeBeanUtils.copyProperties((Object)performOrderInfoEo, (Object)eo, (String[])new String[0]);
            this.performOrderInfoDomain.updateSelective((BaseEo)performOrderInfoEo);
            Optional.ofNullable(performOrderReqDto.getPerformOrderExtensionDto()).ifPresent(dto -> {
                DgPerformOrderExtensionEo performOrderExtensionEo = new DgPerformOrderExtensionEo();
                CubeBeanUtils.copyProperties((Object)performOrderExtensionEo, (Object)dto, (String[])new String[]{"id"});
                this.performOrderExtensionDomain.updateByOrderId(eo.getId(), (DgPerformOrderExtensionDto)dto);
            });
            Optional.ofNullable(performOrderReqDto.getPerformOrderPaymentDto()).ifPresent(dto -> {
                DgPerformOrderPaymentEo performOrderPaymentEo = new DgPerformOrderPaymentEo();
                CubeBeanUtils.copyProperties((Object)performOrderPaymentEo, (Object)dto, (String[])new String[]{"id"});
                this.performOrderPaymentDomain.updateByOrderId(eo.getId(), performOrderPaymentEo);
            });
            Optional.ofNullable(performOrderReqDto.getPerformOrderSnapshotDto()).ifPresent(dto -> {
                DgPerformOrderSnapshotEo performOrderSnapshotEo = new DgPerformOrderSnapshotEo();
                CubeBeanUtils.copyProperties((Object)performOrderSnapshotEo, (Object)dto, (String[])new String[]{"id"});
                this.performOrderSnapshotDomain.updateByOrderId(eo.getId(), performOrderSnapshotEo);
            });
            Optional.ofNullable(performOrderReqDto.getPerformOrderAmountDto()).ifPresent(dto -> {
                DgPerformOrderAmountEo performOrderAmountEo = new DgPerformOrderAmountEo();
                CubeBeanUtils.copyProperties((Object)performOrderAmountEo, (Object)performOrderReqDto.getPerformOrderAmountDto(), (String[])new String[]{"id"});
                this.performOrderAmountDomain.updateByOrderId(eo.getId(), performOrderAmountEo);
            });
            Optional.ofNullable(performOrderReqDto.getPerformOrderWarehouseInfoDto()).ifPresent(dto -> {
                DgPerformOrderWarehouseInfoEo performOrderWarehouseInfoEo = new DgPerformOrderWarehouseInfoEo();
                CubeBeanUtils.copyProperties((Object)performOrderWarehouseInfoEo, (Object)performOrderReqDto.getPerformOrderWarehouseInfoDto(), (String[])new String[]{"id"});
                this.performOrderWarehouseInfoDomain.updateByOrderId(eo.getId(), performOrderWarehouseInfoEo);
            });
        });
    }

    @Override
    public void modifyPlanDeliveryDate(ModifyPlanDeliveryDateVo modifyPlanDeliveryDateVo) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BaseEo::getId, (Object)modifyPlanDeliveryDateVo.getSaleOrderId());
        DgPerformOrderInfoEo performOrderInfoEo = (DgPerformOrderInfoEo)this.performOrderInfoDomain.getMapper().selectOne((Wrapper)wrapper);
        AssertUtils.notNull((Object)performOrderInfoEo, (String)"\u53d1\u8d27\u652f\u4ed8\u5c65\u7ea6\u76f8\u5173\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        performOrderInfoEo.setPlanDeliveryTime(modifyPlanDeliveryDateVo.getPlanDeliveryTime());
        this.performOrderInfoDomain.update((BaseEo)performOrderInfoEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateSaleOrderAssignStatus(Long id, SaleOrderAssignStatusEnum assignStatusEnum) {
        DgPerformOrderInfoEo updateEo = new DgPerformOrderInfoEo();
        updateEo.setId(id);
        updateEo.setAssignStatus(assignStatusEnum.getCode());
        updateEo.setInterceptInfo("");
        this.performOrderInfoDomain.updateSaleOrderById(id, updateEo);
    }

    @Override
    public void cleanSourceData(Long orderId) {
        this.performOrderInfoDomain.cleanSourceData(orderId);
        DgPerformOrderWarehouseInfoEo warehouseInfoEo = this.performOrderWarehouseInfoDomain.queryDtoById(orderId);
        warehouseInfoEo.setDeliveryLogicalWarehouseCode("");
        warehouseInfoEo.setPhysicsWarehouseCode("");
        warehouseInfoEo.setUpdateTime(new Date());
        this.performOrderWarehouseInfoDomain.updateSelective((BaseEo)warehouseInfoEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @DgRedisLock(lockName="saleOrder", key="#respDto.getId()")
    public void modifyOrderByDeliveredResult(DgPerformOrderRespDto respDto, DgOutDeliveryResultReqDto reqDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        log.info("[\u51fa\u5e93\u56de\u4f20]\u4fee\u6539\u7684\u8ba2\u5355\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        DgPerformOrderRespDto performOrderInfoDto = this.omsOrderInfoQueryDomain.queryDtoById(respDto.getId());
        AssertUtils.isTrue((boolean)respDto.getSaleOrderNo().equals(reqDto.getOrderNo()), (String)"\u56de\u4f20\u9500\u552e\u5355\u53f7\u4e0d\u4e00\u81f4");
        BigDecimal totalOutDeliveryCount = this.getOrderOutDeliveredCount((DgPerformOrderInfoDto)performOrderInfoDto);
        this.performNoticeSyncRecordDomain.saleOutSyncRecord(performOrderInfoDto, reqDto);
        if (reqDto.getTotalQuantity() != null) {
            this.modifyOrderItemOutDeliveredResult(performOrderInfoDto.getId(), reqDto);
            DgPerformOrderInfoEo updateStatusEo = new DgPerformOrderInfoEo();
            if (reqDto.getDeliveryTime() != null) {
                updateStatusEo.setDeliveryTime(reqDto.getDeliveryTime());
                updateStatusEo.setDeliveryCompleteDate(reqDto.getDeliveryTime());
            } else {
                updateStatusEo.setDeliveryCompleteDate(new Date());
                updateStatusEo.setDeliveryTime(new Date());
            }
            updateStatusEo.setId(performOrderInfoDto.getId());
            this.performOrderInfoDomain.updateSaleOrderById(performOrderInfoDto.getId(), updateStatusEo);
        } else {
            log.info("\u51fa\u5e93\u56de\u4f20\u5f02\u5e38");
        }
    }

    private BigDecimal getOrderOutDeliveredCount(DgPerformOrderInfoDto saleOrderEo) {
        List<DgPerformOrderLineDto> orderLineDtoList = this.omsOrderLineBizQueryDomain.queryOrderLineInfoByOrderId(saleOrderEo.getId());
        AssertUtils.notEmpty(orderLineDtoList, (String)"\u8ba2\u5355\u5546\u54c1\u4e0d\u5b58\u5728");
        return orderLineDtoList.stream().filter(Objects::nonNull).map(item -> Optional.ofNullable(item.getOutItemNum()).orElse(BigDecimal.ZERO)).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    @Override
    @Deprecated
    public DgPerformOrderInfoOutNoticeSyncRecordRespDto saveOutNoticeRecord(DgPerformOrderRespDto saleOrderRespDto, DgOutDeliveryResultReqDto reqDto) {
        return null;
    }

    private void modifyOrderItemOutDeliveredResult(Long saleOrderId, DgOutDeliveryResultReqDto reqDto) {
        AssertUtils.notEmpty((Collection)reqDto.getDeliveryDetailList(), (String)"\u51fa\u5e93\u5546\u54c1\u4e3a\u7a7a");
        List<DgPerformOrderLineDto> orderLineDtos = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderId(saleOrderId);
        log.info("[\u51fa\u5e93\u56de\u4f20]\u8ba2\u5355\u539f\u5546\u54c1\u5217\u8868\u4e3a\uff1a{}", (Object)JSON.toJSONString(orderLineDtos));
        AssertUtils.notEmpty(orderLineDtos, (String)"\u8ba2\u5355\u5546\u54c1\u4e0d\u5b58\u5728");
        Map<String, Map<String, BigDecimal>> longCodeGroupMap = reqDto.getDeliveryDetailList().stream().collect(Collectors.groupingBy(DgOutDeliveryDetailResultExtDto::getLongCode, Collectors.collectingAndThen(Collectors.toList(), saveOrderItems -> {
            Map<String, BigDecimal> batchCountMap = saveOrderItems.stream().collect(Collectors.groupingBy(DgOutDeliveryDetailResultExtDto::getBatch, Collectors.collectingAndThen(Collectors.toList(), batchOutDeliveryDetailResults -> batchOutDeliveryDetailResults.stream().filter(Objects::nonNull).map(DgOutDeliveryDetailResultExtDto::getOutQuantity).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add))));
            return batchCountMap;
        })));
        Map<Long, List<String>> orderItemIdSnCodeMap = reqDto.getDeliveryDetailList().stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getSnCode())).collect(Collectors.toMap(DgOutDeliveryDetailResultExtDto::getTradeOrderItemId, a -> Arrays.stream(a.getSnCode().split(",")).collect(Collectors.toList())));
        log.info("[\u51fa\u5e93\u56de\u4f20]\u51fa\u5e93\u56de\u4f20\u5206\u7ec4\u5904\u7406\u540e\u7684\u6570\u636e\u4e3a\uff1a{}\uff0c sn\u7801\u6570\u636e: {}", (Object)JSON.toJSONString(longCodeGroupMap), (Object)JSON.toJSONString(orderItemIdSnCodeMap));
        HashMap outDeliveredMap = Maps.newHashMap();
        HashMap outDeliveredResultMap = Maps.newHashMap();
        this.expectOutDelivery(orderLineDtos, longCodeGroupMap, outDeliveredMap, outDeliveredResultMap);
        this.updateOutDeliveryResult(outDeliveredResultMap, orderItemIdSnCodeMap);
    }

    private void expectOutDelivery(List<DgPerformOrderLineDto> orderLineDtos, Map<String, Map<String, BigDecimal>> longCodeGroupMap, Map<String, Map<String, BigDecimal>> outDeliveredMap, Map<Long, DgPerformOrderLineDto> outDeliveredResultMap) {
        orderLineDtos.sort(Comparator.comparing(DgPerformOrderLineDto::getGiftFlag));
        this.scanOrderItems(orderLineDtos, longCodeGroupMap, outDeliveredMap, outDeliveredResultMap, (batchCountMap, orderLineDto) -> {
            BigDecimal batchCount;
            if (batchCountMap != null && (batchCount = (BigDecimal)batchCountMap.get(orderLineDto.getDeliveryItemBatchNo())) != null) {
                this.deductOutDelivery((DgPerformOrderLineDto)orderLineDto, orderLineDto.getDeliveryItemBatchNo(), batchCount, outDeliveredMap, outDeliveredResultMap);
            }
        });
        this.scanOrderItems(orderLineDtos, longCodeGroupMap, outDeliveredMap, outDeliveredResultMap, (batchCountMap, orderLineDto) -> {
            if (batchCountMap != null) {
                batchCountMap.forEach((batchNo, count) -> this.deductOutDelivery((DgPerformOrderLineDto)orderLineDto, (String)batchNo, (BigDecimal)count, outDeliveredMap, outDeliveredResultMap));
            }
        });
    }

    private void scanOrderItems(List<DgPerformOrderLineDto> orderLineDtos, Map<String, Map<String, BigDecimal>> longCodeGroupMap, Map<String, Map<String, BigDecimal>> outDeliveredMap, Map<Long, DgPerformOrderLineDto> outDeliveredResultMap, BiConsumer<Map<String, BigDecimal>, DgPerformOrderLineDto> callHandle) {
        for (DgPerformOrderLineDto orderLineDto : orderLineDtos) {
            if (orderLineDto.getCalcItemNum().equals(orderLineDto.getOutItemNum())) {
                log.info("[\u51fa\u5e93\u56de\u4f20]\u8ba2\u5355\u5546\u54c1\u884cid\u4e3a{}\u5df2\u5168\u90e8\u51fa\u5e93", (Object)orderLineDto.getId());
                continue;
            }
            Map<String, BigDecimal> batchCountMap = longCodeGroupMap.get(orderLineDto.getSkuCode());
            callHandle.accept(batchCountMap, orderLineDto);
        }
    }

    private void deductOutDelivery(DgPerformOrderLineDto orderLineDto, String deliveryItemBatchNo, BigDecimal batchCount, Map<String, Map<String, BigDecimal>> outDeliveredMap, Map<Long, DgPerformOrderLineDto> outDeliveredResultMap) {
        BigDecimal availableCount = this.calAvailableCount(outDeliveredMap, orderLineDto.getSkuCode(), deliveryItemBatchNo, batchCount);
        BigDecimal needCount = orderLineDto.getCalcItemNum().subtract(Optional.ofNullable(orderLineDto.getOutItemNum()).orElse(BigDecimal.ZERO));
        log.info("[\u51fa\u5e93\u56de\u4f20]\u53ef\u7528\u51fa\u5e93\u6570\u91cf\u4e3a\uff1a{}\uff0c\u9700\u8981\u51fa\u5e93\u6570\u91cf\u4e3a\uff1a{}", (Object)availableCount, (Object)needCount);
        if (availableCount.compareTo(needCount) >= 0) {
            log.info("[\u51fa\u5e93\u56de\u4f20]\u5546\u54c1orderItemId={},\u5df2\u5168\u90e8\u51fa\u5e93", (Object)orderLineDto.getId());
            this.updateItemOutDeliveryCount(orderLineDto.getId(), orderLineDto.getCalcItemNum(), outDeliveredResultMap);
            this.calDeliveredCount(outDeliveredMap, orderLineDto.getSkuCode(), deliveryItemBatchNo, needCount);
        } else if (BigDecimal.ZERO.compareTo(availableCount) < 0) {
            log.info("[\u51fa\u5e93\u56de\u4f20]\u5546\u54c1orderItemId={},\u90e8\u5206\u51fa\u5e93\uff0c\u5df2\u51fa\u5e93\u6570\u91cf\u4e3a\uff1aoutItemNum={}\uff0cavailableCount={}", new Object[]{orderLineDto.getId(), orderLineDto.getOutItemNum(), availableCount});
            this.updateItemOutDeliveryCount(orderLineDto.getId(), orderLineDto.getOutItemNum().add(availableCount), outDeliveredResultMap);
            this.calDeliveredCount(outDeliveredMap, orderLineDto.getSkuCode(), deliveryItemBatchNo, availableCount);
        }
    }

    private BigDecimal calAvailableCount(Map<String, Map<String, BigDecimal>> outDeliveredMap, String longCode, String batchNo, BigDecimal batchCount) {
        Map<String, BigDecimal> batchCountMap = outDeliveredMap.get(longCode);
        if (batchCountMap == null) {
            return batchCount;
        }
        BigDecimal count = batchCountMap.get(batchNo);
        if (count != null) {
            return batchCount.subtract(count);
        }
        return batchCount;
    }

    private void updateItemOutDeliveryCount(Long orderItemId, BigDecimal outDeliveryCount, Map<Long, DgPerformOrderLineDto> outDeliveredResultMap) {
        AssertUtils.notNull((Object)orderItemId, (String)"orderItemId \u4e0d\u80fd\u4e3a\u7a7a");
        outDeliveredResultMap.compute(orderItemId, (k, updateItemEo) -> {
            if (updateItemEo == null) {
                updateItemEo = new DgPerformOrderLineDto();
                updateItemEo.setId(orderItemId);
                updateItemEo.setOutItemNum(outDeliveryCount);
                updateItemEo.setCurrentOutItemNum(outDeliveryCount);
                return updateItemEo;
            }
            BigDecimal totalDeliveryCount = updateItemEo.getOutItemNum().add(outDeliveryCount);
            updateItemEo.setOutItemNum(totalDeliveryCount);
            updateItemEo.setCurrentOutItemNum(outDeliveryCount);
            return updateItemEo;
        });
    }

    private void calDeliveredCount(Map<String, Map<String, BigDecimal>> outDeliveredMap, String skuCode, String batchNo, BigDecimal count) {
        HashMap batchCountMap = outDeliveredMap.get(skuCode);
        if (batchCountMap == null) {
            batchCountMap = Maps.newHashMap();
            batchCountMap.put(batchNo, count);
            outDeliveredMap.put(skuCode, batchCountMap);
        } else {
            BigDecimal usedCount = Optional.ofNullable(batchCountMap.get(batchNo)).orElse(BigDecimal.ZERO).add(count);
            batchCountMap.put(batchNo, usedCount);
        }
        log.info("[\u51fa\u5e93\u56de\u4f20]\u5df2\u51fa\u5e93\u7684\u8bb0\u5f55\u7edf\u8ba1\uff1a{}", (Object)JSON.toJSONString((Object)batchCountMap));
    }

    private void updateOutDeliveryResult(Map<Long, DgPerformOrderLineDto> outDeliveredResultMap, Map<Long, List<String>> orderItemIdSnCodeMap) {
        List<DgPerformOrderLineDto> updateOrderItemDtos = outDeliveredResultMap.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toList());
        List<DgPerformOrderItemLineEo> itemLineEoList = this.orderItemLineDomain.queryItemLineByOrderLineIds(updateOrderItemDtos.stream().map(BaseDto::getId).collect(Collectors.toList()));
        Map<Long, List<DgPerformOrderItemLineEo>> itemMap = itemLineEoList.stream().collect(Collectors.groupingBy(DgPerformOrderItemLineEo::getOrderLineId));
        updateOrderItemDtos.sort(Comparator.comparing(BaseDto::getId));
        updateOrderItemDtos.forEach(updateOrderItemDto -> {
            this.orderLineDomain.updateSelective((BaseEo)DgBeanUtils.dto2eo(updateOrderItemDto, DgPerformOrderLineEo.class));
            List list = (List)itemMap.get(updateOrderItemDto.getId());
            List snCodelist = (List)orderItemIdSnCodeMap.get(updateOrderItemDto.getId());
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                if ((list = list.stream().filter(item -> StringUtils.isBlank((CharSequence)item.getDistributionStatus()) || !item.getDistributionStatus().equals(OrderItemDistributionStatusEnum.OUT.getCode())).collect(Collectors.toList())).size() >= updateOrderItemDto.getCurrentOutItemNum().intValue()) {
                    List<Object> upList = new ArrayList();
                    List<Object> remainderList = new ArrayList();
                    if (list.size() == updateOrderItemDto.getCurrentOutItemNum().intValue()) {
                        upList = list;
                    } else {
                        upList = list.subList(0, updateOrderItemDto.getCurrentOutItemNum().intValue());
                        remainderList = list.subList(updateOrderItemDto.getCurrentOutItemNum().intValue(), list.size() - 1);
                    }
                    itemMap.put(updateOrderItemDto.getId(), remainderList);
                    for (int i = 0; i < upList.size(); ++i) {
                        DgPerformOrderItemLineEo item2 = (DgPerformOrderItemLineEo)upList.get(i);
                        item2.setDistributionStatus(OrderItemDistributionStatusEnum.OUT.getCode());
                        item2.setDeliveryStatus(ItemLineDeliveryStatusEnum.YES.getType());
                        if (CollectionUtil.isNotEmpty((Collection)snCodelist) && i < snCodelist.size()) {
                            item2.setSnCode((String)snCodelist.get(i));
                        }
                        this.orderItemLineDomain.updateSelective((BaseEo)item2);
                    }
                } else {
                    throw DgPcpTradeExceptionCode.FIT_GOOD_IEM_COUNT_NOT_ENOUGHT.builderException();
                }
            }
        });
    }

    @Override
    public void modifyPlatformShipmentEnterprise(Long orderId, DgOutDeliveryResultReqDto modifyReqDto) {
    }

    @Override
    public int optimisticModifySaleOrder(DgPerformOrderInfoEo saleOrderEo, UpdateWrapper<DgPerformOrderInfoEo> queryWrapper, int idealCount, boolean needThrow) {
        log.info("optimisticModifySaleOrder\u5165\u53c2saleOrderEo={}\uff0cqueryWrapper={}\uff0cidealCount={}\uff0cneedThrow={}", new Object[]{JSON.toJSONString((Object)saleOrderEo), JSON.toJSONString(queryWrapper), idealCount, needThrow});
        if (queryWrapper.isEmptyOfWhere()) {
            throw new BizException("-1", "\u66f4\u65b0\u6761\u4ef6\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (((DgPerformOrderInfoEo)queryWrapper.getEntity()).getId() == null) {
            throw new BizException("-1", "\u66f4\u65b0id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        this.das.setUpdateSystemFields((BaseEo)saleOrderEo);
        this.popOrderStatusLog(saleOrderEo, queryWrapper);
        int optCount = this.das.getMapper().update((Object)saleOrderEo, queryWrapper);
        if (this.das.isUseCache()) {
            DgPerformOrderInfoEo entity = (DgPerformOrderInfoEo)queryWrapper.getEntity();
            this.das.removeLogicCache((BaseEo)entity);
            this.das.removeCache((Object)entity.getId());
            this.das.removeCacheByExample((BaseEo)entity);
        }
        if (needThrow && optCount != idealCount) {
            throw new BizException("-1", "\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\u5931\u8d25");
        }
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            this.publisher.publishEvent((Object)new PerformOrderInfoUpdateEvent(((DgPerformOrderInfoEo)queryWrapper.getEntity()).getId()));
        }
        return optCount;
    }

    @Override
    public void logicDeleteById(Long id) {
        AssertUtils.notNull((Object)id, (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderInfoEo performOrderInfoEo = (DgPerformOrderInfoEo)this.performOrderInfoDomain.selectByPrimaryKey(id);
        if (Objects.nonNull(performOrderInfoEo)) {
            Long orderId = performOrderInfoEo.getId();
            DgPerformOrderExtensionEo performOrderExtensionEo = new DgPerformOrderExtensionEo();
            performOrderExtensionEo.setOrderId(orderId);
            this.performOrderExtensionDomain.logicDelete((BaseEo)performOrderExtensionEo);
            DgPerformOrderPaymentEo performOrderPaymentEo = new DgPerformOrderPaymentEo();
            performOrderPaymentEo.setOrderId(orderId);
            this.performOrderPaymentDomain.logicDelete((BaseEo)performOrderPaymentEo);
            DgPerformOrderSnapshotEo performOrderSnapshotEo = new DgPerformOrderSnapshotEo();
            performOrderSnapshotEo.setOrderId(orderId);
            this.performOrderSnapshotDomain.logicDelete((BaseEo)performOrderSnapshotEo);
            DgPerformOrderAmountEo performOrderAmountEo = new DgPerformOrderAmountEo();
            performOrderAmountEo.setOrderId(orderId);
            this.performOrderAmountDomain.logicDelete((BaseEo)performOrderAmountEo);
            DgPerformOrderWarehouseInfoEo performOrderWarehouseInfoEo = new DgPerformOrderWarehouseInfoEo();
            performOrderWarehouseInfoEo.setOrderId(orderId);
            this.performOrderWarehouseInfoDomain.logicDelete((BaseEo)performOrderWarehouseInfoEo);
            DgPerformOrderAddrEo performOrderAddrEo = new DgPerformOrderAddrEo();
            performOrderAddrEo.setOrderId(orderId);
            this.performOrderAddrDomain.logicDelete((BaseEo)performOrderAddrEo);
            DgPerformOrderLineEo performOrderLineEo = new DgPerformOrderLineEo();
            performOrderLineEo.setOrderId(orderId);
            this.orderLineDomain.logicDelete((BaseEo)performOrderLineEo);
            DgPerformOrderLineAmountEo performOrderLineAmountEo = new DgPerformOrderLineAmountEo();
            performOrderLineAmountEo.setOrderId(orderId);
            this.performOrderLineAmountDomain.logicDelete((BaseEo)performOrderLineAmountEo);
            DgPerformOrderItemLineEo performOrderItemLineEo = new DgPerformOrderItemLineEo();
            performOrderItemLineEo.setOrderId(orderId);
            this.orderItemLineDomain.logicDelete((BaseEo)performOrderItemLineEo);
            DgPerformOrderItemLineAmountEo performOrderItemLineAmountEo = new DgPerformOrderItemLineAmountEo();
            performOrderItemLineAmountEo.setOrderId(orderId);
            this.performOrderItemLineAmountDomain.logicDelete((BaseEo)performOrderItemLineAmountEo);
            this.performOrderInfoDomain.logicDeleteById(id);
        }
    }

    @Override
    public void modifyFinancialRevokeReason(Long id, String financialRevokeReason) {
        this.performOrderInfoDomain.modifyFinancialRevokeReason(id, financialRevokeReason);
    }

    @Override
    public void revokeReasonEmpty(Long orderId) {
        AssertUtils.isFalse((orderId == null ? 1 : 0) != 0, (String)"\u53c2\u6570orderId\u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderInfoEo performOrderInfoEo = new DgPerformOrderInfoEo();
        performOrderInfoEo.setId(orderId);
        performOrderInfoEo.setRevokeReason("");
        this.performOrderInfoDomain.updateSelective((BaseEo)performOrderInfoEo);
    }

    private void popOrderStatusLog(DgPerformOrderInfoEo saleOrderEo, UpdateWrapper<DgPerformOrderInfoEo> updateWrapper) {
        LambdaQueryWrapper queryOrderWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryOrderWrapper.eq(BaseEo::getDr, (Object)0)).eq(BaseEo::getId, (Object)((DgPerformOrderInfoEo)updateWrapper.getEntity()).getId());
        DgPerformOrderInfoEo saleOrderDasOne = (DgPerformOrderInfoEo)this.das.getMapper().selectOne((Wrapper)queryOrderWrapper);
        String orderSteps = saleOrderDasOne.getOrderSteps();
        List<DgOrderStatusLogRespDto> orderStatusLogRespDtos = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)orderSteps)) {
            orderStatusLogRespDtos = JSON.parseArray((String)orderSteps, DgOrderStatusLogRespDto.class);
        }
        if (StringUtils.isNotBlank((CharSequence)saleOrderEo.getOrderStatus())) {
            DgOrderStatusLogRespDto orderStatusLogRespDto = new DgOrderStatusLogRespDto();
            orderStatusLogRespDto.setOrderStatus(saleOrderEo.getOrderStatus());
            orderStatusLogRespDto.setOptDate(new Date());
            orderStatusLogRespDto.setOptPerson((String)ObjectUtil.defaultIfNull((Object)ServiceContext.getContext().getRequestUserCode(), (Object)"system"));
            orderStatusLogRespDtos.add(orderStatusLogRespDto);
            saleOrderEo.setOrderSteps(JSON.toJSONString(orderStatusLogRespDtos));
        }
    }

    @Deprecated
    private void saveNoticeSyncRecord(DgPerformOrderRespDto respDto, DgOutDeliveryResultReqDto req) {
        DgPerformNoticeSyncRecordEo dgPerformNoticeSyncRecordEo;
        log.info("\u4fdd\u5b58\u51fa\u5165\u5e93\u7ed3\u679c\u540c\u6b65\u8bb0\u5f55saveNoticeSyncRecord\uff1a{}\uff0c{}", (Object)JSON.toJSONString((Object)respDto), (Object)JSON.toJSONString((Object)req));
        if (StringUtils.isBlank((CharSequence)req.getOutNoticeOrderNo()) && StringUtils.isBlank((CharSequence)req.getOutResultOrderNo())) {
            log.error("\u7269\u6d41\u5355\u53f7\u4e0d\u5b58\u5728");
            return;
        }
        List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.performNoticeSyncRecordDomain.filter().eq((Object)"business_id", (Object)respDto.getId())).eq((Object)"result_notice_order_no", (Object)(StringUtils.isBlank((CharSequence)req.getOutNoticeOrderNo()) ? req.getOutResultOrderNo() : req.getOutNoticeOrderNo()))).list();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            dgPerformNoticeSyncRecordEo = (DgPerformNoticeSyncRecordEo)list.get(0);
        } else {
            dgPerformNoticeSyncRecordEo = new DgPerformNoticeSyncRecordEo();
            dgPerformNoticeSyncRecordEo.setResultNoticeOrderNo(StringUtils.isBlank((CharSequence)req.getOutNoticeOrderNo()) ? req.getOutResultOrderNo() : req.getOutNoticeOrderNo());
            dgPerformNoticeSyncRecordEo.setBusinessId(respDto.getId());
            dgPerformNoticeSyncRecordEo.setBusinessNo(respDto.getSaleOrderNo());
            dgPerformNoticeSyncRecordEo.setBusinessType(Integer.valueOf(1));
            dgPerformNoticeSyncRecordEo.setNoticeResultJson(JSON.toJSONString((Object)req));
            dgPerformNoticeSyncRecordEo.setShippingCompany(req.getShipmentEnterpriseName());
            dgPerformNoticeSyncRecordEo.setTotalCartons(req.getTotalCartons());
            dgPerformNoticeSyncRecordEo.setTotalQuantity(req.getTotalQuantity());
            this.performNoticeSyncRecordDomain.insert((BaseEo)dgPerformNoticeSyncRecordEo);
        }
        if (CollectionUtils.isNotEmpty((Collection)req.getShippingInfoList())) {
            req.getShippingInfoList().stream().filter(f -> StringUtils.isNotBlank((CharSequence)f.getConsignNo()) || StringUtils.isNotBlank((CharSequence)f.getShippingNo())).forEach(shippingInfo -> {
                List shippingEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.performNoticeSyncRecordShippingDomain.filter().eq((Object)"record_id", (Object)dgPerformNoticeSyncRecordEo.getId())).eq((Object)"consignment_no", (Object)shippingInfo.getConsignNo())).list();
                if (CollectionUtils.isEmpty((Collection)shippingEoList)) {
                    DgPerformNoticeSyncRecordShippingEo shippingEo = new DgPerformNoticeSyncRecordShippingEo();
                    shippingEo.setNoticeOrderNo(shippingInfo.getOutNoticeOrderNo());
                    shippingEo.setDeliveryTime(shippingInfo.getDeliveryTime());
                    shippingEo.setShippingType(shippingInfo.getShippingType());
                    shippingEo.setShippingCompany(shippingInfo.getShippingCompanyName());
                    shippingEo.setConsignmentNo(StringUtils.isBlank((CharSequence)shippingInfo.getConsignNo()) ? shippingInfo.getShippingNo() : shippingInfo.getConsignNo());
                    shippingEo.setStatus(shippingInfo.getStatus());
                    shippingEo.setShippingType(shippingInfo.getShippingType());
                    shippingEo.setRecordId(dgPerformNoticeSyncRecordEo.getId());
                    shippingEo.setVolume(req.getTotalVolume());
                    shippingEo.setWeight(req.getTotalWeight());
                    if (StringUtils.isNotBlank((CharSequence)req.getPhoneNum())) {
                        JSONObject extension = new JSONObject();
                        extension.put("phoneNum", (Object)req.getPhoneNum());
                        shippingEo.setExtension(extension.toJSONString());
                    }
                    this.performNoticeSyncRecordShippingDomain.insert((BaseEo)shippingEo);
                } else {
                    log.info("\u7269\u6d41\u5355\u53f7\u5df2\u5b58\u5728\uff1a{}\uff0c{}", (Object)dgPerformNoticeSyncRecordEo.getId(), (Object)shippingInfo.getConsignNo());
                }
            });
        }
    }

    static {
        INDEMPOTENT_ORDERTYPE_CHECK.add(DgSaleOrderTypeEnum.REPLENISH_ORDER.getType());
        INDEMPOTENT_ORDERTYPE_CHECK.add(DgSaleOrderTypeEnum.EXCHANGE_ORDER.getType());
        INDEMPOTENT_ORDERTYPE_CHECK.add(DgSaleOrderTypeEnum.RETURN_LINGYONG.getType());
    }
}

