/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.aop;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.huieryun.lock.provider.redis.RedisLockService;
import com.yunxi.dg.base.center.trade.anno.DgRedisLock;
import com.yunxi.dg.base.center.trade.exception.DgPcpTradeExceptionCode;
import com.yunxi.dg.base.center.trade.utils.SpelUtil;
import com.yunxi.dg.base.center.trade.utils.SplitLevelUtils;
import java.lang.reflect.Method;
import javax.annotation.Resource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class DgRedisLockAspect {
    private static final Logger LOGGER = LoggerFactory.getLogger(DgRedisLockAspect.class);
    @Resource
    private RedisLockService lockService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(dgRedisLock)")
    public Object around(ProceedingJoinPoint joinPoint, DgRedisLock dgRedisLock) throws Throwable {
        Object result = null;
        Mutex mutex = this.lock(joinPoint, dgRedisLock);
        try {
            result = joinPoint.proceed();
        }
        finally {
            this.unLock(mutex, joinPoint, dgRedisLock);
            SplitLevelUtils.removeSplitLevel();
        }
        return result;
    }

    private void unLock(Mutex mutex, ProceedingJoinPoint joinPoint, DgRedisLock dgRedisLock) {
        if (mutex != null && this.lockService.isLocked(dgRedisLock.lockName(), this.getRedisKey(joinPoint, dgRedisLock))) {
            LOGGER.info("[\u5206\u5e03\u5f0f\u9501\u89e3\u9501]\u89e3\u9501\u5206\u5e03\u5f0f\u9501\uff08mutex={},thread={}\uff09", (Object)JSON.toJSONString((Object)mutex), (Object)Thread.currentThread().getName());
            this.lockService.unlock(mutex);
        }
    }

    private Mutex lock(ProceedingJoinPoint joinPoint, DgRedisLock dgRedisLock) throws InterruptedException {
        Boolean canLock = this.getRedisLockCondition(joinPoint, dgRedisLock);
        if (canLock.booleanValue()) {
            String redisKey = this.getRedisKey(joinPoint, dgRedisLock);
            LOGGER.info("[\u6dfb\u52a0\u5206\u5e03\u5f0f\u9501]{}\u51c6\u5907\u83b7\u53d6(thread={})\u4e2d,tableName={},primaryKey={},waitTimeout={},leaseTime={},timeUnit={}", new Object[]{redisKey, Thread.currentThread().getName(), dgRedisLock.lockName(), redisKey, dgRedisLock.waitTime(), dgRedisLock.leaseTime(), dgRedisLock.timeUnit()});
            Mutex lock = null;
            try {
                lock = this.lockService.lock(dgRedisLock.lockName(), redisKey, dgRedisLock.waitTime(), dgRedisLock.leaseTime(), dgRedisLock.timeUnit());
            }
            catch (Exception e) {
                LOGGER.error("[\u6dfb\u52a0\u5206\u5e03\u5f0f\u9501]\u5f02\u5e38\uff1a", (Throwable)e);
                throw DgPcpTradeExceptionCode.OBTAIN_LOCK_EXCEPTION.buildBizException(new Object[]{"\u64cd\u4f5c\u8fc7\u4e8e\u9891\u7e41\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5"});
            }
            LOGGER.info("[\u6dfb\u52a0\u5206\u5e03\u5f0f\u9501]{}\u5206\u5e03\u5f0f\u9501\u6210\u529f(mutex={},thread={})\u4e2d,tableName={},primaryKey={},waitTimeout={},leaseTime={},timeUnit={}", new Object[]{redisKey, JSON.toJSONString((Object)lock), Thread.currentThread().getName(), dgRedisLock.lockName(), redisKey, dgRedisLock.waitTime(), dgRedisLock.leaseTime(), dgRedisLock.timeUnit()});
            return lock;
        }
        return null;
    }

    private Boolean getRedisLockCondition(ProceedingJoinPoint joinPoint, DgRedisLock dgRedisLock) {
        Signature signature = joinPoint.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method targetMethod = methodSignature.getMethod();
        Object target = joinPoint.getTarget();
        Object[] arguments = joinPoint.getArgs();
        String condition = dgRedisLock.condition();
        return SpelUtil.parseBoolean(condition, targetMethod, arguments);
    }

    private String getRedisKey(ProceedingJoinPoint joinPoint, DgRedisLock dgRedisLock) {
        Signature signature = joinPoint.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method targetMethod = methodSignature.getMethod();
        Object target = joinPoint.getTarget();
        Object[] arguments = joinPoint.getArgs();
        String key = dgRedisLock.key();
        return SpelUtil.parse(key, targetMethod, arguments);
    }
}

