/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.domain.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.trade.api.enums.OrderAddrApplyAuditStatusEnum;
import com.yunxi.dg.base.center.trade.dao.das.IDgPerformOrderAddrApplyDas;
import com.yunxi.dg.base.center.trade.dao.das.IDgPerformOrderAddrApplyLineDas;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderAddrApplyDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderAddrApplyDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderAddrApplyLineDto;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderAddrApplyEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderAddrApplyLineEo;
import com.yunxi.dg.base.framework.core.db.das.ICommonDas;
import com.yunxi.dg.base.framework.core.domain.BaseDomainImpl;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DgPerformOrderAddrApplyDomainImpl
extends BaseDomainImpl<DgPerformOrderAddrApplyEo>
implements IDgPerformOrderAddrApplyDomain {
    private static final Logger log = LoggerFactory.getLogger(DgPerformOrderAddrApplyDomainImpl.class);
    @Resource
    private IDgPerformOrderAddrApplyDas das;
    @Resource
    private IDgPerformOrderAddrApplyLineDas performOrderAddrApplyLineDas;

    public ICommonDas<DgPerformOrderAddrApplyEo> commonDas() {
        return this.das;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long save(DgPerformOrderAddrApplyDto dto, Boolean onlyDelete) {
        log.info("\u4fdd\u5b58\u4fee\u6539\u7684\u5730\u5740\u4fe1\u606f\uff08\u5f85\u63d0\u4ea4OA\u5ba1\u6279\uff09:{}", (Object)JSON.toJSONString((Object)dto));
        dto.setAuditStatus(OrderAddrApplyAuditStatusEnum.WAIT_COMMIT.getCode());
        List orderIds = dto.getApplyLineDtos().stream().map(DgPerformOrderAddrApplyLineDto::getOrderId).collect(Collectors.toList());
        List lineIds = this.performOrderAddrApplyLineDas.queryUnCommitRec(orderIds);
        if (CollectionUtils.isNotEmpty((Collection)lineIds)) {
            this.performOrderAddrApplyLineDas.logicDeleteByIds(lineIds);
        }
        Long result = 0L;
        if (!onlyDelete.booleanValue()) {
            DgPerformOrderAddrApplyEo eo = (DgPerformOrderAddrApplyEo)BeanUtil.copyProperties((Object)dto, DgPerformOrderAddrApplyEo.class, (String[])new String[0]);
            this.das.insert((BaseEo)eo);
            for (DgPerformOrderAddrApplyLineDto lineDto : dto.getApplyLineDtos()) {
                lineDto.setApplyId(eo.getId());
                DgPerformOrderAddrApplyLineEo lineEo = (DgPerformOrderAddrApplyLineEo)BeanUtil.copyProperties((Object)lineDto, DgPerformOrderAddrApplyLineEo.class, (String[])new String[0]);
                this.performOrderAddrApplyLineDas.insert((BaseEo)lineEo);
            }
            result = eo.getId();
        }
        return result;
    }

    @Override
    public List<DgPerformOrderAddrApplyEo> queryWaitAuditAddrInfo(List<Long> orderIds) {
        return this.das.queryWaitAuditAddrInfo(orderIds);
    }
}

