/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.domain.entity.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.trade.constants.DgOrderLabelEnum;
import com.yunxi.dg.base.center.trade.dao.das.IOrderLabelItemDas;
import com.yunxi.dg.base.center.trade.dao.das.IOrderLabelRecordDas;
import com.yunxi.dg.base.center.trade.domain.entity.IOrderLabelItemDomain;
import com.yunxi.dg.base.center.trade.dto.entity.OrderLabelItemDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.OrderLabelItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.OrderLabelItemRespDto;
import com.yunxi.dg.base.center.trade.eo.OrderLabelItemEo;
import com.yunxi.dg.base.center.trade.eo.OrderLabelRecordEo;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.db.das.ICommonDas;
import com.yunxi.dg.base.framework.core.domain.BaseDomainImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OrderLabelItemDomainImpl
extends BaseDomainImpl<OrderLabelItemEo>
implements IOrderLabelItemDomain {
    private static final Logger log = LoggerFactory.getLogger(OrderLabelItemDomainImpl.class);
    @Resource
    private IOrderLabelItemDas das;
    @Resource
    private IOrderLabelRecordDas orderLabelRecordDas;

    public ICommonDas<OrderLabelItemEo> commonDas() {
        return this.das;
    }

    @Override
    public List<OrderLabelItemDto> queryByOrderId(Long orderId) {
        AssertUtils.notNull((Object)orderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(BaseEo::getDr, (Object)0)).eq(OrderLabelItemEo::getOrderId, (Object)orderId);
        List saleOrderEos = this.das.getMapper().selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)saleOrderEos)) {
            return null;
        }
        ArrayList resultList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)resultList, (Collection)saleOrderEos, OrderLabelItemDto.class);
        return resultList;
    }

    @Override
    public void addOrderLabelItems(List<OrderLabelItemDto> addReqDtos) {
        if (CollectionUtils.isNotEmpty(addReqDtos)) {
            ArrayList orderLabelItemEos = Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)orderLabelItemEos, addReqDtos, OrderLabelItemEo.class);
            this.das.insertBatch((List)orderLabelItemEos);
        }
    }

    @Override
    public Long addOrderLabelItem(OrderLabelItemDto addReqDto) {
        OrderLabelItemEo orderLabelItemEo = new OrderLabelItemEo();
        CubeBeanUtils.copyProperties((Object)orderLabelItemEo, (Object)addReqDto, (String[])new String[0]);
        this.das.insert((BaseEo)orderLabelItemEo);
        return orderLabelItemEo.getId();
    }

    @Override
    public Long addOrderLabelItem(Long orderId, Long orderItemId, DgOrderLabelEnum addReqDto) {
        AssertUtils.notNull((Object)orderId, (String)"[\u65b0\u589e\u8ba2\u5355\u8bb0\u5f55\u6807\u8bc6]\u8ba2\u5355ID\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)orderItemId, (String)"[\u65b0\u589e\u8ba2\u5355\u8bb0\u5f55\u6807\u8bc6]\u5546\u54c1\u884cID\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)addReqDto, (String)"[\u65b0\u589e\u8ba2\u5355\u8bb0\u5f55\u6807\u8bc6]\u6807\u8bc6\u679a\u4e3e\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        OrderLabelItemEo record = new OrderLabelItemEo();
        record.setOrderId(orderId);
        record.setOrderItemId(orderItemId);
        record.setLabelCode(addReqDto.getCode());
        record.setDisplay(addReqDto.getDisplay());
        OrderLabelItemEo eo = (OrderLabelItemEo)this.das.selectOne((BaseEo)record);
        if (Objects.nonNull(eo)) {
            log.warn(String.format("[\u65b0\u589e\u8ba2\u5355\u8bb0\u5f55\u6807\u8bc6]%s,%s,\u5df2\u5b58\u5728%s\u6807\u8bc6", orderId, orderItemId, addReqDto.getCode()));
            return null;
        }
        OrderLabelItemEo orderLabelItemEo = new OrderLabelItemEo();
        orderLabelItemEo.setLabelCode(addReqDto.getCode());
        orderLabelItemEo.setOrderId(orderId);
        orderLabelItemEo.setOrderItemId(orderItemId);
        orderLabelItemEo.setDisplay(addReqDto.getDisplay());
        this.das.insert((BaseEo)orderLabelItemEo);
        return orderLabelItemEo.getId();
    }

    @Override
    public void removeOrderLabelItemById(Long id) {
        this.das.logicDeleteById(id);
    }

    @Override
    public void removeOrderLabelItemById(Long orderId, Long orderItemId, DgOrderLabelEnum reqDto) {
        AssertUtils.notNull((Object)orderId, (String)"[\u5220\u9664\u8ba2\u5355\u5546\u54c1\u6807\u8bc6]\u8ba2\u5355ID\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)orderItemId, (String)"[\u5220\u9664\u8ba2\u5355\u5546\u54c1\u6807\u8bc6]\u5546\u54c1\u884cID\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)reqDto, (String)"[\u5220\u9664\u8ba2\u5355\u5546\u54c1\u6807\u8bc6]\u6807\u8bc6\u679a\u4e3e\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        OrderLabelItemEo record = new OrderLabelItemEo();
        record.setOrderId(orderId);
        record.setOrderItemId(orderItemId);
        record.setLabelCode(reqDto.getCode());
        record.setDisplay(reqDto.getDisplay());
        OrderLabelItemEo orderLabelItemEo = (OrderLabelItemEo)this.das.selectOne((BaseEo)record);
        if (Objects.isNull(orderLabelItemEo)) {
            log.warn(String.format("[\u5220\u9664\u8ba2\u5355\u8bb0\u5f55\u6807\u8bc6]%s,%s,\u672a\u627e\u5230\u8be5%s\u6807\u8bc6", orderId, orderItemId, reqDto.getCode()));
            return;
        }
        this.das.logicDeleteById(orderLabelItemEo.getId());
    }

    @Override
    public List<OrderLabelItemRespDto> queryByParam(OrderLabelItemReqDto orderLabelItemReqDto) {
        List saleOrderEos;
        AssertUtils.notNull((Object)orderLabelItemReqDto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BaseEo::getDr, (Object)0);
        if (Objects.nonNull(orderLabelItemReqDto.getLabelCode())) {
            queryWrapper.eq(OrderLabelItemEo::getLabelCode, (Object)orderLabelItemReqDto.getLabelCode());
        }
        if (Objects.nonNull(orderLabelItemReqDto.getOrderId())) {
            queryWrapper.eq(OrderLabelItemEo::getOrderId, (Object)orderLabelItemReqDto.getOrderId());
        }
        if (CollectionUtils.isNotEmpty((Collection)orderLabelItemReqDto.getOrderIds())) {
            queryWrapper.in(OrderLabelItemEo::getOrderId, (Collection)orderLabelItemReqDto.getOrderIds());
        }
        if (CollectionUtils.isEmpty((Collection)(saleOrderEos = this.das.getMapper().selectList((Wrapper)queryWrapper)))) {
            return null;
        }
        ArrayList resultList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)resultList, (Collection)saleOrderEos, OrderLabelItemRespDto.class);
        return resultList;
    }

    @Override
    public Long addOrderLabelRecord(Long orderId, DgOrderLabelEnum addReqDto) {
        AssertUtils.notNull((Object)orderId, (String)"[\u65b0\u589e\u8ba2\u5355\u8bb0\u5f55\u6807\u8bc6]\u8ba2\u5355ID\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)addReqDto, (String)"[\u65b0\u589e\u8ba2\u5355\u8bb0\u5f55\u6807\u8bc6]\u6807\u8bc6\u679a\u4e3e\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        OrderLabelRecordEo record = new OrderLabelRecordEo();
        record.setOrderId(orderId);
        record.setLabelCode(addReqDto.getCode());
        record.setDisplay(addReqDto.getDisplay());
        OrderLabelRecordEo eo = (OrderLabelRecordEo)this.orderLabelRecordDas.selectOne((BaseEo)record);
        if (Objects.nonNull(eo)) {
            log.warn(String.format("[\u65b0\u589e\u8ba2\u5355\u8bb0\u5f55\u6807\u8bc6]%s,%s,\u672a\u627e\u5230\u8be5\u6807\u8bc6", orderId, addReqDto.getCode()));
            return null;
        }
        OrderLabelRecordEo orderLabelRecordEo = new OrderLabelRecordEo();
        orderLabelRecordEo.setLabelCode(addReqDto.getCode());
        orderLabelRecordEo.setOrderId(orderId);
        orderLabelRecordEo.setDisplay(addReqDto.getDisplay());
        this.orderLabelRecordDas.insert((BaseEo)orderLabelRecordEo);
        return orderLabelRecordEo.getId();
    }
}

