/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.domain.entity.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.source.dto.entity.DgSourceOrderResultRespDto;
import com.yunxi.dg.base.center.trade.dao.das.ISourceRecordDas;
import com.yunxi.dg.base.center.trade.domain.entity.ISourceOrderItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.ISourceRecordDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineDto;
import com.yunxi.dg.base.center.trade.dto.entity.SourceOrderItemDto;
import com.yunxi.dg.base.center.trade.dto.entity.SourceRecordDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderItemRespDto;
import com.yunxi.dg.base.center.trade.eo.SourceOrderItemEo;
import com.yunxi.dg.base.center.trade.eo.SourceRecordEo;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.db.das.ICommonDas;
import com.yunxi.dg.base.framework.core.domain.BaseDomainImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class SourceRecordDomainImpl
extends BaseDomainImpl<SourceRecordEo>
implements ISourceRecordDomain {
    @Resource
    private ISourceRecordDas das;
    @Resource
    private ISourceOrderItemDomain sourceOrderItemDomain;

    public ICommonDas<SourceRecordEo> commonDas() {
        return this.das;
    }

    @Override
    public SourceRecordDto querySourceRecordByOrderNo(String orderNo) {
        AssertUtils.notBlank((String)orderNo, (String)"orderNo \u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryRecordWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryRecordWrapper.eq(BaseEo::getDr, (Object)0)).eq(SourceRecordEo::getOrderNo, (Object)orderNo)).orderByDesc(BaseEo::getCreateTime);
        SourceRecordEo sourceRecordEo = (SourceRecordEo)this.das.getMapper().selectOne((Wrapper)queryRecordWrapper);
        SourceRecordDto sourceRecordRespDto = new SourceRecordDto();
        CubeBeanUtils.copyProperties((Object)sourceRecordRespDto, (Object)sourceRecordEo, (String[])new String[0]);
        return sourceRecordRespDto;
    }

    @Override
    public SourceRecordDto querySourceRecordByOrderNo(String orderNo, List<DgPerformOrderItemRespDto> orderItemRespDtos) {
        AssertUtils.notBlank((String)orderNo, (String)"orderNo \u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryRecordWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryRecordWrapper.eq(BaseEo::getDr, (Object)0)).eq(SourceRecordEo::getOrderNo, (Object)orderNo)).orderByDesc(BaseEo::getCreateTime);
        SourceRecordEo sourceRecordEo = (SourceRecordEo)this.das.getMapper().selectOne((Wrapper)queryRecordWrapper);
        SourceRecordDto sourceRecordRespDto = new SourceRecordDto();
        CubeBeanUtils.copyProperties((Object)sourceRecordRespDto, (Object)sourceRecordEo, (String[])new String[0]);
        if (Objects.nonNull(sourceRecordEo)) {
            List<Long> itemIds = orderItemRespDtos.stream().map(DgPerformOrderItemDto::getOriginalOrderItemId).collect(Collectors.toList());
            List<SourceOrderItemDto> sourceOrderItemDtos = this.sourceOrderItemDomain.querySourceItemBySgOrderNo(sourceRecordEo.getSgOrderNo(), itemIds);
            sourceRecordRespDto.setSourceOrderItemDtos(sourceOrderItemDtos);
        }
        return sourceRecordRespDto;
    }

    @Override
    public SourceRecordDto querySourceRecordByOrderNoV2(String orderNo, List<DgPerformOrderLineDto> orderItemLineDtoList) {
        AssertUtils.notBlank((String)orderNo, (String)"orderNo \u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryRecordWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryRecordWrapper.eq(BaseEo::getDr, (Object)0)).eq(SourceRecordEo::getOrderNo, (Object)orderNo)).orderByDesc(BaseEo::getCreateTime);
        SourceRecordEo sourceRecordEo = (SourceRecordEo)this.das.getMapper().selectOne((Wrapper)queryRecordWrapper);
        SourceRecordDto sourceRecordRespDto = new SourceRecordDto();
        CubeBeanUtils.copyProperties((Object)sourceRecordRespDto, (Object)sourceRecordEo, (String[])new String[0]);
        if (Objects.nonNull(sourceRecordEo)) {
            List<Long> itemIds = orderItemLineDtoList.stream().map(BaseDto::getId).collect(Collectors.toList());
            List<SourceOrderItemDto> sourceOrderItemDtos = this.sourceOrderItemDomain.querySourceItemBySgOrderNo(sourceRecordEo.getSgOrderNo(), itemIds);
            sourceRecordRespDto.setSourceOrderItemDtos(sourceOrderItemDtos);
        }
        return sourceRecordRespDto;
    }

    @Override
    public SourceRecordDto querySourceRecordBySgOrderNo(String sgOrderNo) {
        AssertUtils.notBlank((String)sgOrderNo, (String)"sgOrderNo \u5bfb\u6e90\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryRecordWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryRecordWrapper.eq(BaseEo::getDr, (Object)0)).eq(SourceRecordEo::getSgOrderNo, (Object)sgOrderNo);
        SourceRecordEo sourceRecordEo = (SourceRecordEo)this.das.getMapper().selectOne((Wrapper)queryRecordWrapper);
        SourceRecordDto sourceRecordRespDto = new SourceRecordDto();
        CubeBeanUtils.copyProperties((Object)sourceRecordRespDto, (Object)sourceRecordEo, (String[])new String[0]);
        return sourceRecordRespDto;
    }

    @Override
    public void saveSourceRecord(DgSourceOrderResultRespDto sourceOrderResultRespDto) {
        SourceRecordEo sourceRecordEo = new SourceRecordEo();
        sourceRecordEo.setOrderNo(sourceOrderResultRespDto.getLinkOrderNo());
        sourceRecordEo.setSgStatus(sourceOrderResultRespDto.getSgStatus());
        sourceRecordEo.setSgOrderNo(sourceOrderResultRespDto.getSgOrderNo());
        this.das.insert((BaseEo)sourceRecordEo);
        List orderItemResultRespDtoList = sourceOrderResultRespDto.getOrderItemResultRespDtoList();
        if (CollectionUtils.isNotEmpty((Collection)orderItemResultRespDtoList)) {
            ArrayList batchInsertEoList = Lists.newArrayList();
            orderItemResultRespDtoList.forEach(orderItemResultRespDto -> {
                SourceOrderItemEo sourceOrderItemEo = new SourceOrderItemEo();
                sourceOrderItemEo.setSgOrderNo(sourceOrderResultRespDto.getSgOrderNo());
                sourceOrderItemEo.setOrderItemId(orderItemResultRespDto.getLinkOrderItemId());
                sourceOrderItemEo.setBatchNo(orderItemResultRespDto.getBatch());
                sourceOrderItemEo.setSkuCode(orderItemResultRespDto.getLinkItemSkuCode());
                sourceOrderItemEo.setSgItemNum(orderItemResultRespDto.getDeliveryItemNum());
                sourceOrderItemEo.setSgWarehouseCode(orderItemResultRespDto.getDeliveryLogicWarehouseCode());
                batchInsertEoList.add(sourceOrderItemEo);
            });
            this.sourceOrderItemDomain.insertBatch(batchInsertEoList);
        }
    }
}

