/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.domain.entity.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.trade.constants.strategy.CisStrategyFitStatusEnum;
import com.yunxi.dg.base.center.trade.dao.das.IStrategyPoolDas;
import com.yunxi.dg.base.center.trade.domain.entity.IStrategyPoolDomain;
import com.yunxi.dg.base.center.trade.dto.entity.StrategyPoolDto;
import com.yunxi.dg.base.center.trade.eo.StrategyPoolEo;
import com.yunxi.dg.base.center.trade.vo.RemoveStrategyPoolVo;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.db.das.ICommonDas;
import com.yunxi.dg.base.framework.core.domain.BaseDomainImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class StrategyPoolDomainImpl
extends BaseDomainImpl<StrategyPoolEo>
implements IStrategyPoolDomain {
    @Resource
    private IStrategyPoolDas das;

    public ICommonDas<StrategyPoolEo> commonDas() {
        return this.das;
    }

    @Override
    public Long addStrategyPool(StrategyPoolDto addReqDto) {
        StrategyPoolEo strategyPoolEo = new StrategyPoolEo();
        CubeBeanUtils.copyProperties((Object)strategyPoolEo, (Object)addReqDto, (String[])new String[0]);
        this.das.insert((BaseEo)strategyPoolEo);
        return strategyPoolEo.getId();
    }

    @Override
    public void modifyStrategyPool(StrategyPoolDto modifyReqDto) {
        StrategyPoolEo strategyPoolEo = new StrategyPoolEo();
        CubeBeanUtils.copyProperties((Object)strategyPoolEo, (Object)modifyReqDto, (String[])new String[0]);
        this.das.updateSelective((BaseEo)strategyPoolEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeStrategyPool(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.das.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public void removeStrategyPool(List<Long> removePoolList) {
        for (Long id : removePoolList) {
            this.das.logicDeleteById(id);
        }
    }

    @Override
    public StrategyPoolDto queryById(Long id) {
        StrategyPoolEo strategyPoolEo = (StrategyPoolEo)this.das.selectByPrimaryKey(id);
        StrategyPoolDto strategyPoolRespDto = new StrategyPoolDto();
        CubeBeanUtils.copyProperties((Object)strategyPoolRespDto, (Object)strategyPoolEo, (String[])new String[0]);
        return strategyPoolRespDto;
    }

    @Override
    public PageInfo<StrategyPoolDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        StrategyPoolDto strategyPoolReqDto = (StrategyPoolDto)JSON.parseObject((String)filter, StrategyPoolDto.class);
        StrategyPoolEo strategyPoolEo = new StrategyPoolEo();
        CubeBeanUtils.copyProperties((Object)strategyPoolEo, (Object)strategyPoolReqDto, (String[])new String[0]);
        PageInfo eoPageInfo = this.das.selectPage((BaseEo)strategyPoolEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        CubeBeanUtils.copyCollection(dtoList, (Collection)eoPageInfo.getList(), StrategyPoolDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public void removeStrategyPool(StrategyPoolDto strategyPoolReqDto) {
        AssertUtils.notNull((Object)strategyPoolReqDto.getSaleOrderId(), (String)"\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        StrategyPoolEo strategyPoolEo = new StrategyPoolEo();
        strategyPoolEo.setSaleOrderId(strategyPoolReqDto.getSaleOrderId());
        strategyPoolEo.setPoolType(strategyPoolReqDto.getPoolType());
        this.das.logicDelete((BaseEo)strategyPoolEo);
    }

    @Override
    public PageInfo<StrategyPoolDto> queryPayge(Integer pageNum, Integer pageSize, String poolType) {
        StrategyPoolEo strategyPoolEo = new StrategyPoolEo();
        strategyPoolEo.setPoolType(poolType);
        strategyPoolEo.setFitStatus(CisStrategyFitStatusEnum.WAIT_FIT.getCode());
        PageInfo eoPageInfo = this.das.selectPage((BaseEo)strategyPoolEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        CubeBeanUtils.copyCollection(dtoList, (Collection)eoPageInfo.getList(), StrategyPoolDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public void cleanStrategyPool(int beforeDate) {
        RemoveStrategyPoolVo removeStrategyPoolVo = new RemoveStrategyPoolVo();
        removeStrategyPoolVo.setDateBefore(DateUtil.addDays((Date)new Date(), (int)(-beforeDate)));
        this.das.deleteByPhysics(removeStrategyPoolVo);
    }
}

