/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.domain.order.oms;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.yundt.cube.center.trade.api.constant.YesOrNoEnum;
import com.yunxi.dg.base.center.trade.constants.DgOmsOrderLineStatusEnum;
import com.yunxi.dg.base.center.trade.constants.DgPerformOrderBizModelEnum;
import com.yunxi.dg.base.center.trade.constants.amount.DgOmsOrderAmountTypeEnum;
import com.yunxi.dg.base.center.trade.constants.amount.DgOrderAmountCategoryEnum;
import com.yunxi.dg.base.center.trade.constants.amount.DgOrderAmountSourceEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgChannelSupplyPriceConfigDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineAmountDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineAmountDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderCalculatorAmountModeDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderLineBizOptDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineAmountDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.oms.DgOmsOrderItemLineAmoutReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.response.DgPerformOrderLineDetailDto;
import com.yunxi.dg.base.center.trade.enums.SaleOrderItemStatusEnum;
import com.yunxi.dg.base.center.trade.eo.DgChannelSupplyPriceConfigEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemLineEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderLineAmountEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderLineEo;
import com.yunxi.dg.base.commons.dto.BaseDto;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DgOmsOrderLineBizOptDomainImpl
implements IDgOmsOrderLineBizOptDomain {
    private static final Logger log = LoggerFactory.getLogger(DgOmsOrderLineBizOptDomainImpl.class);
    @Resource
    private IDgPerformOrderLineDomain orderLineDomain;
    @Resource
    private IDgPerformOrderItemLineDomain orderItemLineDomain;
    @Resource
    private IDgPerformOrderLineAmountDomain performOrderLineAmountDomain;
    @Resource
    private IDgPerformOrderItemLineAmountDomain performOrderItemLineAmountDomain;
    @Resource
    private IDgOmsOrderCalculatorAmountModeDomain omsOrderAmountCalculatorModeDomain;
    @Resource
    private IDgChannelSupplyPriceConfigDomain dgChannelSupplyPriceConfigDomain;

    @Override
    public void batchSaveOrderLine(List<DgPerformOrderLineDetailDto> performOrderLineDtos, DgPerformOrderRespDto performOrderRespDto) {
        BigDecimal totalItemCount = performOrderLineDtos.stream().map(DgPerformOrderLineDto::getCalcItemNum).reduce(BigDecimal.ZERO, BigDecimal::add);
        log.info("[\u6279\u91cf\u63d2\u5165\u5546\u54c1\u884c]\u9700\u8981\u63d2\u5165\u5546\u54c1\u884c\u7684\u603b\u91cf\u4e3a\uff1a{}", (Object)totalItemCount);
        DgChannelSupplyPriceConfigEo supplyPriceConfigEo = this.dgChannelSupplyPriceConfigDomain.queryEoByChannel(performOrderRespDto.getPerformOrderSnapshotDto().getChannelCode());
        LinkedList orderLineEos = new LinkedList();
        LinkedList amountEos = new LinkedList();
        performOrderLineDtos.forEach(orderLineDetailDto -> {
            DgPerformOrderLineAmountEo platformSupplyAmountEo;
            Long orderLineId = IdGenrator.getDistributedId();
            DgPerformOrderLineEo orderLineEo = new DgPerformOrderLineEo();
            CubeBeanUtils.copyProperties((Object)orderLineEo, (Object)orderLineDetailDto, (String[])new String[0]);
            orderLineEo.setId(orderLineId);
            orderLineEo.setOrderId(performOrderRespDto.getId());
            orderLineEo.setOrderNo(performOrderRespDto.getSaleOrderNo());
            orderLineEo.setMainSkuCode(orderLineDetailDto.getSkuCode());
            orderLineEo.setStatus(orderLineDetailDto.getStatus() == null ? SaleOrderItemStatusEnum.NORMAL.getCode() : orderLineDetailDto.getStatus());
            orderLineEos.add(orderLineEo);
            DgPerformOrderLineAmountEo oriOrderLineAmountEo = new DgPerformOrderLineAmountEo();
            oriOrderLineAmountEo.setOrderId(performOrderRespDto.getId());
            oriOrderLineAmountEo.setOrderLineId(orderLineId);
            oriOrderLineAmountEo.setAmountSource(DgOrderAmountSourceEnum.ORDER_LINE_BASE.getCode());
            if (DgPerformOrderBizModelEnum.INVOICE_ORDER.getCode().equals(performOrderRespDto.getBizModel())) {
                oriOrderLineAmountEo.setAccountCategory(DgOrderAmountCategoryEnum.OMS_B2C.getCode());
            }
            DgPerformOrderLineAmountEo itemAmountEo = new DgPerformOrderLineAmountEo();
            CubeBeanUtils.copyProperties((Object)itemAmountEo, (Object)oriOrderLineAmountEo, (String[])new String[0]);
            itemAmountEo.setAccountType(DgOmsOrderAmountTypeEnum.LINE_SALE_TOTAL.getCode());
            itemAmountEo.setAmount(orderLineDetailDto.getSaleAmount());
            amountEos.add(itemAmountEo);
            DgPerformOrderLineAmountEo payAmountEo = new DgPerformOrderLineAmountEo();
            CubeBeanUtils.copyProperties((Object)payAmountEo, (Object)oriOrderLineAmountEo, (String[])new String[0]);
            payAmountEo.setAccountType(DgOmsOrderAmountTypeEnum.LINE_ORIG_PRICE.getCode());
            payAmountEo.setAmount(orderLineDetailDto.getPayAmount());
            amountEos.add(payAmountEo);
            DgPerformOrderLineAmountEo realPayAmountEo = new DgPerformOrderLineAmountEo();
            CubeBeanUtils.copyProperties((Object)realPayAmountEo, (Object)oriOrderLineAmountEo, (String[])new String[0]);
            realPayAmountEo.setAccountType(DgOmsOrderAmountTypeEnum.LINE_ACTUAL_PRICE.getCode());
            realPayAmountEo.setAmount(orderLineDetailDto.getRealPayAmount());
            amountEos.add(realPayAmountEo);
            DgPerformOrderLineAmountEo discountAmountEo = new DgPerformOrderLineAmountEo();
            CubeBeanUtils.copyProperties((Object)discountAmountEo, (Object)oriOrderLineAmountEo, (String[])new String[0]);
            discountAmountEo.setAccountType(DgOmsOrderAmountTypeEnum.LINE_DISCOUNT_AMOUNT.getCode());
            discountAmountEo.setAmount(orderLineDetailDto.getDiscountAmount());
            amountEos.add(discountAmountEo);
            DgPerformOrderLineAmountEo surplusCanRefundPayAmountEo = new DgPerformOrderLineAmountEo();
            CubeBeanUtils.copyProperties((Object)surplusCanRefundPayAmountEo, (Object)oriOrderLineAmountEo, (String[])new String[0]);
            surplusCanRefundPayAmountEo.setAccountType(DgOmsOrderAmountTypeEnum.LINE_SURPLIUS_CAN_REFUND_PAY_AMOUNT.getCode());
            surplusCanRefundPayAmountEo.setAmount(orderLineDetailDto.getPayAmount());
            amountEos.add(surplusCanRefundPayAmountEo);
            if (StringUtils.isNotBlank((CharSequence)performOrderRespDto.getExchangeOrderNo())) {
                if (orderLineDetailDto.getPlatformSupplyPrice() != null) {
                    platformSupplyAmountEo = new DgPerformOrderLineAmountEo();
                    CubeBeanUtils.copyProperties((Object)platformSupplyAmountEo, (Object)oriOrderLineAmountEo, (String[])new String[0]);
                    platformSupplyAmountEo.setAccountType(DgOmsOrderAmountTypeEnum.LINE_SUPPLY_PRICE.getCode());
                    platformSupplyAmountEo.setAmount(orderLineDetailDto.getPlatformSupplyPrice().multiply(orderLineDetailDto.getItemNum()));
                    amountEos.add(platformSupplyAmountEo);
                }
            } else if (orderLineDetailDto.getPlatformSupplyPrice() != null && supplyPriceConfigEo.getSupplyPriceObtainWay().equals(YesOrNoEnum.NO.getType().toString())) {
                platformSupplyAmountEo = new DgPerformOrderLineAmountEo();
                CubeBeanUtils.copyProperties((Object)platformSupplyAmountEo, (Object)oriOrderLineAmountEo, (String[])new String[0]);
                platformSupplyAmountEo.setAccountType(DgOmsOrderAmountTypeEnum.LINE_SUPPLY_PRICE.getCode());
                platformSupplyAmountEo.setAmount(orderLineDetailDto.getPlatformSupplyPrice().multiply(orderLineDetailDto.getItemNum()));
                amountEos.add(platformSupplyAmountEo);
            }
            BigDecimal averagePayAmount = this.omsOrderAmountCalculatorModeDomain.calculateAverageAmount(orderLineDetailDto.getPayAmount(), orderLineDetailDto.getCalcItemNum(), 2, 4);
            log.info("[\u6279\u91cf\u63d2\u5165\u5546\u54c1\u884c]\u8ba1\u7b97skucode={}\u7684\u660e\u7ec6\u884c\u5747\u644a\u6210\u4ea4\u91d1\u989d\u4e3a\uff1a{}", (Object)orderLineEo.getSkuCode(), (Object)averagePayAmount);
            BigDecimal averageRealPayAmount = this.omsOrderAmountCalculatorModeDomain.calculateAverageAmount(orderLineDetailDto.getRealPayAmount(), orderLineDetailDto.getCalcItemNum(), 2, 4);
            log.info("[\u6279\u91cf\u63d2\u5165\u5546\u54c1\u884c]\u8ba1\u7b97skucode={}\u7684\u660e\u7ec6\u884c\u5747\u644a\u5b9e\u4ed8\u91d1\u989d\u4e3a\uff1a{}", (Object)orderLineEo.getSkuCode(), (Object)averageRealPayAmount);
            BigDecimal averageDiscountAmount = this.omsOrderAmountCalculatorModeDomain.calculateAverageAmount(orderLineDetailDto.getDiscountAmount(), orderLineDetailDto.getCalcItemNum(), 2, 4);
            log.info("[\u6279\u91cf\u63d2\u5165\u5546\u54c1\u884c]\u8ba1\u7b97skucode={}\u7684\u660e\u7ec6\u884c\u5747\u644a\u4f18\u60e0\u91d1\u989d\u4e3a\uff1a{}", (Object)orderLineEo.getSkuCode(), (Object)averageDiscountAmount);
            DgOmsOrderItemLineAmoutReqDto amoutReqDto = new DgOmsOrderItemLineAmoutReqDto();
            CubeBeanUtils.copyProperties((Object)amoutReqDto, (Object)orderLineDetailDto, (String[])new String[0]);
            amoutReqDto.setAveragePayAmount(averagePayAmount);
            amoutReqDto.setAverageRealPayAmount(averageRealPayAmount);
            amoutReqDto.setAverageDiscountAmount(averageDiscountAmount);
            this.orderItemLineDomain.multilineMode(orderLineEo, amoutReqDto, (DgPerformOrderLineDetailDto)orderLineDetailDto);
        });
        this.orderLineDomain.insertBatch(orderLineEos);
        this.performOrderLineAmountDomain.insertBatch(amountEos);
    }

    @Override
    public void batchSaveOrderItemByNum(List<DgPerformOrderLineDetailDto> performOrderLineDtos, DgPerformOrderRespDto performOrderRespDto) {
        String homeInstallation = performOrderRespDto.getHomeInstallation();
        BigDecimal totalItemCount = performOrderLineDtos.stream().map(DgPerformOrderLineDto::getCalcItemNum).reduce(BigDecimal.ZERO, BigDecimal::add);
        DgChannelSupplyPriceConfigEo supplyPriceConfigEo = this.dgChannelSupplyPriceConfigDomain.queryEoByChannel(performOrderRespDto.getPerformOrderSnapshotDto().getChannelCode());
        log.info("[\u6279\u91cf\u63d2\u5165\u5546\u54c1\u884c]\u9700\u8981\u63d2\u5165\u5546\u54c1\u884c\u7684\u603b\u91cf\u4e3a\uff1a{}", (Object)totalItemCount);
        LinkedList orderLineEos = new LinkedList();
        LinkedList amountEos = new LinkedList();
        performOrderLineDtos.forEach(orderLineDetailDto -> {
            DgPerformOrderLineAmountEo platformSupplyAmountEo;
            Long orderLineId = IdGenrator.getDistributedId();
            DgPerformOrderLineEo orderLineEo = new DgPerformOrderLineEo();
            CubeBeanUtils.copyProperties((Object)orderLineEo, (Object)orderLineDetailDto, (String[])new String[0]);
            orderLineEo.setId(orderLineId);
            orderLineEo.setOrderId(performOrderRespDto.getId());
            orderLineEo.setOrderNo(performOrderRespDto.getSaleOrderNo());
            orderLineEo.setMainSkuCode(orderLineDetailDto.getSkuCode());
            orderLineEo.setStatus(orderLineDetailDto.getStatus() == null ? SaleOrderItemStatusEnum.NORMAL.getCode() : orderLineDetailDto.getStatus());
            orderLineEos.add(orderLineEo);
            DgPerformOrderLineAmountEo oriOrderLineAmountEo = new DgPerformOrderLineAmountEo();
            oriOrderLineAmountEo.setOrderId(performOrderRespDto.getId());
            oriOrderLineAmountEo.setOrderLineId(orderLineId);
            oriOrderLineAmountEo.setAmountSource(DgOrderAmountSourceEnum.ORDER_LINE_BASE.getCode());
            if (DgPerformOrderBizModelEnum.INVOICE_ORDER.getCode().equals(performOrderRespDto.getBizModel())) {
                oriOrderLineAmountEo.setAccountCategory(DgOrderAmountCategoryEnum.OMS_B2C.getCode());
            }
            DgPerformOrderLineAmountEo itemAmountEo = new DgPerformOrderLineAmountEo();
            CubeBeanUtils.copyProperties((Object)itemAmountEo, (Object)oriOrderLineAmountEo, (String[])new String[0]);
            itemAmountEo.setAccountType(DgOmsOrderAmountTypeEnum.LINE_SALE_TOTAL.getCode());
            itemAmountEo.setAmount(orderLineDetailDto.getSaleAmount());
            amountEos.add(itemAmountEo);
            DgPerformOrderLineAmountEo payAmountEo = new DgPerformOrderLineAmountEo();
            CubeBeanUtils.copyProperties((Object)payAmountEo, (Object)oriOrderLineAmountEo, (String[])new String[0]);
            payAmountEo.setAccountType(DgOmsOrderAmountTypeEnum.LINE_ORIG_PRICE.getCode());
            payAmountEo.setAmount(orderLineDetailDto.getPayAmount());
            amountEos.add(payAmountEo);
            DgPerformOrderLineAmountEo realPayAmountEo = new DgPerformOrderLineAmountEo();
            CubeBeanUtils.copyProperties((Object)realPayAmountEo, (Object)oriOrderLineAmountEo, (String[])new String[0]);
            realPayAmountEo.setAccountType(DgOmsOrderAmountTypeEnum.LINE_ACTUAL_PRICE.getCode());
            realPayAmountEo.setAmount(orderLineDetailDto.getRealPayAmount());
            amountEos.add(realPayAmountEo);
            DgPerformOrderLineAmountEo discountAmountEo = new DgPerformOrderLineAmountEo();
            CubeBeanUtils.copyProperties((Object)discountAmountEo, (Object)oriOrderLineAmountEo, (String[])new String[0]);
            discountAmountEo.setAccountType(DgOmsOrderAmountTypeEnum.LINE_DISCOUNT_AMOUNT.getCode());
            discountAmountEo.setAmount(orderLineDetailDto.getDiscountAmount());
            amountEos.add(discountAmountEo);
            DgPerformOrderLineAmountEo surplusCanRefundPayAmountEo = new DgPerformOrderLineAmountEo();
            CubeBeanUtils.copyProperties((Object)surplusCanRefundPayAmountEo, (Object)oriOrderLineAmountEo, (String[])new String[0]);
            surplusCanRefundPayAmountEo.setAccountType(DgOmsOrderAmountTypeEnum.LINE_SURPLIUS_CAN_REFUND_PAY_AMOUNT.getCode());
            surplusCanRefundPayAmountEo.setAmount(orderLineDetailDto.getPayAmount());
            amountEos.add(surplusCanRefundPayAmountEo);
            if (StringUtils.isNotBlank((CharSequence)performOrderRespDto.getExchangeOrderNo())) {
                if (orderLineDetailDto.getPlatformSupplyPrice() != null) {
                    platformSupplyAmountEo = new DgPerformOrderLineAmountEo();
                    CubeBeanUtils.copyProperties((Object)platformSupplyAmountEo, (Object)oriOrderLineAmountEo, (String[])new String[0]);
                    platformSupplyAmountEo.setAccountType(DgOmsOrderAmountTypeEnum.LINE_SUPPLY_PRICE.getCode());
                    platformSupplyAmountEo.setAmount(orderLineDetailDto.getPlatformSupplyPrice());
                    amountEos.add(platformSupplyAmountEo);
                }
            } else if (orderLineDetailDto.getPlatformSupplyPrice() != null && supplyPriceConfigEo.getSupplyPriceObtainWay().equals(YesOrNoEnum.NO.getType().toString())) {
                platformSupplyAmountEo = new DgPerformOrderLineAmountEo();
                CubeBeanUtils.copyProperties((Object)platformSupplyAmountEo, (Object)oriOrderLineAmountEo, (String[])new String[0]);
                platformSupplyAmountEo.setAccountType(DgOmsOrderAmountTypeEnum.LINE_SUPPLY_PRICE.getCode());
                platformSupplyAmountEo.setAmount(orderLineDetailDto.getPlatformSupplyPrice().multiply(orderLineDetailDto.getItemNum()));
                amountEos.add(platformSupplyAmountEo);
            }
            BigDecimal averagePayAmount = this.omsOrderAmountCalculatorModeDomain.calculateAverageAmount(orderLineDetailDto.getPayAmount(), orderLineDetailDto.getCalcItemNum(), 2, 4);
            log.info("[\u6279\u91cf\u63d2\u5165\u5546\u54c1\u884c]\u8ba1\u7b97skucode={}\u7684\u660e\u7ec6\u884c\u5747\u644a\u6210\u4ea4\u91d1\u989d\u4e3a\uff1a{}", (Object)orderLineEo.getSkuCode(), (Object)averagePayAmount);
            BigDecimal averageRealPayAmount = this.omsOrderAmountCalculatorModeDomain.calculateAverageAmount(orderLineDetailDto.getRealPayAmount(), orderLineDetailDto.getCalcItemNum(), 2, 4);
            log.info("[\u6279\u91cf\u63d2\u5165\u5546\u54c1\u884c]\u8ba1\u7b97skucode={}\u7684\u660e\u7ec6\u884c\u5747\u644a\u5b9e\u4ed8\u91d1\u989d\u4e3a\uff1a{}", (Object)orderLineEo.getSkuCode(), (Object)averageRealPayAmount);
            BigDecimal averageDiscountAmount = this.omsOrderAmountCalculatorModeDomain.calculateAverageAmount(orderLineDetailDto.getDiscountAmount(), orderLineDetailDto.getCalcItemNum(), 2, 4);
            log.info("[\u6279\u91cf\u63d2\u5165\u5546\u54c1\u884c]\u8ba1\u7b97skucode={}\u7684\u660e\u7ec6\u884c\u5747\u644a\u4f18\u60e0\u91d1\u989d\u4e3a\uff1a{}", (Object)orderLineEo.getSkuCode(), (Object)averageDiscountAmount);
            DgOmsOrderItemLineAmoutReqDto amoutReqDto = new DgOmsOrderItemLineAmoutReqDto();
            CubeBeanUtils.copyProperties((Object)amoutReqDto, (Object)orderLineDetailDto, (String[])new String[0]);
            amoutReqDto.setAveragePayAmount(averagePayAmount);
            amoutReqDto.setAverageRealPayAmount(averageRealPayAmount);
            amoutReqDto.setAverageDiscountAmount(averageDiscountAmount);
            orderLineDetailDto.setHomeInstallation(homeInstallation);
            this.orderItemLineDomain.multilineMode(orderLineEo, amoutReqDto, (DgPerformOrderLineDetailDto)orderLineDetailDto);
        });
        this.orderLineDomain.insertBatch(orderLineEos);
        this.performOrderLineAmountDomain.insertBatch(amountEos);
    }

    @Override
    public void batchSaveOrderItemByLine(List<DgPerformOrderLineDetailDto> dgPerformOrderLineDtos, DgPerformOrderRespDto performOrderRespDto) {
        LinkedList<DgPerformOrderLineEo> orderLineEos = new LinkedList<DgPerformOrderLineEo>();
        String homeInstallation = performOrderRespDto.getHomeInstallation();
        LinkedList<DgPerformOrderLineAmountEo> amountEos = new LinkedList<DgPerformOrderLineAmountEo>();
        dgPerformOrderLineDtos.forEach(orderLineReqDto -> {
            log.info("[\u63d2\u5165\u8ba2\u5355\u884c]\u8ba2\u5355\u884c\u5165\u53c2\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)orderLineReqDto));
            Long orderLineId = null != orderLineReqDto.getId() ? orderLineReqDto.getId() : IdGenrator.getDistributedId();
            DgPerformOrderLineEo orderLineEo = new DgPerformOrderLineEo();
            CubeBeanUtils.copyProperties((Object)orderLineEo, (Object)orderLineReqDto, (String[])new String[0]);
            orderLineEo.setId(orderLineId);
            orderLineEo.setOrderId(performOrderRespDto.getId());
            orderLineEo.setOrderNo(performOrderRespDto.getSaleOrderNo());
            orderLineEo.setPlatformOrderNo(performOrderRespDto.getPlatformOrderNo());
            orderLineEo.setStatus(DgOmsOrderLineStatusEnum.NORMAL.getCode());
            orderLineEo.setItemType(orderLineReqDto.getItemType());
            boolean giftFlag = orderLineReqDto.getGift() == 0;
            orderLineEo.setGiftFlag(orderLineReqDto.getGift());
            if (orderLineReqDto.getGift() == 1) {
                orderLineEo.setGiftType(Integer.valueOf(1));
            }
            orderLineEo.setRate(orderLineReqDto.getTaxRate());
            orderLineEo.setSalePrice(orderLineReqDto.getItemMarketPrice());
            orderLineEos.add(orderLineEo);
            DgPerformOrderLineAmountEo oriOrderLineAmountEo = new DgPerformOrderLineAmountEo();
            oriOrderLineAmountEo.setOrderId(performOrderRespDto.getId());
            oriOrderLineAmountEo.setOrderLineId(orderLineEo.getId());
            oriOrderLineAmountEo.setAmountSource(DgOrderAmountSourceEnum.ORDER_LINE_BASE.getCode());
            if (DgPerformOrderBizModelEnum.INSIDE_SALES_ORDER.getCode().equals(performOrderRespDto.getBizModel())) {
                oriOrderLineAmountEo.setAccountCategory(DgOrderAmountCategoryEnum.OMS_B2B.getCode());
            }
            DgPerformOrderLineAmountEo itemAmountEo = new DgPerformOrderLineAmountEo();
            CubeBeanUtils.copyProperties((Object)itemAmountEo, (Object)oriOrderLineAmountEo, (String[])new String[0]);
            itemAmountEo.setAccountType(DgOmsOrderAmountTypeEnum.LINE_SALE_TOTAL.getCode());
            itemAmountEo.setAmount(giftFlag ? orderLineReqDto.getSaleAmount().setScale(2, 4) : orderLineReqDto.getDiscountAmount().setScale(2, 4));
            amountEos.add(itemAmountEo);
            DgPerformOrderLineAmountEo payAmountEo = new DgPerformOrderLineAmountEo();
            CubeBeanUtils.copyProperties((Object)payAmountEo, (Object)oriOrderLineAmountEo, (String[])new String[0]);
            payAmountEo.setAccountType(DgOmsOrderAmountTypeEnum.LINE_ORIG_PRICE.getCode());
            payAmountEo.setAmount(orderLineReqDto.getPayAmount().setScale(2, 4));
            amountEos.add(payAmountEo);
            DgPerformOrderLineAmountEo realPayAmountEo = new DgPerformOrderLineAmountEo();
            CubeBeanUtils.copyProperties((Object)realPayAmountEo, (Object)oriOrderLineAmountEo, (String[])new String[0]);
            realPayAmountEo.setAccountType(DgOmsOrderAmountTypeEnum.LINE_ACTUAL_PRICE.getCode());
            realPayAmountEo.setAmount(giftFlag ? orderLineReqDto.getRealPayAmount().setScale(2, 4) : BigDecimal.ZERO);
            amountEos.add(realPayAmountEo);
            DgPerformOrderLineAmountEo discountAmountEo = new DgPerformOrderLineAmountEo();
            CubeBeanUtils.copyProperties((Object)discountAmountEo, (Object)oriOrderLineAmountEo, (String[])new String[0]);
            discountAmountEo.setAccountType(DgOmsOrderAmountTypeEnum.LINE_DISCOUNT_AMOUNT.getCode());
            if (null != orderLineReqDto.getDiscountAmount()) {
                discountAmountEo.setAmount(orderLineReqDto.getDiscountAmount().setScale(2, RoundingMode.HALF_UP));
            } else {
                discountAmountEo.setAmount(BigDecimal.ZERO);
            }
            amountEos.add(discountAmountEo);
            DgPerformOrderLineAmountEo settlementAmountEo = new DgPerformOrderLineAmountEo();
            CubeBeanUtils.copyProperties((Object)settlementAmountEo, (Object)oriOrderLineAmountEo, (String[])new String[0]);
            settlementAmountEo.setAccountType(DgOmsOrderAmountTypeEnum.LINE_SETTLEMENT_AMOUNT.getCode());
            settlementAmountEo.setAmount(giftFlag ? orderLineReqDto.getRealPayAmount().setScale(2, RoundingMode.HALF_UP) : BigDecimal.ZERO);
            amountEos.add(settlementAmountEo);
            DgPerformOrderLineAmountEo handmadeDiscountAmountEo = new DgPerformOrderLineAmountEo();
            CubeBeanUtils.copyProperties((Object)handmadeDiscountAmountEo, (Object)oriOrderLineAmountEo, (String[])new String[0]);
            handmadeDiscountAmountEo.setAccountType(DgOmsOrderAmountTypeEnum.LINE_HANDMADE_DISCOUNT_AMOUNT.getCode());
            if (null != orderLineReqDto.getHandmadeDiscountAmount()) {
                handmadeDiscountAmountEo.setAmount(giftFlag ? orderLineReqDto.getHandmadeDiscountAmount().setScale(2, RoundingMode.HALF_UP) : BigDecimal.ZERO);
            } else {
                handmadeDiscountAmountEo.setAmount(BigDecimal.ZERO);
            }
            amountEos.add(handmadeDiscountAmountEo);
            DgPerformOrderLineAmountEo surplusCanRefundPayAmountEo = new DgPerformOrderLineAmountEo();
            CubeBeanUtils.copyProperties((Object)surplusCanRefundPayAmountEo, (Object)oriOrderLineAmountEo, (String[])new String[0]);
            surplusCanRefundPayAmountEo.setAccountType(DgOmsOrderAmountTypeEnum.LINE_SURPLIUS_CAN_REFUND_PAY_AMOUNT.getCode());
            surplusCanRefundPayAmountEo.setAmount(giftFlag ? orderLineReqDto.getRealPayAmount().setScale(2, 4) : BigDecimal.ZERO);
            amountEos.add(surplusCanRefundPayAmountEo);
        });
        this.orderLineDomain.insertBatch(orderLineEos);
        List insertAmountEos = amountEos.stream().map(eo -> {
            if (eo.getAmount() == null) {
                eo.setAmount(BigDecimal.ZERO);
            }
            return eo;
        }).collect(Collectors.toList());
        this.performOrderLineAmountDomain.insertBatch(insertAmountEos);
        this.orderItemLineDomain.singleMode(orderLineEos, amountEos);
    }

    @Override
    public void saveOrderLineAmountInfo(List<DgPerformOrderLineAmountDto> orderLineAmountDtoList, DgPerformOrderRespDto respDto) {
        LinkedList amountEos = new LinkedList();
        CubeBeanUtils.copyCollection(amountEos, orderLineAmountDtoList, DgPerformOrderLineAmountEo.class);
        this.performOrderLineAmountDomain.insertBatch(amountEos);
        List<Long> orderLineIdList = respDto.getOrderLineList().stream().map(BaseDto::getId).collect(Collectors.toList());
        List<DgPerformOrderItemLineEo> orderItemLineEoList = this.orderItemLineDomain.queryItemLineByOrderLineIds(orderLineIdList);
        Map<Long, List<DgPerformOrderItemLineEo>> orderItemLineMap = orderItemLineEoList.stream().collect(Collectors.groupingBy(DgPerformOrderItemLineEo::getOrderLineId));
        orderLineAmountDtoList.forEach(orderLineAmount -> {
            List orderItemLineEos = (List)orderItemLineMap.get(orderLineAmount.getOrderLineId());
            BigDecimal averageAmount = this.omsOrderAmountCalculatorModeDomain.calculateAverageAmount(orderLineAmount.getAmount(), new BigDecimal(orderItemLineEos.size()), 2, 4);
            log.info("[\u6279\u91cf\u63d2\u5165\u5546\u54c1\u91d1\u989d\u884c]\u8ba2\u5355\u884cid ={}\u7684\u660e\u7ec6\u884c\u5747\u644a\u8d26\u6237\uff1a{} ===>>\u91d1\u989d\uff1a{}", new Object[]{orderLineAmount.getOrderLineId(), orderLineAmount.getAccountType(), averageAmount});
            if (orderLineAmount.getAccountCategory().equals(DgOrderAmountSourceEnum.ORDER_LINE_AMOUNT.getCode())) {
                this.performOrderItemLineAmountDomain.batchSaveOrderItemLineAmount(DgOrderAmountSourceEnum.ORDER_ITEM_AMOUNT.getCode(), orderLineAmount.getAccountType(), orderItemLineEos, averageAmount);
            } else {
                String accountType = orderLineAmount.getAccountType();
                if (orderLineAmount.getAccountType().equals(DgOmsOrderAmountTypeEnum.LINE_SUPPLY_PRICE.getCode())) {
                    accountType = DgOmsOrderAmountTypeEnum.ITEM_SUPPLY_PRICE.getCode();
                }
                this.performOrderItemLineAmountDomain.batchSaveOrderItemLineAmount(DgOrderAmountSourceEnum.ORDER_ITEM_BASE.getCode(), accountType, orderItemLineEos, averageAmount);
            }
        });
    }
}

