/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.api.utils;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionUtil {
    private static final String SETTER_PREFIX = "set";
    private static final String GETTER_PREFIX = "get";
    private static final String CGLIB_CLASS_SEPARATOR = "$$";
    private static Logger logger = LoggerFactory.getLogger(ReflectionUtil.class);
    private static Map<String, List<Field>> filedMap = new HashMap<String, List<Field>>();
    private static Map<String, Map<String, Method>> methodMap = new HashMap<String, Map<String, Method>>();
    private static Object lock = new Object();

    public static Object invokeGetter(Object obj, String propertyName) {
        String getterMethodName = GETTER_PREFIX + StringUtils.capitalize((String)propertyName);
        return ReflectionUtil.invokeMethod(obj, getterMethodName, new Class[0], new Object[0]);
    }

    public static <T> T invokeGetterAndConvert(Object obj, String propertyName, Class<T> clazz) {
        String getterMethodName = GETTER_PREFIX + StringUtils.capitalize((String)propertyName);
        Object objVal = ReflectionUtil.invokeMethod(obj, getterMethodName, new Class[0], new Object[0]);
        return (T)objVal;
    }

    public static void invokeSetter(Object obj, String propertyName, Object value) {
        String setterMethodName = SETTER_PREFIX + StringUtils.capitalize((String)propertyName);
        ReflectionUtil.invokeMethodByName(obj, setterMethodName, new Object[]{value});
    }

    public static boolean isExistGetter(Object obj, String propertyName) {
        String getterMethodName = GETTER_PREFIX + StringUtils.capitalize((String)propertyName);
        return ReflectionUtil.isExistMethod(obj, getterMethodName);
    }

    public static boolean isExistSetter(Object obj, String propertyName) {
        String setterMethodName = SETTER_PREFIX + StringUtils.capitalize((String)propertyName);
        return ReflectionUtil.isExistMethod(obj, setterMethodName);
    }

    public static boolean isExistMethod(Object obj, String methodName) {
        Map<String, Method> map = methodMap.get(obj.getClass().getName());
        if (map != null && map.get(methodName) != null) {
            return true;
        }
        map = new HashMap<String, Method>();
        methodMap.put(obj.getClass().getName(), map);
        for (Class<?> searchType = obj.getClass(); searchType != Object.class; searchType = searchType.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = searchType.getDeclaredMethods()) {
                map.put(method.getName(), method);
                if (!method.getName().equals(methodName)) continue;
                return true;
            }
        }
        return false;
    }

    public static Object invokeMethod(Object obj, String methodName, Class<?>[] parameterTypes, Object[] args) {
        Method method = ReflectionUtil.getAccessibleMethod(obj, methodName, parameterTypes);
        if (method == null) {
            throw new IllegalArgumentException("\u5728 [" + obj + "]\u7c7b\u91cc\u9762\u627e\u4e0d\u5230\u65b9\u6cd5 [" + methodName + "]");
        }
        try {
            return method.invoke(obj, args);
        }
        catch (Exception e) {
            throw ReflectionUtil.convertReflectionExceptionToUnchecked(e);
        }
    }

    public static Object invokeMethodByName(Object obj, String methodName, Object[] args) {
        Method method = ReflectionUtil.getAccessibleMethodByName(obj, methodName);
        if (method == null) {
            throw new IllegalArgumentException("\u5728 [" + obj + "]\u7c7b\u91cc\u9762\u627e\u4e0d\u5230\u65b9\u6cd5 [" + methodName + "]");
        }
        try {
            return method.invoke(obj, args);
        }
        catch (Exception e) {
            throw ReflectionUtil.convertReflectionExceptionToUnchecked(e);
        }
    }

    public static Field getAccessibleField(Object obj, String fieldName) {
        Validate.notNull((Object)obj, (String)"\u7528\u4e8e\u53cd\u5c04\u7684\u5bf9\u8c61\u4e0d\u80fd\u4e3aNULL", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)fieldName, (String)"\u53cd\u5c04\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        for (Class<?> superClass = obj.getClass(); superClass != Object.class; superClass = superClass.getSuperclass()) {
            try {
                Field field = superClass.getDeclaredField(fieldName);
                ReflectionUtil.makeAccessible(field);
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        return null;
    }

    public static Field getDeclaredField(Object obj, String fieldName) {
        Validate.notNull((Object)obj, (String)"\u7528\u4e8e\u53cd\u5c04\u7684\u5bf9\u8c61\u4e0d\u80fd\u4e3aNULL", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)fieldName, (String)"\u53cd\u5c04\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        for (Class<?> superClass = obj.getClass(); superClass != Object.class; superClass = superClass.getSuperclass()) {
            try {
                Field field = superClass.getDeclaredField(fieldName);
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        return null;
    }

    public static List<Field> getDeclaredFields(Object obj) {
        Validate.notNull((Object)obj, (String)"\u7528\u4e8e\u53cd\u5c04\u7684\u5bf9\u8c61\u4e0d\u80fd\u4e3aNULL", (Object[])new Object[0]);
        return ReflectionUtil.getDeclaredFields(obj.getClass());
    }

    public static List<Field> getDeclaredFields(Class<?> clazz) {
        ArrayList<Field> list = new ArrayList<Field>();
        for (Class<?> superClass = clazz; superClass != Object.class; superClass = superClass.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = superClass.getDeclaredFields()) {
                list.add(field);
            }
        }
        return list;
    }

    public static List<Field> getDeclaredFieldsUseCache(Object obj) {
        return ReflectionUtil.getDeclaredFieldsUseCache(obj.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Field> getDeclaredFieldsUseCache(Class<?> clazz) {
        String key = ReflectionUtil.getFiledMapKey(clazz);
        List<Field> fields = filedMap.get(key);
        if (fields == null) {
            Object object = lock;
            synchronized (object) {
                fields = filedMap.get(key);
                if (fields == null) {
                    ReflectionUtil.initFileds(clazz);
                    fields = filedMap.get(key);
                }
            }
        }
        return fields;
    }

    private static void initFileds(Class<?> clazz) {
        List<Field> fields = ReflectionUtil.getDeclaredFields(clazz);
        filedMap.put(ReflectionUtil.getFiledMapKey(clazz), fields);
    }

    private static String getFiledMapKey(Class<?> clazz) {
        return clazz.getName();
    }

    public static Method getAccessibleMethod(Object obj, String methodName, Class<?> ... parameterTypes) {
        Validate.notNull((Object)obj, (String)"\u7528\u4e8e\u53cd\u5c04\u7684\u5bf9\u8c61\u4e0d\u80fd\u4e3aNULL", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)methodName, (String)"\u53cd\u5c04\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        for (Class<?> searchType = obj.getClass(); searchType != Object.class; searchType = searchType.getSuperclass()) {
            try {
                Method method = searchType.getDeclaredMethod(methodName, parameterTypes);
                ReflectionUtil.makeAccessible(method);
                return method;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
        }
        return null;
    }

    public static Method getAccessibleMethodByName(Object obj, String methodName) {
        Validate.notNull((Object)obj, (String)"\u7528\u4e8e\u53cd\u5c04\u7684\u5bf9\u8c61\u4e0d\u80fd\u4e3aNULL", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)methodName, (String)"\u53cd\u5c04\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        for (Class<?> searchType = obj.getClass(); searchType != Object.class; searchType = searchType.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = searchType.getDeclaredMethods()) {
                if (!method.getName().equals(methodName)) continue;
                ReflectionUtil.makeAccessible(method);
                return method;
            }
        }
        return null;
    }

    public static void makeAccessible(Method method) {
        if (!(Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getDeclaringClass().getModifiers()) || method.isAccessible())) {
            method.setAccessible(true);
        }
    }

    public static void makeAccessible(Field field) {
        if (!(Modifier.isPublic(field.getModifiers()) && Modifier.isPublic(field.getDeclaringClass().getModifiers()) && !Modifier.isFinal(field.getModifiers()) || field.isAccessible())) {
            field.setAccessible(true);
        }
    }

    public static <T> Class<T> getClassGenricType(Class clazz) {
        return ReflectionUtil.getClassGenricType(clazz, 0);
    }

    public static Class getClassGenricType(Class clazz, int index) {
        Type genType = clazz.getGenericSuperclass();
        if (!(genType instanceof ParameterizedType)) {
            logger.warn(clazz.getSimpleName() + "\u7684\u8d85\u7c7b\u6ca1\u6709\u6cdb\u578b\u53c2\u6570\uff08ParameterizedType\uff09");
            return Object.class;
        }
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        if (index >= params.length || index < 0) {
            logger.warn("Index: " + index + ", Size of " + clazz.getSimpleName() + "'s ParameterizedType: " + params.length);
            return Object.class;
        }
        if (!(params[index] instanceof Class)) {
            logger.warn(clazz.getSimpleName() + "\u6ca1\u6709\u5b9e\u9645\u7684\u7c7b\u7684\u7236\u7c7b\u7684\u6cdb\u578b\u53c2\u6570");
            return Object.class;
        }
        return (Class)params[index];
    }

    public static RuntimeException convertReflectionExceptionToUnchecked(Exception e) {
        if (e instanceof IllegalAccessException || e instanceof IllegalArgumentException || e instanceof NoSuchMethodException) {
            return new IllegalArgumentException(e);
        }
        if (e instanceof InvocationTargetException) {
            return new RuntimeException(((InvocationTargetException)e).getTargetException());
        }
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new RuntimeException("Unexpected Checked Exception.", e);
    }
}

