/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.constants;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.yunxi.dg.base.center.trade.constants.SaleOrderStatusFlowTemplate;
import com.yunxi.dg.base.center.trade.constants.statusflows.BdInnerTradeStatusFlow;
import com.yunxi.dg.base.center.trade.constants.statusflows.BdThirdpartyTradeStatusFlow;
import com.yunxi.dg.base.center.trade.constants.statusflows.DgB2BTradeStatusFlow;
import com.yunxi.dg.base.center.trade.constants.statusflows.DgB2CTradeStatusFlow;
import com.yunxi.dg.base.center.trade.constants.statusflows.DgF2BAfterTradeTsthStatusFlow;
import com.yunxi.dg.base.center.trade.constants.statusflows.DgF2BChangeDeliveryTradeStatusFlow;
import com.yunxi.dg.base.center.trade.constants.statusflows.DgF2BIntactTradeStatusFlow;
import com.yunxi.dg.base.center.trade.constants.statusflows.DgF2BPopularizeTradeStatusFlow;
import com.yunxi.dg.base.center.trade.constants.statusflows.DgF2BTradeStatusFlow;
import com.yunxi.dg.base.center.trade.constants.statusflows.DgTocIntactTradeStatusFlow;
import com.yunxi.dg.base.center.trade.constants.statusflows.TcTradeStatusFlow;
import com.yunxi.dg.base.center.trade.constants.statusflows.VirtualOrderTradeStatusFlow;
import com.yunxi.dg.base.center.trade.exception.PcpTradeExceptionCode;
import java.util.List;
import java.util.Map;

public enum TradeStatusFlowSelector {
    TC("TC"){

        @Override
        public Map<String, SaleOrderStatusFlowTemplate> getLookup() {
            return TcTradeStatusFlow.CODE_LOOKUP;
        }

        @Override
        public List<SaleOrderStatusFlowTemplate> getSaleOrderStatusList() {
            return TcTradeStatusFlow.STATUS_LIST;
        }
    }
    ,
    BD("BD"){

        @Override
        public Map<String, SaleOrderStatusFlowTemplate> getLookup() {
            return BdThirdpartyTradeStatusFlow.CODE_LOOKUP;
        }

        @Override
        public List<SaleOrderStatusFlowTemplate> getSaleOrderStatusList() {
            return BdThirdpartyTradeStatusFlow.STATUS_LIST;
        }
    }
    ,
    INNER("INNER"){

        @Override
        public Map<String, SaleOrderStatusFlowTemplate> getLookup() {
            return BdInnerTradeStatusFlow.CODE_LOOKUP;
        }

        @Override
        public List<SaleOrderStatusFlowTemplate> getSaleOrderStatusList() {
            return BdInnerTradeStatusFlow.STATUS_LIST;
        }
    }
    ,
    VIRTUAL("VIRTUAL"){

        @Override
        public Map<String, SaleOrderStatusFlowTemplate> getLookup() {
            return VirtualOrderTradeStatusFlow.CODE_LOOKUP;
        }

        @Override
        public List<SaleOrderStatusFlowTemplate> getSaleOrderStatusList() {
            return VirtualOrderTradeStatusFlow.STATUS_LIST;
        }
    }
    ,
    B2C("B2C"){

        @Override
        public Map<String, SaleOrderStatusFlowTemplate> getLookup() {
            return DgB2CTradeStatusFlow.CODE_LOOKUP;
        }

        @Override
        public List<SaleOrderStatusFlowTemplate> getSaleOrderStatusList() {
            return DgB2CTradeStatusFlow.STATUS_LIST;
        }
    }
    ,
    B2B("B2B"){

        @Override
        public Map<String, SaleOrderStatusFlowTemplate> getLookup() {
            return DgB2BTradeStatusFlow.CODE_LOOKUP;
        }

        @Override
        public List<SaleOrderStatusFlowTemplate> getSaleOrderStatusList() {
            return DgB2BTradeStatusFlow.STATUS_LIST;
        }
    }
    ,
    F2B("F2B"){

        @Override
        public Map<String, SaleOrderStatusFlowTemplate> getLookup() {
            return DgF2BTradeStatusFlow.CODE_LOOKUP;
        }

        @Override
        public List<SaleOrderStatusFlowTemplate> getSaleOrderStatusList() {
            return DgF2BTradeStatusFlow.STATUS_LIST;
        }
    }
    ,
    F2B_AFTER("F2B_AFTER"){

        @Override
        public Map<String, SaleOrderStatusFlowTemplate> getLookup() {
            return DgF2BAfterTradeTsthStatusFlow.CODE_LOOKUP;
        }

        @Override
        public List<SaleOrderStatusFlowTemplate> getSaleOrderStatusList() {
            return DgF2BAfterTradeTsthStatusFlow.STATUS_LIST;
        }
    }
    ,
    F2B_CHANGE_DELIVERY("F2B_CHANGE_DELIVERY"){

        @Override
        public Map<String, SaleOrderStatusFlowTemplate> getLookup() {
            return DgF2BChangeDeliveryTradeStatusFlow.CODE_LOOKUP;
        }

        @Override
        public List<SaleOrderStatusFlowTemplate> getSaleOrderStatusList() {
            return DgF2BChangeDeliveryTradeStatusFlow.STATUS_LIST;
        }
    }
    ,
    F2B_INTACT("F2B_INTACT"){

        @Override
        public Map<String, SaleOrderStatusFlowTemplate> getLookup() {
            return DgF2BIntactTradeStatusFlow.CODE_LOOKUP;
        }

        @Override
        public List<SaleOrderStatusFlowTemplate> getSaleOrderStatusList() {
            return DgF2BIntactTradeStatusFlow.STATUS_LIST;
        }
    }
    ,
    F2B_POPULARIZE("F2B_POPULARIZE"){

        @Override
        public Map<String, SaleOrderStatusFlowTemplate> getLookup() {
            return DgF2BPopularizeTradeStatusFlow.CODE_LOOKUP;
        }

        @Override
        public List<SaleOrderStatusFlowTemplate> getSaleOrderStatusList() {
            return DgF2BPopularizeTradeStatusFlow.STATUS_LIST;
        }
    }
    ,
    TOC_INTACT_RECEIVE("TOC_INTACT_RECEIVE"){

        @Override
        public Map<String, SaleOrderStatusFlowTemplate> getLookup() {
            return DgF2BIntactTradeStatusFlow.CODE_LOOKUP;
        }

        @Override
        public List<SaleOrderStatusFlowTemplate> getSaleOrderStatusList() {
            return DgTocIntactTradeStatusFlow.STATUS_LIST;
        }
    };

    private String code;

    private TradeStatusFlowSelector(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public static TradeStatusFlowSelector enumOf(String code) {
        for (TradeStatusFlowSelector typeEnum : TradeStatusFlowSelector.values()) {
            if (!typeEnum.getCode().equals(code)) continue;
            return typeEnum;
        }
        throw new BizException(PcpTradeExceptionCode.TYPE_NOT_EXIT.getCode(), String.format("(%s)%s", code, PcpTradeExceptionCode.TYPE_NOT_EXIT.getMsg()));
    }

    public abstract Map<String, SaleOrderStatusFlowTemplate> getLookup();

    public abstract List<SaleOrderStatusFlowTemplate> getSaleOrderStatusList();
}

