/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.ext.order.split;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderExtInfoDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderSplitReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.TradeItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.ext.order.split.ISplitServiceExtension;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="splitOrderByShopService")
public class SplitOrderByShopServiceExtImpl
implements ISplitServiceExtension {
    @Override
    public void splitOrder(OrderSplitReqDto orderSplitReqDto) {
        OrderReqDto order = orderSplitReqDto.getParentOrderReqDto();
        ArrayList<OrderReqDto> childrenOrderList = new ArrayList<OrderReqDto>();
        List<TradeItemReqDto> orderItems = order.getOrderItems();
        Map<String, List<TradeItemReqDto>> tradeItemReqDtoMap = orderItems.stream().collect(Collectors.groupingBy(TradeItemReqDto::getShopId));
        Set<String> shopIdSet = tradeItemReqDtoMap.keySet();
        if (shopIdSet.size() == 1) {
            return;
        }
        for (String shopId : shopIdSet) {
            OrderReqDto orderReqDto = new OrderReqDto();
            BeanUtils.copyProperties((Object)((Object)order), (Object)((Object)orderReqDto));
            orderReqDto.setParentOrderNo(order.getTradeNo());
            List<TradeItemReqDto> tradeItemReqDtos = tradeItemReqDtoMap.get(shopId);
            BigDecimal payAmount = new BigDecimal(0.0);
            BigDecimal totalAmount = new BigDecimal(0.0);
            Integer itemNum = 0;
            BigDecimal pointAmount = BigDecimal.ZERO;
            Integer points = 0;
            for (TradeItemReqDto tradeItemReqDto : tradeItemReqDtos) {
                itemNum = itemNum + tradeItemReqDto.getItemNum();
                if (!order.isUsePointDeduct()) continue;
                if (tradeItemReqDto.getCashOutAmount() != null) {
                    pointAmount = pointAmount.add(tradeItemReqDto.getCashOutAmount());
                }
                if (tradeItemReqDto.getCashOutPoint() == null) continue;
                points = points + tradeItemReqDto.getCashOutPoint();
            }
            String sellerId = tradeItemReqDtos.get(0).getSellerId();
            String shopType = tradeItemReqDtos.get(0).getShopType();
            orderReqDto.setPayAmount(payAmount);
            orderReqDto.setTotalAmount(totalAmount);
            orderReqDto.setTotalItemNum(itemNum);
            orderReqDto.setShopId(shopId);
            orderReqDto.setSellerId(sellerId);
            orderReqDto.setShopType(shopType);
            orderReqDto.setOrderItems(tradeItemReqDtos);
            if (order.isUsePointDeduct()) {
                orderReqDto.setTotalCashOutPoint(points);
                orderReqDto.setTotalCashOutAmount(pointAmount);
            } else {
                orderReqDto.setTotalCashOutPoint(0);
                orderReqDto.setTotalCashOutAmount(BigDecimal.ZERO);
            }
            if (CollectionUtils.isNotEmpty(orderReqDto.getExtInfos())) {
                for (OrderExtInfoDto extInfoDto : orderReqDto.getExtInfos()) {
                    if (!shopId.equals(extInfoDto.getShopId())) continue;
                    orderReqDto.setBuyerRemark(extInfoDto.getBuyerRemark());
                    JSONObject extenJson = null;
                    extenJson = StringUtils.isEmpty((Object)orderReqDto.getExtension()) ? new JSONObject() : JSONObject.parseObject((String)orderReqDto.getExtension());
                    extenJson.put("invoice", (Object)Long.valueOf(extInfoDto.getInvoice()));
                    orderReqDto.setExtension(extenJson.toJSONString());
                }
            }
            childrenOrderList.add(orderReqDto);
        }
        orderSplitReqDto.setChildrenOrderList(childrenOrderList);
    }

    @Override
    public Boolean isSplitOrder(OrderReqDto order) {
        List<TradeItemReqDto> orderItems = order.getOrderItems();
        return this.isSplitOrder(orderItems);
    }

    public Boolean isSplitOrder(List<TradeItemReqDto> orderItems) {
        Map<String, List<TradeItemReqDto>> tradeItemReqDtoMap = orderItems.stream().collect(Collectors.groupingBy(TradeItemReqDto::getShopId));
        if (tradeItemReqDtoMap.size() == 1) {
            return false;
        }
        return true;
    }
}

