/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.constants.strategy;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum DgStrategyInterceptEnum {
    PERSON_AUDIT("person_audit", "\u4eba\u5de5\u5ba1\u6838"),
    AUDIT_NO_PASS("audit_no_pass", "\u5ba1\u6838\u4e0d\u901a\u8fc7"),
    AUDIT_PASS("audit_pass", "\u5ba1\u6838\u901a\u8fc7");

    private final String code;
    private final String desc;
    public static final Map<String, DgStrategyInterceptEnum> CODE_LOOKUP;
    public static final Map<String, String> CODE_DESC_MAP;

    private DgStrategyInterceptEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static DgStrategyInterceptEnum forCode(String code) {
        return CODE_LOOKUP.get(code);
    }

    public Map<String, String> getCodeAndDesc() {
        return CODE_DESC_MAP;
    }

    public String getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        CODE_LOOKUP = Arrays.stream(DgStrategyInterceptEnum.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum));
        CODE_DESC_MAP = Arrays.stream(DgStrategyInterceptEnum.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum.desc));
    }
}

