/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.constants.strategy;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum DgPlatFormEnum {
    PLATFORM_2B("2b", "2b\u5e73\u53f0"),
    PLATFORM_2C("2c", "2b\u5e73\u53f0"),
    PLATFORM_F2B("f2b", "f2b\u5e73\u53f0");

    private String code;
    private String desc;
    public static final Map<String, DgPlatFormEnum> CODE_LOOKUP;
    public static final Map<String, String> CODE_DESC_MAP;

    private DgPlatFormEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static DgPlatFormEnum forCode(String code) {
        return CODE_LOOKUP.get(code);
    }

    public Map<String, String> getCodeAndDesc() {
        return CODE_DESC_MAP;
    }

    public String getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        CODE_LOOKUP = Arrays.stream(DgPlatFormEnum.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum));
        CODE_DESC_MAP = Arrays.stream(DgPlatFormEnum.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum.desc));
    }
}

