/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.dto.entity;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.trade.dto.entity.NationalSupplementAreaRuleAreaDto;
import com.yunxi.dg.base.center.trade.dto.entity.NationalSupplementAreaRuleDtoExtension;
import com.yunxi.dg.base.center.trade.dto.entity.NationalSupplementAreaRulePlatformCompanyDto;
import com.yunxi.dg.base.commons.dto.CanExtensionDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@ApiModel(value="NationalSupplementAreaRuleDto", description="\u56fd\u8865\u533a\u57df\u89c4\u5219\u4f20\u8f93\u5bf9\u8c61")
public class NationalSupplementAreaRuleDto
extends CanExtensionDto<NationalSupplementAreaRuleDtoExtension> {
    @ApiModelProperty(name="code", value="\u89c4\u5219\u7f16\u7801")
    private String code;
    @ApiModelProperty(name="name", value="\u89c4\u5219\u540d\u79f0")
    private String name;
    @ApiModelProperty(name="saleCompanyCode", value="\u9500\u552e\u4e3b\u4f53\u7f16\u7801")
    private String saleCompanyCode;
    @ApiModelProperty(name="saleCompanyName", value="\u9500\u552e\u4e3b\u4f53\u540d\u79f0")
    private String saleCompanyName;
    @ApiModelProperty(name="status", value="\u72b6\u6001: enable-\u542f\u7528\uff0cdisable-\u7981\u7528")
    private String status;
    @ApiModelProperty(name="startTime", value="\u89c4\u5219\u6709\u6548\u671f-\u5f00\u59cb\u65f6\u95f4")
    private Date startTime;
    @ApiModelProperty(name="endTime", value="\u89c4\u5219\u6709\u6548\u671f-\u7ed3\u675f\u65f6\u95f4")
    private Date endTime;
    @ApiModelProperty(name="timeRangeDesc", value="\u6709\u6548\u671f\u63cf\u8ff0")
    private String timeRangeDesc;
    @ApiModelProperty(name="platformCompanyCount", value="\u5173\u8054\u5e73\u53f0\u4e3b\u4f53\u6570\u91cf")
    private Integer platformCompanyCount;
    @ApiModelProperty(name="areaLimit", value="\u533a\u57df\u9650\u5236\uff1a1-\u65e0\u9650\u5236\uff0c2-\u9650\u5236\u6307\u5b9a\u533a\u57df")
    private Integer areaLimit;
    @ApiModelProperty(name="remark", value="\u89c4\u5219\u5907\u6ce8")
    private String remark;
    @ApiModelProperty(value="\u9002\u7528\u533a\u57df\u63cf\u8ff0\uff0c\u4f9b\u524d\u7aef\u663e\u793a\u7528")
    private String areaDesc;
    @ApiModelProperty(value="\u9009\u4e2d\u7684\u533a\u57df\u7f16\u7801\u5217\u8868")
    private List<List<String>> areaPathCodes;
    @ApiModelProperty(value="\u5e73\u53f0\u9500\u552e\u4e3b\u4f53\u5217\u8868")
    private List<NationalSupplementAreaRulePlatformCompanyDto> platformCompanies;
    @ApiModelProperty(name="areaList", value="\u6307\u5b9a\u7684\u533a\u57df\u5217\u8868")
    private List<NationalSupplementAreaRuleAreaDto> areaList;

    public void processBeforeReq() {
        this.platformCompanies = Optional.ofNullable(this.platformCompanies).orElse(Collections.emptyList());
        this.areaList = Optional.ofNullable(this.areaList).orElse(Collections.emptyList());
        this.platformCompanyCount = this.platformCompanies.size();
        if (this.startTime != null) {
            this.startTime = DateUtil.beginOfDay((Date)this.startTime);
        }
        if (this.endTime != null) {
            String endTimeStr = new SimpleDateFormat("yyyy-MM-dd").format(this.endTime) + " 23:59:59";
            this.endTime = DateUtil.parse((CharSequence)endTimeStr, (DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        }
        if (Objects.equals(this.areaLimit, 1)) {
            this.areaPathCodes = Collections.emptyList();
        }
        this.areaList = Optional.ofNullable(this.areaPathCodes).orElse(Collections.emptyList()).stream().map(k -> {
            String code = (String)k.get(k.size() - 1);
            NationalSupplementAreaRuleAreaDto area = new NationalSupplementAreaRuleAreaDto();
            area.setTargetCode(code);
            return area;
        }).collect(Collectors.toList());
    }

    public void processBeforeReturn() {
        if (Objects.equals(this.areaLimit, 1)) {
            this.areaDesc = "\u65e0\u9650\u5236";
        } else if (this.areaList != null && !this.areaList.isEmpty()) {
            this.areaDesc = this.areaList.stream().map(k -> Lists.newArrayList((Object[])new String[]{k.getProvinceName(), k.getCityName(), k.getAreaName()}).stream().filter(CharSequenceUtil::isNotBlank).collect(Collectors.joining("/"))).collect(Collectors.joining("\u3001"));
            this.areaPathCodes = this.areaList.stream().map(k -> Lists.newArrayList((Object[])new String[]{k.getProvinceCode(), k.getCityCode(), k.getAreaCode()}).stream().filter(CharSequenceUtil::isNotBlank).collect(Collectors.toList())).collect(Collectors.toList());
        }
        if (this.startTime != null && this.endTime != null) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            this.timeRangeDesc = format.format(this.startTime) + "~" + format.format(this.endTime);
        }
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSaleCompanyCode(String saleCompanyCode) {
        this.saleCompanyCode = saleCompanyCode;
    }

    public void setSaleCompanyName(String saleCompanyName) {
        this.saleCompanyName = saleCompanyName;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public void setTimeRangeDesc(String timeRangeDesc) {
        this.timeRangeDesc = timeRangeDesc;
    }

    public void setPlatformCompanyCount(Integer platformCompanyCount) {
        this.platformCompanyCount = platformCompanyCount;
    }

    public void setAreaLimit(Integer areaLimit) {
        this.areaLimit = areaLimit;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public void setAreaDesc(String areaDesc) {
        this.areaDesc = areaDesc;
    }

    public void setAreaPathCodes(List<List<String>> areaPathCodes) {
        this.areaPathCodes = areaPathCodes;
    }

    public void setPlatformCompanies(List<NationalSupplementAreaRulePlatformCompanyDto> platformCompanies) {
        this.platformCompanies = platformCompanies;
    }

    public void setAreaList(List<NationalSupplementAreaRuleAreaDto> areaList) {
        this.areaList = areaList;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public String getSaleCompanyCode() {
        return this.saleCompanyCode;
    }

    public String getSaleCompanyName() {
        return this.saleCompanyName;
    }

    public String getStatus() {
        return this.status;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public String getTimeRangeDesc() {
        return this.timeRangeDesc;
    }

    public Integer getPlatformCompanyCount() {
        return this.platformCompanyCount;
    }

    public Integer getAreaLimit() {
        return this.areaLimit;
    }

    public String getRemark() {
        return this.remark;
    }

    public String getAreaDesc() {
        return this.areaDesc;
    }

    public List<List<String>> getAreaPathCodes() {
        return this.areaPathCodes;
    }

    public List<NationalSupplementAreaRulePlatformCompanyDto> getPlatformCompanies() {
        return this.platformCompanies;
    }

    public List<NationalSupplementAreaRuleAreaDto> getAreaList() {
        return this.areaList;
    }

    public NationalSupplementAreaRuleDto() {
    }

    public NationalSupplementAreaRuleDto(String code, String name, String saleCompanyCode, String saleCompanyName, String status, Date startTime, Date endTime, String timeRangeDesc, Integer platformCompanyCount, Integer areaLimit, String remark, String areaDesc, List<List<String>> areaPathCodes, List<NationalSupplementAreaRulePlatformCompanyDto> platformCompanies, List<NationalSupplementAreaRuleAreaDto> areaList) {
        this.code = code;
        this.name = name;
        this.saleCompanyCode = saleCompanyCode;
        this.saleCompanyName = saleCompanyName;
        this.status = status;
        this.startTime = startTime;
        this.endTime = endTime;
        this.timeRangeDesc = timeRangeDesc;
        this.platformCompanyCount = platformCompanyCount;
        this.areaLimit = areaLimit;
        this.remark = remark;
        this.areaDesc = areaDesc;
        this.areaPathCodes = areaPathCodes;
        this.platformCompanies = platformCompanies;
        this.areaList = areaList;
    }
}

