/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.rest.statemachine;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.constants.tob.AuditTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.PayMethodReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.OrderModTobReqDto;
import com.dtyunxi.yundt.cube.center.trade.ext.api.dto.request.OrderAuditReqDto;
import com.yunxi.dg.base.center.trade.api.statemachine.IChannelOrderStatemachineApi;
import com.yunxi.dg.base.center.trade.constants.DgPerformOrderBizModelEnum;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformNoticeSyncRecordDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.ResultOrderOptReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.DgOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.order.DgOrderResultRespDto;
import com.yunxi.dg.base.center.trade.dto.pay.DgPerformOrderPayReqDto;
import com.yunxi.dg.base.center.trade.service.entity.IDgTrolleyItemService;
import com.yunxi.dg.base.center.trade.service.oms.channel.IDgF2BOrderService;
import com.yunxi.dg.base.center.trade.statemachine.handler.IChannelOrderStatemachineHandle;
import com.yunxi.dg.base.center.trade.statemachine.handler.IDgF2BOrderStatemachineHandle;
import com.yunxi.dg.base.commons.annotations.OptLogEntryMethod;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/dg/channel/order"})
public class ChannelOrderStatemachineApiRest
implements IChannelOrderStatemachineApi {
    @Resource
    private IChannelOrderStatemachineHandle channelOrderStatemachineHandle;
    @Resource
    private IDgF2BOrderStatemachineHandle dgF2BOrderStatemachineHandle;
    @Resource
    private IDgF2BOrderService dgF2BOrderService;
    @Resource
    private IDgTrolleyItemService dgTrolleyItemService;

    public RestResponse<DgOrderResultRespDto> save(DgOrderReqDto order) {
        return this.channelOrderStatemachineHandle.save(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), order);
    }

    public RestResponse<Void> edit(DgOrderReqDto order) {
        return this.channelOrderStatemachineHandle.edit(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), order);
    }

    public RestResponse<DgOrderResultRespDto> submit(DgOrderReqDto order) {
        return null;
    }

    @OptLogEntryMethod
    public RestResponse<Long> addOrder(@RequestBody OrderReqDto addReqDto) {
        return this.dgF2BOrderStatemachineHandle.createOrder(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), addReqDto);
    }

    public RestResponse<DgOrderResultRespDto> submitOrder(@Validated @RequestBody DgOrderReqDto dgOrderReqDto) {
        return null;
    }

    public RestResponse<DgOrderResultRespDto> saveOrder(DgOrderReqDto dgOrderReqDto) {
        return null;
    }

    @OptLogEntryMethod(linkCodeSpel="#shopOrderReqDtoList[0].id", linkCodeType="PERFORM_ORDER")
    public RestResponse<DgOrderResultRespDto> checkOrder(@Valid @RequestBody DgOrderReqDto dgOrderReqDto) {
        return this.dgF2BOrderStatemachineHandle.checkOrder(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), dgOrderReqDto);
    }

    @OptLogEntryMethod(linkCodeSpel="#shopOrderReqDtoList[0].id", linkCodeType="PERFORM_ORDER")
    public RestResponse<DgOrderResultRespDto> modifyOrder(@Valid @RequestBody DgOrderReqDto dgOrderReqDto) {
        return this.dgF2BOrderStatemachineHandle.modifyOrder(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), dgOrderReqDto);
    }

    @OptLogEntryMethod(linkCodeSpel="#orderModTobReq.id", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> modifyOrderInfo(@RequestBody OrderModTobReqDto orderModTobReq) {
        return this.dgF2BOrderStatemachineHandle.modifyOrderInfo(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), orderModTobReq);
    }

    @OptLogEntryMethod(linkCodeSpel="#orderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> logicDeleteOrder(@PathVariable(value="id") Long orderId) {
        return this.dgF2BOrderStatemachineHandle.logicDeleteOrder(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), orderId);
    }

    @OptLogEntryMethod(linkCodeSpel="#payMethodReqDto.orderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<String> orderPay(@RequestBody PayMethodReqDto payMethodReqDto) {
        return this.dgF2BOrderStatemachineHandle.modifyPayMethod(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), payMethodReqDto);
    }

    @OptLogEntryMethod(linkCodeSpel="#id", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> cancelByOrder(@RequestParam(name="id") Long id, @RequestParam(name="reason") String reason) {
        return this.dgF2BOrderStatemachineHandle.cancelByOrder(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), id, reason);
    }

    @OptLogEntryMethod(linkCodeSpel="#id", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> closeOrder(Long id, String reason) {
        return this.dgF2BOrderStatemachineHandle.closeOrder(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), id, reason);
    }

    public RestResponse<Void> auditOrder(@RequestBody OrderAuditReqDto orderAuditReqDto) {
        if (StringUtils.isEmpty((CharSequence)orderAuditReqDto.getAuditType()) || AuditTypeEnum.CS_AUDIT.getType().equals(orderAuditReqDto.getAuditType())) {
            return this.dgF2BOrderStatemachineHandle.csAuditOrder(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), orderAuditReqDto);
        }
        if (AuditTypeEnum.FINANCE_AUDIT.getType().equals(orderAuditReqDto.getAuditType())) {
            return this.dgF2BOrderStatemachineHandle.financeAuditOrder(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), orderAuditReqDto);
        }
        if (AuditTypeEnum.ORDER_REFUND_AUDIT.getType().equals(orderAuditReqDto.getAuditType())) {
            return this.dgF2BOrderStatemachineHandle.orderRefundAudit(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), orderAuditReqDto);
        }
        if (AuditTypeEnum.ORDER_CS_REFUND_AUDIT.getType().equals(orderAuditReqDto.getAuditType())) {
            return this.dgF2BOrderStatemachineHandle.orderCsRefundAudit(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), orderAuditReqDto);
        }
        throw new BizException("\u5ba1\u6838\u914d\u7f6e\u5f02\u5e38");
    }

    @OptLogEntryMethod(linkCodeSpel="#id", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> delivery(@PathVariable(value="id") Long id) {
        return this.dgF2BOrderStatemachineHandle.delivery(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), id);
    }

    @OptLogEntryMethod(linkCodeSpel="#id", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> confirmOrder(@PathVariable(value="id") Long id) {
        return this.dgF2BOrderStatemachineHandle.confirmOrder(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), id);
    }

    @OptLogEntryMethod(linkCodeSpel="#dgPerformOrderPayReqDto.orderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> pay(@RequestBody DgPerformOrderPayReqDto dgPerformOrderPayReqDto) {
        return this.dgF2BOrderStatemachineHandle.pay(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), dgPerformOrderPayReqDto);
    }

    @OptLogEntryMethod(linkCodeSpel="#dgBizPerformNoticeSyncRecordDto.businessId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> externalOrderDelivery(@Validated @RequestBody DgBizPerformNoticeSyncRecordDto dgBizPerformNoticeSyncRecordDto) {
        return this.dgF2BOrderStatemachineHandle.externalOrderDelivery(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), dgBizPerformNoticeSyncRecordDto);
    }

    public RestResponse<Void> cancelExternalDelivery(@RequestBody @Valid ResultOrderOptReqDto reqDto) {
        return this.dgF2BOrderStatemachineHandle.cancelExternalDelivery(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), reqDto.getBusinessId(), reqDto);
    }

    @OptLogEntryMethod(linkCodeSpel="#id", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> partCancelOrder(Long id, String reason) {
        return this.dgF2BOrderStatemachineHandle.partCancelOrder(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), id, reason);
    }
}

