/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.rest.statemachine;

import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.center.trade.api.statemachine.IDgB2CSaleStatemachineApi;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgArrangeShipmentEnterpriseReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgArrangeWarehouseReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformOrderUpdateDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgChangeDeliveryModelReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgConfirmReceiveOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgModifyOrderItemForDifferenceReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgModifyOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgOrderTagRecordReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgOutDeliveryResultReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderAddrReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderRemarkReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgRemoveGiftBySkuReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgSplitOrderBySkuReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgSplitOrderReqDto;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.center.trade.statemachine.handler.IDgB2CSaleStatemachineHandle;
import com.yunxi.dg.base.commons.annotations.OptLogEntryMethod;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/statemachine/b2c/saleOrder/"})
public class DgB2CSaleStatemachineApiRest
implements IDgB2CSaleStatemachineApi {
    @Resource
    private IDgB2CSaleStatemachineHandle dgB2CSaleStatemachineHandle;
    @Resource
    private IDgPerformOrderInfoDomain dgPerformOrderInfoDomain;

    @OptLogEntryMethod
    public RestResponse<Long> createSaleOrder(String bizModel, DgBizPerformOrderReqDto addReqDto) {
        return this.dgB2CSaleStatemachineHandle.createSaleOrder(bizModel, addReqDto);
    }

    @OptLogEntryMethod(linkCodeSpel="#saleOrderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> resetToCsSaleOrder(String bizModel, Long saleOrderId, String desc) {
        return this.dgB2CSaleStatemachineHandle.resetToCsSaleOrder(bizModel, saleOrderId, desc);
    }

    @OptLogEntryMethod(linkCodeSpel="#saleOrderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> revocationAudit(String bizModel, Long saleOrderId, String desc) {
        return this.dgB2CSaleStatemachineHandle.revocationAudit(bizModel, saleOrderId, desc);
    }

    public RestResponse<Void> updateSaleOrderInfoByPlatformOrderNo(String bizModel, String platformOrderNo, DgBizPerformOrderUpdateDto reqDto) {
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)platformOrderNo), (String)"\u53c2\u6570\u5e73\u53f0\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        List dgPerformOrderInfoEos = this.dgPerformOrderInfoDomain.queryEoByPlatformOrderNo(platformOrderNo);
        for (DgPerformOrderInfoEo dgPerformOrderInfoEo : dgPerformOrderInfoEos) {
            this.dgB2CSaleStatemachineHandle.updateSaleOrderInfo(bizModel, dgPerformOrderInfoEo.getId(), reqDto);
        }
        return RestResponse.VOID;
    }

    @OptLogEntryMethod(linkCodeSpel="#saleOrderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> updateSaleOrderInfo(String bizModel, Long saleOrderId, DgBizPerformOrderUpdateDto reqDto) {
        return this.dgB2CSaleStatemachineHandle.updateSaleOrderInfo(bizModel, saleOrderId, reqDto);
    }

    @OptLogEntryMethod(linkCodeSpel="#saleOrderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> splitOrderBySourceLack(String bizModel, Long saleOrderId, String reqDto) {
        return this.dgB2CSaleStatemachineHandle.splitOrderBySourceLack(bizModel, saleOrderId, reqDto);
    }

    @OptLogEntryMethod(linkCodeSpel="#saleOrderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> arrangeShipmentEnterprise(String bizModel, Long saleOrderId, DgArrangeShipmentEnterpriseReqDto reqDto) {
        return this.dgB2CSaleStatemachineHandle.arrangeShipmentEnterprise(bizModel, saleOrderId, reqDto);
    }

    @OptLogEntryMethod(linkCodeSpel="#saleOrderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> modifiedHomeInstallation(String bizModel, Long saleOrderId, DgBizPerformOrderReqDto reqDto) {
        return this.dgB2CSaleStatemachineHandle.modifiedHomeInstallation(bizModel, saleOrderId, reqDto);
    }

    public RestResponse<Void> installationPush(String bizModel, Long saleOrderId, DgBizPerformOrderReqDto reqDto) {
        return this.dgB2CSaleStatemachineHandle.installationPush(bizModel, saleOrderId, reqDto);
    }

    @OptLogEntryMethod(linkCodeSpel="#saleOrderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> arrangeWarehouse(String bizModel, Long saleOrderId, DgArrangeWarehouseReqDto reqDto) {
        return this.dgB2CSaleStatemachineHandle.arrangeWarehouse(bizModel, saleOrderId, reqDto);
    }

    @OptLogEntryMethod(linkCodeSpel="#saleOrderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> addOrderTagRecord(String bizModel, Long saleOrderId, List<DgOrderTagRecordReqDto> addrReqDtos) {
        return this.dgB2CSaleStatemachineHandle.addOrderTagRecord(bizModel, saleOrderId, addrReqDtos);
    }

    @OptLogEntryMethod(linkCodeSpel="#saleOrderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> removeOrderTagRecord(String bizModel, Long saleOrderId, List<DgOrderTagRecordReqDto> removeReqDtos) {
        return this.dgB2CSaleStatemachineHandle.removeOrderTagRecord(bizModel, saleOrderId, removeReqDtos);
    }

    @OptLogEntryMethod(linkCodeSpel="#saleOrderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> splitOrderByAppointSku(String bizModel, Long saleOrderId, DgSplitOrderBySkuReqDto reqDto) {
        return this.dgB2CSaleStatemachineHandle.splitOrderByAppointSku(bizModel, saleOrderId, reqDto);
    }

    @OptLogEntryMethod(linkCodeSpel="#saleOrderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> splitOrder(String bizModel, Long saleOrderId, DgSplitOrderReqDto splitOrderReqDto) {
        return this.dgB2CSaleStatemachineHandle.splitOrder(bizModel, saleOrderId, splitOrderReqDto);
    }

    @OptLogEntryMethod(linkCodeSpel="#saleOrderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> manualPick(String bizModel, Long saleOrderId, String desc) {
        return this.dgB2CSaleStatemachineHandle.manualPick(bizModel, saleOrderId, desc);
    }

    @OptLogEntryMethod(linkCodeSpel="#saleOrderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> manualSendWarehouse(String bizModel, Long saleOrderId, String desc) {
        return this.dgB2CSaleStatemachineHandle.manualSendWarehouse(bizModel, saleOrderId, desc);
    }

    @OptLogEntryMethod(linkCodeSpel="#saleOrderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Boolean> statusLock(String bizModel, Long saleOrderId, String desc) {
        return this.dgB2CSaleStatemachineHandle.statusLock(bizModel, saleOrderId, desc);
    }

    @OptLogEntryMethod(linkCodeSpel="#saleOrderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> statusUnLock(String bizModel, Long saleOrderId, String desc) {
        return this.dgB2CSaleStatemachineHandle.statusUnLock(bizModel, saleOrderId, desc);
    }

    @OptLogEntryMethod(linkCodeSpel="#saleOrderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> cancelOrder(String bizModel, Long saleOrderId, String cancelReason) {
        return this.dgB2CSaleStatemachineHandle.cancelOrder(bizModel, saleOrderId, cancelReason);
    }

    @OptLogEntryMethod(linkCodeSpel="#saleOrderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> abolishOrder(String bizModel, Long saleOrderId) {
        return this.dgB2CSaleStatemachineHandle.abolishOrder(bizModel, saleOrderId, "");
    }

    @OptLogEntryMethod(linkCodeSpel="#saleOrderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> cancelOrderRecovery(String bizModel, Long saleOrderId) {
        return this.dgB2CSaleStatemachineHandle.cancelOrderRecovery(bizModel, saleOrderId);
    }

    @OptLogEntryMethod(linkCodeSpel="#saleOrderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> csAuditSaleOrder(String bizModel, Long saleOrderId, String desc) {
        return this.dgB2CSaleStatemachineHandle.csAuditSaleOrder(bizModel, saleOrderId, desc);
    }

    @OptLogEntryMethod(linkCodeSpel="#saleOrderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> autoCsAuditSaleOrder(String bizModel, Long strategyOrderId, Long saleOrderId, String desc) {
        return this.dgB2CSaleStatemachineHandle.autoCsAuditSaleOrder(bizModel, strategyOrderId, saleOrderId, desc);
    }

    @OptLogEntryMethod(linkCodeSpel="#saleOrderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> bsAuditSaleOrder(String bizModel, Long saleOrderId, String desc) {
        return this.dgB2CSaleStatemachineHandle.bsAuditSaleOrder(bizModel, saleOrderId, desc);
    }

    @OptLogEntryMethod(linkCodeSpel="#saleOrderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> autoBsAuditSaleOrder(String bizModel, Long strategyOrderId, Long saleOrderId, String desc) {
        return this.dgB2CSaleStatemachineHandle.autoBsAuditSaleOrder(bizModel, strategyOrderId, saleOrderId, desc);
    }

    @OptLogEntryMethod(linkCodeSpel="#saleOrderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> confirmReceiveGoods(String bizModel, Long saleOrderId, DgConfirmReceiveOrderReqDto reqDto) {
        return this.dgB2CSaleStatemachineHandle.confirmReceiveGoods(bizModel, saleOrderId, reqDto);
    }

    @OptLogEntryMethod(linkCodeSpel="#saleOrderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> platformDelivery(String bizModel, Long saleOrderId) {
        return this.dgB2CSaleStatemachineHandle.platformDelivery(bizModel, saleOrderId);
    }

    @OptLogEntryMethod(linkCodeSpel="#saleOrderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> manualAddSaleOrderItems(String bizModel, Long saleOrderId, DgBizPerformOrderReqDto reqDto) {
        return this.dgB2CSaleStatemachineHandle.manualAddSaleOrderItems(bizModel, saleOrderId, reqDto);
    }

    @OptLogEntryMethod(linkCodeSpel="#saleOrderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> manualModifyOrderItemBySkucode(String bizModel, Long saleOrderId, DgModifyOrderItemReqDto reqDto) {
        return this.dgB2CSaleStatemachineHandle.manualModifyOrderItemBySkucode(bizModel, saleOrderId, reqDto);
    }

    @OptLogEntryMethod(linkCodeSpel="#saleOrderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> manualModifyOrderItem(String bizModel, Long saleOrderId, DgModifyOrderItemReqDto reqDto) {
        return this.dgB2CSaleStatemachineHandle.manualModifyOrderItem(bizModel, saleOrderId, reqDto);
    }

    @OptLogEntryMethod(linkCodeSpel="#saleOrderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> modifyAddress(String bizModel, Long saleOrderId, DgPerformOrderAddrReqDto addrReqDto) {
        return this.dgB2CSaleStatemachineHandle.modifyAddress(bizModel, saleOrderId, addrReqDto);
    }

    @OptLogEntryMethod(linkCodeSpel="#platformOrderNo", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> modifyAddress(String bizModel, String platformOrderNo, DgPerformOrderAddrReqDto addrReqDto) {
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)platformOrderNo), (String)"\u53c2\u6570\u5e73\u53f0\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        List dgPerformOrderInfoEos = this.dgPerformOrderInfoDomain.queryEoByPlatformOrderNo(platformOrderNo);
        dgPerformOrderInfoEos.forEach(eo -> this.dgB2CSaleStatemachineHandle.modifyAddress(bizModel, eo.getId(), addrReqDto));
        return RestResponse.VOID;
    }

    @OptLogEntryMethod(linkCodeSpel="#saleOrderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> manualRemoveSaleOrderItem(String bizModel, Long saleOrderId, Long orderItemId) {
        return this.dgB2CSaleStatemachineHandle.manualRemoveSaleOrderItem(bizModel, saleOrderId, orderItemId);
    }

    @OptLogEntryMethod(linkCodeSpel="#saleOrderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> manualRemoveSaleOrderItemBySku(String bizModel, Long saleOrderId, DgRemoveGiftBySkuReqDto reqDto) {
        return this.dgB2CSaleStatemachineHandle.manualRemoveSaleOrderItemBySku(bizModel, saleOrderId, reqDto);
    }

    @OptLogEntryMethod(linkCodeSpel="#saleOrderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> manualModifyOrderItemForDifference(String bizModel, Long saleOrderId, DgModifyOrderItemForDifferenceReqDto reqDto) {
        return this.dgB2CSaleStatemachineHandle.manualModifyOrderItemForDifference(bizModel, saleOrderId, reqDto);
    }

    @OptLogEntryMethod(linkCodeSpel="#saleOrderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> modifyDeliveryDate(String bizModel, Long saleOrderId, String newDate) {
        return this.dgB2CSaleStatemachineHandle.modifyDeliveryDate(bizModel, saleOrderId, newDate);
    }

    @OptLogEntryMethod(linkCodeSpel="#saleOrderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> modifyPlanDeliveryDate(String bizModel, Long saleOrderId, String newDate) {
        return this.dgB2CSaleStatemachineHandle.modifyPlanDeliveryDate(bizModel, saleOrderId, newDate);
    }

    @OptLogEntryMethod(linkCodeSpel="#saleOrderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> appendOrderRemark(String bizModel, Long saleOrderId, DgPerformOrderRemarkReqDto performOrderRemarkReqDto) {
        return this.dgB2CSaleStatemachineHandle.appendOrderRemark(bizModel, saleOrderId, performOrderRemarkReqDto.getRemark());
    }

    @OptLogEntryMethod(linkCodeSpel="#saleOrderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> modifyOrderRemark(String bizModel, Long saleOrderId, DgPerformOrderRemarkReqDto performOrderRemarkReqDto) {
        return this.dgB2CSaleStatemachineHandle.modifyOrderRemark(bizModel, saleOrderId, performOrderRemarkReqDto.getRemark());
    }

    @OptLogEntryMethod(linkCodeSpel="#saleOrderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> outDeliveryResult(String bizModel, Long saleOrderId, DgOutDeliveryResultReqDto resultReqDto) {
        return this.dgB2CSaleStatemachineHandle.outDeliveryResult(bizModel, saleOrderId, resultReqDto);
    }

    @OptLogEntryMethod(linkCodeSpel="#saleOrderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> cancelSaleOrderSplit(String bizModel, Long saleOrderId, String desc) {
        return this.dgB2CSaleStatemachineHandle.cancelSaleOrderSplit(bizModel, saleOrderId, desc);
    }

    @OptLogEntryMethod(linkCodeSpel="#saleOrderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> changeDeliveryModel(String bizModel, Long saleOrderId, DgChangeDeliveryModelReqDto reqDto) {
        return this.dgB2CSaleStatemachineHandle.changeDeliveryModel(bizModel, saleOrderId, reqDto);
    }

    public RestResponse<Void> retryExecuteEvent(Long eventRecordId) throws Exception {
        return this.dgB2CSaleStatemachineHandle.retryExecuteEvent(eventRecordId);
    }
}

