/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.rest.f2b;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderRemarkReqDto;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.account.constants.AccountCategoryEnum;
import com.yunxi.dg.base.center.account.dto.entity.AccountDto;
import com.yunxi.dg.base.center.trade.action.oms.common.IOrderCommonHandleAction;
import com.yunxi.dg.base.center.trade.api.order.f2b.IDgF2BOrderApi;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.DgOrderRemittanceStatisticsReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.preview.CustomPackageOrderPreviewReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.preview.DgOrderPreviewReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgF2bOrderDetailRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgF2bOrderPayInfoRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgOrderStatusRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderBatchOptRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgRequireRemitAmountRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.CustomAllotInventoryRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.OrderFulfillmentRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.preview.CustomPackageOrderPreviewRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.preview.DgPreviewRespDto;
import com.yunxi.dg.base.center.trade.dto.response.ChannelOrderDetailRespDto;
import com.yunxi.dg.base.center.trade.dto.response.CustomPackageOrderDetailRespDto;
import com.yunxi.dg.base.center.trade.service.oms.channel.IChannelAccountService;
import com.yunxi.dg.base.center.trade.service.oms.channel.IChannelOrderService;
import com.yunxi.dg.base.center.trade.service.oms.channel.IDgF2BOrderService;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/dg/f2b/order"})
public class IDgF2BOrderApiRest
implements IDgF2BOrderApi {
    @Resource
    private IDgF2BOrderService dgF2BOrderService;
    @Resource
    private IChannelOrderService channelOrderService;
    @Resource
    private IOrderCommonHandleAction orderCommonHandleAction;
    @Resource
    private IChannelAccountService channelAccountService;

    public RestResponse<String> generateF2BNo(@RequestParam(value="prefix") String prefix, @RequestParam(value="footLength") Integer footLength) {
        return new RestResponse((Object)this.dgF2BOrderService.generateF2BNo(prefix, footLength));
    }

    public RestResponse<DgPreviewRespDto> previewOrder(@Valid @RequestBody DgOrderPreviewReqDto previewReqDto) {
        return new RestResponse((Object)this.dgF2BOrderService.previewOrder(previewReqDto));
    }

    public RestResponse<CustomPackageOrderPreviewRespDto> customPackagePreviewOrder(@Valid @RequestBody CustomPackageOrderPreviewReqDto previewReqDto) {
        return new RestResponse((Object)this.dgF2BOrderService.customPackagePreviewOrder(previewReqDto));
    }

    @Deprecated
    public RestResponse<DgF2bOrderDetailRespDto> f2bOrderDetailByOrderNo(@RequestParam(value="orderNo") String orderNo) {
        return null;
    }

    public RestResponse<ChannelOrderDetailRespDto> orderDetailByOrderNo(@RequestParam(value="orderNo") String orderNo) {
        return new RestResponse((Object)this.channelOrderService.orderDetailByOrderNo(orderNo));
    }

    public RestResponse<CustomPackageOrderDetailRespDto> customPackageOrderDetailByOrderNo(String orderNo) {
        return new RestResponse((Object)this.channelOrderService.customPackageOrderDetailByOrderNo(orderNo));
    }

    public RestResponse<List<AccountDto>> queryCapitalAccount(@RequestParam(value="orderNo") String orderNo) {
        return new RestResponse((Object)this.channelAccountService.queryCapitalAccount(orderNo, (List)Lists.newArrayList((Object[])new AccountCategoryEnum[]{AccountCategoryEnum.CAPITAL})));
    }

    public RestResponse<List<DgF2bOrderDetailRespDto>> f2bOrderSimpleDetailByOrderNos(List<String> orderNos) {
        return new RestResponse((Object)this.dgF2BOrderService.f2bOrderSimpleDetailByOrderNos(orderNos));
    }

    public RestResponse<DgF2bOrderPayInfoRespDto> getOrderPayTimeById(@RequestParam(value="orderId") Long orderId) {
        return new RestResponse((Object)this.dgF2BOrderService.getOrderPayTimeById(orderId));
    }

    public RestResponse<List<DgOrderStatusRespDto>> queryOrderStatusSteps(List<String> orderNos) {
        return new RestResponse((Object)this.dgF2BOrderService.queryOrderStatusSteps(orderNos));
    }

    public RestResponse<DgRequireRemitAmountRespDto> getRequireRemitAmount(@RequestBody DgOrderRemittanceStatisticsReqDto dgOrderRemittanceStatisticsReqDto) {
        return new RestResponse((Object)this.dgF2BOrderService.getRequireRemitAmount(dgOrderRemittanceStatisticsReqDto));
    }

    public RestResponse<List<CustomAllotInventoryRespDto>> queryAllotInventory(@PathVariable(value="orderId") Long orderId) {
        return new RestResponse((Object)this.channelOrderService.queryAllotInventory(orderId));
    }

    public RestResponse<OrderFulfillmentRespDto> queryOrderFulfillmentList(@RequestParam(value="orderId") Long orderId) {
        return new RestResponse((Object)this.channelOrderService.queryOrderFulfillmentList(orderId));
    }

    public RestResponse<DgPerformOrderRespDto> queryById(@RequestParam(value="orderId") Long orderId) {
        return new RestResponse((Object)this.channelOrderService.queryById(orderId));
    }

    public RestResponse<DgPerformOrderBatchOptRespDto> batchModifyOrderRemark(OrderRemarkReqDto reqDto) {
        return this.orderCommonHandleAction.batchModifyOrderRemark(reqDto);
    }
}

