/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.rest.statemachine;

import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.center.trade.api.statemachine.IDgB2BSaleStatemachineApi;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgArrangeShipmentEnterpriseReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgArrangeWarehouseReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBatchMergeOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgConfirmReceiveOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgOrderTagRecordReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgOutDeliveryResultReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderAddrReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderRemarkReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgSplitOrderBySkuReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgSplitOrderReqDto;
import com.yunxi.dg.base.center.trade.statemachine.handler.IDgB2BSaleStatemachineHandle;
import com.yunxi.dg.base.commons.annotations.OptLogEntryMethod;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/statemachine/b2b/saleOrder/"})
public class DgB2BSaleStatemachineApiRest
implements IDgB2BSaleStatemachineApi {
    @Resource
    private IDgB2BSaleStatemachineHandle dgB2BSaleStatemachineHandle;

    @OptLogEntryMethod
    public RestResponse<Long> createSaleOrder(String bizModel, DgBizPerformOrderReqDto addReqDto) {
        return this.dgB2BSaleStatemachineHandle.createSaleOrder(bizModel, addReqDto);
    }

    public RestResponse<Long> fulfillment(String bizModel, DgBizPerformOrderReqDto addReqDto) {
        return this.dgB2BSaleStatemachineHandle.fulfillment(bizModel, addReqDto);
    }

    @OptLogEntryMethod(linkCodeSpel="#orderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> auditPass(String bizModel, Long orderId) {
        return this.dgB2BSaleStatemachineHandle.auditPass(bizModel, orderId);
    }

    @OptLogEntryMethod(linkCodeSpel="#orderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> auditNoPass(String bizModel, Long orderId) {
        return this.dgB2BSaleStatemachineHandle.auditNoPass(bizModel, orderId);
    }

    @OptLogEntryMethod(linkCodeSpel="#orderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> copyOrder(String bizModel, Long orderId) {
        return this.dgB2BSaleStatemachineHandle.copyOrder(bizModel, orderId);
    }

    @OptLogEntryMethod(linkCodeSpel="#orderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> checkOrder(String bizModel, Long orderId) {
        return this.dgB2BSaleStatemachineHandle.checkOrder(bizModel, orderId);
    }

    @OptLogEntryMethod(linkCodeSpel="#orderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> modifyAddress(String bizModel, Long orderId, DgPerformOrderAddrReqDto reqDto) {
        return this.dgB2BSaleStatemachineHandle.modifyAddress(bizModel, orderId, reqDto);
    }

    @OptLogEntryMethod(linkCodeSpel="#saleOrderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> modifyOrderRemark(String bizModel, Long saleOrderId, DgPerformOrderRemarkReqDto performOrderRemarkReqDto) {
        return this.dgB2BSaleStatemachineHandle.modifyOrderRemark(bizModel, saleOrderId, performOrderRemarkReqDto.getRemark());
    }

    @OptLogEntryMethod(linkCodeSpel="#orderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> cancelOrder(String bizModel, Long orderId, String cancelReason) {
        return this.dgB2BSaleStatemachineHandle.cancelOrder(bizModel, orderId, cancelReason);
    }

    @OptLogEntryMethod(linkCodeSpel="#orderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> invalidOrder(String bizModel, Long orderId) {
        return this.dgB2BSaleStatemachineHandle.invalidOrder(bizModel, orderId);
    }

    @OptLogEntryMethod(linkCodeSpel="#orderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> resetOrder(String bizModel, Long orderId) {
        return this.dgB2BSaleStatemachineHandle.resetOrder(bizModel, orderId);
    }

    @OptLogEntryMethod(linkCodeSpel="#saleOrderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> statusLock(String bizModel, Long saleOrderId, String desc) {
        return this.dgB2BSaleStatemachineHandle.statusLock(bizModel, saleOrderId, desc);
    }

    @OptLogEntryMethod(linkCodeSpel="#saleOrderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> statusUnLock(String bizModel, Long saleOrderId, String desc) {
        return this.dgB2BSaleStatemachineHandle.statusUnLock(bizModel, saleOrderId, desc);
    }

    public RestResponse<Void> channelStatusLock(String bizModel, Long saleOrderId, String desc) {
        return this.dgB2BSaleStatemachineHandle.channelStatusLock(bizModel, saleOrderId, desc);
    }

    public RestResponse<Void> channelStatusUnLock(String bizModel, Long saleOrderId, String desc) {
        return this.dgB2BSaleStatemachineHandle.channelStatusUnLock(bizModel, saleOrderId, desc);
    }

    @OptLogEntryMethod(linkCodeSpel="#saleOrderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> addOrderTagRecord(String bizModel, Long saleOrderId, List<DgOrderTagRecordReqDto> addrReqDtos) {
        return this.dgB2BSaleStatemachineHandle.addOrderTagRecord(bizModel, saleOrderId, addrReqDtos);
    }

    @OptLogEntryMethod(linkCodeSpel="#saleOrderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> replaceOrderTagRecord(String bizModel, Long saleOrderId, List<DgOrderTagRecordReqDto> replaceReqDtos) {
        return this.dgB2BSaleStatemachineHandle.replaceOrderTagRecord(bizModel, saleOrderId, replaceReqDtos);
    }

    @OptLogEntryMethod(linkCodeSpel="#saleOrderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> removeOrderTagRecord(String bizModel, Long saleOrderId, List<DgOrderTagRecordReqDto> removeReqDtos) {
        return this.dgB2BSaleStatemachineHandle.removeOrderTagRecord(bizModel, saleOrderId, removeReqDtos);
    }

    @OptLogEntryMethod(linkCodeSpel="#orderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> splitOrder(String bizModel, Long orderId, DgSplitOrderReqDto reqDto) {
        return this.dgB2BSaleStatemachineHandle.splitOrder(bizModel, orderId, reqDto);
    }

    @OptLogEntryMethod(linkCodeSpel="#orderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> splitOrderByAppointSku(String bizModel, Long orderId, DgSplitOrderBySkuReqDto reqDto) {
        return this.dgB2BSaleStatemachineHandle.splitOrderByAppointSku(bizModel, orderId, reqDto);
    }

    @OptLogEntryMethod(linkCodeSpel="#orderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> splitOrderByAppointBatch(String bizModel, Long orderId, DgSplitOrderReqDto reqDto) {
        return this.dgB2BSaleStatemachineHandle.splitOrderByAppointBatch(bizModel, orderId, reqDto);
    }

    @OptLogEntryMethod(linkCodeSpel="#saleOrderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> arrangeWarehouse(String bizModel, Long saleOrderId, DgArrangeWarehouseReqDto reqDto) {
        return this.dgB2BSaleStatemachineHandle.arrangeWarehouse(bizModel, saleOrderId, reqDto);
    }

    @OptLogEntryMethod(linkCodeSpel="#orderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> manualPick(String bizModel, Long orderId) {
        return this.dgB2BSaleStatemachineHandle.manualPick(bizModel, orderId);
    }

    @OptLogEntryMethod(linkCodeSpel="#orderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> modifyDeliveryDate(String bizModel, Long orderId, String newDate) {
        return this.dgB2BSaleStatemachineHandle.modifyDeliveryDate(bizModel, orderId, newDate);
    }

    @OptLogEntryMethod(linkCodeSpel="#orderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> modifyPlanDeliveryDate(String bizModel, Long orderId, String newDate) {
        return this.dgB2BSaleStatemachineHandle.modifyPlanDeliveryDate(bizModel, orderId, newDate);
    }

    @OptLogEntryMethod(linkCodeSpel="#orderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> cancelPick(String bizModel, Long orderId) {
        return this.dgB2BSaleStatemachineHandle.cancelPick(bizModel, orderId);
    }

    @OptLogEntryMethod(linkCodeSpel="#orderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> unlock(String bizModel, Long orderId) {
        return this.dgB2BSaleStatemachineHandle.unlock(bizModel, orderId);
    }

    @OptLogEntryMethod(linkCodeSpel="#orderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> continueDeliver(String bizModel, Long orderId, Integer mergeStatus) {
        return this.dgB2BSaleStatemachineHandle.continueDeliver(bizModel, orderId, mergeStatus);
    }

    @OptLogEntryMethod(linkCodeSpel="#orderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> cancelAppoint(String bizModel, Long orderId) {
        return this.dgB2BSaleStatemachineHandle.cancelAppoint(bizModel, orderId);
    }

    @OptLogEntryMethod(linkCodeSpel="#orderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Boolean> confirmReceiptGoods(String bizModel, Long orderId, DgConfirmReceiveOrderReqDto reqDto) {
        return this.dgB2BSaleStatemachineHandle.confirmReceiptGoods(bizModel, orderId, reqDto);
    }

    @OptLogEntryMethod(linkCodeSpel="#orderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> completed(String bizModel, Long orderId, String completeReason) {
        return this.dgB2BSaleStatemachineHandle.completed(bizModel, orderId, completeReason);
    }

    @OptLogEntryMethod(linkCodeSpel="#orderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> batchMerge(String bizModel, Long orderId, DgBatchMergeOrderReqDto reqDto) {
        return this.dgB2BSaleStatemachineHandle.batchMerge(bizModel, orderId, reqDto);
    }

    @OptLogEntryMethod(linkCodeSpel="#orderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> outDeliveryResult(String bizModel, Long orderId, DgOutDeliveryResultReqDto resultReqDto) {
        return this.dgB2BSaleStatemachineHandle.outDeliveryResult(bizModel, orderId, resultReqDto);
    }

    @OptLogEntryMethod(linkCodeSpel="#orderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> cancelSaleOrderSplit(String bizModel, Long saleOrderId, String desc) {
        return this.dgB2BSaleStatemachineHandle.cancelSaleOrderSplit(bizModel, saleOrderId, desc);
    }

    public RestResponse<Void> retryExecuteEvent(Long eventRecordId) throws Exception {
        return this.dgB2BSaleStatemachineHandle.retryExecuteEvent(eventRecordId);
    }

    @OptLogEntryMethod(linkCodeSpel="#orderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> assignPlanShipmentEnterprise(String bizModel, Long orderId, DgArrangeShipmentEnterpriseReqDto reqDto) {
        return this.dgB2BSaleStatemachineHandle.assignPlanShipmentEnterprise(bizModel, orderId, reqDto);
    }
}

