/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.rest.test;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import com.yunxi.dg.base.center.trade.api.test.ITestApi;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderExtensionDto;
import com.yunxi.dg.base.center.trade.dto.finance.PushStatusToTradeDto;
import com.yunxi.dg.base.center.trade.mqc.order.PerformOrderSysFinanceProcessor;
import com.yunxi.dg.base.center.trade.scheduler.AutomaticUnhookRangeJob;
import com.yunxi.dg.base.center.trade.service.entity.IPerformOrderSysFinanceService;
import com.yunxi.dg.base.center.trade.service.oms.b2c.IAutoLockSchedulerService;
import io.swagger.annotations.ApiOperation;
import java.util.Calendar;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/dg/test"})
public class TestApiRest
implements ITestApi {
    @Resource
    private IAutoLockSchedulerService autoLockSchedulerService;
    @Resource
    private AutomaticUnhookRangeJob automaticUnhookRangeJob;
    @Resource
    private PerformOrderSysFinanceProcessor performOrderSysFinanceProcessor;
    @Resource
    private IPerformOrderSysFinanceService iPerformOrderSysFinanceService;

    public RestResponse<Void> tradeTestApi(Long id) {
        return new RestResponse();
    }

    @PostMapping(value={"/autoUnHangLock"})
    @ApiOperation(value="\u6d4b\u8bd5\u63a5\u53e3", notes="\u6d4b\u8bd5\u63a5\u53e3")
    public RestResponse<Void> autoUnHangLock(@RequestBody DgPerformOrderExtensionDto dto) {
        Long orderId = dto.getOrderId();
        String autoUnhangDate = dto.getAutoUnhangDate();
        Date date = DateUtil.parse((String)autoUnhangDate, (String)"yyyy-MM-dd HH:mm:ss");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.add(5, 1);
        Date nextDay = calendar.getTime();
        this.autoLockSchedulerService.createAutoUnhangTask(nextDay, orderId);
        return RestResponse.VOID;
    }

    @PostMapping(value={"/autoUnHangLock/action"})
    @ApiOperation(value="\u6d4b\u8bd5\u63a5\u53e3", notes="\u6d4b\u8bd5\u63a5\u53e3")
    public RestResponse<Void> actionUnHangLock(@RequestBody TaskMsg taskMsg) {
        this.automaticUnhookRangeJob.execute(taskMsg);
        return RestResponse.VOID;
    }

    @PostMapping(value={"/financePush/saleOrder/action"})
    @ApiOperation(value="\u6d4b\u8bd5\u6b63\u5411\u63a5\u53e3\u63a5\u53e3", notes="\u6d4b\u8bd5\u6b63\u5411\u63a5\u53e3\u63a5\u53e3")
    public RestResponse<Void> financePushAaleOrder(@RequestBody PushStatusToTradeDto pushStatusToTradeDto) {
        String orderType = pushStatusToTradeDto.getOrderType();
        if (orderType.equals("SALE_LIST")) {
            this.iPerformOrderSysFinanceService.assembleSaleOrderAction(pushStatusToTradeDto);
        } else {
            this.iPerformOrderSysFinanceService.assembleAfterSaleOrderAction(pushStatusToTradeDto);
        }
        return RestResponse.VOID;
    }
}

