/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.rest.aftersale;

import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.inventory.dto.entity.AdjustmentOrderDto;
import com.yunxi.dg.base.center.inventory.proxy.other.IInventoryAdjustmentOrderApiProxy;
import com.yunxi.dg.base.center.trade.api.aftersale.IDgNoSourceReturnRecordApi;
import com.yunxi.dg.base.center.trade.constants.aftersale.DgCisAfterSaleBizModelEnum;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgBizAfterSaleOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgNoSourceReturnRecordReqDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgNoSourceReturnRecordDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgNoSourceReturnRecordPageReqDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgNoSourceReturnRecordRemarkModifyReqDto;
import com.yunxi.dg.base.center.trade.service.after.IDgAfterSaleOrderItemService;
import com.yunxi.dg.base.center.trade.service.after.IDgAfterSaleOrderService;
import com.yunxi.dg.base.center.trade.service.entity.IDgNoSourceReturnRecordService;
import com.yunxi.dg.base.center.trade.statemachine.b2c.aftersale.constant.DgB2CAfterSaleMachineEvents;
import com.yunxi.dg.base.center.trade.statemachine.b2c.aftersale.execute.DgB2CAfterSaleStatemachineExecutor;
import com.yunxi.dg.base.center.trade.vo.NoSourceReturnRecordMatchSuccessDto;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import io.swagger.annotations.Api;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u4ea4\u6613\u4e2d\u5fc3:\u65e0\u5934\u4ef6\u9000\u8d27\u8bb0\u5f55\u8868\u63a5\u53e3\u670d\u52a1"})
@Validated
public class DgNoSourceReturnRecordRest
implements IDgNoSourceReturnRecordApi {
    private static final Logger log = LoggerFactory.getLogger(DgNoSourceReturnRecordRest.class);
    @Resource
    private IDgNoSourceReturnRecordService service;
    @Resource
    private DgB2CAfterSaleStatemachineExecutor dgB2CAfterSaleStatemachineExecutor;
    @Resource
    private IDgAfterSaleOrderService afterSaleOrderService;
    @Resource
    private IInventoryAdjustmentOrderApiProxy inventoryAdjustmentOrderApiProxy;
    @Resource
    private ILockService lockService;
    @Resource
    private IDgAfterSaleOrderItemService afterSaleOrderItemService;

    public RestResponse<Long> add(@Valid @RequestBody DgNoSourceReturnRecordReqDto dto) {
        return new RestResponse((Object)this.service.add(dto));
    }

    public RestResponse<Void> update(@RequestBody DgNoSourceReturnRecordDto dto) {
        this.service.batchUpdate(dto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> updateShippingNo(Long id, String shippingNo) {
        this.service.updateShippingNo(id, shippingNo);
        return RestResponse.VOID;
    }

    public RestResponse<Void> batchAddOtherStorageOrder(@NotEmpty @RequestBody List<Long> ids) {
        this.service.batchAddOtherStorageOrder(ids);
        return RestResponse.VOID;
    }

    public RestResponse<Void> batchAddOtherStorageOrderOut(@NotEmpty @RequestBody List<Long> ids) {
        this.service.batchAddOtherStorageOrderOut(ids);
        return RestResponse.VOID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RestResponse<Void> batchMatch(List<Long> ids) {
        Mutex lock = null;
        try {
            lock = this.lockService.lock("batch_match_lock_key:", "x", 0, 600, TimeUnit.SECONDS);
            List matchSuccessDtos = this.service.batchMatch(ids);
            List afterOrderIds = matchSuccessDtos.stream().map(NoSourceReturnRecordMatchSuccessDto::getAfterOrderId).distinct().collect(Collectors.toList());
            Map<Long, List<NoSourceReturnRecordMatchSuccessDto>> afterOrderIdMap = matchSuccessDtos.stream().collect(Collectors.groupingBy(NoSourceReturnRecordMatchSuccessDto::getAfterOrderId));
            log.info("\u6279\u91cf\u5339\u914d\u65e0\u5934\u4ef6\u9000\u8d27\u8bb0\u5f55,\u5339\u914d\u6210\u529f\u7684\u552e\u540e\u5355ids\u6761\u6570:{}", (Object)afterOrderIds.size());
            Map<Long, List<NoSourceReturnRecordMatchSuccessDto>> group = matchSuccessDtos.stream().collect(Collectors.groupingBy(NoSourceReturnRecordMatchSuccessDto::getAfterOrderId));
            if (CollectionUtil.isNotEmpty(afterOrderIds)) {
                List afterSaleOrderRespDtos = this.afterSaleOrderService.queryByIds(afterOrderIds);
                afterSaleOrderRespDtos.forEach(afterSaleOrderRespDto -> {
                    block8: {
                        log.info("\u5339\u914d\u6210\u529f\u7684\u552e\u540e\u5355\u53f7\uff1a{}\uff0c \u552e\u540e\u7c7b\u578b\uff1a{}", (Object)afterSaleOrderRespDto.getAfterSaleOrderNo(), (Object)afterSaleOrderRespDto.getAfterSaleOrderType());
                        DgBizAfterSaleOrderReqDto bizAfterSaleOrderReqDto = new DgBizAfterSaleOrderReqDto();
                        bizAfterSaleOrderReqDto.setId(afterSaleOrderRespDto.getId());
                        bizAfterSaleOrderReqDto.setNoSendWms(true);
                        bizAfterSaleOrderReqDto.setAutoComplete(true);
                        DgCisAfterSaleBizModelEnum cisAfterSaleOrderBizModelEnum = (DgCisAfterSaleBizModelEnum)DgCisAfterSaleBizModelEnum.CODE_LOOKUP.get(afterSaleOrderRespDto.getAfterSaleOrderType());
                        try {
                            switch (cisAfterSaleOrderBizModelEnum) {
                                case THTK: {
                                    this.dgB2CAfterSaleStatemachineExecutor.executeStatemachine(afterSaleOrderRespDto.getAfterSaleOrderType(), afterSaleOrderRespDto.getId(), (Object)bizAfterSaleOrderReqDto, (Object)DgB2CAfterSaleMachineEvents.THTK_CONFIRM_NO_SOURCE).getActionResultSubRestResponse(Void.class);
                                    break;
                                }
                                case HH: {
                                    this.dgB2CAfterSaleStatemachineExecutor.executeStatemachine(afterSaleOrderRespDto.getAfterSaleOrderType(), afterSaleOrderRespDto.getId(), (Object)bizAfterSaleOrderReqDto, (Object)DgB2CAfterSaleMachineEvents.HH_BUYER_SENT_NO_SOURCE).getActionResultSubRestResponse(Void.class);
                                    break;
                                }
                            }
                            List adjustmentReqs = ((List)group.getOrDefault(afterSaleOrderRespDto.getId(), new ArrayList(0))).stream().map(NoSourceReturnRecordMatchSuccessDto::getAdjustmentOrderDtoList).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
                            if (!adjustmentReqs.isEmpty()) {
                                RestResponse resp = this.inventoryAdjustmentOrderApiProxy.insertBatchV3(adjustmentReqs);
                                List list = (List)RestResponseHelper.extractData((RestResponse)resp);
                                for (int i = 0; i < adjustmentReqs.size(); ++i) {
                                    AdjustmentOrderDto dto = (AdjustmentOrderDto)adjustmentReqs.get(i);
                                    AdjustmentOrderDto rs = (AdjustmentOrderDto)list.get(i);
                                    log.info("\u6dfb\u52a0\u5e93\u5b58\u8c03\u6574\u5355\u6210\u529f\uff1aafterSaleOrderItemId={}, noSourceReturnRecordIds={}, adjustmentOrderId={}, adjustmentOrderNo={}", new Object[]{dto.getAfterSaleOrderItemId(), dto.getNoSourceReturnRecordIds(), rs.getId(), rs.getAdjustmentNo()});
                                    this.service.updateAdjustmentNo(dto.getNoSourceReturnRecordIds(), rs.getAdjustmentNo());
                                    this.afterSaleOrderItemService.updateAdjustmentNo(dto.getAfterSaleOrderItemId(), rs.getAdjustmentNo());
                                }
                            }
                        }
                        catch (Exception e) {
                            log.error("\u5339\u914d\u6210\u529f\u7684\u552e\u540e\u5355\u53f7\uff1a{}\uff0c\u5904\u7406\u8ba2\u5355\u6d41\u7a0b\u9519\u8bef\uff1a{}", new Object[]{afterSaleOrderRespDto.getAfterSaleOrderNo(), e.getMessage(), e});
                            List matchSuccessDtos1 = (List)afterOrderIdMap.get(afterSaleOrderRespDto.getId());
                            if (!CollectionUtil.isNotEmpty((Collection)matchSuccessDtos1)) break block8;
                            this.service.updateMatchFailByIds(matchSuccessDtos1);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u5339\u914d\u9519\u8bef", (Throwable)e);
            if (e.getMessage().contains("\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25")) {
                throw new BizException("\u6570\u636e\u5904\u7406\u4e2d...");
            }
        }
        finally {
            if (Objects.nonNull(lock)) {
                this.lockService.unlock(lock);
            }
        }
        return RestResponse.VOID;
    }

    public RestResponse<Void> batchNoMatch(@NotEmpty List<Long> ids) {
        return this.service.batchNoMatch(ids);
    }

    public RestResponse<DgNoSourceReturnRecordDto> get(Long id) {
        return this.service.get(id);
    }

    public RestResponse<Void> logicDelete(@PathVariable(name="id", required=true) Long id) {
        return this.service.logicDeleteById(id);
    }

    public RestResponse<Void> abolish(@PathVariable(name="id", required=true) Long id) {
        return this.service.abolish(id);
    }

    public RestResponse<Void> batchAbololish(@RequestBody DgNoSourceReturnRecordDto dto) {
        return this.service.batchAbololish(dto);
    }

    public RestResponse<PageInfo<DgNoSourceReturnRecordDto>> page(@RequestBody DgNoSourceReturnRecordPageReqDto dto) {
        return new RestResponse((Object)this.service.queryPage(dto));
    }

    public RestResponse<Void> batchModifyRemark(@RequestBody DgNoSourceReturnRecordRemarkModifyReqDto reqDto) {
        return this.service.batchModifyRemark(reqDto);
    }

    public RestResponse<Void> modifyRemarkOrU9No(DgNoSourceReturnRecordDto reqDto) {
        return this.service.modifyRemarkOrU9No(reqDto);
    }
}

