/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.rest.entity;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.dto.entity.CsOrganizationPageQueryDto;
import com.yunxi.dg.base.center.report.dto.entity.CsOrganizationPageRespDto;
import com.yunxi.dg.base.center.report.proxy.customer.IDgOrganizationQueryApiProxy;
import com.yunxi.dg.base.center.trade.api.entity.IDgRefundDetailApi;
import com.yunxi.dg.base.center.trade.dto.entity.DgRefundDetailDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgRefundDetailPageReqDto;
import com.yunxi.dg.base.center.trade.enums.NewDgRefundDetailStatusEnum;
import com.yunxi.dg.base.center.trade.service.entity.IDgRefundDetailService;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.BeanCopyUtil;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import io.swagger.annotations.Api;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u57fa\u7ebf-\u6837\u672c\u4e2d\u5fc3:\u9000\u6b3e\u660e\u7ec6\u8868\u63a5\u53e3\u670d\u52a1"})
public class DgRefundDetailController
implements IDgRefundDetailApi {
    private static final Logger log = LoggerFactory.getLogger(DgRefundDetailController.class);
    @Resource
    private IDgRefundDetailService service;
    @Resource
    private IDgOrganizationQueryApiProxy dgOrganizationQueryApiProxy;

    public RestResponse<Long> insert(@RequestBody DgRefundDetailDto dto) {
        return this.service.insert((BaseDto)dto);
    }

    public RestResponse update(@RequestBody DgRefundDetailDto dto) {
        return this.service.update((BaseDto)dto);
    }

    public RestResponse<DgRefundDetailDto> get(Long id) {
        return this.service.get(id);
    }

    public RestResponse logicDelete(@PathVariable(name="id", required=true) Long id) {
        return this.service.logicDelete(id);
    }

    public RestResponse<PageInfo<DgRefundDetailDto>> page(@RequestBody DgRefundDetailPageReqDto dto) {
        RestResponse pageRest = this.service.page((BaseDto)BeanCopyUtil.copy((Object)dto, DgRefundDetailDto.class), dto.getPageNum(), dto.getPageSize());
        PageInfo data = (PageInfo)pageRest.getData();
        if (CollectionUtils.isNotEmpty((Collection)data.getList())) {
            CsOrganizationPageQueryDto dgSaleCompanyReqDto = new CsOrganizationPageQueryDto();
            dgSaleCompanyReqDto.setCodeList(data.getList().stream().map(DgRefundDetailDto::getEnterpriseCode).collect(Collectors.toList()));
            log.info("\u9500\u552e\u516c\u53f8\u5165\u53c2\u6570\uff1a{}", JSON.toJSON((Object)dgSaleCompanyReqDto));
            List csOrganizationPageRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.dgOrganizationQueryApiProxy.querySaleOrgByList(dgSaleCompanyReqDto));
            Map saleCompanyMap = csOrganizationPageRespDtos.stream().collect(Collectors.toMap(CsOrganizationPageRespDto::getCode, Function.identity(), (e1, e2) -> e1));
            for (DgRefundDetailDto dgRefundDetailDto : data.getList()) {
                CsOrganizationPageRespDto dgSaleCompanyRespDto;
                if (StringUtils.isNotBlank((CharSequence)dgRefundDetailDto.getStatus())) {
                    dgRefundDetailDto.setStatusStr(NewDgRefundDetailStatusEnum.getDescByCode((String)dgRefundDetailDto.getStatus()));
                }
                if ((dgSaleCompanyRespDto = (CsOrganizationPageRespDto)saleCompanyMap.get(dgRefundDetailDto.getEnterpriseCode())) == null) continue;
                dgRefundDetailDto.setSaleCompanyCode(dgSaleCompanyRespDto.getCode());
                dgRefundDetailDto.setSaleCompanyName(dgSaleCompanyRespDto.getName());
            }
        }
        pageRest.setData((Object)data);
        return pageRest;
    }
}

