/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.rest.statemachine;

import cn.hutool.core.bean.BeanUtil;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.constant.DgF2BOrderStatus;
import com.dtyunxi.yundt.cube.center.trade.api.constants.tob.AuditTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderRemarkReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderStayReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.PayMethodReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.OrderModTobReqDto;
import com.dtyunxi.yundt.cube.center.trade.ext.api.dto.request.OrderAuditReqDto;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.trade.action.oms.channel.IChannelOrderCreateAction;
import com.yunxi.dg.base.center.trade.action.oms.channel.IOrderItemToOrderLineAction;
import com.yunxi.dg.base.center.trade.api.statemachine.IDgF2BOrderStatemachineApi;
import com.yunxi.dg.base.center.trade.constants.DgPerformOrderBizModelEnum;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgArrangeShipmentEnterpriseReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformNoticeSyncRecordDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.ResultOrderOptReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.DgF2BAuditRevokeReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.DgF2BOrderRejectReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.DgGeneralOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.DgOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.DgShopOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.OrderAllotInventoryReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.OrderBatchPushReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.OrderFulfillmentReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.custom.DgCustomPackageOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.preview.OrderPreviewItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgBizPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.order.DgOrderResultRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.order.DgShopOrderResultRespDto;
import com.yunxi.dg.base.center.trade.dto.pay.DgPerformOrderPayReqDto;
import com.yunxi.dg.base.center.trade.service.entity.IDgTrolleyItemService;
import com.yunxi.dg.base.center.trade.service.oms.channel.IDgF2BOrderService;
import com.yunxi.dg.base.center.trade.service.oms.common.ICommonOrderQueryService;
import com.yunxi.dg.base.center.trade.statemachine.handler.IDgF2BOrderStatemachineHandle;
import com.yunxi.dg.base.commons.annotations.OptLogEntryMethod;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/dg/f2b/order"})
public class DgF2BOrderStatemachineApiRest
implements IDgF2BOrderStatemachineApi {
    private static final Logger log = LoggerFactory.getLogger(DgF2BOrderStatemachineApiRest.class);
    @Resource
    private IDgF2BOrderStatemachineHandle dgF2BOrderStatemachineHandle;
    @Resource
    private IDgF2BOrderService dgF2BOrderService;
    @Resource
    private IDgTrolleyItemService dgTrolleyItemService;
    @Resource
    private IChannelOrderCreateAction channelOrderCreateAction;
    @Resource
    private ICommonOrderQueryService commonOrderQueryService;
    @Resource
    private IOrderItemToOrderLineAction orderItemToOrderLineAction;

    @OptLogEntryMethod
    @Deprecated
    public RestResponse<Long> addOrder(@RequestBody OrderReqDto addReqDto) {
        return this.dgF2BOrderStatemachineHandle.createOrder(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), addReqDto);
    }

    public RestResponse<DgOrderResultRespDto> submitOrder(@Validated @RequestBody DgOrderReqDto dgOrderReqDto) {
        dgOrderReqDto.setOrderStatus(DgF2BOrderStatus.WAIT_CS_AUDIT.getCode());
        DgOrderResultRespDto dgOrderResultRespDto = this.channelOrderCreateAction.submitChannelOrderV2(dgOrderReqDto);
        DgOrderReqDto orderReqDto = new DgOrderReqDto();
        BeanUtil.copyProperties((Object)dgOrderReqDto, (Object)orderReqDto, (String[])new String[]{"shopOrderReqDtoList"});
        dgOrderReqDto.getShopOrderReqDtoList().forEach(dgShopOrderResultRespDto -> {
            DgShopOrderResultRespDto resultRespDto = (DgShopOrderResultRespDto)dgOrderResultRespDto.getShopOrderResultRespDtos().get(0);
            dgShopOrderResultRespDto.setId(resultRespDto.getOrderId());
            orderReqDto.setShopOrderReqDtoList((List)Lists.newArrayList((Object[])new DgShopOrderReqDto[]{dgShopOrderResultRespDto}));
            this.dgF2BOrderStatemachineHandle.submitOrder(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), orderReqDto);
        });
        CompletableFuture.runAsync(() -> {
            if (dgOrderResultRespDto.getShopOrderResultRespDtos().stream().allMatch(DgShopOrderResultRespDto::isSucc)) {
                List trolleyItemIds = dgOrderReqDto.getShopOrderReqDtoList().stream().flatMap(e -> e.getItemList().stream()).map(OrderPreviewItemReqDto::getTrolleyItemId).collect(Collectors.toList());
                Optional.ofNullable(trolleyItemIds).ifPresent(arg_0 -> ((IDgTrolleyItemService)this.dgTrolleyItemService).deleteBatch(arg_0));
            }
        });
        return new RestResponse((Object)dgOrderResultRespDto);
    }

    public RestResponse<DgOrderResultRespDto> saveOrder(DgOrderReqDto dgOrderReqDto) {
        dgOrderReqDto.setOrderStatus(DgF2BOrderStatus.WAIT_CHECK.getCode());
        return new RestResponse((Object)this.channelOrderCreateAction.saveChannelOrderV2(dgOrderReqDto));
    }

    @OptLogEntryMethod(linkCodeSpel="#shopOrderReqDtoList[0].id", linkCodeType="PERFORM_ORDER")
    public RestResponse<DgOrderResultRespDto> checkOrder(@Valid @RequestBody DgOrderReqDto dgOrderReqDto) {
        return this.dgF2BOrderStatemachineHandle.checkOrder(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), dgOrderReqDto);
    }

    @OptLogEntryMethod(linkCodeSpel="#shopOrderReqDtoList[0].id", linkCodeType="PERFORM_ORDER")
    public RestResponse<DgOrderResultRespDto> batchPush(@Valid @RequestBody OrderBatchPushReqDto reqDto) {
        return this.dgF2BOrderStatemachineHandle.batchPush(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), reqDto);
    }

    public RestResponse<DgOrderResultRespDto> recalculateOrder(DgOrderReqDto dgOrderReqDto) {
        return this.dgF2BOrderStatemachineHandle.recalculateOrder(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), dgOrderReqDto);
    }

    @OptLogEntryMethod(linkCodeSpel="#shopOrderReqDtoList[0].id", linkCodeType="PERFORM_ORDER")
    @Deprecated
    public RestResponse<DgOrderResultRespDto> modifyOrder(@Valid @RequestBody DgOrderReqDto dgOrderReqDto) {
        return this.dgF2BOrderStatemachineHandle.modifyOrder(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), dgOrderReqDto);
    }

    @OptLogEntryMethod(linkCodeSpel="#orderModTobReq.id", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> modifyOrderInfo(@RequestBody OrderModTobReqDto orderModTobReq) {
        return this.dgF2BOrderStatemachineHandle.modifyOrderInfo(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), orderModTobReq);
    }

    public RestResponse<Void> modifyOrderRemark(OrderRemarkReqDto reqDto) {
        return this.dgF2BOrderStatemachineHandle.modifyOrderRemark(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), reqDto);
    }

    @OptLogEntryMethod(linkCodeSpel="#orderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> logicDeleteOrder(@PathVariable(value="id") Long orderId) {
        return this.dgF2BOrderStatemachineHandle.logicDeleteOrder(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), orderId);
    }

    @OptLogEntryMethod(linkCodeSpel="#payMethodReqDto.orderId", linkCodeType="PERFORM_ORDER")
    @Deprecated
    public RestResponse<String> orderPay(@RequestBody PayMethodReqDto payMethodReqDto) {
        return this.dgF2BOrderStatemachineHandle.modifyPayMethod(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), payMethodReqDto);
    }

    @OptLogEntryMethod(linkCodeSpel="#id", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> cancelByOrder(@RequestParam(name="id") Long id, @RequestParam(name="reason") String reason) {
        return this.dgF2BOrderStatemachineHandle.cancelByOrder(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), id, reason);
    }

    @OptLogEntryMethod(linkCodeSpel="#id", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> closeOrder(Long id, String reason) {
        return this.dgF2BOrderStatemachineHandle.closeOrder(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), id, reason);
    }

    public RestResponse<Void> auditOrder(@RequestBody OrderAuditReqDto orderAuditReqDto) {
        if (StringUtils.isEmpty((CharSequence)orderAuditReqDto.getAuditType()) || AuditTypeEnum.CS_AUDIT.getType().equals(orderAuditReqDto.getAuditType())) {
            return this.dgF2BOrderStatemachineHandle.csAuditOrder(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), orderAuditReqDto);
        }
        if (AuditTypeEnum.FINANCE_AUDIT.getType().equals(orderAuditReqDto.getAuditType())) {
            return this.dgF2BOrderStatemachineHandle.financeAuditOrder(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), orderAuditReqDto);
        }
        if (AuditTypeEnum.ORDER_REFUND_AUDIT.getType().equals(orderAuditReqDto.getAuditType())) {
            return this.dgF2BOrderStatemachineHandle.orderRefundAudit(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), orderAuditReqDto);
        }
        if (AuditTypeEnum.ORDER_CS_REFUND_AUDIT.getType().equals(orderAuditReqDto.getAuditType())) {
            return this.dgF2BOrderStatemachineHandle.orderCsRefundAudit(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), orderAuditReqDto);
        }
        if (AuditTypeEnum.EXTERNAL_AUDIT.getType().equals(orderAuditReqDto.getAuditType())) {
            return this.dgF2BOrderStatemachineHandle.orderExternalAudit(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), orderAuditReqDto);
        }
        throw new BizException("\u5ba1\u6838\u914d\u7f6e\u5f02\u5e38");
    }

    @OptLogEntryMethod(linkCodeSpel="#orderAuditReqDto.orderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> businessAuditRevoke(DgF2BAuditRevokeReqDto orderAuditReqDto) {
        return this.dgF2BOrderStatemachineHandle.businessAuditRevoke(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), orderAuditReqDto);
    }

    @OptLogEntryMethod(linkCodeSpel="#orderAuditReqDto.orderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> financialAuditRevoke(DgF2BAuditRevokeReqDto orderAuditReqDto) {
        return this.dgF2BOrderStatemachineHandle.financialAuditRevoke(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), orderAuditReqDto);
    }

    @OptLogEntryMethod(linkCodeSpel="#orderAuditReqDto.orderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> reject(DgF2BOrderRejectReqDto orderAuditReqDto) {
        return this.dgF2BOrderStatemachineHandle.reject(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), orderAuditReqDto);
    }

    @OptLogEntryMethod(linkCodeSpel="#id", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> delivery(@PathVariable(value="id") Long id) {
        return this.dgF2BOrderStatemachineHandle.delivery(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), id);
    }

    @OptLogEntryMethod(linkCodeSpel="#id", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> confirmOrder(@PathVariable(value="id") Long id) {
        return this.dgF2BOrderStatemachineHandle.confirmOrder(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), id);
    }

    @OptLogEntryMethod(linkCodeSpel="#dgPerformOrderPayReqDto.orderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> pay(@RequestBody DgPerformOrderPayReqDto dgPerformOrderPayReqDto) {
        return this.dgF2BOrderStatemachineHandle.pay(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), dgPerformOrderPayReqDto);
    }

    @OptLogEntryMethod(linkCodeSpel="#dgBizPerformNoticeSyncRecordDto.businessId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> externalOrderDelivery(@Validated @RequestBody DgBizPerformNoticeSyncRecordDto dgBizPerformNoticeSyncRecordDto) {
        return this.dgF2BOrderStatemachineHandle.externalOrderDelivery(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), dgBizPerformNoticeSyncRecordDto);
    }

    public RestResponse<Void> cancelExternalDelivery(@RequestBody @Valid ResultOrderOptReqDto reqDto) {
        return this.dgF2BOrderStatemachineHandle.cancelExternalDelivery(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), reqDto.getBusinessId(), reqDto);
    }

    @OptLogEntryMethod(linkCodeSpel="#id", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> partCancelOrder(Long id, String reason) {
        return this.dgF2BOrderStatemachineHandle.partCancelOrder(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), id, reason);
    }

    public RestResponse<Void> externalOrderDeliveryTest(@Validated @RequestBody DgBizPerformNoticeSyncRecordDto dgBizPerformNoticeSyncRecordDto) {
        DgBizPerformOrderRespDto performOrderRespDto = this.commonOrderQueryService.queryByOrderNo(dgBizPerformNoticeSyncRecordDto.getBusinessNo());
        return RestResponse.VOID;
    }

    public RestResponse<Void> orderItemToOrderLine(@RequestBody List<Long> orderIds) {
        return this.orderItemToOrderLineAction.orderItemToOrderLine(orderIds);
    }

    @OptLogEntryMethod(linkCodeSpel="#id", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> modifyOrderInternalRemark(Long id, String remark) {
        return this.dgF2BOrderStatemachineHandle.modifyOrderInternalRemark(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), id, remark);
    }

    @OptLogEntryMethod(linkCodeSpel="#reqDto.orderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> assignShipmentEnterprise(DgArrangeShipmentEnterpriseReqDto reqDto) {
        return this.dgF2BOrderStatemachineHandle.assignShipmentEnterprise(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), reqDto.getOrderId(), reqDto);
    }

    @OptLogEntryMethod(linkCodeSpel="#saleOrderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> statusLock(String bizModel, Long saleOrderId, String desc) {
        return this.dgF2BOrderStatemachineHandle.statusLock(bizModel, saleOrderId, desc);
    }

    @OptLogEntryMethod(linkCodeSpel="#saleOrderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> statusUnLock(String bizModel, Long saleOrderId, String desc) {
        return this.dgF2BOrderStatemachineHandle.statusUnLock(bizModel, saleOrderId, desc);
    }

    @OptLogEntryMethod(linkCodeSpel="#id", linkCodeType="PERFORM_ORDER")
    public RestResponse<DgOrderResultRespDto> customPackageSubmitOrder(DgCustomPackageOrderReqDto dgOrderReqDto) {
        return this.dgF2BOrderStatemachineHandle.customPackageSubmitOrder(dgOrderReqDto);
    }

    @OptLogEntryMethod(linkCodeSpel="#id", linkCodeType="PERFORM_ORDER")
    public RestResponse<DgOrderResultRespDto> customPackageSaveOrder(DgCustomPackageOrderReqDto dgOrderReqDto) {
        return this.dgF2BOrderStatemachineHandle.customPackageSaveOrder(dgOrderReqDto);
    }

    @OptLogEntryMethod(linkCodeSpel="#id", linkCodeType="PERFORM_ORDER")
    public RestResponse<DgOrderResultRespDto> customPackageCheckOrder(DgCustomPackageOrderReqDto dgOrderReqDto) {
        return this.dgF2BOrderStatemachineHandle.customPackageCheckOrder(dgOrderReqDto);
    }

    @OptLogEntryMethod(linkCodeSpel="#id", linkCodeType="PERFORM_ORDER")
    public RestResponse<DgOrderResultRespDto> customPackageRecalculateOrder(DgCustomPackageOrderReqDto dgOrderReqDto) {
        return this.dgF2BOrderStatemachineHandle.customPackageRecalculateOrder(dgOrderReqDto);
    }

    @OptLogEntryMethod(linkCodeSpel="#id", linkCodeType="PERFORM_ORDER")
    public RestResponse<DgOrderResultRespDto> customPackageModifyOrder(DgCustomPackageOrderReqDto dgOrderReqDto) {
        return this.dgF2BOrderStatemachineHandle.customPackageModifyOrder(dgOrderReqDto);
    }

    @OptLogEntryMethod(linkCodeSpel="#id", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> customPackageSubmitOrderById(Long id) {
        return this.dgF2BOrderStatemachineHandle.customPackageSubmitOrderById(id);
    }

    public RestResponse<Void> fulfillment(@RequestBody @Valid OrderFulfillmentReqDto req) {
        return this.dgF2BOrderStatemachineHandle.fulfillment(req);
    }

    public RestResponse<Void> allotInventory(@RequestBody @Valid OrderAllotInventoryReqDto req) {
        return this.dgF2BOrderStatemachineHandle.allotInventory(req);
    }

    @OptLogEntryMethod(linkCodeSpel="#reqDto.id", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> modifyOrderStayTime(OrderStayReqDto reqDto) {
        return this.dgF2BOrderStatemachineHandle.modifyOrderStayTime(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), reqDto);
    }

    public RestResponse<Void> reloanByOrderId(Long orderId) {
        return this.dgF2BOrderStatemachineHandle.reloanByOrderId(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), orderId);
    }

    public RestResponse<Long> generalOrderCreate(DgGeneralOrderReqDto reqDto) {
        return this.dgF2BOrderStatemachineHandle.generalOrderCreate(reqDto);
    }

    public RestResponse<Void> generalOrderUpdate(DgGeneralOrderReqDto reqDto) {
        return null;
    }

    public RestResponse<Void> debtOrderOver(@PathVariable(value="id") Long orderId) {
        return this.dgF2BOrderStatemachineHandle.debtOrderOver(orderId);
    }

    public RestResponse<Void> pushExternalSystem(@PathVariable(value="id") Long orderId) {
        return this.dgF2BOrderStatemachineHandle.pushExternalSystem(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), orderId);
    }

    public RestResponse<Void> manualPick(@PathVariable(value="id") Long orderId) {
        return this.dgF2BOrderStatemachineHandle.manualPick(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), orderId);
    }
}

