/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.rest.entity;

import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.trade.api.entity.INationalSupplementAreaRuleApi;
import com.yunxi.dg.base.center.trade.convert.entity.NationalSupplementAreaRuleConverter;
import com.yunxi.dg.base.center.trade.dto.entity.NationalSupplementAreaRuleDto;
import com.yunxi.dg.base.center.trade.dto.entity.NationalSupplementAreaRuleExportDetailDto;
import com.yunxi.dg.base.center.trade.dto.entity.NationalSupplementAreaRulePageReqDto;
import com.yunxi.dg.base.center.trade.dto.entity.NationalSupplementAreaRuleUpdateStatusReqDto;
import com.yunxi.dg.base.center.trade.service.entity.INationalSupplementAreaRuleService;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import io.swagger.annotations.Api;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u57fa\u7ebf-\u8f6c\u5355\u4e2d\u5fc3:\u56fd\u8865\u533a\u57df\u89c4\u5219\u63a5\u53e3\u670d\u52a1"})
public class NationalSupplementAreaRuleController
implements INationalSupplementAreaRuleApi {
    @Resource
    private INationalSupplementAreaRuleService service;

    public RestResponse<Long> insert(@RequestBody NationalSupplementAreaRuleDto dto) {
        return this.service.insert((BaseDto)dto);
    }

    public RestResponse<Void> insertBatch(List<NationalSupplementAreaRuleDto> dtoList) {
        this.service.insertBatch(dtoList);
        return new RestResponse();
    }

    public RestResponse<Void> update(@RequestBody NationalSupplementAreaRuleDto dto) {
        this.service.update((BaseDto)dto);
        return new RestResponse();
    }

    public RestResponse<Void> updateStatusBatch(NationalSupplementAreaRuleUpdateStatusReqDto dto) {
        this.service.updateStatus(dto.getIdList(), dto.getStatus());
        return new RestResponse();
    }

    public RestResponse<NationalSupplementAreaRuleDto> get(Long id) {
        return this.service.get(id);
    }

    public RestResponse<Void> logicDelete(@PathVariable(name="id", required=true) Long id) {
        this.service.logicDelete(id);
        return new RestResponse();
    }

    public RestResponse<Void> logicDeleteBatch(List<Long> idList) {
        this.service.logicDeleteByIds(idList);
        return new RestResponse();
    }

    public RestResponse<PageInfo<NationalSupplementAreaRuleDto>> page(@RequestBody NationalSupplementAreaRulePageReqDto dto) {
        return this.service.page(dto);
    }

    public RestResponse<List<NationalSupplementAreaRuleDto>> queryBySaleCompanyCodes(List<String> saleCompanyCodes) {
        return new RestResponse((Object)this.service.queryDtoListBySaleCompanyCodes(saleCompanyCodes));
    }

    public RestResponse<List<NationalSupplementAreaRuleDto>> queryByPlatformCompanyCodes(List<String> platformCompanyCodes) {
        return new RestResponse((Object)this.service.queryDtoListByPlatformCompanyCodes(platformCompanyCodes));
    }

    public RestResponse<PageInfo<NationalSupplementAreaRuleExportDetailDto>> pageQueryDetails(@RequestBody NationalSupplementAreaRulePageReqDto dto) {
        RestResponse resp = this.service.page(dto);
        PageInfo eoPage = (PageInfo)RestResponseHelper.extractData((RestResponse)resp);
        List list = eoPage.getList().stream().flatMap(k -> k.getPlatformCompanies().stream().map(platformCompany -> {
            NationalSupplementAreaRuleExportDetailDto c = NationalSupplementAreaRuleConverter.INSTANCE.toExportDetail(k);
            c.setPlatformCompanyCode(platformCompany.getCode());
            c.setPlatformCompanyName(platformCompany.getName());
            return c;
        })).collect(Collectors.toList());
        PageInfo page = new PageInfo();
        page.setPageNum(eoPage.getPageNum());
        page.setPageSize(eoPage.getPageSize());
        page.setTotal(eoPage.getTotal());
        page.setList(list);
        page.calcByNavigatePages(8);
        return new RestResponse((Object)page);
    }
}

