/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.rest.entity;

import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.account.proxy.biz.IAccountApiProxy;
import com.yunxi.dg.base.center.report.proxy.customer.IDgOrganizationQueryApiProxy;
import com.yunxi.dg.base.center.trade.api.entity.IPayRecordApi;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderSnapshotDomain;
import com.yunxi.dg.base.center.trade.dto.entity.PayRecordDto;
import com.yunxi.dg.base.center.trade.dto.entity.PayRecordPageReqDto;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderSnapshotEo;
import com.yunxi.dg.base.center.trade.service.entity.IPayRecordService;
import com.yunxi.dg.base.center.trade.utils.AccountTypeUtils;
import com.yunxi.dg.base.commons.dto.BaseDto;
import io.swagger.annotations.Api;
import java.util.Collection;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8ba2\u5355\u4e2d\u5fc3:\u4ea4\u6613\u652f\u4ed8\u8bb0\u5f55"})
public class PayRecordController
implements IPayRecordApi {
    @Resource
    private IPayRecordService service;
    @Resource
    private AccountTypeUtils accountTypeUtils;
    @Resource
    private IAccountApiProxy accountApiProxy;
    @Resource
    private IDgOrganizationQueryApiProxy dgOrganizationQueryApiProxy;
    @Resource
    private IDgPerformOrderSnapshotDomain dgPerformOrderSnapshotDomain;
    @Resource
    private IDgPerformOrderInfoDomain dgPerformOrderInfoDomain;

    public RestResponse<Long> insert(@RequestBody PayRecordDto dto) {
        return this.service.insert((BaseDto)dto);
    }

    public RestResponse update(@RequestBody PayRecordDto dto) {
        return this.service.update((BaseDto)dto);
    }

    public RestResponse<PayRecordDto> get(Long id) {
        return this.service.get(id);
    }

    public RestResponse logicDelete(@PathVariable(name="id", required=true) Long id) {
        return this.service.logicDelete(id);
    }

    public RestResponse<PageInfo<PayRecordDto>> page(@RequestBody PayRecordPageReqDto dto) {
        PageInfo data = this.service.queryPage(dto);
        if (CollectionUtils.isNotEmpty((Collection)data.getList())) {
            DgPerformOrderInfoEo dgPerformOrderInfoEo = this.dgPerformOrderInfoDomain.queryByOrderNo(((PayRecordDto)data.getList().get(0)).getOrderNo());
            DgPerformOrderSnapshotEo snapshotEo = this.dgPerformOrderSnapshotDomain.selectByOrderId(dgPerformOrderInfoEo.getId());
            for (PayRecordDto payRecordDto : data.getList()) {
                payRecordDto.setSaleCompanyCode(snapshotEo.getEnterpriseCode());
                payRecordDto.setSaleCompanyName(snapshotEo.getEnterpriseName());
            }
        }
        return new RestResponse((Object)data);
    }
}

