/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.rest.order;

import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.center.trade.api.order.IPerformOrderApi;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgBizAfterSaleOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.TradeOrder2TransferReqDto;
import com.yunxi.dg.base.center.trade.service.oms.b2c.IDgOmsOrderService;
import com.yunxi.dg.base.center.trade.service.oms.common.IOrderCommonHandleService;
import com.yunxi.dg.base.center.trade.statemachine.handler.IDgB2CAfterSaleStatemachineHandle;
import java.math.BigDecimal;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/dg/b2c/sale/order"})
public class PerformOrderApiRest
implements IPerformOrderApi {
    @Resource
    private IOrderCommonHandleService orderCommonHandleService;
    @Resource
    IDgOmsOrderService dgOmsOrderService;
    @Resource
    private IDgB2CAfterSaleStatemachineHandle afterSaleStatemachineHandle;

    public RestResponse<Void> executeTradeOrder2Transfer(TradeOrder2TransferReqDto reqDto) {
        this.orderCommonHandleService.executeTradeOrder2Transfer(reqDto);
        return RestResponse.VOID;
    }

    public RestResponse<String> reCalByOrderNo(String orderNo) {
        return new RestResponse((Object)this.dgOmsOrderService.reCalByOrderNo(orderNo));
    }

    public RestResponse<String> reCalByAfterOrderNo(String orderNo) {
        return new RestResponse((Object)this.dgOmsOrderService.reCalByAfterOrderNo(orderNo));
    }

    public RestResponse<String> reCalAfterOrder(String orderNo, BigDecimal amount) {
        return new RestResponse((Object)this.dgOmsOrderService.reCalAfterOrder(orderNo, amount));
    }

    public RestResponse<String> reCalAfterOrderByPlatformRefundOrderSn(String platformRefundOrderSn) {
        return new RestResponse((Object)this.dgOmsOrderService.reCalAfterOrderByPlatformRefundOrderSn(platformRefundOrderSn));
    }

    public RestResponse<String> reSaveSupplyPrice(String orderNo) {
        return new RestResponse((Object)this.dgOmsOrderService.reSaveSupplyPrice(orderNo));
    }

    public RestResponse<Void> reSaveReturnShippingNo(String afterOrderNo) {
        DgBizAfterSaleOrderReqDto dgBizAfterSaleOrderReqDto = this.dgOmsOrderService.reSaveReturnShippingNo(afterOrderNo);
        return this.afterSaleStatemachineHandle.modifyShipping("THTK", dgBizAfterSaleOrderReqDto.getId(), dgBizAfterSaleOrderReqDto);
    }

    public RestResponse<String> reSaveShippingNo(String orderNo) {
        return new RestResponse((Object)this.dgOmsOrderService.reSaveShippingNo(orderNo));
    }
}

