/*
 * Decompiled with CFR 0.152.
 */
package com.wh.center.data.api.dto.response;

import cn.hutool.core.util.StrUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.wh.center.data.api.dto.request.AreaNameReqDto;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class AreaNodeDto {
    @JsonIgnore
    private transient AreaNodeDto parent;
    @ApiModelProperty(value="\u7c7b\u578b\uff0c0-\u7701\uff0c1-\u5e02\uff0c2-\u533a")
    private Integer levelId;
    @ApiModelProperty(value="\u7f16\u7801")
    private String code;
    @ApiModelProperty(value="\u540d\u79f0")
    private String name;
    @ApiModelProperty(value="\u522b\u540d\u805a\u5408")
    private List<String> aliases;
    private List<AreaNodeDto> children;

    public static List<AreaNodeDto> parse(List<AreaNameReqDto> reqList) {
        if (reqList == null || reqList.isEmpty()) {
            return new ArrayList<AreaNodeDto>(0);
        }
        return AreaNodeDto.merge(AreaNodeDto.parse(null, reqList));
    }

    public static List<AreaNodeDto> merge(List<AreaNodeDto> nodes) {
        if (nodes == null || nodes.isEmpty()) {
            return new ArrayList<AreaNodeDto>(0);
        }
        ArrayList<AreaNodeDto> result = new ArrayList<AreaNodeDto>(nodes);
        List hasCodeList = result.stream().filter(s -> StrUtil.isNotBlank((CharSequence)s.getCode())).collect(Collectors.toList());
        Map<String, List<AreaNodeDto>> codeGroup = hasCodeList.stream().collect(Collectors.groupingBy(AreaNodeDto::getCode));
        result.removeAll(hasCodeList);
        codeGroup.forEach((code, values) -> {
            AreaNodeDto node = (AreaNodeDto)values.get(0);
            AreaNodeDto.append(node, values);
            result.add(node);
        });
        result.forEach(node -> {
            node.children = AreaNodeDto.merge(node.children);
        });
        return result;
    }

    private static void append(AreaNodeDto node, List<AreaNodeDto> values) {
        node.aliases.addAll(values.stream().flatMap(s -> s.getAliases().stream()).distinct().collect(Collectors.toList()));
        node.children = values.stream().flatMap(s -> s.children.stream()).collect(Collectors.toList());
        node.distinct();
    }

    private static List<AreaNodeDto> parse(AreaNodeDto parent, List<AreaNameReqDto> reqList) {
        if (reqList == null || reqList.isEmpty()) {
            return new ArrayList<AreaNodeDto>(0);
        }
        return reqList.stream().map(req -> {
            AreaNodeDto node = new AreaNodeDto();
            node.parent = parent;
            node.levelId = req.getLevelId();
            node.aliases = new ArrayList<String>();
            node.aliases.add(req.getName());
            node.children = AreaNodeDto.parse(node, req.getChildren());
            return node;
        }).collect(Collectors.toList());
    }

    public static String nameCacheKeys(String parentCode, Integer levelId, String childName) {
        return "Area:Name:" + (StrUtil.isNotBlank((CharSequence)parentCode) ? parentCode : "0") + "-" + levelId + "-" + childName;
    }

    public List<String> nameCacheKeys() {
        String parentCode = this.parent == null ? "0" : this.parent.getCode();
        return this.names().stream().map(k -> AreaNodeDto.nameCacheKeys(parentCode, this.levelId, k)).collect(Collectors.toList());
    }

    public void distinct() {
        this.aliases = this.aliases.stream().distinct().collect(Collectors.toList());
        this.children = this.children.stream().distinct().collect(Collectors.toList());
    }

    @JsonIgnore
    public Set<String> names() {
        HashSet<String> names = new HashSet<String>(this.aliases);
        if (StrUtil.isNotBlank((CharSequence)this.name)) {
            names.add(this.name);
        }
        return names;
    }

    public AreaNodeDto getParent() {
        return this.parent;
    }

    public void setParent(AreaNodeDto parent) {
        this.parent = parent;
    }

    public Integer getLevelId() {
        return this.levelId;
    }

    public void setLevelId(Integer levelId) {
        this.levelId = levelId;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public void setAliases(List<String> aliases) {
        this.aliases = aliases;
    }

    public List<AreaNodeDto> getChildren() {
        return this.children;
    }

    public void setChildren(List<AreaNodeDto> children) {
        this.children = children;
    }
}

