/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.scheduler;

import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderExtensionDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoQueryDomain;
import com.yunxi.dg.base.center.trade.dto.entity.OperationLogDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderExtensionEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.center.trade.service.oms.b2c.IDgOmsOrderOptService;
import com.yunxi.dg.base.center.trade.statemachine.b2c.order.constant.DgB2COrderMachineEvents;
import com.yunxi.dg.base.center.trade.statemachine.b2c.order.execute.DgB2COrderStatemachineExecutor;
import com.yunxi.dg.base.center.trade.statemachine.handler.IOperationLogHandle;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="automaticUnhookRangeJob")
@Scope(value="prototype")
public class AutomaticUnhookRangeJob
extends SingleTupleScheduleEvent {
    private static final Logger log = LoggerFactory.getLogger(AutomaticUnhookRangeJob.class);
    @Resource
    private IDgOmsOrderOptService omsOrderOptService;
    @Resource
    private IDgOmsOrderInfoQueryDomain domain;
    @Resource
    private DgB2COrderStatemachineExecutor dgB2COrderStatemachineExecutor;
    @Resource
    private IDgPerformOrderExtensionDomain dgPerformOrderExtensionDomain;
    @Resource
    private IDgPerformOrderInfoDomain dgPerformOrderInfoDomain;
    @Resource
    private IOperationLogHandle operationLogHandle;

    public void before(TaskMsg taskMsg) {
    }

    public boolean execute(TaskMsg taskMsg) {
        try {
            log.info("\u4ea4\u6613\u81ea\u52a8\u89e3\u6302:{}", (Object)JSON.toJSONString((Object)taskMsg));
            JSONObject jsonObject = JSON.parseObject((String)taskMsg.getContent());
            Long balanceAddLogId = jsonObject.getLong("addLogId");
            DgPerformOrderRespDto dgPerformOrderRespDto = this.domain.queryDtoById(balanceAddLogId);
            DgPerformOrderExtensionEo dgPerformOrderExtensionEo = (DgPerformOrderExtensionEo)((ExtQueryChainWrapper)this.dgPerformOrderExtensionDomain.filter().eq((Object)"order_id", (Object)balanceAddLogId)).one();
            if ("-".equals(dgPerformOrderExtensionEo.getAutoUnhangDate())) {
                log.info("\u5df2\u7ecf\u624b\u52a8\u89e3\u6302");
                return true;
            }
            this.dgB2COrderStatemachineExecutor.executeStatemachine(dgPerformOrderRespDto.getBizModel(), balanceAddLogId, (Object)"", (Object)DgB2COrderMachineEvents.STATUS_UNLOCK);
            this.extractedGenerateLog(balanceAddLogId);
            DgPerformOrderInfoEo queryById = (DgPerformOrderInfoEo)this.dgPerformOrderInfoDomain.selectByPrimaryKey(dgPerformOrderExtensionEo.getOrderId());
            queryById.setUpdateTime(new Date());
            this.dgPerformOrderInfoDomain.updateSelective((BaseEo)queryById);
            dgPerformOrderExtensionEo.setAutoUnhangDate("-");
            this.dgPerformOrderExtensionDomain.updateSelective((BaseEo)dgPerformOrderExtensionEo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return true;
        }
        return true;
    }

    private void extractedGenerateLog(Long balanceAddLogId) {
        OperationLogDto operationLogDto = new OperationLogDto();
        operationLogDto.setOptLinkCode(balanceAddLogId.toString());
        operationLogDto.setOptEntry("PERFORM_ORDER");
        long l = IdUtil.getSnowflake().nextId();
        operationLogDto.setOptCorrelationId(String.valueOf(l));
        long l1 = IdUtil.getSnowflake().nextId();
        operationLogDto.setOptTraceId(String.valueOf(l1));
        operationLogDto.setOptLinkType("PERFORM_ORDER");
        operationLogDto.setOptPerson("system");
        operationLogDto.setOptTime(new Date());
        operationLogDto.setOptEntry("\u8ba2\u5355\u89e3\u6302");
        operationLogDto.setOptEntryCode("\u8ba2\u5355\u89e3\u6302");
        operationLogDto.setOptDetails("\u89e6\u53d1\u4e8b\u4ef6-\u8ba2\u5355\u81ea\u52a8\u89e3\u6302");
        operationLogDto.setOptDetailsCode("STATUS_UNLOCK");
        operationLogDto.setOptResult("SUCCESS");
        operationLogDto.setOptContent("\u3010\u8ba2\u5355\u81ea\u52a8\u89e3\u6302\u3011");
        this.operationLogHandle.manuallyInsertLog(operationLogDto);
    }

    public void after(TaskMsg taskMsg) {
    }
}

