/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.scheduler;

import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.AbstractSingleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import com.dtyunxi.yundt.cube.center.trade.api.constant.DgF2BOrderStatus;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.CancelReqDto;
import com.yunxi.dg.base.center.trade.constants.DgPerformOrderBizModelEnum;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoQueryDomain;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.statemachine.handler.IDgF2BOrderStatemachineHandle;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.MDC;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="f2bAutoCancelOrder")
@Scope(value="prototype")
public class F2BOrderCancleScheduler
extends AbstractSingleScheduleEvent {
    @Resource
    private IDgOmsOrderInfoQueryDomain dgOmsOrderInfoQueryDomain;
    @Resource
    private IDgF2BOrderStatemachineHandle dgF2BOrderStatemachineHandle;
    private static final String AUTO_CANCEL_REASON = "\u672a\u652f\u4ed8\u8ba2\u5355\u8fc7\u671f\u81ea\u52a8\u53d6\u6d88";

    public void before(TaskMsg taskMsg) {
        MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
    }

    public boolean execute(TaskMsg taskMsg) {
        DgPerformOrderRespDto dgBizPerformOrderRespDto = this.dgOmsOrderInfoQueryDomain.queryDtoByOrderNo(taskMsg.getContent());
        if (Objects.equals(dgBizPerformOrderRespDto.getOrderStatus(), DgF2BOrderStatus.WAIT_PAY.getCode())) {
            CancelReqDto cancelReqDto = new CancelReqDto();
            cancelReqDto.setOrderId(dgBizPerformOrderRespDto.getId());
            cancelReqDto.setTradeNo(dgBizPerformOrderRespDto.getSaleOrderNo());
            cancelReqDto.setCancelDesc("");
            cancelReqDto.setCancelType("auto_cancle");
            this.dgF2BOrderStatemachineHandle.cancelByOrder(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), dgBizPerformOrderRespDto.getId(), AUTO_CANCEL_REASON);
        }
        return true;
    }

    public void after(TaskMsg taskMsg) {
    }
}

