/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.action.oms.B2B.Impl;

import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.center.source.dto.entity.DgSourceOrderResultRespDto;
import com.yunxi.dg.base.center.trade.action.oms.B2B.IB2BOrderSplitAction;
import com.yunxi.dg.base.center.trade.constants.DgOmsSaleOrderStatus;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderLineBizQueryDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgSplitChildOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgSplitOrderBySkuReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgSplitOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.service.oms.b2b.IB2BOrderSplitService;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class B2BOrderSplitActionImpl
implements IB2BOrderSplitAction {
    private static final Logger log = LoggerFactory.getLogger(B2BOrderSplitActionImpl.class);
    @Resource
    private IB2BOrderSplitService b2bOrderSplitService;
    @Resource
    private IDgOmsOrderLineBizQueryDomain omsOrderLineBizQueryDomain;

    @Override
    public RestResponse<List<DgPerformOrderRespDto>> splitOrderBySourceResult(DgPerformOrderRespDto respDto, DgSourceOrderResultRespDto sourceOrderResultRespDto) {
        return new RestResponse(this.b2bOrderSplitService.splitOrderBySourceResult(respDto, sourceOrderResultRespDto));
    }

    @Override
    public RestResponse<List<DgPerformOrderRespDto>> splitOrder(DgPerformOrderRespDto respDto, DgSplitOrderReqDto splitOrderReqDto) {
        List orderLineDtoList = this.omsOrderLineBizQueryDomain.queryOrderLineInfoByOrderId(respDto.getId());
        splitOrderReqDto.setInitOrderStatus(DgOmsSaleOrderStatus.CREATED.getCode());
        splitOrderReqDto.setInitOmsOrderStatus(DgOmsSaleOrderStatus.CREATED.getCode());
        return new RestResponse(this.b2bOrderSplitService.splitOrder(respDto, orderLineDtoList, splitOrderReqDto));
    }

    @Override
    public RestResponse<List<DgPerformOrderRespDto>> splitOrderBySkus(DgPerformOrderRespDto respDto, DgSplitOrderBySkuReqDto splitOrderBySkuReqDto) {
        DgSplitOrderReqDto splitOrderReqDto = new DgSplitOrderReqDto();
        splitOrderReqDto.setInitOrderStatus(DgOmsSaleOrderStatus.CREATED.getCode());
        splitOrderReqDto.setInitOmsOrderStatus(DgOmsSaleOrderStatus.CREATED.getCode());
        DgPerformOrderItemReqDto reqDto = new DgPerformOrderItemReqDto();
        reqDto.setSkuCodeList(splitOrderBySkuReqDto.getSkuCodeList());
        List saleOrderRespDtoList = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderSkus(reqDto);
        ArrayList<DgSplitChildOrderReqDto> orderList = new ArrayList<DgSplitChildOrderReqDto>();
        ArrayList orderLineList = new ArrayList();
        saleOrderRespDtoList.forEach(orderLine -> {
            DgPerformOrderLineDto orderLineDto = new DgPerformOrderLineDto();
            orderLineDto.setId(orderLine.getId());
            orderLineDto.setSplitItemNum(orderLine.getSplitItemNum());
            orderLineList.add(orderLineDto);
        });
        DgSplitChildOrderReqDto splitChildOrderReqDto = new DgSplitChildOrderReqDto();
        splitChildOrderReqDto.setOrderLineDtoList(orderLineList);
        orderList.add(splitChildOrderReqDto);
        splitOrderReqDto.setOrderList(orderList);
        List orderLineDtoList = this.omsOrderLineBizQueryDomain.queryOrderLineInfoByOrderId(respDto.getId());
        return new RestResponse(this.b2bOrderSplitService.splitOrder(respDto, orderLineDtoList, splitOrderReqDto));
    }

    @Override
    public RestResponse<Void> reCalculatorAmountAction(DgPerformOrderRespDto respDto, List<DgPerformOrderRespDto> orderRespDtoList) {
        this.b2bOrderSplitService.modifyChildOrderBySplit(respDto, orderRespDtoList);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> recoveryOrderSplitReleation(Long orderId) {
        this.b2bOrderSplitService.recoveryOrderSplitReleation(orderId);
        return RestResponse.VOID;
    }
}

