/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.action.oms.channel.Impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.order.activity.OrderActivityInfoJoinReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.order.activity.OrderActivityInfoReqDto;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.shop.dto.response.DgShopRespDto;
import com.yunxi.dg.base.center.trade.action.oms.channel.IChannelOrderCreate;
import com.yunxi.dg.base.center.trade.action.oms.channel.Impl.ChannelAbstractOrderCreate;
import com.yunxi.dg.base.center.trade.constants.DgGoodItemDeliveryStatusEnum;
import com.yunxi.dg.base.center.trade.constants.DgPerformOrderBizModelEnum;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderPaymentDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgF2BPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderAddrReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.OrderFeeControlRespDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.DgF2BOrderContextVo;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.DgOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.DgShopOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.preview.DgOrderPreviewReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.order.DgOrderResultRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.order.DgShopOrderResultRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.preview.DgF2BOrderPreviewContext;
import com.yunxi.dg.base.center.trade.service.oms.channel.IChannelAccountService;
import com.yunxi.dg.base.center.trade.service.oms.channel.IChannelActiveService;
import com.yunxi.dg.base.center.trade.service.oms.channel.IChannelBasicInfoService;
import com.yunxi.dg.base.center.trade.service.oms.channel.IChannelCalculatorService;
import com.yunxi.dg.base.center.trade.service.oms.channel.IChannelCustomerService;
import com.yunxi.dg.base.center.trade.service.oms.channel.IChannelFeeControlService;
import com.yunxi.dg.base.center.trade.service.oms.channel.IChannelInventoryService;
import com.yunxi.dg.base.center.trade.service.oms.channel.IChannelItemService;
import com.yunxi.dg.base.center.trade.service.oms.channel.IChannelOrderService;
import com.yunxi.dg.base.center.trade.service.oms.channel.IChannelShopService;
import com.yunxi.dg.base.center.trade.utils.NoGreateUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="channelCustomOrderCreateImpl")
public class ChannelCustomOrderCreateImpl
extends ChannelAbstractOrderCreate
implements IChannelOrderCreate {
    private static final Logger log = LoggerFactory.getLogger(ChannelCustomOrderCreateImpl.class);
    @Resource
    private IChannelCustomerService channelCustomerService;
    @Resource
    private IChannelShopService channelShopService;
    @Resource
    private IChannelBasicInfoService channelBasicInfoService;
    @Resource
    private IChannelActiveService channelActiveService;
    @Resource
    private IChannelAccountService channelCostAccountService;
    @Resource(name="channelCustomItemServiceImpl")
    private IChannelItemService channelItemService;
    @Resource
    private IChannelCalculatorService channelCalculatorService;
    @Resource
    private IChannelFeeControlService channelFeeControlService;
    @Resource
    private IChannelOrderService channelOrderService;
    @Resource
    private IChannelInventoryService channelInventoryService;
    @Resource
    private NoGreateUtil noGreateUtil;

    @Override
    public DgF2BOrderPreviewContext execute(DgOrderPreviewReqDto previewReqDto) {
        log.info("=================\u5b9a\u5236\u54c1\u8ba2\u5355\u9884\u89c8\u6d41\u7a0b\u6267\u884c begin=====================");
        DgF2BOrderPreviewContext f2BOrderPreviewContext = new DgF2BOrderPreviewContext();
        f2BOrderPreviewContext.setOrderType(previewReqDto.getOrderType());
        f2BOrderPreviewContext.setSaleOrderNo(previewReqDto.getSaleOrderNo());
        DgF2BOrderContextVo f2BOrderContextVo = new DgF2BOrderContextVo();
        f2BOrderContextVo.setPreviewReqDto(previewReqDto);
        this.channelCustomerService.supplementAndCheckInfo(f2BOrderContextVo, f2BOrderPreviewContext);
        this.channelShopService.supplementAndCheckInfo(f2BOrderContextVo, f2BOrderPreviewContext);
        this.channelBasicInfoService.supplementSnapshotDtoInfo(f2BOrderContextVo, f2BOrderPreviewContext, null);
        this.channelInventoryService.supplementAndCheckInfo(f2BOrderContextVo, f2BOrderPreviewContext);
        this.channelCostAccountService.supplementAndCheckInfo(f2BOrderContextVo, f2BOrderPreviewContext);
        this.channelBasicInfoService.supplementAndCheckAdvanceOrderInfo(f2BOrderContextVo, f2BOrderPreviewContext);
        this.channelItemService.supplementAndCheckInfo(f2BOrderContextVo, f2BOrderPreviewContext);
        this.channelFeeControlService.supplementAndCheckInfo(f2BOrderContextVo, f2BOrderPreviewContext);
        this.channelBasicInfoService.setAdvanceOrderInfo(f2BOrderContextVo, f2BOrderPreviewContext);
        this.channelCalculatorService.calcOrderBasicAmount(f2BOrderPreviewContext);
        this.channelCalculatorService.dealHandmadeDiscountYdd(f2BOrderPreviewContext);
        this.channelCostAccountService.queryAccountDto(f2BOrderPreviewContext);
        this.channelCostAccountService.setYdjAmount(f2BOrderPreviewContext);
        OrderFeeControlRespDto orderFeeControlRespDto = this.channelFeeControlService.feeControl(f2BOrderPreviewContext);
        this.channelCostAccountService.setAccountMaxPayAmount(f2BOrderPreviewContext);
        this.channelCalculatorService.suggestAccountPay(f2BOrderPreviewContext, orderFeeControlRespDto);
        log.info("=================\u5b9a\u5236\u54c1\u8ba2\u5355\u9884\u89c8\u6d41\u7a0b\u6267\u884c end=====================");
        return f2BOrderPreviewContext;
    }

    @Override
    public DgOrderResultRespDto saveExecute(DgOrderReqDto dgOrderReqDto) {
        log.info("\u8ba2\u5355\u4fdd\u5b58\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)dgOrderReqDto));
        this.channelBasicInfoService.checkIsOverdue(dgOrderReqDto);
        DgOrderPreviewReqDto previewReqDto = this.channelBasicInfoService.checkAndTransformOrderData(dgOrderReqDto);
        DgF2BOrderContextVo f2BOrderContextVo = new DgF2BOrderContextVo();
        f2BOrderContextVo.setPreviewReqDto(previewReqDto);
        DgF2BOrderPreviewContext f2BOrderPreviewContext = new DgF2BOrderPreviewContext();
        f2BOrderPreviewContext.setOrderType(previewReqDto.getOrderType());
        f2BOrderPreviewContext.setBizModel(DgPerformOrderBizModelEnum.F2B_ORDER.getCode());
        f2BOrderPreviewContext.setDefPreviewOpt(dgOrderReqDto.getDefPreviewOpt());
        this.channelCustomerService.supplementAndCheckInfo(f2BOrderContextVo, f2BOrderPreviewContext);
        this.channelShopService.supplementAndCheckInfo(f2BOrderContextVo, f2BOrderPreviewContext);
        DgShopRespDto shopRespDto = f2BOrderContextVo.getShopRespDto();
        String saleOrderNo = this.noGreateUtil.generateSaleOrderNoByShop(shopRespDto.getStoreCode(), ((DgShopOrderReqDto)dgOrderReqDto.getShopOrderReqDtoList().get(0)).getSaleOrderNo());
        ((DgShopOrderReqDto)dgOrderReqDto.getShopOrderReqDtoList().get(0)).setSaleOrderNo(saleOrderNo);
        f2BOrderPreviewContext.setSaleOrderNo(saleOrderNo);
        this.channelBasicInfoService.supplementSnapshotDtoInfo(f2BOrderContextVo, f2BOrderPreviewContext, dgOrderReqDto);
        this.channelInventoryService.supplementAndCheckInfo(f2BOrderContextVo, f2BOrderPreviewContext);
        this.channelCostAccountService.supplementAndCheckInfo(f2BOrderContextVo, f2BOrderPreviewContext);
        this.channelBasicInfoService.supplementAndCheckAdvanceOrderInfo(f2BOrderContextVo, f2BOrderPreviewContext);
        this.channelItemService.supplementAndCheckInfo(f2BOrderContextVo, f2BOrderPreviewContext);
        this.channelFeeControlService.supplementAndCheckInfo(f2BOrderContextVo, f2BOrderPreviewContext);
        this.channelBasicInfoService.setAdvanceOrderInfo(f2BOrderContextVo, f2BOrderPreviewContext);
        this.channelCalculatorService.calcOrderBasicAmount(f2BOrderPreviewContext);
        this.channelCalculatorService.dealHandmadeDiscountYdd(f2BOrderPreviewContext);
        this.channelCostAccountService.queryAccountDto(f2BOrderPreviewContext);
        this.channelCostAccountService.setYdjAmount(f2BOrderPreviewContext);
        this.channelBasicInfoService.supplementExtraInfo(f2BOrderContextVo, f2BOrderPreviewContext, dgOrderReqDto);
        DgBizPerformOrderReqDto dgBizPerformOrderReqDto = this.buildDgBizPerformOrderReqDto(f2BOrderPreviewContext.getDgF2BPerformOrderReqDto(), (DgShopOrderReqDto)dgOrderReqDto.getShopOrderReqDtoList().get(0), f2BOrderPreviewContext);
        DgShopOrderResultRespDto resultRespDto = this.channelOrderService.saveOrder(dgBizPerformOrderReqDto);
        this.channelCostAccountService.advanceDepositRepay(dgBizPerformOrderReqDto);
        DgOrderResultRespDto dgOrderResultRespDto = new DgOrderResultRespDto();
        dgOrderResultRespDto.setOrganizationId(dgOrderReqDto.getOrganizationId());
        dgOrderResultRespDto.setCustomerId(dgOrderReqDto.getCustomerId());
        dgOrderResultRespDto.setEnterpriseId(dgOrderReqDto.getEnterpriseId());
        ArrayList<DgShopOrderResultRespDto> dgShopOrderResultRespDtos = new ArrayList<DgShopOrderResultRespDto>();
        dgShopOrderResultRespDtos.add(resultRespDto);
        dgOrderResultRespDto.setShopOrderResultRespDtos(dgShopOrderResultRespDtos);
        dgOrderResultRespDto.setDgBizPerformOrderReqDto(dgBizPerformOrderReqDto);
        return dgOrderResultRespDto;
    }

    @Override
    public DgOrderResultRespDto saveAfterExecute(DgOrderResultRespDto resultRespDto, DgOrderReqDto dgOrderReqDto) {
        return super.saveAfterExecute(resultRespDto, dgOrderReqDto);
    }

    private DgBizPerformOrderReqDto buildDgBizPerformOrderReqDto(DgF2BPerformOrderReqDto f2BPerformOrderReqDto, DgShopOrderReqDto dgShopOrderReqDto, DgF2BOrderPreviewContext dgF2BOrderPreviewContext) {
        DgBizPerformOrderReqDto dgBizPerformOrderReqDto = new DgBizPerformOrderReqDto();
        BeanUtil.copyProperties((Object)f2BPerformOrderReqDto, (Object)dgBizPerformOrderReqDto, (String[])new String[0]);
        dgBizPerformOrderReqDto.setId(dgShopOrderReqDto.getId());
        dgBizPerformOrderReqDto.setBizModel(dgF2BOrderPreviewContext.getBizModel());
        dgBizPerformOrderReqDto.setOrderType(dgF2BOrderPreviewContext.getOrderType());
        dgBizPerformOrderReqDto.setBizType(dgF2BOrderPreviewContext.getOrderType());
        dgBizPerformOrderReqDto.setRemark(dgShopOrderReqDto.getRemark());
        dgBizPerformOrderReqDto.setDeliveryDate(dgShopOrderReqDto.getDeliveryDate());
        dgBizPerformOrderReqDto.setSaleOrderNo(dgShopOrderReqDto.getSaleOrderNo());
        dgBizPerformOrderReqDto.setSubmitFlag(dgF2BOrderPreviewContext.getDefPreviewOpt() == 2);
        dgBizPerformOrderReqDto.setDeliveryStatus(DgGoodItemDeliveryStatusEnum.WAIT_DELIVERY.getCode());
        DgPerformOrderPaymentDto performOrderPaymentDto = new DgPerformOrderPaymentDto();
        performOrderPaymentDto.setPayStatus(Integer.valueOf(0));
        BigDecimal[] totalUseCostAmount = new BigDecimal[]{BigDecimal.ZERO};
        BigDecimal itemTotalUseAmount = f2BPerformOrderReqDto.getItemList().stream().map(DgPerformOrderItemDto::getTotalUseCostAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        totalUseCostAmount[0] = totalUseCostAmount[0].add(itemTotalUseAmount);
        List itemList = BeanUtil.copyToList((Collection)f2BPerformOrderReqDto.getItemList(), DgPerformOrderItemReqDto.class);
        dgBizPerformOrderReqDto.setItemList(itemList);
        if (CollectionUtils.isNotEmpty((Collection)f2BPerformOrderReqDto.getMaterialList())) {
            List materialList = BeanUtil.copyToList((Collection)f2BPerformOrderReqDto.getMaterialList(), DgPerformOrderItemReqDto.class);
            log.info("\u4fdd\u5b58\u8ba2\u5355\u524d\u7684\u4fc3\u9500\u7269\u6599\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)materialList));
            materialList.forEach(e -> {
                e.setPayAmount(BigDecimal.ZERO);
                e.setTotalUseCostAmount(e.getItemMarketPrice().multiply(e.getCalcItemNum()));
                totalUseCostAmount[0] = totalUseCostAmount[0].add(e.getTotalUseCostAmount());
            });
            dgBizPerformOrderReqDto.setMaterialList(materialList);
        }
        if (CollectionUtils.isNotEmpty((Collection)dgF2BOrderPreviewContext.getGiftItemList())) {
            List giftList = BeanUtil.copyToList((Collection)dgF2BOrderPreviewContext.getGiftItemList(), DgPerformOrderItemReqDto.class);
            log.info("\u4fdd\u5b58\u8ba2\u5355\u524d\u7684\u8d60\u54c1\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)giftList));
            giftList.forEach(e -> {
                e.setPayAmount(BigDecimal.ZERO);
                e.setTotalUseCostAmount(BigDecimal.ZERO);
                e.setDiscountAmount(e.getItemMarketPrice().multiply(e.getCalcItemNum()));
                totalUseCostAmount[0] = totalUseCostAmount[0].add(e.getTotalUseCostAmount());
            });
            dgBizPerformOrderReqDto.setGiftList(giftList);
        }
        performOrderPaymentDto.setTotalUseCostAmount(totalUseCostAmount[0]);
        BigDecimal remainingPayAmount = itemList.stream().map(DgPerformOrderItemDto::getRealPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        performOrderPaymentDto.setRemainingPayAmount(remainingPayAmount);
        dgBizPerformOrderReqDto.setPerformOrderPaymentDto(performOrderPaymentDto);
        dgBizPerformOrderReqDto.setDgOrderAmountDtos(dgF2BOrderPreviewContext.getDgOrderAmountDtos());
        dgBizPerformOrderReqDto.setOrderItemPriceDtos(dgF2BOrderPreviewContext.getOrderItemPriceDtos());
        dgBizPerformOrderReqDto.setOrderStatus(dgShopOrderReqDto.getOrderStatus());
        dgBizPerformOrderReqDto.setCreditFileNo(f2BPerformOrderReqDto.getCreditFileNo());
        dgBizPerformOrderReqDto.setOrderAddrReqDto(dgShopOrderReqDto.getOrderAddrReqDto());
        if (Objects.nonNull(f2BPerformOrderReqDto.getActivity()) && CollectionUtils.isNotEmpty((Collection)f2BPerformOrderReqDto.getActivity().getActivityList())) {
            OrderActivityInfoJoinReqDto activity = f2BPerformOrderReqDto.getActivity();
            Map activityDiscountMap = dgF2BOrderPreviewContext.getActivityDiscountMap();
            for (OrderActivityInfoReqDto orderActivityInfoReqDto : activity.getActivityList()) {
                BigDecimal discountAmount = (BigDecimal)activityDiscountMap.get(orderActivityInfoReqDto.getActivityId().toString());
                orderActivityInfoReqDto.setDiscountAmount(discountAmount);
            }
            dgBizPerformOrderReqDto.setActivity(activity);
        }
        dgBizPerformOrderReqDto.getPerformOrderSnapshotDto().setKneadeFlag(f2BPerformOrderReqDto.getKneadeFlag());
        dgBizPerformOrderReqDto.setAttachmentFileList(dgShopOrderReqDto.getAttachmentFileList());
        dgBizPerformOrderReqDto.setOrderAddrReqDtos(dgShopOrderReqDto.getOrderAddrReqDto() != null ? Lists.newArrayList((Object[])new DgPerformOrderAddrReqDto[]{dgShopOrderReqDto.getOrderAddrReqDto()}) : dgShopOrderReqDto.getOrderAddrReqDtos());
        dgBizPerformOrderReqDto.setOrderAddrReqDtoWaitAudit(dgShopOrderReqDto.getOrderAddrReqDtoWaitAudit());
        dgBizPerformOrderReqDto.setAddrItemDtos(dgShopOrderReqDto.getAddrItemDtos());
        dgBizPerformOrderReqDto.setAdvanceOrderDto(dgF2BOrderPreviewContext.getAdvanceOrderDto());
        dgBizPerformOrderReqDto.setAdvanceTotalAmount(dgF2BOrderPreviewContext.getAdvanceTotalAmount());
        return dgBizPerformOrderReqDto;
    }
}

