/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.action.oms.channel.Impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.account.dto.biz.AccountTradeBatchReqDto;
import com.yunxi.dg.base.center.account.dto.biz.AccountTradeReqDto;
import com.yunxi.dg.base.center.account.proxy.biz.IAccountTradeApiProxy;
import com.yunxi.dg.base.center.credit.proxy.entity.ICreditArchiveDgApiProxy;
import com.yunxi.dg.base.center.trade.action.oms.channel.IChannelOrderDeliveryAction;
import com.yunxi.dg.base.center.trade.action.oms.common.ICommonMqMessageAction;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderTypeEnum;
import com.yunxi.dg.base.center.trade.constants.amount.DgOrderAmountCategoryEnum;
import com.yunxi.dg.base.center.trade.constants.amount.DgOrderAmountSourceEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineAmountDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoQueryDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderLineBizQueryDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformNoticeSyncRecordItemDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemLineAmountDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemLineDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderSnapshotDto;
import com.yunxi.dg.base.center.trade.dto.entity.PayRecordDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformNoticeSyncRecordDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgOutDeliveryResultReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.DgOrderNoticeCreditMqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderOutNoticeSyncRecordRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.enums.F2BOrderDeliveryStatusEnum;
import com.yunxi.dg.base.center.trade.enums.ItemLineCancelStatusEnum;
import com.yunxi.dg.base.center.trade.enums.ItemLineDeliveryStatusEnum;
import com.yunxi.dg.base.center.trade.enums.NoticeBusinessTypeEnum;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemLineEo;
import com.yunxi.dg.base.center.trade.service.entity.IDgPerformNoticeSyncRecordService;
import com.yunxi.dg.base.center.trade.service.entity.IPayRecordService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ChannelOrderDeliveryActionImpl
implements IChannelOrderDeliveryAction {
    private static final Logger log = LoggerFactory.getLogger(ChannelOrderDeliveryActionImpl.class);
    @Resource
    private ICreditArchiveDgApiProxy creditArchiveDgApiProxy;
    @Resource
    private ICommonMqMessageAction commonMqMessageAction;
    @Resource
    private IPayRecordService payRecordService;
    @Resource
    private IDgOmsOrderInfoQueryDomain omsOrderInfoQueryDomain;
    @Resource
    private IDgPerformOrderInfoDomain dgPerformOrderInfoDomain;
    @Resource
    private IDgPerformOrderLineDomain dgPerformOrderLineDomain;
    @Resource
    private IDgPerformOrderItemLineDomain performOrderItemLineDomain;
    @Resource
    private IDgOmsOrderLineBizQueryDomain omsOrderLineBizQueryDomain;
    @Resource
    private IDgPerformOrderItemLineAmountDomain performOrderItemLineAmountDomain;
    @Resource
    private IDgPerformNoticeSyncRecordService dgPerformNoticeSyncRecordService;
    @Resource
    private IAccountTradeApiProxy accountTradeApiProxy;
    @Resource
    private ICommonsMqService commonsMqService;

    @Override
    public Boolean isAllDelivery(DgPerformOrderRespDto dto) {
        List orderItemLineEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.performOrderItemLineDomain.filter().eq((Object)"order_id", (Object)dto.getId())).eq((Object)"delivery_status", (Object)ItemLineDeliveryStatusEnum.NO.getType())).eq((Object)"cancel_status", (Object)ItemLineCancelStatusEnum.NO.getType())).list();
        Boolean flag = CollectionUtils.isEmpty((Collection)orderItemLineEos);
        if (flag.booleanValue()) {
            DgPerformOrderInfoEo dgPerformOrderInfoEo = new DgPerformOrderInfoEo();
            dgPerformOrderInfoEo.setId(dto.getId());
            dgPerformOrderInfoEo.setDeliveryStatus(F2BOrderDeliveryStatusEnum.DELIVERY.getCode());
            dgPerformOrderInfoEo.setDeliveryTime(Optional.ofNullable(dto.getDeliveryTime()).orElse(new Date()));
            dgPerformOrderInfoEo.setDeliveryCompleteDate(new Date());
            this.dgPerformOrderInfoDomain.updateSelective((BaseEo)dgPerformOrderInfoEo);
        } else {
            DgPerformOrderInfoEo dgPerformOrderInfoEo = new DgPerformOrderInfoEo();
            dgPerformOrderInfoEo.setId(dto.getId());
            dgPerformOrderInfoEo.setDeliveryTime(Optional.ofNullable(dto.getDeliveryTime()).orElse(new Date()));
            dgPerformOrderInfoEo.setDeliveryStatus(F2BOrderDeliveryStatusEnum.PARTIALSHIPMENT.getCode());
            this.dgPerformOrderInfoDomain.updateSelective((BaseEo)dgPerformOrderInfoEo);
        }
        return CollectionUtils.isEmpty((Collection)orderItemLineEos);
    }

    @Override
    public RestResponse<Void> synchronizationOrderDelivery(DgPerformOrderRespDto dto, DgBizPerformNoticeSyncRecordDto req) {
        DgPerformOrderRespDto omsPerformOrderRespDto;
        DgBizPerformNoticeSyncRecordDto syncRecordDto = this.dgPerformNoticeSyncRecordService.queryByResultNoticeOrderNo(req.getResultNoticeOrderNo(), NoticeBusinessTypeEnum.OUT_RESULT.getType());
        if (null == syncRecordDto) {
            this.dgPerformNoticeSyncRecordService.saveExternalNoticeRecord(req);
        }
        if (null != (omsPerformOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoById(req.getExternalOrderId()))) {
            Integer sortNo = CollectionUtil.isNotEmpty((Collection)req.getDgPerformNoticeSyncRecordDtoItems()) ? ((DgPerformNoticeSyncRecordItemDto)req.getDgPerformNoticeSyncRecordDtoItems().get(0)).getSortNo() : -1;
            log.info("\u4f9b\u5e94\u94fe\u5185\u90e8\u8ba2\u5355\u56de\u4f20\u51fa\u5e93\u4fe1\u606f,\u51fa\u5e93\u987a\u5e8f\u53f7\uff1a{}", (Object)sortNo);
            AssertUtils.notNull((Object)omsPerformOrderRespDto, (String)"\u5916\u90e8\u8ba2\u5355\u8ba2\u5355\u4e3a\u7a7a");
            Map orderLineDtoMap = dto.getOrderLineList().stream().collect(Collectors.toMap(BaseDto::getId, Function.identity(), (a, b) -> a));
            ArrayList<DgPerformOrderItemLineEo> upPerformOrderItemLineEos = new ArrayList<DgPerformOrderItemLineEo>();
            List omsPerformOrderItemLineDtos = this.performOrderItemLineDomain.queryInfoByOrderId(omsPerformOrderRespDto.getId());
            Map<String, List<DgPerformOrderItemLineDto>> omsPerformOrderItemLineMap = omsPerformOrderItemLineDtos.stream().collect(Collectors.groupingBy(DgPerformOrderItemLineDto::getPlatformOrderItemNo));
            List performOrderItemLineDtos = this.performOrderItemLineDomain.queryInfoByOrderId(dto.getId());
            log.info("\u6e20\u9053\u8ba2\u5355\u884c\uff1a{}", CollectionUtil.isNotEmpty((Collection)performOrderItemLineDtos) ? Integer.valueOf(performOrderItemLineDtos.size()) : "0");
            ArrayList accountTradeReqDtos = Lists.newArrayList();
            for (Object itemLine : performOrderItemLineDtos) {
                List<Object> omsPerformOrderItemLineList = omsPerformOrderItemLineMap.get(itemLine.getId().toString());
                if (null == omsPerformOrderItemLineList) {
                    log.info("\u8ba2\u5355\u884c\u5bf9\u5e94\u7684\u4f9b\u5e94\u94fe\u8ba2\u5355\u884c\u6ca1\u6709\u51fa\u5e93\uff1a{}", (Object)itemLine.getId());
                    continue;
                }
                if (CollectionUtil.isNotEmpty(omsPerformOrderItemLineList = omsPerformOrderItemLineList.stream().filter(item -> Objects.equals(item.getDeliverySortNo(), sortNo)).collect(Collectors.toList()))) {
                    for (DgPerformOrderItemLineDto dgPerformOrderItemLineDto : omsPerformOrderItemLineList) {
                        DgPerformOrderItemLineEo upEo2 = new DgPerformOrderItemLineEo();
                        if (dgPerformOrderItemLineDto.getDeliveryStatus().equals(ItemLineDeliveryStatusEnum.YES.getType())) {
                            upEo2.setId(itemLine.getId());
                            if (dgPerformOrderItemLineDto.getItemNum().equals(itemLine.getItemNum())) {
                                upEo2.setOutItemNum(itemLine.getItemNum());
                                upEo2.setDeliveryStatus(ItemLineDeliveryStatusEnum.YES.getType());
                            } else {
                                log.info("\u6e20\u9053\u5546\u54c1\u884c\u6570\u91cf\uff1a{} \uff01= \u4f9b\u5e94\u94fe\u5546\u54c1\u884c\u6570\u91cf{}===>>>\u6e20\u9053\u5df2\u51fa\u5e93\u5546\u54c1\u8ba1\u4ef7\u6570\u91cf\uff1a{}", new Object[]{itemLine.getItemNum(), dgPerformOrderItemLineDto.getItemNum(), itemLine.getOutItemNum()});
                                BigDecimal waitOutNum = itemLine.getItemNum().subtract(itemLine.getOutItemNum());
                                if (waitOutNum.compareTo(dgPerformOrderItemLineDto.getItemNum()) > 0) {
                                    upEo2.setOutItemNum(itemLine.getOutItemNum().add(dgPerformOrderItemLineDto.getItemNum()));
                                    upEo2.setDeliveryStatus(ItemLineDeliveryStatusEnum.NO.getType());
                                } else {
                                    log.info("\u6e20\u9053\u5546\u54c1\u884c\u53ef\u51fa\u5e93\u6570\u91cf\u5c0f\u4e8e\u5f53\u524d\u5bf9\u5e94\u4f9b\u5e94\u94fe\u5546\u54c1\u6570\u91cf");
                                    upEo2.setOutItemNum(itemLine.getItemNum());
                                    upEo2.setDeliveryStatus(ItemLineDeliveryStatusEnum.YES.getType());
                                }
                            }
                            upEo2.setDeliveryNoticeNo(dgPerformOrderItemLineDto.getDeliveryNoticeNo());
                            accountTradeReqDtos.addAll(this.buildAccountTradeReq(dgPerformOrderItemLineDto.getPerformOrderItemLineAmountDtoList(), dto));
                            upPerformOrderItemLineEos.add(upEo2);
                            continue;
                        }
                        log.info("\u4f9b\u5e94\u94fe\u5546\u54c1\u884c\u672a\u51fa\u5e93\uff1a{}", (Object)itemLine.getId());
                    }
                    continue;
                }
                log.error("\u4f9b\u5e94\u94fe\u5185\u90e8\u8ba2\u5355\u5bf9\u5e94\u5546\u54c1\u884c\u4e0d\u5b58\u5728\u6216\u8005\u5df2\u7ecf\u51fa\u5e93");
            }
            log.info("\u66f4\u65b0\u6e20\u9053\u5546\u54c1\u884c\u51fa\u5e93\u6570\u91cf===>>\uff1a{}", (Object)upPerformOrderItemLineEos.size());
            upPerformOrderItemLineEos.forEach(upEo -> this.performOrderItemLineDomain.updateSelective((BaseEo)upEo));
            List<PayRecordDto> payRecordDtos = this.payRecordService.selectListByOrderNo(dto.getSaleOrderNo());
            for (AccountTradeReqDto accountTradeReq : accountTradeReqDtos) {
                if (StringUtils.isNotBlank((CharSequence)accountTradeReq.getSaleCompanyCode()) && StringUtils.isNotBlank((CharSequence)accountTradeReq.getAccountType())) {
                    List subPayRecordDtos = payRecordDtos.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getSellerId())).filter(e -> e.getSellerId().equals(accountTradeReq.getSaleCompanyCode()) && e.getPayMethod().equals(accountTradeReq.getAccountType())).filter(e -> StringUtils.isNotBlank((CharSequence)e.getCardNo())).collect(Collectors.toList());
                    if (CollectionUtil.isNotEmpty(subPayRecordDtos)) {
                        accountTradeReq.setCreditFileNo(((PayRecordDto)subPayRecordDtos.get(0)).getCardNo());
                        continue;
                    }
                    log.info("\u6ca1\u6709\u5339\u914d\u7684\u4ed8\u6b3e\u8bb0\u5f55\uff1a{}", (Object)JSON.toJSONString((Object)accountTradeReq));
                    continue;
                }
                log.info("\u8bf7\u6c42\u53c2\u6570\u4e0d\u6b63\u786e\uff1a{}", (Object)JSON.toJSONString((Object)accountTradeReq));
            }
            AccountTradeBatchReqDto accountTradeBatchReqDto = new AccountTradeBatchReqDto();
            if (CollectionUtils.isNotEmpty((Collection)accountTradeReqDtos)) {
                accountTradeBatchReqDto.setOrderNo(dto.getSaleOrderNo());
                accountTradeBatchReqDto.setSaleCompanyCode(dto.getPerformOrderSnapshotDto().getEnterpriseCode());
                accountTradeBatchReqDto.setCustomerNo(dto.getPerformOrderSnapshotDto().getCustomerCode());
                accountTradeBatchReqDto.setShopCode(dto.getPerformOrderSnapshotDto().getShopCode());
                accountTradeBatchReqDto.setTradeReqDtos((List)accountTradeReqDtos);
                log.info("\u51fa\u5e93\u91ca\u653e\u8bf7\u6c42\u53c2\u6570\uff1a{}", JSON.toJSON((Object)accountTradeBatchReqDto));
                RestResponseHelper.extractData((RestResponse)this.accountTradeApiProxy.outboundRelease(accountTradeBatchReqDto));
            }
            this.sendMqNoticeCredit(accountTradeBatchReqDto, dto, req);
        } else {
            log.info("\u5916\u90e8\u7cfb\u7edf\u8ba2\u5355\u56de\u4f20\u51fa\u5e93\u4fe1\u606f");
        }
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> externalOrderDelivery(DgPerformOrderRespDto dto, DgBizPerformNoticeSyncRecordDto req) {
        this.dgPerformNoticeSyncRecordService.saveExternalNoticeRecord(req);
        Map deliveryItemDtoMap = req.getDgPerformNoticeSyncRecordDtoItems().stream().collect(Collectors.toMap(DgPerformNoticeSyncRecordItemDto::getOrderItemId, Function.identity(), (e1, e2) -> e1));
        ArrayList<DgPerformOrderItemLineEo> upPerformOrderItemLineEos = new ArrayList<DgPerformOrderItemLineEo>();
        List performOrderItemLineDtos = this.performOrderItemLineDomain.queryInfoByOrderId(dto.getId());
        log.info("\u6e20\u9053\u8ba2\u5355\u884c\uff1a{}", CollectionUtil.isNotEmpty((Collection)performOrderItemLineDtos) ? Integer.valueOf(performOrderItemLineDtos.size()) : "0");
        ArrayList accountTradeReqDtos = Lists.newArrayList();
        for (Object itemLine : performOrderItemLineDtos) {
            DgPerformNoticeSyncRecordItemDto omsItemLine = (DgPerformNoticeSyncRecordItemDto)deliveryItemDtoMap.get(itemLine.getOrderLineId());
            if (null == omsItemLine) {
                log.info("\u8ba2\u5355\u884c\u5bf9\u5e94\u7684\u4f9b\u5e94\u94fe\u8ba2\u5355\u884c\u6ca1\u6709\u51fa\u5e93\uff1a{}", (Object)itemLine.getId());
                continue;
            }
            BigDecimal waitDeliveryNum = BigDecimalUtils.subtract((BigDecimal)itemLine.getItemNum(), (BigDecimal)itemLine.getOutItemNum());
            AssertUtils.isTrue((boolean)BigDecimalUtils.gt((BigDecimal)waitDeliveryNum, (BigDecimal)BigDecimal.ZERO), (String)String.format("\u5546\u54c1\u884c\u5df2\u53d1\u8d27\u5b8c\u6210\uff0c\u4e0d\u5141\u8bb8\u8d85\u53d1\uff1a%s, %s", itemLine.getOrderLineId(), itemLine.getSkuCode()));
            BigDecimal crrrDeliveryNum = omsItemLine.getQuantity();
            AssertUtils.isTrue((boolean)BigDecimalUtils.ge((BigDecimal)waitDeliveryNum, (BigDecimal)crrrDeliveryNum), (String)String.format("\u672c\u6b21\u53d1\u8d27\u6570\u91cf%s\u5927\u4e8e\u672a\u53d1\u8d27\u6570\u91cf%s\uff0c\u4e0d\u5141\u8bb8\u8d85\u53d1\uff1a%s, %s", crrrDeliveryNum, waitDeliveryNum, itemLine.getOrderLineId(), itemLine.getSkuCode()));
            DgPerformOrderItemLineEo upEo2 = new DgPerformOrderItemLineEo();
            upEo2.setId(itemLine.getId());
            if (BigDecimalUtils.equals((BigDecimal)crrrDeliveryNum, (BigDecimal)waitDeliveryNum).booleanValue()) {
                upEo2.setOutItemNum(itemLine.getItemNum());
                upEo2.setDeliveryStatus(ItemLineDeliveryStatusEnum.YES.getType());
            } else {
                log.info("\u6e20\u9053\u5546\u54c1\u884c\u6570\u91cf\uff1a{} \uff01= \u672c\u6b21\u53d1\u8d27\u5546\u54c1\u6570\u91cf{}===>>>\u6e20\u9053\u5df2\u51fa\u5e93\u5546\u54c1\u8ba1\u4ef7\u6570\u91cf\uff1a{}", new Object[]{itemLine.getItemNum(), omsItemLine.getQuantity(), itemLine.getOutItemNum()});
                upEo2.setOutItemNum(itemLine.getOutItemNum().add(crrrDeliveryNum));
                upEo2.setDeliveryStatus(ItemLineDeliveryStatusEnum.NO.getType());
            }
            upEo2.setDeliveryNoticeNo(req.getResultNoticeOrderNo());
            accountTradeReqDtos.addAll(this.buildAccountTradeReqByDeliveryNum((DgPerformOrderItemLineDto)itemLine, dto, crrrDeliveryNum));
            upPerformOrderItemLineEos.add(upEo2);
        }
        log.info("\u66f4\u65b0\u6e20\u9053\u5546\u54c1\u884c\u51fa\u5e93\u6570\u91cf===>>\uff1a{}", (Object)upPerformOrderItemLineEos.size());
        upPerformOrderItemLineEos.forEach(upEo -> this.performOrderItemLineDomain.updateSelective((BaseEo)upEo));
        List<PayRecordDto> payRecordDtos = this.payRecordService.selectListByOrderNo(dto.getSaleOrderNo());
        for (AccountTradeReqDto accountTradeReq : accountTradeReqDtos) {
            if (StringUtils.isNotBlank((CharSequence)accountTradeReq.getSaleCompanyCode()) && StringUtils.isNotBlank((CharSequence)accountTradeReq.getAccountType())) {
                List subPayRecordDtos = payRecordDtos.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getSellerId())).filter(e -> e.getSellerId().equals(accountTradeReq.getSaleCompanyCode()) && e.getPayMethod().equals(accountTradeReq.getAccountType())).filter(e -> StringUtils.isNotBlank((CharSequence)e.getCardNo())).collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(subPayRecordDtos)) {
                    accountTradeReq.setCreditFileNo(((PayRecordDto)subPayRecordDtos.get(0)).getCardNo());
                    continue;
                }
                log.info("\u6ca1\u6709\u5339\u914d\u7684\u4ed8\u6b3e\u8bb0\u5f55\uff1a{}", (Object)JSON.toJSONString((Object)accountTradeReq));
                continue;
            }
            log.info("\u8bf7\u6c42\u53c2\u6570\u4e0d\u6b63\u786e\uff1a{}", (Object)JSON.toJSONString((Object)accountTradeReq));
        }
        AccountTradeBatchReqDto accountTradeBatchReqDto = new AccountTradeBatchReqDto();
        if (CollectionUtils.isNotEmpty((Collection)accountTradeReqDtos)) {
            accountTradeBatchReqDto.setOrderNo(dto.getSaleOrderNo());
            accountTradeBatchReqDto.setSaleCompanyCode(dto.getPerformOrderSnapshotDto().getEnterpriseCode());
            accountTradeBatchReqDto.setCustomerNo(dto.getPerformOrderSnapshotDto().getCustomerCode());
            accountTradeBatchReqDto.setShopCode(dto.getPerformOrderSnapshotDto().getShopCode());
            accountTradeBatchReqDto.setTradeReqDtos((List)accountTradeReqDtos);
            log.info("\u51fa\u5e93\u91ca\u653e\u8bf7\u6c42\u53c2\u6570\uff1a{}", JSON.toJSON((Object)accountTradeBatchReqDto));
            RestResponseHelper.extractData((RestResponse)this.accountTradeApiProxy.outboundRelease(accountTradeBatchReqDto));
        }
        this.sendMqNoticeCredit(accountTradeBatchReqDto, dto, req);
        return RestResponse.VOID;
    }

    private List<AccountTradeReqDto> buildAccountTradeReq(List<DgPerformOrderItemLineAmountDto> performOrderItemLineAmountDtoList, DgPerformOrderRespDto dto) {
        ArrayList accountTradeReqDtos = Lists.newArrayList();
        Map<String, List<DgPerformOrderItemLineAmountDto>> itemAmountMap = performOrderItemLineAmountDtoList.stream().filter(e -> {
            if (dto.getPerformOrderSnapshotDto().getKneadeFlag().equals(0)) {
                return e.getAmountSource().equals(DgOrderAmountSourceEnum.ORDER_ITEM_AMOUNT.getCode()) || e.getAmountSource().equals(DgOrderAmountSourceEnum.COST.getCode());
            }
            return e.getAmountSource().equals(DgOrderAmountSourceEnum.KNEAD.getCode()) && !e.getAccountCategory().equals(DgOrderAmountCategoryEnum.OMS_B2B.getCode());
        }).collect(Collectors.groupingBy(itemPayRecord -> itemPayRecord.getAccountType() + "&" + itemPayRecord.getSellerId()));
        if (CollectionUtil.isNotEmpty(itemAmountMap)) {
            itemAmountMap.forEach((type, list) -> {
                if (CollectionUtil.isEmpty((Collection)list)) {
                    return;
                }
                AccountTradeReqDto accountTradeReqDto = new AccountTradeReqDto();
                accountTradeReqDto.setAccountType(((DgPerformOrderItemLineAmountDto)list.get(0)).getAccountType());
                accountTradeReqDto.setSaleCompanyCode(((DgPerformOrderItemLineAmountDto)list.get(0)).getSellerId());
                accountTradeReqDto.setAmount(list.stream().map(DgPerformOrderItemLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
                if (accountTradeReqDto.getAmount().compareTo(BigDecimal.ZERO) <= 0) {
                    log.info("\u5546\u54c1\u8d26\u6237\u652f\u4ed8\u91d1\u989d\u4e3a0\uff1a{}", (Object)((DgPerformOrderItemLineAmountDto)list.get(0)).getOrderItemLineId());
                } else {
                    accountTradeReqDtos.add(accountTradeReqDto);
                }
            });
        }
        return accountTradeReqDtos;
    }

    private List<AccountTradeReqDto> buildAccountTradeReqByDeliveryNum(DgPerformOrderItemLineDto itemLine, DgPerformOrderRespDto dto, BigDecimal currDeliveryNum) {
        ArrayList accountTradeReqDtos = Lists.newArrayList();
        Map<String, List<DgPerformOrderItemLineAmountDto>> itemAmountMap = itemLine.getPerformOrderItemLineAmountDtoList().stream().filter(e -> {
            if (dto.getPerformOrderSnapshotDto().getKneadeFlag().equals(0)) {
                return e.getAmountSource().equals(DgOrderAmountSourceEnum.ORDER_ITEM_AMOUNT.getCode()) || e.getAmountSource().equals(DgOrderAmountSourceEnum.COST.getCode());
            }
            return e.getAmountSource().equals(DgOrderAmountSourceEnum.KNEAD.getCode()) && !e.getAccountCategory().equals(DgOrderAmountCategoryEnum.OMS_F2B.getCode());
        }).collect(Collectors.groupingBy(itemPayRecord -> itemPayRecord.getAccountType() + "&" + itemPayRecord.getSellerId()));
        if (CollectionUtil.isNotEmpty(itemAmountMap)) {
            itemAmountMap.forEach((type, list) -> {
                if (CollectionUtil.isEmpty((Collection)list)) {
                    return;
                }
                AccountTradeReqDto accountTradeReqDto = new AccountTradeReqDto();
                accountTradeReqDto.setAccountType(((DgPerformOrderItemLineAmountDto)list.get(0)).getAccountType());
                accountTradeReqDto.setSaleCompanyCode(((DgPerformOrderItemLineAmountDto)list.get(0)).getSellerId());
                accountTradeReqDto.setAmount(list.stream().map(amountDto -> this.calcDeliveryAmout((DgPerformOrderItemLineAmountDto)amountDto, itemLine, currDeliveryNum)).reduce(BigDecimal.ZERO, BigDecimal::add));
                if (accountTradeReqDto.getAmount().compareTo(BigDecimal.ZERO) <= 0) {
                    log.info("\u5546\u54c1\u8d26\u6237\u652f\u4ed8\u91d1\u989d\u4e3a0\uff1a{}", (Object)((DgPerformOrderItemLineAmountDto)list.get(0)).getOrderItemLineId());
                } else {
                    accountTradeReqDtos.add(accountTradeReqDto);
                }
            });
        }
        return accountTradeReqDtos;
    }

    private BigDecimal calcDeliveryAmout(DgPerformOrderItemLineAmountDto amountDto, DgPerformOrderItemLineDto itemLine, BigDecimal currDeliveryNum) {
        if (BigDecimalUtils.equals((BigDecimal)currDeliveryNum, (BigDecimal)BigDecimalUtils.subtract((BigDecimal)itemLine.getItemNum(), (BigDecimal)itemLine.getOutItemNum())).booleanValue()) {
            BigDecimal oldDeliveryAmout = BigDecimalUtils.divide((BigDecimal)BigDecimalUtils.multiply((BigDecimal)amountDto.getAmount(), (BigDecimal)itemLine.getOutItemNum()), (BigDecimal)itemLine.getItemNum(), (int)2, (RoundingMode)RoundingMode.HALF_UP);
            return BigDecimalUtils.subtract((BigDecimal)amountDto.getAmount(), (BigDecimal)oldDeliveryAmout);
        }
        return BigDecimalUtils.divide((BigDecimal)BigDecimalUtils.multiply((BigDecimal)amountDto.getAmount(), (BigDecimal)currDeliveryNum), (BigDecimal)itemLine.getItemNum(), (int)2, (RoundingMode)RoundingMode.HALF_UP);
    }

    private void sendMqNoticeCredit(AccountTradeBatchReqDto accountTradeBatchReqDto, DgPerformOrderRespDto dto, DgBizPerformNoticeSyncRecordDto req) {
        String orderNo = accountTradeBatchReqDto.getOrderNo();
        log.info("[\u53d1\u8d27\u5b9e\u6263\u901a\u77e5\u4fe1\u7528MQ]\u8ba2\u5355\u53f7\uff1a{}\uff0c\u53d1\u9001\u6d88\u606f\u5f00\u59cb", (Object)orderNo);
        if (CollectionUtils.isEmpty((Collection)accountTradeBatchReqDto.getTradeReqDtos())) {
            log.info("[\u53d1\u8d27\u5b9e\u6263\u901a\u77e5\u4fe1\u7528MQ]\u8ba2\u5355\u53f7\uff1a{}\uff0c\u8d26\u6237\u4ed8\u6b3e\u660e\u7ec6\u4e3a\u7a7a\uff0c\u53d6\u6d88\u53d1\u9001", (Object)orderNo);
            return;
        }
        Map<String, List<AccountTradeReqDto>> map = accountTradeBatchReqDto.getTradeReqDtos().stream().filter(tradeReqDto -> StringUtils.isNotBlank((CharSequence)tradeReqDto.getCreditFileNo()) && tradeReqDto.getAmount().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.groupingBy(AccountTradeReqDto::getCreditFileNo));
        for (Map.Entry<String, List<AccountTradeReqDto>> entry : map.entrySet()) {
            AccountTradeReqDto tradeReqDto2 = entry.getValue().get(0);
            DgPerformOrderSnapshotDto snapshotDto = dto.getPerformOrderSnapshotDto();
            DgOrderNoticeCreditMqDto mqDto = new DgOrderNoticeCreditMqDto();
            mqDto.setSaleOrderNo(accountTradeBatchReqDto.getOrderNo());
            mqDto.setCustomerId(snapshotDto.getCustomerId());
            mqDto.setCustomerCode(snapshotDto.getCustomerCode());
            mqDto.setCustomerName(snapshotDto.getCustomerName());
            mqDto.setDeliveryNoticeNo(req.getResultNoticeOrderNo());
            mqDto.setCreditFileNo(tradeReqDto2.getCreditFileNo());
            mqDto.setAmount(entry.getValue().stream().map(AccountTradeReqDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
            String msg = JSON.toJSONString((Object)mqDto);
            log.info("[\u53d1\u8d27\u5b9e\u6263\u901a\u77e5\u4fe1\u7528MQ]\u8ba2\u5355\u53f7\uff1a{}\uff0c\u8d26\u6237\u7c7b\u578b\uff1a{}\uff0c\u53d1\u9001\u6d88\u606f\u5165\u53c2===>>{}", new Object[]{orderNo, tradeReqDto2.getAccountType(), msg});
            this.commonsMqService.publishDelayMessage("OP_SALE_EXTERNAL_TOPIC", "ORDER_NOTICE_CREDIT_TAG", (Object)msg, Long.valueOf(5L));
        }
    }

    @Override
    public RestResponse<Void> channelOrderWaitDelivery(DgPerformOrderRespDto dto, String channelOrderWaitDeliveryTag) {
        this.commonsMqService.sendSingleMessage(channelOrderWaitDeliveryTag, (Object)dto.getPerformOrderExtensionDto().getBeforeOrderNo());
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> channelOrderDeliveryNotice(DgPerformOrderRespDto dto, DgBizPerformNoticeSyncRecordDto req, F2BOrderDeliveryStatusEnum f2BOrderDeliveryStatusEnum) {
        if (DgSaleOrderTypeEnum.OVERSEAS_ORDER.getType().equals(dto.getOrderType())) {
            List orderLineDtos = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderId(dto.getId());
            Map orderLineDtoMap = orderLineDtos.stream().collect(Collectors.toMap(BaseDto::getId, Function.identity(), (e1, e2) -> e1));
            DgBizPerformNoticeSyncRecordDto noticeSyncRecordDto = (DgBizPerformNoticeSyncRecordDto)BeanUtil.copyProperties((Object)req, DgBizPerformNoticeSyncRecordDto.class, (String[])new String[]{"businessId", "businessNo"});
            noticeSyncRecordDto.setBusinessNo(dto.getPerformOrderExtensionDto().getBeforeOrderNo());
            for (DgPerformNoticeSyncRecordItemDto syncItemDto : noticeSyncRecordDto.getDgPerformNoticeSyncRecordDtoItems()) {
                DgPerformOrderLineDto orderLineDto = (DgPerformOrderLineDto)orderLineDtoMap.get(syncItemDto.getOrderItemId());
                syncItemDto.setOrderItemId(orderLineDto.getBeforeOrderItemId());
            }
            noticeSyncRecordDto.setDeliveryStatus(f2BOrderDeliveryStatusEnum.getCode());
            this.commonsMqService.sendSingleMessage("CHANNEL_ORDER_DELIVERY_TAG", (Object)JSON.toJSONString((Object)noticeSyncRecordDto));
        }
        return RestResponse.VOID;
    }

    @Override
    @Deprecated
    public RestResponse<Void> sendMsgForShipmentEnterprise(Long saleOrderId, DgOutDeliveryResultReqDto request) {
        DgPerformOrderRespDto saleOrderRespDto = new DgPerformOrderRespDto();
        saleOrderRespDto.setId(saleOrderId);
        DgPerformOrderOutNoticeSyncRecordRespDto syncRecordRespDto = this.saveOutNoticeRecord(this.omsOrderInfoQueryDomain.queryDtoById(saleOrderId), request);
        CubeBeanUtils.copyProperties((Object)request, (Object)syncRecordRespDto, (String[])new String[0]);
        return this.commonMqMessageAction.sendMsgForAllDelivery(saleOrderRespDto, request);
    }

    @Override
    @Deprecated
    public DgPerformOrderOutNoticeSyncRecordRespDto saveOutNoticeRecord(DgPerformOrderRespDto saleOrderRespDto, DgOutDeliveryResultReqDto reqDto) {
        log.info("[\u51fa\u5e93\u56de\u4f20]\u4fdd\u5b58\u56de\u4f20\u4fe1\u606f{}", (Object)JSON.toJSONString((Object)reqDto));
        return null;
    }

    public static void main(String[] args) {
    }
}

