/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.action.oms.channel.Impl;

import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.center.trade.action.oms.channel.IChannelOrderSigningAction;
import com.yunxi.dg.base.center.trade.action.oms.channel.IDgF2BMqMessageAction;
import com.yunxi.dg.base.center.trade.constants.amount.DgOmsOrderAmountTypeEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderSnapshotDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderLineBizQueryDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemLineAmountDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemLineDto;
import com.yunxi.dg.base.center.trade.enums.ItemLineDeliveryStatusEnum;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderSnapshotEo;
import com.yunxi.dg.base.center.trade.service.entity.IDgAfterSaleQuotaService;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ChannelOrderSigningActionImpl
implements IChannelOrderSigningAction {
    private static final Logger log = LoggerFactory.getLogger(ChannelOrderSigningActionImpl.class);
    @Resource
    protected IDgPerformOrderInfoDomain dgPerformOrderInfoDomain;
    @Resource
    protected IDgPerformOrderSnapshotDomain snapshotDomain;
    @Resource
    protected IDgAfterSaleQuotaService dgAfterSaleQuotaService;
    @Resource
    protected IDgPerformOrderItemLineDomain dgPerformOrderItemLineDomain;
    @Resource
    private IDgOmsOrderLineBizQueryDomain omsOrderLineBizQueryDomain;
    @Resource
    private IDgF2BMqMessageAction dgF2BMqMessageAction;

    @Override
    public RestResponse<Void> confirmOrder(Long id) {
        DgPerformOrderInfoEo performOrderInfoEo = new DgPerformOrderInfoEo();
        performOrderInfoEo.setId(id);
        performOrderInfoEo.setConfirmReceiveTime(new Date());
        this.dgPerformOrderInfoDomain.updateSelective((BaseEo)performOrderInfoEo);
        try {
            DgPerformOrderSnapshotEo dgPerformOrderSnapshotEo = this.snapshotDomain.selectByOrderId(id);
            List orderItemLineDtos = this.dgPerformOrderItemLineDomain.queryInfoByOrderId(id);
            BigDecimal price = BigDecimal.ZERO;
            String orderNo = "";
            for (DgPerformOrderItemLineDto orderItemLineDto : orderItemLineDtos) {
                if (ItemLineDeliveryStatusEnum.YES.getType().equals(orderItemLineDto.getDeliveryStatus()) && CollectionUtil.isNotEmpty((Collection)orderItemLineDto.getPerformOrderItemLineAmountDtoList())) {
                    List payAmountList = orderItemLineDto.getPerformOrderItemLineAmountDtoList().stream().filter(a -> a.getAccountType().equals(DgOmsOrderAmountTypeEnum.ITEM_LINE_ORIG_PRICE.getCode())).collect(Collectors.toList());
                    BigDecimal payAmount = CollectionUtil.isNotEmpty(payAmountList) ? payAmountList.stream().map(DgPerformOrderItemLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add) : BigDecimal.ZERO;
                    price = price.add(payAmount);
                }
                orderNo = orderItemLineDto.getOrderNo();
            }
            DgPerformOrderInfoEo dgPerformOrderInfoEo = this.dgPerformOrderInfoDomain.queryEoById(id);
            this.dealWithGift(dgPerformOrderInfoEo.getSaleOrderNo());
        }
        catch (Exception e) {
            log.error("\u8ba1\u7b97\u989d\u5ea6\u51fa\u9519", (Throwable)e);
        }
        return RestResponse.VOID;
    }

    private void dealWithGift(String orderNo) {
        log.info("\u8ba2\u5355\u5b8c\u6210\uff0c\u8d60\u54c1\u884c\u5904\u7406\uff1a{}", (Object)orderNo);
        this.dgF2BMqMessageAction.dealWithActivityExpense(orderNo, 2);
    }
}

