/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.action.oms.common.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.customer.dto.request.ChannelQueryReqDto;
import com.yunxi.dg.base.center.customer.dto.response.DgCsChannelRespDto;
import com.yunxi.dg.base.center.customer.proxy.query.IDgCsChannelQueryApiProxy;
import com.yunxi.dg.base.center.item.api.sku.IItemSkuDgQueryApi;
import com.yunxi.dg.base.center.item.dto.request.ItemQueryDgReqDto;
import com.yunxi.dg.base.center.item.dto.response.DgItemSkuDetailRespDto;
import com.yunxi.dg.base.center.item.dto.response.DgItemSkuRespDto;
import com.yunxi.dg.base.center.item.dto.response.DirRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemMediasDgRespDto;
import com.yunxi.dg.base.center.item.proxy.sku.IItemSkuDgQueryApiProxy;
import com.yunxi.dg.base.center.trade.action.oms.common.IOrderLineCommonHandleAction;
import com.yunxi.dg.base.center.trade.constants.DgGiftEnum;
import com.yunxi.dg.base.center.trade.constants.DgOrderSourceModelEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderItemTypeEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderSnapshotDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderLineEo;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class OrderLineCommonHandleActionImpl
implements IOrderLineCommonHandleAction {
    private static final Logger log = LoggerFactory.getLogger(OrderLineCommonHandleActionImpl.class);
    @Value(value="${oms.supplement.sale.order.info.enable:false}")
    private Boolean supplementSaleOrderInfoEnable;
    @Resource
    private IItemSkuDgQueryApi itemSkuDgQueryApi;
    @Resource
    private IDgCsChannelQueryApiProxy csChannelQueryApiProxy;
    @Resource
    private IItemSkuDgQueryApiProxy itemSkuDgQueryApiProxy;
    @Resource
    private IDgPerformOrderLineDomain dgPerformOrderLineDomain;

    @Override
    public List<DgPerformOrderItemReqDto> supplementSaleOrderInfo(DgBizPerformOrderReqDto request) {
        DgPerformOrderSnapshotDto snapshotDto = request.getPerformOrderSnapshotDto();
        if (StrUtil.isBlank((CharSequence)request.getPerformOrderSnapshotDto().getSiteCode()) && StrUtil.isBlank((CharSequence)request.getPerformOrderSnapshotDto().getChannelCode())) {
            throw new BizException("\u8bf7\u4f20\u5165\u7ad9\u70b9\u4fe1\u606f");
        }
        ChannelQueryReqDto queryReqDto = new ChannelQueryReqDto();
        queryReqDto.setCodes((List)Lists.newArrayList((Object[])new String[]{StrUtil.isNotBlank((CharSequence)snapshotDto.getSiteCode()) ? snapshotDto.getSiteCode() : snapshotDto.getChannelCode()}));
        List channelRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.csChannelQueryApiProxy.queryListChannelByCodes(queryReqDto));
        if (CollectionUtils.isNotEmpty((Collection)channelRespDtos)) {
            DgCsChannelRespDto siteRespDto = (DgCsChannelRespDto)channelRespDtos.get(0);
            if (Objects.nonNull(siteRespDto.getSystemType())) {
                String sourceModel = siteRespDto.getSystemType() == 1 ? DgOrderSourceModelEnum.THIRDPARTY.getCode() : DgOrderSourceModelEnum.INNER.getCode();
                request.setOrderSourceModel(sourceModel);
            } else {
                request.setOrderSourceModel(DgOrderSourceModelEnum.convertSource((String)snapshotDto.getChannelCode()));
            }
        } else {
            request.setOrderSourceModel(DgOrderSourceModelEnum.convertSource((String)snapshotDto.getChannelCode()));
        }
        ArrayList baseOrderItemDtoList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)request.getItemList())) {
            request.getItemList().forEach(saleOrderItemReqDto -> saleOrderItemReqDto.setGift(saleOrderItemReqDto.getGift() == null ? DgGiftEnum.NOT_GIFT.getType() : saleOrderItemReqDto.getGift()));
            baseOrderItemDtoList.addAll(request.getItemList());
        }
        if (CollectionUtils.isNotEmpty((Collection)request.getGiftList())) {
            request.getGiftList().forEach(saleOrderItemReqDto -> saleOrderItemReqDto.setGift(DgGiftEnum.GIFT.getType()));
            baseOrderItemDtoList.addAll(request.getGiftList());
        }
        return this.setSubItemList(baseOrderItemDtoList);
    }

    private List<DgPerformOrderItemReqDto> setSubItemList(List<DgPerformOrderItemReqDto> baseOrderItemDtoList) {
        Set skuCodeSet = baseOrderItemDtoList.stream().map(DgPerformOrderItemDto::getSkuCode).collect(Collectors.toSet());
        ItemQueryDgReqDto reqDto = new ItemQueryDgReqDto();
        reqDto.setSkuCodes((List)Lists.newArrayList(skuCodeSet));
        log.info("[\u7ec4\u5408\u5546\u54c1\u67e5\u8be2]\u67e5\u8be2\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)reqDto));
        List itemBundleList = (List)RestResponseHelper.extractData((RestResponse)this.itemSkuDgQueryApi.querySkuList(reqDto));
        log.info("[\u7ec4\u5408\u5546\u54c1\u67e5\u8be2]\u67e5\u8be2\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)itemBundleList));
        if (CollUtil.isEmpty((Collection)itemBundleList)) {
            log.info("\u5546\u54c1\u884c\uff1a{} \u5339\u914d\u65e0\u7ec4\u5408\u5546\u54c1", (Object)JSON.toJSONString(skuCodeSet));
            return new ArrayList<DgPerformOrderItemReqDto>();
        }
        Map<String, List<DgItemSkuDetailRespDto>> skuCodeMap = itemBundleList.stream().collect(Collectors.groupingBy(DgItemSkuRespDto::getSkuCode));
        ArrayList<DgPerformOrderItemReqDto> list = new ArrayList<DgPerformOrderItemReqDto>();
        for (DgPerformOrderItemReqDto performOrderItemDto : baseOrderItemDtoList) {
            String skuCode = performOrderItemDto.getSkuCode();
            List<DgItemSkuDetailRespDto> rItemBundleRespDtos = skuCodeMap.get(skuCode);
            DgItemSkuDetailRespDto detailRespDto = rItemBundleRespDtos.get(0);
            if (!skuCodeMap.containsKey(skuCode) || Objects.isNull(detailRespDto.getBundleSkus())) continue;
            Optional.ofNullable(detailRespDto.getBundleSkus()).ifPresent(bundle -> {
                performOrderItemDto.setType(DgSaleOrderItemTypeEnum.COMBINATION.getType());
                performOrderItemDto.setGroupGift(performOrderItemDto.getGift());
                List subItemList = bundle.stream().map(r -> {
                    AssertUtils.notNull((Object)r.getPriceAllocationRatio(), (String)"\u7ec4\u5408\u5546\u54c1\u4e3b\u6570\u636e\u672a\u914d\u7f6e\u4ef7\u683c\u5206\u644a\u6bd4\u4f8b");
                    DgPerformOrderItemReqDto subItem = new DgPerformOrderItemReqDto();
                    BeanUtil.copyProperties((Object)performOrderItemDto, (Object)subItem, (String[])new String[0]);
                    BeanUtil.copyProperties((Object)r, (Object)subItem, (String[])new String[0]);
                    subItem.setItemNum(new BigDecimal(r.getNum()));
                    subItem.setSkuId(r.getSubSkuId());
                    subItem.setSkuCode(r.getSubSkuCode());
                    subItem.setSkuName(r.getSubSkuName());
                    subItem.setItemId(r.getSubItemId());
                    subItem.setItemCode(r.getSubItemCode());
                    subItem.setItemName(r.getSubItemName());
                    BigDecimal unitPrice = Convert.toBigDecimal((Object)r.getRetailPrice(), (BigDecimal)BigDecimal.ZERO);
                    subItem.setSalePrice(unitPrice);
                    subItem.setPrice(unitPrice);
                    subItem.setTransactionPrice(unitPrice);
                    BigDecimal priceAllocationRatio = r.getPriceAllocationRatio().divide(new BigDecimal(100));
                    subItem.setPriceAllocationRatio(priceAllocationRatio);
                    Integer gift = performOrderItemDto.getGift();
                    if (!DgGiftEnum.GIFT.getType().equals(gift) && NumberUtil.equals((BigDecimal)unitPrice, (BigDecimal)BigDecimal.ZERO)) {
                        subItem.setGift(DgGiftEnum.GIFT.getType());
                    }
                    return subItem;
                }).collect(Collectors.toList());
                performOrderItemDto.setSubItemList(subItemList);
                list.addAll(subItemList);
                log.info("[\u7ec4\u5408\u5546\u54c1\u67e5\u8be2]\u7ec4\u5408\u5546\u54c1:{},\u7ec4\u88c5\u540e\u5b50\u5546\u54c1\u7ed3\u679c:{}", (Object)performOrderItemDto.getSkuCode(), (Object)JSON.toJSONString(subItemList));
            });
        }
        return list;
    }

    @Override
    public RestResponse<List<DgPerformOrderItemReqDto>> supplementBundleItem(List<DgPerformOrderItemReqDto> orderItemReqDtos, DgPerformOrderRespDto saleOrderRespDto) {
        this.setSubItemList(orderItemReqDtos);
        ArrayList<DgPerformOrderItemReqDto> saleOrderItemReqDtoList = new ArrayList<DgPerformOrderItemReqDto>();
        saleOrderItemReqDtoList.addAll(orderItemReqDtos);
        orderItemReqDtos.forEach(dto -> {
            if (CollectionUtils.isNotEmpty((Collection)dto.getSubItemList())) {
                saleOrderItemReqDtoList.addAll(dto.getSubItemList());
            }
        });
        DgBizPerformOrderReqDto reqDto = new DgBizPerformOrderReqDto();
        CubeBeanUtils.copyProperties((Object)reqDto, (Object)saleOrderRespDto, (String[])new String[0]);
        this.supplementSaleOrderItem(saleOrderItemReqDtoList);
        return new RestResponse(orderItemReqDtos);
    }

    @Override
    public RestResponse<List<DgPerformOrderItemReqDto>> supplementSaleOrderItem(List<DgPerformOrderItemReqDto> request) {
        List itemSkuCode = request.stream().map(DgPerformOrderItemDto::getSkuCode).collect(Collectors.toList());
        List itemSkuIds = request.stream().map(DgPerformOrderItemDto::getSkuId).collect(Collectors.toList());
        ItemQueryDgReqDto reqDto = new ItemQueryDgReqDto();
        reqDto.setSkuCodes(itemSkuCode);
        log.info("[\u8865\u5145\u5165\u53c2\u5546\u54c1\u4fe1\u606f]\u67e5\u8be2\u5546\u54c1\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)reqDto));
        List itemRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.itemSkuDgQueryApi.querySkuList(reqDto));
        log.info("[\u8865\u5145\u5165\u53c2\u5546\u54c1\u4fe1\u606f]\u67e5\u8be2\u5546\u54c1\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)itemRespDtos));
        if (CollectionUtils.isEmpty((Collection)itemRespDtos)) {
            throw new BizException("-1", "\u83b7\u53d6\u4e0d\u5230\u5546\u54c1\u4fe1\u606f");
        }
        Map itemRespDtoMap = itemRespDtos.stream().collect(Collectors.toMap(DgItemSkuRespDto::getSkuCode, Function.identity(), (v1, v2) -> v1));
        request.forEach(dto -> {
            DgItemSkuDetailRespDto itemRespDto = (DgItemSkuDetailRespDto)itemRespDtoMap.get(dto.getSkuCode());
            if (itemRespDto == null) {
                throw new BizException("-1", "\u83b7\u53d6\u4e0d\u5230\u5546\u54c1\u4fe1\u606f" + dto.getSkuCode());
            }
            log.info("itemRespDto\uff1a{},skuName{}", (Object)JSON.toJSONString((Object)itemRespDto), (Object)itemRespDto.getSkuName());
            BeanUtils.copyProperties((Object)itemRespDto, (Object)dto, (String[])new String[]{"id"});
            this.supplementSaleOrderItemBaseInfo(itemRespDto, (DgPerformOrderItemReqDto)dto);
        });
        log.info("\u8865\u5145\u540e\u5546\u54c1\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(request));
        return new RestResponse(request);
    }

    private void supplementSaleOrderItemBaseInfo(DgItemSkuDetailRespDto itemRespDto, DgPerformOrderItemReqDto dto) {
        List collect;
        if (dto.getOriginalOrderGoodsId() != null) {
            DgPerformOrderLineEo orderLineEo = (DgPerformOrderLineEo)this.dgPerformOrderLineDomain.selectByPrimaryKey(dto.getOriginalOrderGoodsId());
            AssertUtils.isFalse((orderLineEo == null ? 1 : 0) != 0, (String)"\u8ba2\u5355\u884c\u4fe1\u606f\u672a\u627e\u5230");
            dto.setItemNum(orderLineEo.getItemNum());
        }
        dto.setSkuId(itemRespDto.getId());
        if (dto.getSalePrice() == null) {
            this.getPrice(itemRespDto, dto);
        }
        if (DgGiftEnum.GIFT.getType().equals(dto.getGift())) {
            dto.setRealPayAmount(Optional.ofNullable(dto.getRealPayAmount()).orElse(BigDecimal.ZERO));
            dto.setPayAmount(Optional.ofNullable(dto.getPayAmount()).orElse(BigDecimal.ZERO));
            dto.setSalePrice(Optional.ofNullable(dto.getSalePrice()).orElse(BigDecimal.ZERO));
        } else {
            dto.setRealPayAmount(Optional.ofNullable(dto.getRealPayAmount()).orElse(BigDecimal.ZERO));
            dto.setPayAmount(Optional.ofNullable(dto.getPayAmount()).orElse(BigDecimal.ZERO));
            dto.setSalePrice(Optional.ofNullable(dto.getSalePrice()).orElse(BigDecimal.ZERO));
        }
        if (CollectionUtils.isNotEmpty((Collection)itemRespDto.getImgUrlList()) && CollectionUtils.isNotEmpty(collect = itemRespDto.getImgUrlList().stream().filter(x -> 0 == x.getFileType()).collect(Collectors.toList()))) {
            dto.setImgUrl(((ItemMediasDgRespDto)collect.get(0)).getPath1());
        }
        if (itemRespDto.getSubType() == 2) {
            dto.setType(DgSaleOrderItemTypeEnum.VIRTUAL.getType());
        } else if (itemRespDto.getSubType() == 3) {
            dto.setType(DgSaleOrderItemTypeEnum.SERVICE.getType());
        } else {
            dto.setType(Optional.ofNullable(itemRespDto.getItemType()).orElse(0).toString());
        }
        Optional.ofNullable(itemRespDto.getVersion()).ifPresent(version -> dto.setItemVer(version.toString()));
        if (CollectionUtils.isNotEmpty((Collection)itemRespDto.getDirList())) {
            dto.setItemBackCategoryOneName(null);
            dto.setItemBackCategoryOneCode(null);
            dto.setItemBackCategoryTwoName(null);
            dto.setItemBackCategoryTwoCode(null);
            dto.setItemBackCategoryThirdName(null);
            dto.setItemBackCategoryThirdCode(null);
            dto.setItemBackCategoryFourthName(null);
            dto.setItemBackCategoryFourthCode(null);
            block6: for (int i = 0; i < itemRespDto.getDirList().size(); ++i) {
                DirRespDto dirRespDto = (DirRespDto)itemRespDto.getDirList().get(i);
                if (dirRespDto.getParentId() == null || dirRespDto.getParentId() == 0L) continue;
                switch (i) {
                    case 1: {
                        dto.setItemBackCategoryOneName(dirRespDto.getName());
                        dto.setItemBackCategoryOneCode(dirRespDto.getCode());
                        continue block6;
                    }
                    case 2: {
                        dto.setItemBackCategoryTwoName(dirRespDto.getName());
                        dto.setItemBackCategoryTwoCode(dirRespDto.getCode());
                        continue block6;
                    }
                    case 3: {
                        dto.setItemBackCategoryThirdName(dirRespDto.getName());
                        dto.setItemBackCategoryThirdCode(dirRespDto.getCode());
                        continue block6;
                    }
                    case 4: {
                        dto.setItemBackCategoryFourthName(dirRespDto.getName());
                        dto.setItemBackCategoryFourthCode(dirRespDto.getCode());
                    }
                }
            }
        }
        BigDecimal weight = Optional.ofNullable(itemRespDto.getNetWeight()).orElse(Optional.ofNullable(itemRespDto.getGrossWeight()).orElse(BigDecimal.ZERO));
        BigDecimal volume = Optional.ofNullable(itemRespDto.getVolume()).orElse(BigDecimal.ZERO);
        dto.setWeight(weight.multiply(Optional.ofNullable(dto.getItemNum()).orElse(BigDecimal.ONE)));
        dto.setVolume(volume.multiply(Optional.ofNullable(dto.getItemNum()).orElse(BigDecimal.ONE)));
        log.info("sku\u7f16\u7801:{},\u5355\u4f4d\u91cd\u91cf:{},\u5355\u4f4d\u4f53\u79ef:{}", new Object[]{dto.getSkuCode(), dto.getWeight(), dto.getVolume()});
    }

    private RestResponse<DgPerformOrderItemDto> getPrice(DgItemSkuDetailRespDto item, DgPerformOrderItemReqDto itemReqDto) {
        if (Objects.nonNull(item.getRetailPrice())) {
            itemReqDto.setSalePrice(item.getRetailPrice());
        } else {
            itemReqDto.setSalePrice(BigDecimal.ZERO);
        }
        return new RestResponse((Object)itemReqDto);
    }
}

